/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public final class RegistryFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends IRegistry<E>> a;
    private final Codec<E> b;
    private final boolean c;

    public static <E> RegistryFileCodec<E> a(ResourceKey<? extends IRegistry<E>> registryKey, Codec<E> elementCodec) {
        return RegistryFileCodec.a(registryKey, elementCodec, true);
    }

    public static <E> RegistryFileCodec<E> a(ResourceKey<? extends IRegistry<E>> registryKey, Codec<E> elementCodec, boolean allowInline) {
        return new RegistryFileCodec<E>(registryKey, elementCodec, allowInline);
    }

    private RegistryFileCodec(ResourceKey<? extends IRegistry<E>> registryKey, Codec<E> elementCodec, boolean allowInline) {
        this.a = registryKey;
        this.b = elementCodec;
        this.c = allowInline;
    }

    public <T> DataResult<T> a(Holder<E> input, DynamicOps<T> ops, T prefix) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).a(this.a)).isPresent()) {
            if (!input.a(optional.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(input) + " is not valid in current registry set");
            }
            return input.d().map(resourceKey -> MinecraftKey.a.encode((Object)resourceKey.a(), ops, prefix), element -> this.b.encode(element, ops, prefix));
        }
        return this.b.encode(input.a(), ops, prefix);
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops instanceof RegistryOps) {
            RegistryOps registryOps = (RegistryOps)ops;
            Optional optional = registryOps.b(this.a);
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Registry does not exist: " + String.valueOf(this.a));
            }
            HolderGetter holderGetter = optional.get();
            DataResult dataResult = MinecraftKey.a.decode(ops, input);
            if (dataResult.result().isEmpty()) {
                return !this.c ? DataResult.error(() -> "Inline definitions not allowed here") : this.b.decode(ops, input).map(pair1 -> pair1.mapFirst(Holder::a));
            }
            Pair pair = (Pair)dataResult.result().get();
            ResourceKey resourceKey = ResourceKey.a(this.a, (MinecraftKey)pair.getFirst());
            return holderGetter.a(resourceKey).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf(resourceKey))).map(holder -> Pair.of((Object)holder, (Object)pair.getSecond())).setLifecycle(Lifecycle.stable());
        }
        return this.b.decode(ops, input).map(pair1 -> pair1.mapFirst(Holder::a));
    }

    public String toString() {
        return "RegistryFileCodec[" + String.valueOf(this.a) + " " + String.valueOf(this.b) + "]";
    }
}

