/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DynamicOpsWrapper<T> {
    public final c b;

    public static <T> RegistryOps<T> a(DynamicOps<T> delegate, HolderLookup.a registries) {
        return RegistryOps.a(delegate, new a(registries));
    }

    public static <T> RegistryOps<T> a(DynamicOps<T> delegate, c lookupProvider) {
        return new RegistryOps<T>(delegate, lookupProvider);
    }

    public static <T> Dynamic<T> a(Dynamic<T> dynamic, HolderLookup.a registries) {
        return new Dynamic(registries.a(dynamic.getOps()), dynamic.getValue());
    }

    private RegistryOps(DynamicOps<T> delegate, c lookupProvider) {
        super(delegate);
        this.b = lookupProvider;
    }

    public <U> RegistryOps<U> a(DynamicOps<U> ops) {
        return ops == this.a ? this : new RegistryOps<U>(ops, this.b);
    }

    public <E> Optional<HolderOwner<E>> a(ResourceKey<? extends IRegistry<? extends E>> registryKey) {
        return this.b.a(registryKey).map(b::a);
    }

    public <E> Optional<HolderGetter<E>> b(ResourceKey<? extends IRegistry<? extends E>> registryKey) {
        return this.b.a(registryKey).map(b::b);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            RegistryOps registryOps = (RegistryOps)other;
            return this.a.equals(registryOps.a) && this.b.equals(registryOps.b);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode() * 31 + this.b.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> c(ResourceKey<? extends IRegistry<? extends E>> registryKey) {
        return ExtraCodecs.a((DynamicOps<?> ops) -> {
            DataResult dataResult;
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                dataResult = registryOps.b.a(registryKey).map(registryInfo -> DataResult.success(registryInfo.b(), (Lifecycle)registryInfo.c())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(registryKey)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(object -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.c<E>> d(ResourceKey<E> key) {
        ResourceKey resourceKey = ResourceKey.a(key.b());
        return ExtraCodecs.a((DynamicOps<?> ops) -> {
            DataResult dataResult;
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                dataResult = registryOps.b.a(resourceKey).flatMap(registryInfo -> registryInfo.b().a(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(key)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(object -> null);
    }

    public static final class a
    implements c {
        private final HolderLookup.a a;
        private final Map<ResourceKey<? extends IRegistry<?>>, Optional<? extends b<?>>> b = new ConcurrentHashMap();

        public a(HolderLookup.a lookupProvider) {
            this.a = lookupProvider;
        }

        public <E> Optional<b<E>> a(ResourceKey<? extends IRegistry<? extends E>> registryKey) {
            return this.b.computeIfAbsent(registryKey, this::b);
        }

        private Optional<b<Object>> b(ResourceKey<? extends IRegistry<?>> registryKey) {
            return this.a.a(registryKey).map(b::a);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof a)) return false;
            a holderLookupAdapter = (a)other;
            if (!this.a.equals(holderLookupAdapter.a)) return false;
            return true;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public HolderLookup.a lookupForValueCopyViaBuilders() {
            return this.a;
        }
    }

    public static interface c {
        public <T> Optional<b<T>> a(ResourceKey<? extends IRegistry<? extends T>> var1);

        public HolderLookup.a lookupForValueCopyViaBuilders();
    }

    public record b<T>(HolderOwner<T> a, HolderGetter<T> b, Lifecycle c) {
        public static <T> b<T> a(HolderLookup.b<T> registryLookup) {
            return new b<T>(registryLookup, registryLookup, registryLookup.h());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this, o2);
        }
    }
}

