/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.MapMaker;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;

public class ResourceKey<T> {
    private static final ConcurrentMap<a, ResourceKey<?>> a = new MapMaker().weakValues().makeMap();
    private final MinecraftKey b;
    private final MinecraftKey c;

    public static <T> Codec<ResourceKey<T>> a(ResourceKey<? extends IRegistry<T>> registryKey) {
        return MinecraftKey.a.xmap(path -> ResourceKey.a(registryKey, path), ResourceKey::a);
    }

    public static <T> StreamCodec<ByteBuf, ResourceKey<T>> b(ResourceKey<? extends IRegistry<T>> registryKey) {
        return MinecraftKey.b.a(location -> ResourceKey.a(registryKey, location), ResourceKey::a);
    }

    public static <T> ResourceKey<T> a(ResourceKey<? extends IRegistry<T>> registryKey, MinecraftKey location) {
        return ResourceKey.a(registryKey.c, location);
    }

    public static <T> ResourceKey<IRegistry<T>> a(MinecraftKey location) {
        return ResourceKey.a(Registries.a, location);
    }

    private static <T> ResourceKey<T> a(MinecraftKey registryName, MinecraftKey location) {
        return a.computeIfAbsent(new a(registryName, location), key -> new ResourceKey(key.a, key.b));
    }

    private ResourceKey(MinecraftKey registryName, MinecraftKey identifier) {
        this.b = registryName;
        this.c = identifier;
    }

    public String toString() {
        return "ResourceKey[" + String.valueOf(this.b) + " / " + String.valueOf(this.c) + "]";
    }

    public boolean c(ResourceKey<? extends IRegistry<?>> registryKey) {
        return this.b.equals(registryKey.a());
    }

    public <E> Optional<ResourceKey<E>> d(ResourceKey<? extends IRegistry<E>> registryKey) {
        return this.c(registryKey) ? Optional.of(this) : Optional.empty();
    }

    public MinecraftKey a() {
        return this.c;
    }

    public MinecraftKey b() {
        return this.b;
    }

    public ResourceKey<IRegistry<T>> c() {
        return ResourceKey.a(this.b);
    }

    record a(MinecraftKey a, MinecraftKey b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "registry;identifier", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "registry;identifier", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "registry;identifier", "a", "b"}, this, o2);
        }
    }
}

