/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.time.Schedule;
import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.time.TickTime;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.destroystokyo.paper.PaperVersionFetcher;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.event.world.WorldDifficultyChangeEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.EntityScheduler;
import io.papermc.paper.threadedregions.RegionizedServerInitEvent;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import io.papermc.paper.world.PaperWorldLoader;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.ChunkLoadStatusView;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.server.notifications.ServerActivityMonitor;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.FileUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.PngInfo;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Stopwatches;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.wanderingtrader.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R7.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftDifficulty;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ICommandListener,
ChunkIOErrorReporter,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger m;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float n = 0.8f;
    private static final int o = 100;
    private static final long p;
    private static final int q = 20;
    private static final long r;
    private static final int s = 100;
    private static final long t;
    private static final long u;
    private static final int v = 12;
    public static final int c = 5;
    private static final int w = 30;
    private static final int x = 6000;
    private static final int y = 100;
    private static final int z = 3;
    public static final int d = 29999984;
    public static final WorldSettings e;
    public static final NameAndId f;
    public Convertable.ConversionSession g;
    public final WorldNBTStorage h;
    private final List<Runnable> A = Lists.newArrayList();
    private MetricsRecorder B = InactiveMetricsRecorder.a;
    private Consumer<MethodProfilerResults> C = results -> this.aW();
    private Consumer<Path> D = path -> {};
    private boolean E;
    private @Nullable TimeProfiler F;
    private boolean G;
    private ServerConnection H;
    private @Nullable ServerPing J;
    private @Nullable ServerPing.a K;
    private final RandomSource L = RandomSource.a();
    public final DataFixer M;
    private String N;
    private int O = -1;
    private final LayeredRegistryAccess<RegistryLayer> P;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> Q = Maps.newLinkedHashMap();
    private PlayerList R;
    private volatile boolean S = true;
    private volatile boolean isRestarting = false;
    private boolean T;
    private int U;
    private int V = 6000;
    protected final Proxy i;
    private boolean W;
    private boolean X;
    private Component motd;
    private int Z;
    private final long[] aa = new long[100];
    private long ab = 0L;
    private @Nullable KeyPair ac;
    private @Nullable GameProfile ad;
    private boolean ae;
    private volatile boolean af;
    private long ag;
    protected final Services j;
    private final NotificationManager ah;
    private final ServerActivityMonitor ai;
    private long aj;
    public final Thread ak;
    private long al = SystemUtils.d();
    private long am = SystemUtils.d();
    private long an;
    private long ao = SystemUtils.d();
    private boolean ap = false;
    private long aq;
    private boolean ar;
    private final ResourcePackRepository as;
    private final ScoreboardServer at = new ScoreboardServer(this);
    private @Nullable Stopwatches au;
    private @Nullable PersistentCommandStorage av;
    private final BossBattleCustomData aw = new BossBattleCustomData();
    private final CustomFunctionData ax;
    private boolean ay;
    private boolean az;
    private float aA;
    public final Executor aB;
    private @Nullable String aC;
    public ReloadableResources aD;
    private final StructureTemplateManager aE;
    private final ServerTickRateManager aF;
    private final ServerDebugSubscribers aG = new ServerDebugSubscribers(this);
    protected SaveData k;
    private WorldData.a aH = WorldData.a.a;
    public PotionBrewer aI;
    private FuelValues aJ;
    private int aK;
    private volatile boolean aL;
    private static final AtomicReference<@Nullable RuntimeException> aM;
    private final SuppressedExceptionCollector aN = new SuppressedExceptionCollector();
    private final DiscontinuousFrame aO;
    private final PacketProcessor aP;
    public final WorldLoader.a worldLoaderContext;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    public volatile boolean hasFullyShutdown;
    public volatile boolean abnormalExit;
    public volatile Thread shutdownThread;
    public final PaperConfigurations paperConfigurations;
    public boolean isIteratingOverLevels = false;
    private final Set<String> pluginsBlockingSleep = new HashSet<String>();
    public static final long SERVER_INIT;
    public final TickData tickTimes1s = new TickData(TimeUnit.SECONDS.toNanos(1L));
    public final TickData tickTimes5s = new TickData(TimeUnit.SECONDS.toNanos(5L));
    public final TickData tickTimes10s = new TickData(TimeUnit.SECONDS.toNanos(10L));
    public final TickData tickTimes15s = new TickData(TimeUnit.SECONDS.toNanos(15L));
    public final TickData tickTimes1m = new TickData(TimeUnit.MINUTES.toNanos(1L));
    public final TickData tickTimes5m = new TickData(TimeUnit.MINUTES.toNanos(5L));
    public final TickData tickTimes15m = new TickData(TimeUnit.MINUTES.toNanos(15L));
    private final Schedule tickSchedule = new Schedule(0L);
    private long lastTickStart;
    private long currentTickStart;
    private long scheduledTickStart;
    private long taskExecutionTime;
    private final Object statsLock = new Object();
    private @Nullable double[] tps;
    private @Nullable TickData.MSPTData msptData5s;
    private volatile Throwable chunkSystemCrash;
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private long lastMidTickExecute;
    private long lastMidTickExecuteFailure;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    private final Object stopLock = new Object();
    public final EntityScheduler.EntitySchedulerTickList entitySchedulerTickList = new EntityScheduler.EntitySchedulerTickList();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(m)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTickTime(TickTime time) {
        Object object = this.statsLock;
        synchronized (object) {
            this.tickTimes1s.addDataFrom(time);
            this.tickTimes5s.addDataFrom(time);
            this.tickTimes10s.addDataFrom(time);
            this.tickTimes15s.addDataFrom(time);
            this.tickTimes1m.addDataFrom(time);
            this.tickTimes5m.addDataFrom(time);
            this.tickTimes15m.addDataFrom(time);
            this.clearTickTimeStatistics();
        }
    }

    private void clearTickTimeStatistics() {
        this.msptData5s = null;
        this.tps = null;
    }

    private static double getTPS(TickData tickData, long tickInterval) {
        Double avg = tickData.getTPSAverage(null, tickInterval);
        if (avg == null) {
            return 1.0E9 / (double)tickInterval;
        }
        return avg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getTPS() {
        Object object = this.statsLock;
        synchronized (object) {
            double[] tps = this.tps;
            if (tps == null) {
                this.tps = tps = this.computeTPS();
            }
            return (double[])tps.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable TickData.MSPTData getMSPTData5s() {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.msptData5s == null) {
                this.msptData5s = this.tickTimes5s.getMSPTData(null, this.aR().h());
            }
            return this.msptData5s;
        }
    }

    public double[] computeTPS() {
        long interval = this.aR().h();
        return new double[]{MinecraftServer.getTPS(this.tickTimes1m, interval), MinecraftServer.getTPS(this.tickTimes5m, interval), MinecraftServer.getTPS(this.tickTimes15m, interval)};
    }

    public static <S extends MinecraftServer> S a(Function<Thread, S> threadFunction) {
        MCTypeRegistry.init();
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicReference.get()).A(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, exception) -> m.error("Uncaught exception in server thread", exception));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer minecraftServer = (MinecraftServer)threadFunction.apply(thread);
        atomicReference.set(minecraftServer);
        thread.start();
        return (S)minecraftServer;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.P()) {
            long currTime = System.nanoTime();
            if (currTime - world.moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.p().c()) {
                world.moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    @Override
    public final void moonrise$issueEmergencySave() {
        m.warn("Performing emergency save...");
        m.info("Saving all players...");
        this.aj().h();
        m.info("Saved all players");
        m.info("Saving all worlds...");
        for (WorldServer world : this.P()) {
            m.info("Saving chunks in world '" + WorldUtil.getWorldName(world) + "'...");
            world.moonrise$issueEmergencySave();
            m.info("Saved chunks in world '" + WorldUtil.getWorldName(world) + "'...");
        }
        m.info("Saved all worlds");
        m.warn("Performed emergency save");
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoaderContext, Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer fixerUpper, Services services, LevelLoadListener levelLoadListener) {
        super("Server");
        SERVER = this;
        this.P = worldStem.c();
        this.k = worldStem.d();
        this.i = proxy;
        this.as = packRepository;
        this.aD = new ReloadableResources(worldStem.a(), worldStem.b());
        this.j = services;
        this.aF = new ServerTickRateManager(this);
        this.g = storageSource;
        this.h = storageSource.g();
        this.M = fixerUpper;
        this.ax = new CustomFunctionData(this, this.aD.b.a());
        HolderLookup.b holderGetter = this.P.a().f(Registries.i).a(this.k.J());
        this.aE = new StructureTemplateManager(worldStem.a(), storageSource, fixerUpper, holderGetter);
        this.ak = serverThread;
        this.aB = SystemUtils.h();
        this.aI = PotionBrewer.a(this.k.J());
        this.aD.b.c().a(this.k.J());
        this.aJ = FuelValues.a(this.P.a(), this.k.J());
        this.aO = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.ah = new NotificationManager();
        this.ai = new ServerActivityMonitor(this.ah, 30);
        this.aP = new PacketProcessor(serverThread);
        this.options = options;
        this.worldLoaderContext = worldLoaderContext;
        LogManagerShutdownThread.unhook();
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paper().configurations();
    }

    protected abstract boolean e() throws IOException;

    public ChunkLoadStatusView a(final int radius) {
        return new ChunkLoadStatusView(){
            private @Nullable PlayerChunkMap c;
            private int d;
            private int e;

            @Override
            public void a(ResourceKey<net.minecraft.world.level.World> dimension, ChunkCoordIntPair chunkPos) {
                WorldServer level = MinecraftServer.this.a(dimension);
                this.c = level != null ? level.p().a : null;
                this.d = chunkPos.h;
                this.e = chunkPos.i;
            }

            @Override
            public @Nullable ChunkStatus a(int x2, int z2) {
                return this.c == null ? null : this.c.c(ChunkCoordIntPair.d(x2 + this.d - radius, z2 + this.e - radius));
            }

            @Override
            public int a() {
                return radius;
            }
        };
    }

    protected void loadLevel(String levelId) {
        boolean flag = !JvmProfiler.f.c() && SharedConstants.au && JvmProfiler.f.a(Environment.a(this));
        ProfiledDuration profiledDuration = JvmProfiler.f.e();
        PaperWorldLoader loader = PaperWorldLoader.create(this, levelId);
        loader.loadInitialWorlds();
        if (profiledDuration != null) {
            profiledDuration.finish(true);
        }
        if (flag) {
            try {
                JvmProfiler.f.b();
            }
            catch (Throwable var4) {
                m.warn("Failed to stop JFR profiling", var4);
            }
        }
    }

    protected void initPostWorld() {
        ScoreboardServer scoreboard = this.aK();
        Collection toRemove = scoreboard.f().stream().filter(team -> team.c().startsWith("collideRule_")).map(ScoreboardTeam::c).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.b(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.aj().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.c(this.aj().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.spark.registerCommandBeforePlugins(this.server);
        this.server.spark.enableAfterPlugins(this.server);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        this.server.getCommandMap().registerServerAliases();
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.H.acceptConnections();
    }

    protected void t() {
    }

    public void createLevel(WorldDimension levelStem, PaperWorldLoader.WorldLoadingInfo loadingInfo, Convertable.ConversionSession levelStorageAccess, WorldDataServer serverLevelData) {
        WorldServer serverLevel;
        WorldOptions worldOptions = serverLevelData.x();
        long seed = worldOptions.c();
        long l2 = BiomeManager.a(seed);
        ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(serverLevelData));
        ChunkGenerator chunkGenerator = this.server.getGenerator(loadingInfo.name());
        BiomeProvider biomeProvider = this.server.getBiomeProvider(loadingInfo.name());
        CraftWorldInfo worldInfo = new CraftWorldInfo(serverLevelData, levelStorageAccess, World.Environment.getEnvironment((int)loadingInfo.dimension()), levelStem.a().a(), levelStem.b(), this.bc());
        if (biomeProvider == null && chunkGenerator != null) {
            biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ResourceKey<net.minecraft.world.level.World> dimensionKey = ResourceKey.a(Registries.bE, loadingInfo.stemKey().a());
        if (loadingInfo.stemKey() == WorldDimension.b) {
            serverLevel = new WorldServer(this, this.aB, levelStorageAccess, serverLevelData, dimensionKey, levelStem, serverLevelData.z(), l2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)loadingInfo.dimension()), chunkGenerator, biomeProvider);
            this.k = serverLevelData;
            this.k.a(((DedicatedServer)this).a().n.get());
            WorldPersistentData dataStorage = serverLevel.A();
            this.at.a(dataStorage.a(PersistentScoreboard.a).b());
            this.av = new PersistentCommandStorage(dataStorage);
            this.au = dataStorage.a(Stopwatches.a);
            this.server.scoreboardManager = new CraftScoreboardManager(this, serverLevel.i());
        } else {
            ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && levelStem.a().a(BuiltinDimensionTypes.a) ? list : Collections.emptyList();
            serverLevel = new WorldServer(this, this.aB, levelStorageAccess, serverLevelData, dimensionKey, levelStem, this.k.z(), l2, (List<MobSpawner>)spawners, true, this.N().T(), World.Environment.getEnvironment((int)loadingInfo.dimension()), chunkGenerator, biomeProvider);
        }
        this.addLevel(serverLevel);
        this.initWorld(serverLevel, serverLevelData, worldOptions);
    }

    public void initWorld(WorldServer serverLevel, WorldDataServer serverLevelData, WorldOptions worldOptions) {
        boolean isDebugWorld = this.k.z();
        if (serverLevel.generator != null) {
            serverLevel.getWorld().getPopulators().addAll(serverLevel.generator.getDefaultPopulators((World)serverLevel.getWorld()));
        }
        this.initWorldBorder(serverLevelData, serverLevel);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)serverLevel.getWorld()));
        if (!serverLevelData.m()) {
            try {
                MinecraftServer.a(serverLevel, serverLevelData, worldOptions.e(), isDebugWorld, serverLevel.levelLoadListener);
                serverLevelData.c(true);
                if (isDebugWorld) {
                    this.a(this.k);
                }
            }
            catch (Throwable var28) {
                CrashReport crashReport = CrashReport.a(var28, "Exception initializing level");
                try {
                    serverLevel.a(crashReport);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            serverLevelData.c(true);
        }
        GlobalPos globalPos = this.v();
        serverLevel.levelLoadListener.a(globalPos.a(), new ChunkCoordIntPair(globalPos.b()));
        if (serverLevelData.D() != null) {
            this.aN().a(serverLevelData.D(), this.bc());
        }
    }

    private void initWorldBorder(WorldDataServer serverLevelData, WorldServer serverLevel) {
        WorldServer serverLevel1 = serverLevel;
        Optional<WorldBorder.c> legacyWorldBorderSettings = serverLevelData.o();
        if (legacyWorldBorderSettings.isPresent()) {
            WorldBorder.c settings = legacyWorldBorderSettings.get();
            WorldPersistentData dataStorage1 = serverLevel1.A();
            if (dataStorage1.b(WorldBorder.d) == null) {
                double coordinateScale = serverLevel1.F_().g();
                WorldBorder.c settings1 = new WorldBorder.c(settings.a() / coordinateScale, settings.b() / coordinateScale, settings.c(), settings.d(), settings.e(), settings.f(), settings.g(), settings.h(), settings.i());
                WorldBorder worldBorder = new WorldBorder(settings1);
                worldBorder.a(serverLevel1.au());
                dataStorage1.a(WorldBorder.d, worldBorder);
            }
            serverLevelData.a(Optional.empty());
        }
        serverLevel.w().world = serverLevel;
        serverLevel.w().a(this.au());
        this.aj().a(serverLevel);
    }

    private static void a(WorldServer level, IWorldDataServer levelData, boolean generateBonusChest, boolean debug, LevelLoadListener levelLoadListener) {
        if (SharedConstants.ax && SharedConstants.aN) {
            levelData.a(WorldData.a.a(level.aq(), new BlockPosition(0, 64, -100), 0.0f, 0.0f));
        } else if (debug) {
            levelData.a(WorldData.a.a(level.aq(), BlockPosition.c.b(80), 0.0f, 0.0f));
        } else {
            ChunkProviderServer chunkSource = level.p();
            if (level.generator != null) {
                Random rand = new Random(level.J());
                Location spawn = level.generator.getFixedSpawnLocation((World)level.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != level.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + levelData.d() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    levelData.a(WorldData.a.a(level.aq(), CraftLocation.toBlockPosition(spawn), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkSource.i().b().a());
            levelLoadListener.a(LevelLoadListener.a.b, 0);
            levelLoadListener.a(level.aq(), chunkPos);
            int spawnHeight = chunkSource.g().a(level);
            if (spawnHeight < level.K_()) {
                BlockPosition worldPosition = chunkPos.m();
                spawnHeight = level.a(HeightMap.Type.b, worldPosition.u() + 8, worldPosition.w() + 8);
            }
            levelData.a(WorldData.a.a(level.aq(), chunkPos.m().b(8, spawnHeight, 8), 0.0f, 0.0f));
            int i2 = 0;
            int i1 = 0;
            int i22 = 0;
            int i3 = -1;
            for (int i4 = 0; i4 < MathHelper.i(11); ++i4) {
                BlockPosition spawnPosInChunk;
                if (i2 >= -5 && i2 <= 5 && i1 >= -5 && i1 <= 5 && (spawnPosInChunk = PlayerSpawnFinder.a(level, new ChunkCoordIntPair(chunkPos.h + i2, chunkPos.i + i1))) != null) {
                    levelData.a(WorldData.a.a(level.aq(), spawnPosInChunk, 0.0f, 0.0f));
                    break;
                }
                if (i2 == i1 || i2 < 0 && i2 == -i1 || i2 > 0 && i2 == 1 - i1) {
                    int i5 = i22;
                    i22 = -i3;
                    i3 = i5;
                }
                i2 += i22;
                i1 += i3;
            }
            if (generateBonusChest) {
                level.J_().a(Registries.aY).flatMap(registry -> registry.a(MiscOverworldFeatures.m)).ifPresent(holder -> ((WorldGenFeatureConfigured)holder.a()).a(level, chunkSource.g(), level.y, levelData.a().b()));
            }
            levelLoadListener.a(LevelLoadListener.a.b);
        }
    }

    private void a(SaveData worldData) {
        worldData.a(EnumDifficulty.a);
        worldData.d(true);
        IWorldDataServer serverLevelData = worldData.H();
        serverLevelData.b(false);
        serverLevelData.a(false);
        serverLevelData.a(1000000000);
        serverLevelData.b(6000L);
        serverLevelData.a(EnumGamemode.d);
    }

    public void prepareLevel(WorldServer serverLevel) {
        this.forceTicks = true;
        ChunkLoadCounter chunkLoadCounter = new ChunkLoadCounter();
        chunkLoadCounter.a(serverLevel, () -> {
            TicketStorage ticketStorage = serverLevel.A().b(TicketStorage.b);
            if (ticketStorage != null) {
                ticketStorage.b();
            }
        });
        serverLevel.levelLoadListener.a(LevelLoadListener.a.c, chunkLoadCounter.c());
        do {
            serverLevel.levelLoadListener.a(LevelLoadListener.a.c, chunkLoadCounter.a(), chunkLoadCounter.c());
            this.executeModerately();
        } while (chunkLoadCounter.b() > 0);
        serverLevel.levelLoadListener.a(LevelLoadListener.a.c);
        serverLevel.b(serverLevel.O());
        this.bI();
        this.forceTicks = false;
        new WorldLoadEvent((World)serverLevel.getWorld()).callEvent();
    }

    protected GlobalPos v() {
        return this.k.H().a().c();
    }

    public EnumGamemode w() {
        return this.k.j();
    }

    public boolean v_() {
        return this.k.k();
    }

    public abstract LevelBasedPermissionSet k();

    public abstract PermissionSet l();

    public abstract boolean m();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        if (this.N() != null) {
            this.at.a(this.N().A().a(PersistentScoreboard.a));
        }
        boolean flag = false;
        for (WorldServer serverLevel : this.P()) {
            if (!suppressLogs) {
                m.info("Saving chunks for level '{}'/{}", (Object)serverLevel, (Object)serverLevel.aq().a());
            }
            serverLevel.save(null, flush, SharedConstants.X || serverLevel.e && !force, close);
            flag = true;
        }
        if (flush) {
            for (WorldServer serverLevel : this.P()) {
                m.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)serverLevel.p().a.l());
            }
            m.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean var4;
        try {
            this.aL = true;
            this.aj().h();
            var4 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aL = false;
        }
        return var4;
    }

    @Override
    public void close() {
        this.x();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void x() {
        Iterator<WorldServer> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        this.aP.close();
        if (this.B.e()) {
            this.aY();
        }
        m.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        if (this.server != null) {
            this.server.spark.disable();
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.ak().b();
        this.aL = true;
        if (this.R != null) {
            m.info("Saving players");
            this.R.h();
            this.R.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        m.info("Saving worlds");
        for (WorldServer serverLevel : this.P()) {
            if (serverLevel == null) continue;
            serverLevel.e = false;
        }
        for (WorldServer world : this.P()) {
            world.p().q();
        }
        this.saveAllChunks(false, true, false, true);
        this.aL = false;
        this.aD.close();
        try {
            this.g.close();
        }
        catch (IOException var4) {
            m.error("Failed to unlock level {}", (Object)this.g.f(), (Object)var4);
        }
        MCUtil.ASYNC_EXECUTOR.shutdown();
        try {
            MCUtil.ASYNC_EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            m.info("Saving usercache.json");
            this.ar().f().save(false);
        }
        m.info("Waiting for all RegionFile I/O tasks to complete...");
        MoonriseRegionFileIO.flush(this);
        m.info("All RegionFile I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
        SystemUtils.k();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.i();
    }

    public String y() {
        return this.N;
    }

    @Override
    public void a_(String localIp) {
        this.N = localIp;
    }

    public boolean z() {
        return this.S;
    }

    public void a(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.S = false;
        if (waitForShutdown) {
            try {
                this.ak.join();
            }
            catch (InterruptedException var3) {
                m.error("Error while shutting down", (Throwable)var3);
            }
        }
    }

    private void initTickSchedule() {
        long interval = this.I() || !this.aF.a() ? this.aF.h() : 0L;
        this.tickSchedule.setNextPeriod(this.ao, interval);
        this.lastTickStart = Long.MIN_VALUE;
        this.scheduledTickStart = this.tickSchedule.getDeadline(interval);
    }

    private void recordEndOfTick() {
        long prevStart = this.lastTickStart;
        long currStart = this.currentTickStart;
        this.lastTickStart = this.currentTickStart;
        long scheduledStart = this.scheduledTickStart;
        this.scheduledTickStart = this.ao;
        long now = SystemUtils.d();
        TickTime time = new TickTime(prevStart, scheduledStart, currStart, 0L, now, 0L, this.taskExecutionTime, 0L, false);
        this.taskExecutionTime = 0L;
        this.addTickTime(time);
    }

    private void runAllTasksAtTickStart() {
        this.bz();
        GameProfilerFiller profiler = Profiler.a();
        profiler.a("moonrise:run_all_tasks");
        profiler.a("moonrise:run_all_server");
        while (super.E()) {
            this.moonrise$executeMidTickTasks();
            this.aP.executeSinglePacket();
        }
        profiler.b("moonrise:run_all_packets");
        while (this.aP.executeSinglePacket()) {
            this.moonrise$executeMidTickTasks();
        }
        profiler.b("moonrise:run_all_chunk");
        for (WorldServer world : this.P()) {
            profiler.a(world.toString() + " " + String.valueOf(world.aq().a()));
            profiler.a("moonrise:distance_manager_update");
            world.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
            profiler.b("moonrise:legacy_chunk_tasks");
            world.p().g.executeAllRecentInternalTasks();
            profiler.b("moonrise:chunk_system_tasks");
            world.moonrise$getChunkTaskScheduler().executeAllRecentlyQueuedMainThreadTasks();
            profiler.c();
            profiler.c();
        }
        profiler.c();
        profiler.c();
        this.bA();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTaskExecutionTimeWhileWaiting() {
        GameProfilerFiller profiler = Profiler.a();
        profiler.a("moonrise:execute_tasks_until_tick");
        this.ap = true;
        boolean isLoggingEnabled = this.g();
        try {
            long deadline = this.ao;
            while (true) {
                long start;
                if ((start = SystemUtils.d()) - deadline >= 0L) {
                } else {
                    while (this.E() && SystemUtils.d() - deadline < 0L) {
                    }
                    long now = SystemUtils.d();
                    this.taskExecutionTime += now - start;
                    long toWait = deadline - now;
                    if (toWait > 0L) {
                        LockSupport.parkNanos("waiting for tick or tasks", toWait);
                        if (!isLoggingEnabled) continue;
                        this.an += SystemUtils.d() - now;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.ap = false;
        }
        profiler.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void A() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.ao = SystemUtils.d();
            this.initTickSchedule();
            this.K = this.bD().orElse(null);
            this.J = this.bG();
            this.server.spark.enableBeforePlugins();
            m.info("Running delayed init tasks");
            new RegionizedServerInitEvent().callEvent();
            this.server.getScheduler().mainThreadHeartbeat();
            long actualDoneTimeMs = System.currentTimeMillis() - Main.BOOT_TIME.toEpochMilli();
            m.info("Done ({})! For help, type \"help\"", (Object)String.format(Locale.ROOT, "%.3fs", (double)actualDoneTimeMs / 1000.0));
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            if (GlobalConfiguration.isFirstStart) {
                m.info("*************************************************************************************");
                m.info("This is the first time you're starting this server.");
                m.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                m.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                m.info("*************************************************************************************");
            }
            if (System.getProperty("paper.disableStartupVersionCheck") == null && GlobalConfiguration.get().updateChecker.enabled) {
                CompletableFuture.runAsync(PaperVersionFetcher::getUpdateStatusStartupMessage, MCUtil.ASYNC_EXECUTOR);
            }
            while (this.S) {
                boolean flag;
                long l2;
                long tickStart = System.nanoTime();
                if (!this.I() && this.aF.a() && this.aF.d()) {
                    l2 = 0L;
                    this.tickSchedule.setNextPeriod(tickStart, l2);
                } else {
                    long catchup;
                    l2 = this.aF.h();
                    long ticksBehind = Math.max(1L, this.tickSchedule.getPeriodsAhead(l2, tickStart));
                    if (ticksBehind > (catchup = (long)Math.max(1, 5))) {
                        long difference = ticksBehind - catchup;
                        this.tickSchedule.advanceBy(difference, l2);
                    }
                    this.tickSchedule.advanceBy(1L, l2);
                }
                this.ag = this.ao = this.tickSchedule.getDeadline(l2);
                this.currentTickStart = tickStart;
                ++currentTick;
                boolean bl = flag = l2 == 0L;
                if (this.G) {
                    this.G = false;
                    this.F = new TimeProfiler(SystemUtils.d(), this.U);
                }
                try (Profiler.a scope = Profiler.a(this.bQ());){
                    this.b(flag);
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a("nextTickWait");
                    this.ar = true;
                    this.aq = Math.max(SystemUtils.d() + l2, this.ao);
                    this.bz();
                    this.recordTaskExecutionTimeWhileWaiting();
                    this.bA();
                    if (flag) {
                        this.aF.e();
                    }
                    profilerFiller.c();
                    this.by();
                }
                finally {
                    this.aU();
                }
                this.af = true;
                JvmProfiler.f.a(this.aA);
            }
        }
        catch (Throwable var69) {
            m.error("Encountered an unexpected exception", var69);
            CrashReport crashReport = MinecraftServer.b(var69);
            this.b(crashReport.f());
            Path path = this.G().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
            if (crashReport.a(path, ReportType.a)) {
                m.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                m.error("We were unable to save this crash report to disk.");
            }
            this.a(crashReport);
        }
        finally {
            try {
                this.T = true;
                this.x();
            }
            catch (Throwable var64) {
                m.error("Exception stopping the server", var64);
            }
        }
    }

    private void by() {
        long nanos = SystemUtils.d();
        if (this.g()) {
            this.f().a(nanos - this.al);
        }
        this.al = nanos;
    }

    private void bz() {
        if (this.g()) {
            this.am = SystemUtils.d();
            this.an = 0L;
        }
    }

    private void bA() {
        if (this.g()) {
            SampleLogger tickTimeLogger = this.f();
            tickTimeLogger.a(SystemUtils.d() - this.am - this.an, TpsDebugDimensions.c.ordinal());
            tickTimeLogger.a(this.an, TpsDebugDimensions.d.ordinal());
        }
    }

    private static CrashReport b(Throwable cause) {
        CrashReport report;
        ReportedException reportedException = null;
        for (Throwable throwable = cause; throwable != null; throwable = throwable.getCause()) {
            ReportedException reportedException1;
            if (!(throwable instanceof ReportedException)) continue;
            reportedException = reportedException1 = (ReportedException)throwable;
        }
        if (reportedException != null) {
            report = reportedException.a();
            if (reportedException != cause) {
                report.a("Wrapped in").a("Wrapping exception", cause);
            }
        } else {
            report = new CrashReport("Exception in server tick loop", cause);
        }
        return report;
    }

    private boolean bB() {
        return this.forceTicks || this.bP() || SystemUtils.d() < (this.ar ? this.aq : this.ao);
    }

    private void executeModerately() {
        this.bN();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean B() {
        RuntimeException runtimeException = aM.get();
        if (runtimeException != null) {
            throw runtimeException;
        }
        return true;
    }

    public static void a(RuntimeException fatalException) {
        aM.compareAndSet(null, fatalException);
    }

    @Override
    public void b(BooleanSupplier isDone) {
        super.b(() -> MinecraftServer.B() && isDone.getAsBoolean());
    }

    public NotificationManager C() {
        return this.ah;
    }

    protected void w_() {
        this.ap = true;
        try {
            this.b(() -> SystemUtils.d() - this.ao >= 0L);
        }
        finally {
            this.ap = false;
        }
    }

    @Override
    public void D() {
        boolean isTickTimeLoggingEnabled = this.g();
        long l2 = isTickTimeLoggingEnabled ? SystemUtils.d() : 0L;
        long l1 = this.ap ? this.ao - SystemUtils.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", l1);
        if (isTickTimeLoggingEnabled) {
            this.an += SystemUtils.d() - l2;
        }
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.U, runnable);
    }

    protected boolean a(TickTask runnable) {
        return runnable.a() + 1 < this.U || this.bB();
    }

    @Override
    public boolean E() {
        boolean flag;
        this.ar = flag = this.aP.executeSinglePacket() | this.bC();
        return flag;
    }

    private boolean bC() {
        if (super.E()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.aF.a() || this.bO() || this.bB()) {
            for (WorldServer serverLevel : this.P()) {
                if (!serverLevel.p().c()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask task) {
        Profiler.a().f("runTask");
        super.d(task);
    }

    private Optional<ServerPing.a> bD() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> Files.isRegularFile(path, new LinkOption[0])).or(() -> this.g.j().filter(path -> Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                byte[] allBytes = Files.readAllBytes(path);
                PngInfo pngInfo = PngInfo.a(allBytes);
                if (pngInfo.a() == 64 && pngInfo.b() == 64) {
                    return Optional.of(new ServerPing.a(allBytes));
                }
                throw new IllegalArgumentException("Invalid world icon size [" + pngInfo.a() + ", " + pngInfo.b() + "], but expected [64, 64]");
            }
            catch (Exception var3) {
                m.error("Couldn't load server icon", (Throwable)var3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> F() {
        return this.g.j();
    }

    public Path G() {
        return Path.of("", new String[0]);
    }

    public ServerActivityMonitor H() {
        return this.ai;
    }

    public void a(CrashReport report) {
    }

    public void i() {
    }

    public boolean I() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(BooleanSupplier hasTimeLeft) {
        WatchdogThread.tick();
        long nanos = SystemUtils.d();
        int i2 = this.bu() * 20;
        this.removeDisabledPluginsBlockingSleep();
        if (i2 > 0) {
            this.aK = this.R.m() == 0 && !this.aF.a() && this.pluginsBlockingSleep.isEmpty() ? ++this.aK : 0;
            if (this.aK >= i2) {
                Runnable task;
                this.server.spark.tickStart();
                if (this.aK == i2) {
                    m.info("Server empty for {} seconds, pausing", (Object)this.bu());
                    this.bE();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                while ((task = this.processQueue.poll()) != null) {
                    task.run();
                }
                for (WorldServer level : this.Q.values()) {
                    level.p().a(() -> true, false);
                }
                this.server.spark.executeMainThreadTasks();
                this.K();
                this.server.spark.tickEnd((double)(System.nanoTime() - this.currentTickStart) / 1000000.0);
                return;
            }
        }
        this.server.spark.tickStart();
        new ServerTickStartEvent(this.U + 1).callEvent();
        ++this.U;
        this.aF.m();
        this.c(hasTimeLeft);
        if (nanos - this.aj >= t) {
            this.aj = nanos;
            this.J = this.bG();
        }
        --this.V;
        GameProfilerFiller profiler = Profiler.a();
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        profiler.a("save");
        boolean fullSave = this.autosavePeriod > 0 && this.U % this.autosavePeriod == 0;
        try {
            this.aL = true;
            if (playerSaveInterval > 0) {
                this.R.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.P()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aL = false;
        }
        profiler.c();
        GameProfilerFiller profilerFiller = Profiler.a();
        this.server.spark.executeMainThreadTasks();
        long endTime = System.nanoTime();
        long remaining = this.ao - endTime;
        new ServerTickEndEvent(this.U, (double)(endTime - this.currentTickStart) / 1000000.0, remaining).callEvent();
        this.server.spark.tickEnd((double)(endTime - this.currentTickStart) / 1000000.0);
        profilerFiller.a("tallying");
        long l2 = SystemUtils.d() - nanos;
        int i1 = this.U % 100;
        this.ab -= this.aa[i1];
        this.ab += l2;
        this.aa[i1] = l2;
        this.aA = this.aA * 0.8f + (float)l2 / (float)TimeRange.b * 0.19999999f;
        this.a(nanos);
        profilerFiller.c();
    }

    protected void b(boolean sprinting) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("tick");
        this.aO.start();
        this.runAllTasksAtTickStart();
        this.a(sprinting ? () -> false : this::bB);
        Throwable crash = this.chunkSystemCrash;
        if (crash != null) {
            this.chunkSystemCrash = null;
            throw new RuntimeException("Chunk system crash propagated to tick()", crash);
        }
        this.aO.end();
        this.recordEndOfTick();
        profilerFiller.c();
    }

    private void bE() {
        this.V = this.autosavePeriod;
        m.debug("Autosave started");
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("save");
        this.b(true, false, false);
        profilerFiller.c();
        m.debug("Autosave finished");
    }

    private void a(long startTime) {
        if (this.g()) {
            this.f().a(SystemUtils.d() - startTime, TpsDebugDimensions.b.ordinal());
        }
    }

    private int bF() {
        float f2;
        if (this.aF.a()) {
            long l2 = this.aS() + 1L;
            f2 = (float)TimeRange.a / (float)l2;
        } else {
            f2 = this.aF.f();
        }
        int i2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void J() {
        int i2 = this.bF();
        if (i2 < this.V) {
            this.V = i2;
        }
    }

    protected abstract SampleLogger f();

    public abstract boolean g();

    private ServerPing bG() {
        ServerPing.ServerPingPlayerSample players = this.bH();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(players), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.K), this.ay());
    }

    private ServerPing.ServerPingPlayerSample bH() {
        List<EntityPlayer> players = this.R.t();
        int maxPlayers = this.r();
        if (this.ao()) {
            return new ServerPing.ServerPingPlayerSample(maxPlayers, players.size(), List.of());
        }
        int min = Math.min(players.size(), SpigotConfig.playerSample);
        ObjectArrayList list = new ObjectArrayList(min);
        int randomInt = MathHelper.a(this.L, 0, players.size() - min);
        for (int i2 = 0; i2 < min; ++i2) {
            EntityPlayer serverPlayer = players.get(randomInt + i2);
            list.add((Object)(serverPlayer.aa() ? serverPlayer.gJ() : f));
        }
        SystemUtils.c(list, this.L);
        return new ServerPing.ServerPingPlayerSample(maxPlayers, players.size(), (List<NameAndId>)list);
    }

    protected void c(BooleanSupplier hasTimeLeft) {
        GameProfilerFiller profilerFiller = Profiler.a();
        this.aj().t().forEach(serverPlayer1 -> serverPlayer1.g.f());
        this.server.getScheduler().mainThreadHeartbeat();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        for (EntityScheduler scheduler : this.entitySchedulerTickList.getAllSchedulers()) {
            if (scheduler.isRetired()) continue;
            scheduler.executeTick();
        }
        ClickCallbackProviderImpl.ADVENTURE_CLICK_MANAGER.handleQueue(this.U);
        ClickCallbackProviderImpl.DIALOG_CLICK_MANAGER.handleQueue(this.U);
        profilerFiller.a("commandFunctions");
        this.aC().b();
        profilerFiller.b("levels");
        this.bI();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (WorldServer level : this.P()) {
            boolean doDaylight = level.U().a(GameRules.a);
            long dayTime = level.al();
            long worldTime = level.au();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level.E()) {
                if (!(entityHuman instanceof EntityPlayer) || (this.U + entityHuman.aA()) % 20 != 0) continue;
                EntityPlayer entityplayer = (EntityPlayer)entityHuman;
                long playerTime = entityplayer.getPlayerTime();
                boolean relativeTime = entityplayer.relativeTime;
                PacketPlayOutUpdateTime packet = (relativeTime || !doDaylight) && playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, relativeTime && doDaylight);
                entityplayer.g.b(packet);
            }
        }
        this.isIteratingOverLevels = true;
        for (WorldServer serverLevel : this.P()) {
            serverLevel.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.updateLagCompensationTick();
            TileEntityHopper.skipHopperEvents = serverLevel.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            profilerFiller.a(() -> String.valueOf(serverLevel) + " " + String.valueOf(serverLevel.aq().a()));
            profilerFiller.a("tick");
            try {
                serverLevel.a(hasTimeLeft);
            }
            catch (Throwable var7) {
                CrashReport crashReport = CrashReport.a(var7, "Exception ticking world");
                serverLevel.a(crashReport);
                throw new ReportedException(crashReport);
            }
            profilerFiller.c();
            profilerFiller.c();
            serverLevel.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        profilerFiller.b("connection");
        this.K();
        profilerFiller.b("players");
        this.R.d();
        profilerFiller.b("debugSubscribers");
        this.aG.a();
        if (this.aF.i()) {
            profilerFiller.b("gameTests");
            GameTestHarnessTicker.a.b();
        }
        profilerFiller.b("server gui refresh");
        for (Runnable runnable : this.A) {
            runnable.run();
        }
        profilerFiller.b("send chunks");
        for (EntityPlayer serverPlayer : this.R.t()) {
            serverPlayer.g.h.a(serverPlayer);
            serverPlayer.g.g();
        }
        profilerFiller.c();
        this.ai.a();
    }

    public void bI() {
        WorldServer serverLevel = this.aH();
        WorldData.a respawnData = serverLevel.I.a();
        respawnData = respawnData.withLevel(serverLevel.aq());
        this.aH = serverLevel.b(respawnData);
    }

    public void K() {
        this.ak().c();
    }

    private void a(WorldServer level) {
        this.R.a(new PacketPlayOutUpdateTime(level.au(), level.al(), level.U().a(GameRules.a)), level.aq());
    }

    public void L() {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("timeSync");
        for (WorldServer serverLevel : this.P()) {
            this.a(serverLevel);
        }
        profilerFiller.c();
    }

    public void b(Runnable tickable) {
        this.A.add(tickable);
    }

    protected void b(String serverId) {
        this.aC = serverId;
    }

    public boolean M() {
        return !this.ak.isAlive();
    }

    public Path c(String path) {
        return this.G().resolve(path);
    }

    public final WorldServer N() {
        return this.Q.get(net.minecraft.world.level.World.h);
    }

    public @Nullable WorldServer a(ResourceKey<net.minecraft.world.level.World> dimension) {
        return this.Q.get(dimension);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.aq(), level);
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.aq());
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> O() {
        return this.Q.keySet();
    }

    public Iterable<WorldServer> P() {
        return this.Q.values();
    }

    @Override
    public String Q() {
        return SharedConstants.b().c();
    }

    @Override
    public int R() {
        return this.R.m();
    }

    public String[] S() {
        return this.R.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return ServerBuildInfo.buildInfo().brandName();
    }

    public SystemReport b(SystemReport systemReport) {
        systemReport.a("Server Running", () -> Boolean.toString(this.S));
        if (this.R != null) {
            systemReport.a("Player Count", () -> this.R.m() + " / " + this.R.n() + "; " + String.valueOf(this.R.t()));
        }
        systemReport.a("Active Data Packs", () -> ResourcePackRepository.a(this.as.g()));
        systemReport.a("Available Data Packs", () -> ResourcePackRepository.a(this.as.d()));
        systemReport.a("Enabled Feature Flags", () -> FeatureFlags.e.b(this.k.J()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        systemReport.a("World Generation", () -> this.k.A().toString());
        systemReport.a("World Seed", () -> String.valueOf(this.k.x().c()));
        systemReport.a("Suppressed Exceptions", this.aN::a);
        if (this.aC != null) {
            systemReport.a("Server Id", () -> this.aC);
        }
        return this.a(systemReport);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck T() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message) {
        m.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair U() {
        return Objects.requireNonNull(this.ac);
    }

    public int V() {
        return this.O;
    }

    public void b(int port) {
        this.O = port;
    }

    public @Nullable GameProfile W() {
        return this.ad;
    }

    public void a(@Nullable GameProfile singleplayerProfile) {
        this.ad = singleplayerProfile;
    }

    public boolean X() {
        return this.ad != null;
    }

    protected void Y() {
        m.info("Generating keypair");
        try {
            this.ac = MinecraftEncryption.b();
        }
        catch (CryptographyException var2) {
            throw new IllegalStateException("Failed to generate key pair", var2);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, @Nullable CommandListenerWrapper source, boolean forced) {
        WorldDataServer worldData = level.I;
        if (forced || !worldData.q()) {
            new WorldDifficultyChangeEvent((World)level.getWorld(), (CommandSourceStack)source, CraftDifficulty.toBukkit(difficulty)).callEvent();
            worldData.a(worldData.k() ? EnumDifficulty.d : difficulty);
            level.b(level.O());
        }
    }

    public int c(int trackingDistance) {
        return trackingDistance;
    }

    public void Z() {
        for (WorldServer serverLevel : this.P()) {
            serverLevel.b(serverLevel.O());
        }
    }

    public void c(boolean locked) {
        this.k.d(locked);
        this.aj().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData levelData = player.A().D_();
        player.g.b(new PacketPlayOutServerDifficulty(levelData.p(), levelData.q()));
    }

    public boolean aa() {
        return this.ae;
    }

    @Override
    public void d(boolean demo) {
        this.ae = demo;
    }

    public Map<String, String> ab() {
        return Map.of();
    }

    public Optional<ServerResourcePackInfo> ac() {
        return Optional.empty();
    }

    public boolean ad() {
        return this.ac().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean ae() {
        return this.W;
    }

    public void e(boolean online) {
        this.W = online;
    }

    public boolean af() {
        return this.X;
    }

    public void f(boolean preventProxyConnections) {
        this.X = preventProxyConnections;
    }

    public abstract boolean p();

    public boolean ag() {
        return true;
    }

    @Override
    public String ah() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean ai() {
        return this.T;
    }

    public PlayerList aj() {
        return this.R;
    }

    public void a(PlayerList list) {
        this.R = list;
    }

    public abstract boolean q();

    public void a(EnumGamemode gameMode) {
        this.k.a(gameMode);
    }

    public int b(@Nullable EnumGamemode gameMode) {
        if (gameMode == null) {
            return 0;
        }
        int i2 = 0;
        for (EntityPlayer serverPlayer : this.aj().t()) {
            PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null);
            if (event == null || event.isCancelled()) continue;
            ++i2;
        }
        return i2;
    }

    public ServerConnection ak() {
        return this.H == null ? (this.H = new ServerConnection(this)) : this.H;
    }

    public boolean al() {
        return this.af;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean commands, int port) {
        return false;
    }

    public int am() {
        return this.U;
    }

    public boolean a(WorldServer level, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean an() {
        return true;
    }

    public boolean ao() {
        return false;
    }

    public Proxy ap() {
        return this.i;
    }

    public int aq() {
        return this.Z;
    }

    @Override
    public void d(int idleTimeout) {
        this.Z = idleTimeout;
    }

    public Services ar() {
        return this.j;
    }

    public @Nullable ServerPing as() {
        return this.J;
    }

    public void at() {
        this.aj = 0L;
    }

    public int au() {
        return 29999984;
    }

    @Override
    public boolean av() {
        return super.av() && !this.ai();
    }

    @Override
    public void c(Runnable task) {
        if (this.ai()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.c(task);
    }

    @Override
    public Thread aw() {
        return this.ak;
    }

    public int ax() {
        return 256;
    }

    public boolean ay() {
        return false;
    }

    public long az() {
        return this.ao;
    }

    public DataFixer aA() {
        return this.M;
    }

    public AdvancementDataWorld aB() {
        return this.aD.b.e();
    }

    public CustomFunctionData aC() {
        return this.ax;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> selectedIds) {
        return this.reloadResources(selectedIds, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> selectedIds, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)selectedIds.stream().map(this.as::c).filter(Objects::nonNull).map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList()), this).thenCompose(list -> {
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)list);
            List<IRegistry.a<?>> list1 = TagDataPack.loadTagsForExistingRegistries(closeableResourceManager, this.P.a(), ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, this.P, list1, this.k.J(), this.n() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.l(), this.aB, this).whenComplete((reloadableServerResources, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApply(reloadableServerResources -> new ReloadableResources(closeableResourceManager, (DataPackResources)reloadableServerResources));
        })).thenAcceptAsync(reloadableResources -> {
            PaperBrigadier.moveBukkitCommands(this.aD.b().d(), reloadableResources.b().d);
            this.aD.close();
            this.aD = reloadableResources;
            this.as.setSelected(selectedIds, false);
            WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(MinecraftServer.a(this.as, true), this.k.J());
            this.k.a(worldDataConfiguration);
            this.aD.b.g();
            this.aD.b.c().a(this.k.J());
            this.aI = this.aI.reload(this.k.J());
            if (Thread.currentThread() != this.ak) {
                return;
            }
            for (EntityPlayer player : this.aj().t()) {
                player.U().b();
            }
            this.aj().u();
            this.ax.a(this.aD.b.a());
            this.aE.a(this.aD.a);
            this.aJ = FuelValues.a(this.P.a(), this.k.J());
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bK()) {
            this.b(((CompletableFuture)completableFuture)::isDone);
        }
        return completableFuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean initMode, boolean safeMode) {
        DataPackConfiguration dataPackConfig = initialDataConfig.a();
        FeatureFlagSet featureFlagSet = initMode ? FeatureFlagSet.a() : initialDataConfig.b();
        FeatureFlagSet featureFlagSet1 = initMode ? FeatureFlags.e.a() : initialDataConfig.b();
        packRepository.reload(true);
        if (safeMode) {
            return MinecraftServer.a(packRepository, List.of(b), featureFlagSet, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String string : dataPackConfig.a()) {
            if (packRepository.d(string)) {
                set.add(string);
                continue;
            }
            m.warn("Missing data pack {}", (Object)string);
        }
        for (ResourcePackLoader pack : packRepository.d()) {
            String id = pack.g();
            if (dataPackConfig.b().contains(id)) continue;
            FeatureFlagSet requestedFeatures = pack.e();
            boolean flag = set.contains(id);
            if (!flag && pack.l().a()) {
                if (requestedFeatures.a(featureFlagSet1)) {
                    m.info("Found new data pack {}, loading it automatically", (Object)id);
                    set.add(id);
                } else {
                    m.info("Found new data pack {}, but can't load it due to missing features {}", (Object)id, (Object)FeatureFlags.a(featureFlagSet1, requestedFeatures));
                }
            }
            if (!flag || requestedFeatures.a(featureFlagSet1)) continue;
            m.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)id, (Object)FeatureFlags.a(featureFlagSet1, requestedFeatures));
            set.remove(id);
        }
        if (set.isEmpty()) {
            m.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(packRepository, set, featureFlagSet, true);
    }

    private static WorldDataConfiguration a(ResourcePackRepository packRepository, Collection<String> selectedPacks, FeatureFlagSet enabledFeatures, boolean safeMode) {
        packRepository.setSelected(selectedPacks, true);
        MinecraftServer.a(packRepository, enabledFeatures);
        DataPackConfiguration selectedPacks1 = MinecraftServer.a(packRepository, safeMode);
        FeatureFlagSet featureFlagSet = packRepository.f().c(enabledFeatures);
        return new WorldDataConfiguration(selectedPacks1, featureFlagSet);
    }

    private static void a(ResourcePackRepository packRepository, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet requestedFeatureFlags = packRepository.f();
        FeatureFlagSet featureFlagSet = enabledFeatures.d(requestedFeatureFlags);
        if (!featureFlagSet.b()) {
            ObjectArraySet set = new ObjectArraySet(packRepository.e());
            for (ResourcePackLoader pack : packRepository.d()) {
                if (featureFlagSet.b()) break;
                if (pack.l() != PackSource.d) continue;
                String id = pack.g();
                FeatureFlagSet requestedFeatures = pack.e();
                if (requestedFeatures.b() || !requestedFeatures.b(featureFlagSet) || !requestedFeatures.a(enabledFeatures)) continue;
                if (!set.add(id)) {
                    throw new IllegalStateException("Tried to force '" + id + "', but it was already enabled");
                }
                m.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)id);
                featureFlagSet = featureFlagSet.d(requestedFeatures);
            }
            packRepository.setSelected((Collection<String>)set, true);
        }
    }

    private static DataPackConfiguration a(ResourcePackRepository packRepository, boolean safeMode) {
        Collection<String> selectedIds = packRepository.e();
        ImmutableList list = ImmutableList.copyOf(selectedIds);
        List<String> list1 = safeMode ? packRepository.c().stream().filter(packId -> !selectedIds.contains(packId)).toList() : List.of();
        return new DataPackConfiguration((List<String>)list, list1);
    }

    public void aD() {
        if (this.aO() && this.aP()) {
            PlayerList playerList = this.aj();
            WhiteList whiteList = playerList.i();
            for (EntityPlayer serverPlayer : Lists.newArrayList(playerList.t())) {
                if (whiteList.a(serverPlayer.gJ()) || this.aj().f(serverPlayer.gJ())) continue;
                serverPlayer.g.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aE() {
        return this.as;
    }

    public CommandDispatcher aF() {
        return this.aD.b.d();
    }

    public CommandListenerWrapper aG() {
        WorldServer serverLevel = this.aH();
        return new CommandListenerWrapper(this, Vec3D.a(this.aI().b()), Vec2F.a, serverLevel, LevelBasedPermissionSet.e, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    public WorldServer aH() {
        ResourceKey<net.minecraft.world.level.World> resourceKey = ((WorldDataServer)this.bb().H()).respawnDimension;
        WorldServer level = this.a(resourceKey);
        return level != null ? level : this.N();
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public void a(WorldData.a respawnData) {
        IWorldDataServer serverLevelData = this.k.H();
        WorldData.a respawnData1 = serverLevelData.a();
        if (!respawnData1.equals(respawnData)) {
            serverLevelData.a(respawnData);
            this.aj().a(new PacketPlayOutSpawnPosition(respawnData));
            this.bI();
        }
    }

    public WorldData.a aI() {
        return this.aH;
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public CraftingManager aJ() {
        return this.aD.b.c();
    }

    public ScoreboardServer aK() {
        return this.at;
    }

    public PersistentCommandStorage aL() {
        if (this.av == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.av;
    }

    public Stopwatches aM() {
        if (this.au == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.au;
    }

    public BossBattleCustomData aN() {
        return this.aw;
    }

    public boolean aO() {
        return this.ay;
    }

    public void g(boolean enforceWhitelist) {
        this.ay = enforceWhitelist;
    }

    public boolean aP() {
        return this.az;
    }

    public void h(boolean usingWhitelist) {
        this.az = usingWhitelist;
    }

    public float aQ() {
        return this.aA;
    }

    public ServerTickRateManager aR() {
        return this.aF;
    }

    public long aS() {
        return this.ab / (long)Math.min(100, Math.max(this.U, 1));
    }

    public long[] aT() {
        return this.aa;
    }

    public LevelBasedPermissionSet b(NameAndId nameAndId) {
        if (this.aj().f(nameAndId)) {
            OpListEntry serverOpListEntry = (OpListEntry)this.aj().k().c(nameAndId);
            if (serverOpListEntry != null) {
                return serverOpListEntry.a();
            }
            if (this.a(nameAndId)) {
                return LevelBasedPermissionSet.e;
            }
            if (this.X()) {
                return this.aj().v() ? LevelBasedPermissionSet.e : LevelBasedPermissionSet.a;
            }
            return this.k();
        }
        return LevelBasedPermissionSet.a;
    }

    public abstract boolean a(NameAndId var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.Q.entrySet()) {
                MinecraftKey identifier = entry.getKey().a();
                Path path2 = path1.resolve(identifier.b()).resolve(identifier.a());
                Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException var7) {
            m.warn("Failed to save debug report", (Throwable)var7);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bL()));
            bufferedWriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aQ())));
            bufferedWriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.aa)));
            bufferedWriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gameRules = this.k.n();
            gameRules.a(new GameRuleTypeVisitor(){

                @Override
                public <T> void a(GameRule<T> rule) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", rule.b(), gameRules.b(rule)));
                }
            });
            for (String string : list) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String property = System.getProperty("java.class.path");
            String string = File.pathSeparator;
            for (String string1 : Splitter.on((String)string).split((CharSequence)property)) {
                bufferedWriter.write(string1);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        Arrays.sort(threadInfos, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : threadInfos) {
                bufferedWriter.write(threadInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(NativeModuleLister.a());
            }
            catch (Throwable var7) {
                m.warn("Failed to list native modules", var7);
                if (bufferedWriter != null) {
                    ((Writer)bufferedWriter).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativeModuleInfo1 -> nativeModuleInfo1.a));
            for (NativeModuleLister.a nativeModuleInfo : list) {
                bufferedWriter.write(nativeModuleInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    ((Writer)bufferedWriter).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean bK() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    private GameProfilerFiller bQ() {
        if (this.E) {
            this.B = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.c, this.n()), SystemUtils.c, SystemUtils.i(), new MetricsPersister("server"), this.C, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.D.accept((Path)path);
            });
            this.E = false;
        }
        this.B.c();
        return GameProfilerTick.a(this.B.f(), GameProfilerTick.a("Server"));
    }

    public void aU() {
        this.B.d();
    }

    public boolean aV() {
        return this.B.e();
    }

    public void a(Consumer<MethodProfilerResults> output, Consumer<Path> onMetricsRecordingFinished) {
        this.C = profileResults -> {
            this.aW();
            output.accept((MethodProfilerResults)profileResults);
        };
        this.D = onMetricsRecordingFinished;
        this.E = true;
    }

    public void aW() {
        this.B = InactiveMetricsRecorder.a;
    }

    public void aX() {
        this.B.a();
    }

    public void aY() {
        this.B.b();
    }

    public Path a(SavedFile levelResource) {
        return this.g.a(levelResource);
    }

    public boolean aZ() {
        return true;
    }

    public StructureTemplateManager ba() {
        return this.aE;
    }

    public SaveData bb() {
        return this.k;
    }

    public IRegistryCustom.Dimension bc() {
        return this.P.a();
    }

    public LayeredRegistryAccess<RegistryLayer> bd() {
        return this.P;
    }

    public ReloadableServerRegistries.a be() {
        return this.aD.b.b();
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.e;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.aa() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    public @Nullable EnumGamemode bf() {
        return null;
    }

    public IResourceManager bg() {
        return this.aD.a;
    }

    public boolean bh() {
        return this.aL;
    }

    public boolean bi() {
        return this.G || this.F != null;
    }

    public void bj() {
        this.G = true;
    }

    public MethodProfilerResults bk() {
        if (this.F == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults profileResults = this.F.a(SystemUtils.d(), this.U);
        this.F = null;
        return profileResults;
    }

    public int bl() {
        return 1000000;
    }

    public void a(IChatBaseComponent content, ChatMessageType.a boundChatType, @Nullable String header) {
        Component string = PaperAdventure.asAdventure(boundChatType.a(content));
        if (header != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)header, (Object)string);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)string);
        }
    }

    public ChatDecorator bm() {
        return this.improvedChatDecorator;
    }

    public boolean bn() {
        return true;
    }

    public void a(MinecraftKey id, Optional<NBTBase> payload) {
        m.debug("Received custom click action {} with payload {}", (Object)id, payload.orElse(null));
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public LevelLoadListener bo() {
        throw new UnsupportedOperationException();
    }

    public boolean i(boolean autoSave) {
        boolean flag = false;
        for (WorldServer serverLevel : this.P()) {
            if (serverLevel == null || serverLevel.e != autoSave) continue;
            serverLevel.e = !autoSave;
            flag = true;
        }
        return flag;
    }

    public boolean bp() {
        for (WorldServer serverLevel : this.P()) {
            if (serverLevel == null || serverLevel.e) continue;
            return true;
        }
        return false;
    }

    public <T> void onGameRuleChanged(WorldServer serverLevel, GameRule<T> rule, T value) {
        this.C().onGameRuleChanged(serverLevel, rule, value);
        if (rule == GameRules.P) {
            byte b2 = (byte)((Boolean)value != false ? 22 : 23);
            for (EntityPlayer serverPlayer : serverLevel.E()) {
                serverPlayer.g.b(new PacketPlayOutEntityStatus(serverPlayer, b2));
            }
        } else if (rule == GameRules.u || rule == GameRules.r) {
            PacketPlayOutGameStateChange.a type = rule == GameRules.u ? PacketPlayOutGameStateChange.n : PacketPlayOutGameStateChange.m;
            PacketPlayOutGameStateChange clientboundGameEventPacket = new PacketPlayOutGameStateChange(type, (Boolean)value != false ? 1.0f : 0.0f);
            serverLevel.E().forEach(serverPlayer1 -> serverPlayer1.g.b(clientboundGameEventPacket));
        } else if (rule == GameRules.v) {
            ServerWaypointManager waypointManager = serverLevel.j();
            if (((Boolean)value).booleanValue()) {
                serverLevel.E().forEach(waypointManager::b);
            } else {
                waypointManager.a();
            }
        } else if (rule == GameRules.W) {
            serverLevel.b(serverLevel.O());
        }
    }

    public boolean bq() {
        return false;
    }

    private void a(CrashReport crashReport, ChunkCoordIntPair chunkPos, RegionStorageInfo regionStorageInfo) {
        SystemUtils.i().execute(() -> {
            try {
                Path file = this.c("debug");
                FileUtils.c(file);
                String string = FileUtils.a(regionStorageInfo.a());
                Path path = file.resolve("chunk-" + string + "-" + SystemUtils.f() + "-server.txt");
                FileStore fileStore = Files.getFileStore(file);
                long usableSpace = fileStore.getUsableSpace();
                if (usableSpace < 8192L) {
                    m.warn("Not storing chunk IO report due to low space on drive {}", (Object)fileStore.name());
                    return;
                }
                CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk Info");
                crashReportCategory.a("Level", regionStorageInfo::a);
                crashReportCategory.a("Dimension", () -> regionStorageInfo.b().a().toString());
                crashReportCategory.a("Storage", regionStorageInfo::c);
                crashReportCategory.a("Position", chunkPos::toString);
                crashReport.a(path, ReportType.e);
                m.info("Saved details to {}", (Object)crashReport.e());
            }
            catch (Exception var11) {
                m.warn("Failed to store chunk IO exception", (Throwable)var11);
            }
        });
    }

    @Override
    public void a(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos) {
        m.error("Failed to load chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, throwable});
        this.aN.a("chunk/load", throwable);
        this.a(CrashReport.a(throwable, "Chunk load failure"), chunkPos, regionStorageInfo);
    }

    @Override
    public void b(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos) {
        m.error("Failed to save chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, throwable});
        this.aN.a("chunk/save", throwable);
        this.a(CrashReport.a(throwable, "Chunk save failure"), chunkPos, regionStorageInfo);
    }

    public void a(Throwable throwable, PacketType<?> packetType) {
        this.aN.a("packet/" + String.valueOf(packetType), throwable);
    }

    public PotionBrewer br() {
        return this.aI;
    }

    public FuelValues bs() {
        return this.aJ;
    }

    public ServerLinks bt() {
        return ServerLinks.a;
    }

    protected int bu() {
        return 0;
    }

    public PacketProcessor bv() {
        return this.aP;
    }

    public ServerDebugSubscribers bw() {
        return this.aG;
    }

    public boolean isTickPaused() {
        return this.aK > 0 && this.aK >= this.bu() * 20;
    }

    public void addPluginAllowingSleep(String pluginName, boolean value) {
        if (!value) {
            this.pluginsBlockingSleep.add(pluginName);
        } else {
            this.pluginsBlockingSleep.remove(pluginName);
        }
    }

    private void removeDisabledPluginsBlockingSleep() {
        if (this.pluginsBlockingSleep.isEmpty()) {
            return;
        }
        this.pluginsBlockingSleep.removeIf(plugin -> !PaperPluginManagerImpl.getInstance().isPluginEnabled((String)plugin));
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(WorldServer level) {
        return level.p().a.e();
    }

    static {
        m = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)m.getName());
        p = 30L * TimeRange.a / 20L;
        r = 10L * TimeRange.a;
        t = 5L * TimeRange.a;
        u = 10L * TimeRange.b;
        e = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(FeatureFlags.h), WorldDataConfiguration.d);
        f = new NameAndId(SystemUtils.e, "Anonymous Player");
        aM = new AtomicReference();
        SERVER_INIT = System.nanoTime();
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long startNanos, int startTick) {
            this.a = startNanos;
            this.b = startTick;
        }

        MethodProfilerResults a(final long endTimeNano, final int endTimeTicks) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String sectionPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTimeNano;
                }

                @Override
                public int d() {
                    return endTimeTicks;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

