/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.jspecify.annotations.Nullable;

public class ScoreboardServer
extends Scoreboard {
    private final MinecraftServer b;
    private final Set<ScoreboardObjective> c = Sets.newHashSet();
    private boolean d;

    public ScoreboardServer(MinecraftServer server) {
        this.b = server;
    }

    public void a(PersistentScoreboard.a packed) {
        packed.a().forEach(packed1 -> this.a((ScoreboardObjective.a)packed1));
        packed.b().forEach(packedScore -> this.a((Scoreboard.a)packedScore));
        packed.c().forEach((displaySlot, string) -> {
            ScoreboardObjective objective = this.a((String)string);
            this.a((DisplaySlot)displaySlot, objective);
        });
        packed.d().forEach(packed1 -> this.a((ScoreboardTeam.a)packed1));
    }

    private PersistentScoreboard.a k() {
        return new PersistentScoreboard.a(this.i(), this.g(), this.j(), this.h());
    }

    @Override
    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective, ScoreboardScore score) {
        super.a(scoreHolder, objective, score);
        if (this.c.contains(objective)) {
            this.broadcastAll(new PacketPlayOutScoreboardScore(scoreHolder.da(), objective.c(), score.a(), Optional.ofNullable(score.e()), Optional.ofNullable(score.c())));
        }
        this.a();
    }

    @Override
    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        super.a(scoreHolder, objective);
        this.a();
    }

    @Override
    public void a(ScoreHolder scoreHolder) {
        super.a(scoreHolder);
        this.broadcastAll(new ClientboundResetScorePacket(scoreHolder.da(), null));
        this.a();
    }

    @Override
    public void b(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        super.b(scoreHolder, objective);
        if (this.c.contains(objective)) {
            this.broadcastAll(new ClientboundResetScorePacket(scoreHolder.da(), objective.c()));
        }
        this.a();
    }

    @Override
    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        ScoreboardObjective displayObjective = this.a(slot);
        super.a(slot, objective);
        if (displayObjective != objective && displayObjective != null) {
            if (this.h(displayObjective) > 0) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(slot, objective));
            } else {
                this.g(displayObjective);
            }
        }
        if (objective != null) {
            if (this.c.contains(objective)) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(slot, objective));
            } else {
                this.e(objective);
            }
        }
        this.a();
    }

    @Override
    public boolean a(String playerName, ScoreboardTeam team) {
        if (super.a(playerName, team)) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, playerName, PacketPlayOutScoreboardTeam.a.a));
            this.f(playerName);
            this.a();
            return true;
        }
        return false;
    }

    public boolean addPlayersToTeam(Collection<String> players, ScoreboardTeam team) {
        boolean anyAdded = false;
        for (String playerName : players) {
            if (!super.a(playerName, team)) continue;
            anyAdded = true;
        }
        if (anyAdded) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.createMultiplePlayerPacket(team, players, PacketPlayOutScoreboardTeam.a.a));
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public void b(String playerName, ScoreboardTeam team) {
        super.b(playerName, team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, playerName, PacketPlayOutScoreboardTeam.a.b));
        this.f(playerName);
        this.a();
    }

    public void removePlayersFromTeam(Collection<String> players, ScoreboardTeam team) {
        for (String playerName : players) {
            super.b(playerName, team);
        }
        this.broadcastAll(PacketPlayOutScoreboardTeam.createMultiplePlayerPacket(team, players, PacketPlayOutScoreboardTeam.a.b));
        this.a();
    }

    @Override
    public void a(ScoreboardObjective objective) {
        super.a(objective);
        this.a();
    }

    @Override
    public void b(ScoreboardObjective objective) {
        super.b(objective);
        if (this.c.contains(objective)) {
            this.broadcastAll(new PacketPlayOutScoreboardObjective(objective, 2));
        }
        this.a();
    }

    @Override
    public void c(ScoreboardObjective objective) {
        super.c(objective);
        if (this.c.contains(objective)) {
            this.g(objective);
        }
        this.a();
    }

    @Override
    public void a(ScoreboardTeam team) {
        super.a(team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, true));
        this.a();
    }

    @Override
    public void b(ScoreboardTeam team) {
        super.b(team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team, false));
        this.e(team);
        this.a();
    }

    @Override
    public void c(ScoreboardTeam team) {
        super.c(team);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(team));
        this.e(team);
        this.a();
    }

    protected void a() {
        this.d = true;
    }

    public void a(PersistentScoreboard saveData) {
        if (this.d) {
            this.d = false;
            saveData.a(this.k());
        }
    }

    public List<Packet<?>> d(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(objective, 0));
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displaySlot, objective));
        }
        for (PlayerScoreEntry playerScoreEntry : this.i(objective)) {
            list.add(new PacketPlayOutScoreboardScore(playerScoreEntry.c(), objective.c(), playerScoreEntry.d(), Optional.ofNullable(playerScoreEntry.e()), Optional.ofNullable(playerScoreEntry.f())));
        }
        return list;
    }

    public void e(ScoreboardObjective objective) {
        List<Packet<?>> startTrackingPackets = this.d(objective);
        for (EntityPlayer serverPlayer : this.b.aj().t()) {
            if (serverPlayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : startTrackingPackets) {
                serverPlayer.g.b(packet);
            }
        }
        this.c.add(objective);
    }

    public List<Packet<?>> f(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(objective, 1));
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displaySlot, objective));
        }
        return list;
    }

    public void g(ScoreboardObjective objective) {
        List<Packet<?>> stopTrackingPackets = this.f(objective);
        for (EntityPlayer serverPlayer : this.b.aj().t()) {
            if (serverPlayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : stopTrackingPackets) {
                serverPlayer.g.b(packet);
            }
        }
        this.c.remove(objective);
    }

    public int h(ScoreboardObjective objective) {
        int i2 = 0;
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            ++i2;
        }
        return i2;
    }

    private void f(String playerName) {
        EntityPlayer playerByName = this.b.aj().a(playerName);
        if (playerByName != null) {
            playerByName.A().j().d(playerByName);
        }
    }

    private void e(ScoreboardTeam team) {
        for (WorldServer serverLevel : this.b.P()) {
            team.h().stream().map(string -> this.b.aj().a((String)string)).filter(Objects::nonNull).forEach(serverPlayer -> serverLevel.j().d((WaypointTransmitter)serverPlayer));
        }
    }

    private void broadcastAll(Packet<?> packet) {
        for (EntityPlayer serverPlayer : this.b.aj().k) {
            if (serverPlayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            serverPlayer.g.b(packet);
        }
    }
}

