/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.tags.TagDataPack;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger a = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> a(c initConfig, f<D> worldDataSupplier, e<D, R> resultFactory, Executor backgroundExecutor, Executor gameExecutor) {
        try {
            Pair<WorldDataConfiguration, IReloadableResourceManager> pair = initConfig.a.a();
            IReloadableResourceManager closeableResourceManager = (IReloadableResourceManager)pair.getSecond();
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = RegistryLayer.a();
            List<IRegistry.a<?>> list = TagDataPack.loadTagsForExistingRegistries(closeableResourceManager, layeredRegistryAccess.a(RegistryLayer.a), ReloadableRegistrarEvent.Cause.INITIAL);
            IRegistryCustom.Dimension accessForLoading = layeredRegistryAccess.b(RegistryLayer.b);
            List<HolderLookup.b<?>> list1 = TagDataPack.a(accessForLoading, list);
            IRegistryCustom.Dimension frozen = RegistryDataLoader.a((IResourceManager)closeableResourceManager, list1, RegistryDataLoader.a);
            List<HolderLookup.b<?>> list2 = Stream.concat(list1.stream(), frozen.c()).toList();
            IRegistryCustom.Dimension frozen1 = RegistryDataLoader.a((IResourceManager)closeableResourceManager, list2, RegistryDataLoader.b);
            WorldDataConfiguration worldDataConfiguration = (WorldDataConfiguration)pair.getFirst();
            HolderLookup.a provider = HolderLookup.a.a(list2.stream());
            b<D> dataLoadOutput = worldDataSupplier.get(new a(closeableResourceManager, worldDataConfiguration, provider, frozen1));
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess1 = layeredRegistryAccess.a(RegistryLayer.b, frozen, dataLoadOutput.b);
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, layeredRegistryAccess1, list, worldDataConfiguration.b(), initConfig.b(), initConfig.c(), backgroundExecutor, gameExecutor).whenComplete((result, exception1) -> {
                if (exception1 != null) {
                    closeableResourceManager.close();
                }
            })).thenApplyAsync(reloadableServerResources -> {
                reloadableServerResources.g();
                return resultFactory.create(closeableResourceManager, (DataPackResources)reloadableServerResources, layeredRegistryAccess1, dataLoadOutput.a);
            }, gameExecutor);
        }
        catch (Exception var18) {
            return CompletableFuture.failedFuture(var18);
        }
    }

    public record c(d a, CommandDispatcher.ServerType b, PermissionSet c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationPermissions", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationPermissions", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationPermissions", "a", "b", "c"}, this, o2);
        }
    }

    public record d(ResourcePackRepository a, WorldDataConfiguration b, boolean c, boolean d) {
        private final ResourcePackRepository a;
        private final WorldDataConfiguration b;
        private final boolean c;
        private final boolean d;

        public Pair<WorldDataConfiguration, IReloadableResourceManager> a() {
            WorldDataConfiguration worldDataConfiguration = MinecraftServer.a(this.a, this.b, this.d, this.c);
            List<IResourcePack> list = this.a.h();
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, list);
            return Pair.of((Object)worldDataConfiguration, (Object)closeableResourceManager);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this, o2);
        }

        public ResourcePackRepository b() {
            return this.a;
        }

        public WorldDataConfiguration c() {
            return this.b;
        }

        public boolean d() {
            return this.c;
        }

        public boolean e() {
            return this.d;
        }
    }

    public record a(IResourceManager a, WorldDataConfiguration b, HolderLookup.a c, IRegistryCustom.Dimension d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface f<D> {
        public b<D> get(a var1);
    }

    public record b<D>(D a, IRegistryCustom.Dimension b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface e<D, R> {
        public R create(IReloadableResourceManager var1, DataPackResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

