/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.net.InetAddresses;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import org.bukkit.event.player.PlayerKickEvent;
import org.jspecify.annotations.Nullable;

public class CommandBanIp {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.banip.invalid"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.banip.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("ban-ip").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.e))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("target", StringArgumentType.word()).executes(commandContext -> CommandBanIp.a((CommandListenerWrapper)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"target"), null))).then(net.minecraft.commands.CommandDispatcher.a("reason", ArgumentChat.a()).executes(context -> CommandBanIp.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), ArgumentChat.a((CommandContext<CommandListenerWrapper>)context, "reason")))))));
    }

    private static int a(CommandListenerWrapper source, String username, @Nullable IChatBaseComponent reason) throws CommandSyntaxException {
        if (InetAddresses.isInetAddress((String)username)) {
            return CommandBanIp.b(source, username, reason);
        }
        EntityPlayer playerByName = source.m().aj().a(username);
        if (playerByName != null) {
            return CommandBanIp.b(source, playerByName.D(), reason);
        }
        throw a.create();
    }

    private static int b(CommandListenerWrapper source, String ip, @Nullable IChatBaseComponent reason) throws CommandSyntaxException {
        IpBanList ipBans = source.m().aj().g();
        if (ipBans.a(ip)) {
            throw b.create();
        }
        List<EntityPlayer> playersWithAddress = source.m().aj().b(ip);
        IpBanEntry ipBanListEntry = new IpBanEntry(ip, null, source.c(), null, reason == null ? null : reason.getString());
        ipBans.a(ipBanListEntry);
        source.a(() -> IChatBaseComponent.a("commands.banip.success", new Object[]{ip, ipBanListEntry.e()}), true);
        if (!playersWithAddress.isEmpty()) {
            source.a(() -> IChatBaseComponent.a("commands.banip.info", playersWithAddress.size(), EntitySelector.a(playersWithAddress)), true);
        }
        for (EntityPlayer serverPlayer : playersWithAddress) {
            serverPlayer.g.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.ip_banned"), PlayerKickEvent.Cause.IP_BANNED);
        }
        return playersWithAddress.size();
    }
}

