/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.FileUtils;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class CommandDatapack {
    private static final Logger a = LogUtils.getLogger();
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.unknown", pack));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.enable.failed", pack));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.disable.failed", pack));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.disable.failed.feature", pack));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((pack, flags) -> IChatBaseComponent.b("commands.datapack.enable.failed.no_flags", pack, flags));
    private static final DynamicCommandExceptionType g = new DynamicCommandExceptionType(name -> IChatBaseComponent.b("commands.datapack.create.invalid_name", name));
    private static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(name -> IChatBaseComponent.b("commands.datapack.create.invalid_full_name", name));
    private static final DynamicCommandExceptionType i = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.datapack.create.already_exists", object));
    private static final Dynamic2CommandExceptionType j = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("commands.datapack.create.metadata_encode_failure", object, object1));
    private static final DynamicCommandExceptionType k = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.datapack.create.io_failure", object));
    private static final SuggestionProvider<CommandListenerWrapper> l = (commandContext, suggestionsBuilder) -> ICompletionProvider.b(((CommandListenerWrapper)commandContext.getSource()).m().aE().e().stream().map(StringArgumentType::escapeIfRequired), suggestionsBuilder);
    private static final SuggestionProvider<CommandListenerWrapper> m = (commandContext, suggestionsBuilder) -> {
        ResourcePackRepository packRepository = ((CommandListenerWrapper)commandContext.getSource()).m().aE();
        Collection<String> selectedIds = packRepository.e();
        FeatureFlagSet featureFlagSet = ((CommandListenerWrapper)commandContext.getSource()).w();
        return ICompletionProvider.b(packRepository.d().stream().filter(pack -> pack.e().a(featureFlagSet)).map(ResourcePackLoader::g).filter(string -> !selectedIds.contains(string)).map(StringArgumentType::escapeIfRequired), suggestionsBuilder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("datapack").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(m).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> currentPacks, ResourcePackLoader pack) -> pack.k().a(currentPacks, pack, ResourcePackLoader::h, false)))).then(net.minecraft.commands.CommandDispatcher.b("after").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(l).executes(commandContext -> CommandDatapack.a((CommandListenerWrapper)commandContext.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)commandContext, "name", true), (List<ResourcePackLoader> currentPacks, ResourcePackLoader pack) -> currentPacks.add(currentPacks.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)commandContext, "existing", false)) + 1, pack)))))).then(net.minecraft.commands.CommandDispatcher.b("before").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(l).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> currentPacks, ResourcePackLoader pack) -> currentPacks.add(currentPacks.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "existing", false)), pack)))))).then(net.minecraft.commands.CommandDispatcher.b("last").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), List::add)))).then(net.minecraft.commands.CommandDispatcher.b("first").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> currentPacks, ResourcePackLoader pack) -> currentPacks.add(0, pack))))))).then(net.minecraft.commands.CommandDispatcher.b("disable").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(l).executes(commandContext -> CommandDatapack.a((CommandListenerWrapper)commandContext.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)commandContext, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("list").executes(commandContext -> CommandDatapack.a((CommandListenerWrapper)commandContext.getSource()))).then(net.minecraft.commands.CommandDispatcher.b("available").executes(commandContext -> CommandDatapack.b((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("enabled").executes(commandContext -> CommandDatapack.c((CommandListenerWrapper)commandContext.getSource()))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("create").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.f))).then(net.minecraft.commands.CommandDispatcher.a("id", StringArgumentType.string()).then(net.minecraft.commands.CommandDispatcher.a("description", ArgumentChatComponent.a(buildContext)).executes(commandContext -> CommandDatapack.a((CommandListenerWrapper)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"id"), ArgumentChatComponent.b((CommandContext<CommandListenerWrapper>)commandContext, "description"))))))));
    }

    private static int a(CommandListenerWrapper source, String id, IChatBaseComponent description) throws CommandSyntaxException {
        Path worldPath = source.m().a(SavedFile.j);
        if (!FileUtils.f(id)) {
            throw g.create((Object)id);
        }
        if (!FileUtils.b(id)) {
            throw h.create((Object)id);
        }
        Path path = worldPath.resolve(id);
        if (Files.exists(path, new LinkOption[0])) {
            throw i.create((Object)id);
        }
        ResourcePackInfo packMetadataSection = new ResourcePackInfo(description, SharedConstants.b().a(EnumResourcePackType.b).a());
        DataResult dataResult = ResourcePackInfo.b.b().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)packMetadataSection);
        Optional optional = dataResult.error();
        if (optional.isPresent()) {
            throw j.create((Object)id, (Object)((DataResult.Error)optional.get()).message());
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(ResourcePackInfo.b.a(), (JsonElement)dataResult.getOrThrow());
        try {
            Files.createDirectory(path, new FileAttribute[0]);
            Files.createDirectory(path.resolve(EnumResourcePackType.b.a()), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve("pack.mcmeta"), StandardCharsets.UTF_8, new OpenOption[0]);
                 JsonWriter jsonWriter = new JsonWriter((Writer)bufferedWriter);){
                jsonWriter.setSerializeNulls(false);
                jsonWriter.setIndent("  ");
                ChatDeserializer.a(jsonWriter, (JsonElement)jsonObject, null);
            }
        }
        catch (IOException var17) {
            a.warn("Failed to create pack at {}", (Object)worldPath.toAbsolutePath(), (Object)var17);
            throw k.create((Object)id);
        }
        source.a(() -> IChatBaseComponent.a("commands.datapack.create.success", new Object[]{id}), true);
        return 1;
    }

    private static int a(CommandListenerWrapper source, ResourcePackLoader pack, a priorityCallback) throws CommandSyntaxException {
        ResourcePackRepository packRepository = source.m().aE();
        ArrayList list = Lists.newArrayList(packRepository.g());
        priorityCallback.apply(list, pack);
        source.a(() -> IChatBaseComponent.a("commands.datapack.modify.enable", pack.a(true)), true);
        CommandReload.a(list.stream().map(ResourcePackLoader::g).collect(Collectors.toList()), source);
        return list.size();
    }

    private static int a(CommandListenerWrapper source, ResourcePackLoader pack) {
        ResourcePackRepository packRepository = source.m().aE();
        ArrayList list = Lists.newArrayList(packRepository.g());
        list.remove(pack);
        source.a(() -> IChatBaseComponent.a("commands.datapack.modify.disable", pack.a(true)), true);
        CommandReload.a(list.stream().map(ResourcePackLoader::g).collect(Collectors.toList()), source);
        return list.size();
    }

    private static int a(CommandListenerWrapper source) {
        return CommandDatapack.c(source) + CommandDatapack.b(source);
    }

    private static int b(CommandListenerWrapper source) {
        ResourcePackRepository packRepository = source.m().aE();
        packRepository.a();
        Collection<ResourcePackLoader> selectedPacks = packRepository.g();
        Collection<ResourcePackLoader> availablePacks = packRepository.d();
        FeatureFlagSet featureFlagSet = source.w();
        List<ResourcePackLoader> list = availablePacks.stream().filter(pack -> !selectedPacks.contains(pack) && pack.e().a(featureFlagSet)).toList();
        if (list.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.datapack.list.available.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.datapack.list.available.success", list.size(), ChatComponentUtils.b(list, (T pack) -> pack.a(false))), false);
        }
        return list.size();
    }

    private static int c(CommandListenerWrapper source) {
        ResourcePackRepository packRepository = source.m().aE();
        packRepository.a();
        Collection<ResourcePackLoader> selectedPacks = packRepository.g();
        if (selectedPacks.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.datapack.list.enabled.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.datapack.list.enabled.success", selectedPacks.size(), ChatComponentUtils.b(selectedPacks, (T pack) -> pack.a(true))), false);
        }
        return selectedPacks.size();
    }

    private static ResourcePackLoader a(CommandContext<CommandListenerWrapper> context, String name, boolean enabling) throws CommandSyntaxException {
        String string = StringArgumentType.getString(context, (String)name);
        ResourcePackRepository packRepository = ((CommandListenerWrapper)context.getSource()).m().aE();
        ResourcePackLoader pack = packRepository.c(string);
        if (pack == null) {
            throw b.create((Object)string);
        }
        boolean flag = packRepository.g().contains(pack);
        if (enabling && flag) {
            throw c.create((Object)string);
        }
        if (!enabling && !flag) {
            throw d.create((Object)string);
        }
        FeatureFlagSet featureFlagSet = ((CommandListenerWrapper)context.getSource()).w();
        FeatureFlagSet requestedFeatures = pack.e();
        if (!enabling && !requestedFeatures.b() && pack.l() == PackSource.d) {
            throw e.create((Object)string);
        }
        if (!requestedFeatures.a(featureFlagSet)) {
            throw f.create((Object)string, (Object)FeatureFlags.a(featureFlagSet, requestedFeatures));
        }
        return pack;
    }

    static interface a {
        public void apply(List<ResourcePackLoader> var1, ResourcePackLoader var2) throws CommandSyntaxException;
    }
}

