/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.SlotsArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.StopwatchCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.IInventory;
import net.minecraft.world.Stopwatch;
import net.minecraft.world.Stopwatches;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CommandExecute {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 32768;
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.execute.blocks.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(count -> IChatBaseComponent.b("commands.execute.conditional.fail_count", count));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((function, message) -> IChatBaseComponent.b("commands.execute.function.instantiationFailure", function, message));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext buildContext) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("execute").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("execute").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("run").redirect(dispatcher.getRoot()))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.b("if"), true, buildContext))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.b("unless"), false, buildContext))).then(net.minecraft.commands.CommandDispatcher.b("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.b("at").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a((WorldServer)entity.ao()).a(entity.dI()).a(entity.cl()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("store").then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.b("result"), true))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.b("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("positioned").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos")).a(ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.b("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity.dI()));
            }
            return list;
        })))).then(net.minecraft.commands.CommandDispatcher.b("over").then(net.minecraft.commands.CommandDispatcher.a("heightmap", HeightmapTypeArgument.a()).redirect(literalCommandNode, context -> {
            Vec3D position = ((CommandListenerWrapper)context.getSource()).e();
            WorldServer level = ((CommandListenerWrapper)context.getSource()).f();
            double x2 = position.a();
            double z2 = position.c();
            if (!level.b(SectionPosition.b(x2), SectionPosition.b(z2))) {
                throw ArgumentPosition.a.create();
            }
            int height = level.a(HeightmapTypeArgument.a((CommandContext<CommandListenerWrapper>)context, "heightmap"), MathHelper.c(x2), MathHelper.c(z2));
            return ((CommandListenerWrapper)context.getSource()).a(new Vec3D(x2, height, z2));
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("rotated").then(net.minecraft.commands.CommandDispatcher.a("rot", ArgumentRotation.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context, "rot").b((CommandListenerWrapper)context.getSource()))))).then(net.minecraft.commands.CommandDispatcher.b("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity.cl()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("facing").then(net.minecraft.commands.CommandDispatcher.b("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            ArgumentAnchor.Anchor anchor = ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "anchor");
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "targets")) {
                list.add(((CommandListenerWrapper)context.getSource()).a(entity, anchor));
            }
            return list;
        }))))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos")))))).then(net.minecraft.commands.CommandDispatcher.b("align").then(net.minecraft.commands.CommandDispatcher.a("axes", ArgumentRotationAxis.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(((CommandListenerWrapper)context.getSource()).e().a(ArgumentRotationAxis.a((CommandContext<CommandListenerWrapper>)context, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.b("anchored").then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.b("in").then(net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()).redirect(literalCommandNode, context -> ((CommandListenerWrapper)context.getSource()).a(ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "dimension")))))).then(net.minecraft.commands.CommandDispatcher.b("summon").then(net.minecraft.commands.CommandDispatcher.a("entity", ResourceArgument.a(buildContext, Registries.F)).suggests(CompletionProviders.a(CompletionProviders.c)).redirect(literalCommandNode, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context, "entity")))))).then(CommandExecute.a(literalCommandNode, net.minecraft.commands.CommandDispatcher.b("on")))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(LiteralCommandNode<CommandListenerWrapper> parent, LiteralArgumentBuilder<CommandListenerWrapper> literal, boolean storingResult) {
        literal.then(net.minecraft.commands.CommandDispatcher.b("score").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).redirect(parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), storingResult)))));
        literal.then(net.minecraft.commands.CommandDispatcher.b("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(CommandBossBar.a).then(net.minecraft.commands.CommandDispatcher.b("value").redirect(parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), true, storingResult)))).then(net.minecraft.commands.CommandDispatcher.b("max").redirect(parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)context), false, storingResult)))));
        for (CommandData.c dataProvider : CommandData.b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literal, argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).then(net.minecraft.commands.CommandDispatcher.b("int").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int i2) -> NBTTagInt.a((int)((double)i2 * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.b("float").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int i2) -> NBTTagFloat.a((float)((double)i2 * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.b("short").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int i2) -> NBTTagShort.a((short)((double)i2 * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.b("long").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int i2) -> NBTTagLong.a((long)((double)i2 * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(net.minecraft.commands.CommandDispatcher.b("double").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int i2) -> NBTTagDouble.a((double)i2 * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")), storingResult))))).then(net.minecraft.commands.CommandDispatcher.b("byte").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> CommandExecute.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), (int i2) -> NBTTagByte.a((byte)((double)i2 * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))));
        }
        return literal;
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Collection<ScoreHolder> targets, ScoreboardObjective objective, boolean storingResult) {
        ScoreboardServer scoreboard = source.m().aK();
        return source.a((success, result) -> {
            for (ScoreHolder scoreHolder : targets) {
                ScoreAccess playerScore = scoreboard.c(scoreHolder, objective);
                int i2 = storingResult ? result : (success ? 1 : 0);
                playerScore.a(i2);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, BossBattleCustom bar, boolean storingValue, boolean storingResult) {
        return source.a((success, result) -> {
            int i2;
            int n2 = storingResult ? result : (i2 = success ? 1 : 0);
            if (storingValue) {
                bar.a(i2);
            } else {
                bar.b(i2);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, CommandDataAccessor accessor, ArgumentNBTKey.g path, IntFunction<NBTBase> tagConverter, boolean storingResult) {
        return source.a((success, result) -> {
            try {
                NBTTagCompound data = accessor.a();
                int i2 = storingResult ? result : (success ? 1 : 0);
                path.a((NBTBase)data, (NBTBase)tagConverter.apply(i2));
                accessor.a(data);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean a(WorldServer level, BlockPosition pos) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        Chunk chunkNow = level.p().a(chunkPos.h, chunkPos.i);
        return chunkNow != null && chunkNow.G() == FullChunkStatus.d && level.c(chunkPos.b());
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> parent, LiteralArgumentBuilder<CommandListenerWrapper> literal, boolean isIf, CommandBuildContext buildContext) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literal.then(net.minecraft.commands.CommandDispatcher.b("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("block", ArgumentBlockPredicate.a(buildContext)), isIf, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)context.getSource()).f(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.b("biome").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(buildContext, Registries.aS)), isIf, (CommandContext<CommandListenerWrapper> context) -> ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context, "biome", Registries.aS).test(((CommandListenerWrapper)context.getSource()).f().z(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos")))))))).then(net.minecraft.commands.CommandDispatcher.b("loaded").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a(((CommandListenerWrapper)context.getSource()).f(), ArgumentPosition.b((CommandContext<CommandListenerWrapper>)context, "pos")))))).then(net.minecraft.commands.CommandDispatcher.b("dimension").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "dimension") == ((CommandListenerWrapper)context.getSource()).f())))).then(net.minecraft.commands.CommandDispatcher.b("score").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.b("=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int value1, int value2) -> value1 == value2)))))).then(net.minecraft.commands.CommandDispatcher.b("<").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int value1, int value2) -> value1 < value2)))))).then(net.minecraft.commands.CommandDispatcher.b("<=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int value1, int value2) -> value1 <= value2)))))).then(net.minecraft.commands.CommandDispatcher.b(">").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int value1, int value2) -> value1 > value2)))))).then(net.minecraft.commands.CommandDispatcher.b(">=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, (int value1, int value2) -> value1 >= value2)))))).then(net.minecraft.commands.CommandDispatcher.b("matches").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.b("blocks").then(net.minecraft.commands.CommandDispatcher.a("start", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.b("all"), isIf, false))).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.b("masked"), isIf, true))))))).then(net.minecraft.commands.CommandDispatcher.b("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).fork(parent, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, isIf, !ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "entities").isEmpty()))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context) -> ArgumentEntity.c((CommandContext<CommandListenerWrapper>)context, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.b("predicate").then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("predicate", ResourceOrIdArgument.c(buildContext)), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ResourceOrIdArgument.c((CommandContext<CommandListenerWrapper>)context, "predicate")))))).then(net.minecraft.commands.CommandDispatcher.b("function").then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(CommandFunction.b).fork(parent, (RedirectModifier)new c(isIf))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("items").then(net.minecraft.commands.CommandDispatcher.b("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("slots", SlotsArgument.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item_predicate", ArgumentItemPredicate.a(buildContext)).fork(parent, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, isIf, CommandExecute.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "entities"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)context, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)context, "item_predicate")) > 0))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "entities"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)context, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)context, "item_predicate"))))))))).then(net.minecraft.commands.CommandDispatcher.b("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("slots", SlotsArgument.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item_predicate", ArgumentItemPredicate.a(buildContext)).fork(parent, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, isIf, CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)context, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)context, "item_predicate")) > 0))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), SlotsArgument.a((CommandContext<CommandListenerWrapper>)context, "slots"), ArgumentItemPredicate.a((CommandContext<CommandListenerWrapper>)context, "item_predicate")))))))))).then(net.minecraft.commands.CommandDispatcher.b("stopwatch").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(StopwatchCommand.b).then(CommandExecute.a(parent, net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.b()), isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, ArgumentCriterionValue.a.a((CommandContext<CommandListenerWrapper>)context, "range"))))));
        for (CommandData.c dataProvider : CommandData.c) {
            literal.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.b("data"), argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).fork(parent, context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, isIf, CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")) > 0))).executes(CommandExecute.a(isIf, (CommandContext<CommandListenerWrapper> context) -> CommandExecute.a(dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")))))));
        }
        return literal;
    }

    private static int a(Iterable<? extends SlotProvider> targets, SlotRange slotRange, Predicate<ItemStack> filter) {
        int i2 = 0;
        for (SlotProvider slotProvider : targets) {
            IntList list = slotRange.a();
            for (int i1 = 0; i1 < list.size(); ++i1) {
                ItemStack itemStack;
                int _int = list.getInt(i1);
                SlotAccess slot = slotProvider.a_(_int);
                if (slot == null || !filter.test(itemStack = slot.a())) continue;
                i2 += itemStack.N();
            }
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, SlotRange slotRange, Predicate<ItemStack> filter) throws CommandSyntaxException {
        int i2 = 0;
        IInventory container = ItemCommands.a(source, pos, ItemCommands.b);
        int containerSize = container.b();
        IntList list = slotRange.a();
        for (int i1 = 0; i1 < list.size(); ++i1) {
            ItemStack item;
            int _int = list.getInt(i1);
            if (_int < 0 || _int >= containerSize || !filter.test(item = container.a(_int))) continue;
            i2 += item.N();
        }
        return i2;
    }

    private static Command<CommandListenerWrapper> a(boolean isIf, a predicate) {
        return isIf ? context -> {
            int i2 = predicate.test((CommandContext<CommandListenerWrapper>)context);
            if (i2 > 0) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", i2), false);
                return i2;
            }
            throw e.create();
        } : context -> {
            int i2 = predicate.test((CommandContext<CommandListenerWrapper>)context);
            if (i2 == 0) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw f.create((Object)i2);
        };
    }

    private static int a(CommandDataAccessor accessor, ArgumentNBTKey.g path) throws CommandSyntaxException {
        return path.b(accessor.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, d predicate) throws CommandSyntaxException {
        ScoreHolder name = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        ScoreHolder name1 = ArgumentScoreholder.a(context, "source");
        ScoreboardObjective objective1 = ArgumentScoreboardObjective.a(context, "sourceObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).m().aK();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(name, objective);
        ReadOnlyScoreInfo playerScoreInfo1 = scoreboard.d(name1, objective1);
        return playerScoreInfo != null && playerScoreInfo1 != null && predicate.test(playerScoreInfo.a(), playerScoreInfo1.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, CriterionConditionValue.IntegerRange bounds) throws CommandSyntaxException {
        ScoreHolder name = ArgumentScoreholder.a(context, "target");
        ScoreboardObjective objective = ArgumentScoreboardObjective.a(context, "targetObjective");
        ScoreboardServer scoreboard = ((CommandListenerWrapper)context.getSource()).m().aK();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(name, objective);
        return playerScoreInfo != null && bounds.d(playerScoreInfo.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> context, CriterionConditionValue.DoubleRange bounds) throws CommandSyntaxException {
        MinecraftKey id = ArgumentMinecraftKeyRegistered.a(context, "id");
        Stopwatches stopwatches = ((CommandListenerWrapper)context.getSource()).m().aM();
        Stopwatch stopwatch = stopwatches.a(id);
        if (stopwatch == null) {
            throw StopwatchCommand.a.create((Object)id);
        }
        long l2 = Stopwatches.c();
        double d2 = stopwatch.b(l2);
        return bounds.d(d2);
    }

    private static boolean a(CommandListenerWrapper source, Holder<LootItemCondition> condition) {
        WorldServer level = source.f();
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.h, source.e()).b(LootContextParameters.a, source.g()).a(LootContextParameterSets.d);
        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(Optional.empty());
        lootContext.b(LootTableInfo.a(condition.a()));
        return condition.a().test(lootContext);
    }

    private static Collection<CommandListenerWrapper> a(CommandContext<CommandListenerWrapper> context, boolean actual, boolean expected) {
        return expected == actual ? Collections.singleton((CommandListenerWrapper)context.getSource()) : Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> commandNode, ArgumentBuilder<CommandListenerWrapper, ?> builder, boolean value, b test) {
        return ((ArgumentBuilder)builder.fork(commandNode, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, value, test.test((CommandContext<CommandListenerWrapper>)context))))).executes(context -> {
            if (value == test.test((CommandContext<CommandListenerWrapper>)context)) {
                ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw e.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> commandNode, ArgumentBuilder<CommandListenerWrapper, ?> literal, boolean isIf, boolean isMasked) {
        return ((ArgumentBuilder)literal.fork(commandNode, (RedirectModifier<CommandListenerWrapper>)((RedirectModifier)context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, isIf, CommandExecute.c((CommandContext<CommandListenerWrapper>)context, isMasked).isPresent())))).executes(isIf ? context -> CommandExecute.a((CommandContext<CommandListenerWrapper>)context, isMasked) : context -> CommandExecute.b((CommandContext<CommandListenerWrapper>)context, isMasked));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, boolean isMasked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, isMasked);
        if (optionalInt.isPresent()) {
            ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw e.create();
    }

    private static int b(CommandContext<CommandListenerWrapper> context, boolean isMasked) throws CommandSyntaxException {
        OptionalInt optionalInt = CommandExecute.c(context, isMasked);
        if (optionalInt.isPresent()) {
            throw f.create((Object)optionalInt.getAsInt());
        }
        ((CommandListenerWrapper)context.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt c(CommandContext<CommandListenerWrapper> context, boolean isMasked) throws CommandSyntaxException {
        return CommandExecute.a(((CommandListenerWrapper)context.getSource()).f(), ArgumentPosition.a(context, "start"), ArgumentPosition.a(context, "end"), ArgumentPosition.a(context, "destination"), isMasked);
    }

    private static OptionalInt a(WorldServer level, BlockPosition begin, BlockPosition end, BlockPosition destination, boolean isMasked) throws CommandSyntaxException {
        StructureBoundingBox boundingBox = StructureBoundingBox.a((BaseBlockPosition)begin, (BaseBlockPosition)end);
        StructureBoundingBox boundingBox1 = StructureBoundingBox.a((BaseBlockPosition)destination, (BaseBlockPosition)destination.a(boundingBox.c()));
        BlockPosition blockPos = new BlockPosition(boundingBox1.h() - boundingBox.h(), boundingBox1.i() - boundingBox.i(), boundingBox1.j() - boundingBox.j());
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > 32768) {
            throw d.create((Object)32768, (Object)i2);
        }
        int i1 = 0;
        IRegistryCustom registryAccess = level.J_();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(b);){
            for (int z2 = boundingBox.j(); z2 <= boundingBox.m(); ++z2) {
                for (int y2 = boundingBox.i(); y2 <= boundingBox.l(); ++y2) {
                    for (int x2 = boundingBox.h(); x2 <= boundingBox.k(); ++x2) {
                        BlockPosition blockPos1 = new BlockPosition(x2, y2, z2);
                        BlockPosition blockPos2 = blockPos1.a(blockPos);
                        IBlockData blockState = level.a_(blockPos1);
                        if (isMasked && blockState.a(Blocks.a)) continue;
                        if (blockState != level.a_(blockPos2)) {
                            OptionalInt optionalInt = OptionalInt.empty();
                            return optionalInt;
                        }
                        TileEntity blockEntity = level.c_(blockPos1);
                        TileEntity blockEntity1 = level.c_(blockPos2);
                        if (blockEntity != null) {
                            OptionalInt optionalInt;
                            if (blockEntity1 == null) {
                                optionalInt = OptionalInt.empty();
                                return optionalInt;
                            }
                            if (blockEntity1.s() != blockEntity.s()) {
                                optionalInt = OptionalInt.empty();
                                return optionalInt;
                            }
                            if (!blockEntity.u().equals(blockEntity1.u())) {
                                optionalInt = OptionalInt.empty();
                                return optionalInt;
                            }
                            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector.a(blockEntity.v()), registryAccess);
                            blockEntity.f(tagValueOutput);
                            NBTTagCompound compoundTag = tagValueOutput.b();
                            TagValueOutput tagValueOutput1 = TagValueOutput.a(scopedCollector.a(blockEntity1.v()), registryAccess);
                            blockEntity1.f(tagValueOutput1);
                            NBTTagCompound compoundTag1 = tagValueOutput1.b();
                            if (!compoundTag.equals(compoundTag1)) {
                                OptionalInt optionalInt2 = OptionalInt.empty();
                                return optionalInt2;
                            }
                        }
                        ++i1;
                    }
                }
            }
        }
        return OptionalInt.of(i1);
    }

    private static RedirectModifier<CommandListenerWrapper> a(Function<Entity, Optional<Entity>> relation) {
        return commandContext -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)commandContext.getSource();
            Entity entity = commandSourceStack.g();
            return entity == null ? List.of() : (Collection)((Optional)relation.apply(entity)).filter(entity1 -> !entity1.eh()).map(entity1 -> List.of(commandSourceStack.a((Entity)entity1))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandListenerWrapper> b(Function<Entity, Stream<Entity>> relation) {
        return commandContext -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)commandContext.getSource();
            Entity entity = commandSourceStack.g();
            return entity == null ? List.of() : ((Stream)relation.apply(entity)).filter(entity1 -> !entity1.eh()).map(commandSourceStack::a).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(CommandNode<CommandListenerWrapper> node, LiteralArgumentBuilder<CommandListenerWrapper> argumentBuilder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)argumentBuilder.then(net.minecraft.commands.CommandDispatcher.b("owner").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)((Object)entity);
                optional = Optional.ofNullable(ownableEntity.U_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.b("leasher").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                optional = Optional.ofNullable(leashable.C());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.b("target").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Targeting) {
                Targeting targeting = (Targeting)((Object)entity);
                optional = Optional.ofNullable(targeting.ag_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.b("attacker").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof Attackable) {
                Attackable attackable = (Attackable)((Object)entity);
                optional = Optional.ofNullable(attackable.f_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.b("vehicle").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.dz()))))).then(net.minecraft.commands.CommandDispatcher.b("controller").fork(node, CommandExecute.a((Entity entity) -> Optional.ofNullable(entity.dl()))))).then(net.minecraft.commands.CommandDispatcher.b("origin").fork(node, CommandExecute.a((Entity entity) -> {
            Optional<Object> optional;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceableEntity = (TraceableEntity)((Object)entity);
                optional = Optional.ofNullable(traceableEntity.p());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.b("passengers").fork(node, CommandExecute.b((Entity entity) -> entity.dn().stream())));
    }

    private static CommandListenerWrapper a(CommandListenerWrapper source, Holder.c<EntityTypes<?>> entityType) throws CommandSyntaxException {
        Entity entity = CommandSummon.a(source, entityType, source.e(), new NBTTagCompound(), true);
        return source.a(entity);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void a(T originalSource, List<T> sources, Function<T, T> sourceModifier, IntPredicate successCheck, ContextChain<T> contextChain, @Nullable NBTTagCompound arguments, ExecutionControl<T> executionControl, InCommandFunction<CommandContext<T>, Collection<net.minecraft.commands.functions.CommandFunction<T>>> functionsGetter, ChainModifiers chainModifiers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void a(List list1, ExecutionCommandSource executionCommandSource1, ExecutionControl executionControl1) {
        for (InstantiatedFunction instantiatedFunction : list1) {
            executionControl1.a(new CallFunction<ExecutionCommandSource>(instantiatedFunction, executionControl1.b().d(), true).bind(executionCommandSource1));
        }
        executionControl1.a(FallthroughTask.a());
    }

    private static /* synthetic */ void a(IntPredicate successCheck, List list, ExecutionCommandSource executionCommandSource, boolean success, int result) {
        if (successCheck.test(result)) {
            list.add(executionCommandSource);
        }
    }

    @FunctionalInterface
    static interface b {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    static class c
    implements CustomModifierExecutor.a<CommandListenerWrapper> {
        private final IntPredicate a;

        c(boolean invert) {
            this.a = invert ? i2 -> i2 != 0 : i2 -> i2 == 0;
        }

        @Override
        public void a(CommandListenerWrapper originalSource, List<CommandListenerWrapper> sources, ContextChain<CommandListenerWrapper> contextChain, ChainModifiers chainModifiers, ExecutionControl<CommandListenerWrapper> executionControl) {
            CommandExecute.a(originalSource, sources, CommandFunction::a, this.a, contextChain, null, executionControl, context -> ArgumentTag.a((CommandContext<CommandListenerWrapper>)context, "name"), chainModifiers);
        }
    }

    @FunctionalInterface
    static interface d {
        public boolean test(int var1, int var2);
    }
}

