/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import org.jspecify.annotations.Nullable;

public class CommandFill {
    private static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.fill.toobig", maxBlocks, specifiedBlocks));
    static final ArgumentTileLocation b = new ArgumentTileLocation(Blocks.a.m(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.fill.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("fill").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.a("from", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentPosition.a()).then(((ArgumentBuilder)CommandFill.a(buildContext, net.minecraft.commands.CommandDispatcher.a("block", ArgumentTile.a(buildContext)), (CommandContext<CommandListenerWrapper> input) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)input, "from"), (CommandContext<CommandListenerWrapper> context) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to"), (CommandContext<CommandListenerWrapper> input) -> ArgumentTile.a((CommandContext<CommandListenerWrapper>)input, "block"), context -> null).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("replace").executes(commandContext -> CommandFill.a((CommandListenerWrapper)commandContext.getSource(), StructureBoundingBox.a((BaseBlockPosition)ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandContext, "from"), (BaseBlockPosition)ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandContext, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)commandContext, "block"), Mode.a, null, false))).then(CommandFill.a(buildContext, net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(buildContext)), (CommandContext<CommandListenerWrapper> input) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)input, "from"), (CommandContext<CommandListenerWrapper> context) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to"), (CommandContext<CommandListenerWrapper> input) -> ArgumentTile.a((CommandContext<CommandListenerWrapper>)input, "block"), context -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"))))).then(net.minecraft.commands.CommandDispatcher.b("keep").executes(commandContext -> CommandFill.a((CommandListenerWrapper)commandContext.getSource(), StructureBoundingBox.a((BaseBlockPosition)ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandContext, "from"), (BaseBlockPosition)ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandContext, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)commandContext, "block"), Mode.a, (ShapeDetectorBlock blockInWorld) -> blockInWorld.c().A(blockInWorld.d()), false))))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, InCommandFunction<CommandContext<CommandListenerWrapper>, BlockPosition> from, InCommandFunction<CommandContext<CommandListenerWrapper>, BlockPosition> to, InCommandFunction<CommandContext<CommandListenerWrapper>, ArgumentTileLocation> block, e<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> filter) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)commandContext -> CommandFill.a((CommandListenerWrapper)commandContext.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(commandContext), (BaseBlockPosition)to.apply(commandContext)), (ArgumentTileLocation)block.apply(commandContext), Mode.a, (Predicate)filter.apply(commandContext), false)))).then(net.minecraft.commands.CommandDispatcher.b("outline").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.b, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.b("hollow").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.c, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.b("destroy").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.d, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.b("strict").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.a, (Predicate)filter.apply(context), true)));
    }

    private static int a(CommandListenerWrapper source, StructureBoundingBox box, ArgumentTileLocation block, Mode mode, @Nullable Predicate<ShapeDetectorBlock> filter, boolean strict) throws CommandSyntaxException {
        record A(BlockPosition a, IBlockData b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "pos;oldState", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "pos;oldState", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "pos;oldState", "a", "b"}, this, o2);
            }
        }
        int i1;
        int i2 = box.d() * box.e() * box.f();
        if (i2 > (i1 = source.f().U().a(GameRules.x).intValue())) {
            throw a.create((Object)i1, (Object)i2);
        }
        ArrayList list = Lists.newArrayList();
        WorldServer level = source.f();
        if (level.ar()) {
            throw c.create();
        }
        int i22 = 0;
        for (BlockPosition blockPos : BlockPosition.b(box.h(), box.i(), box.j(), box.k(), box.l(), box.m())) {
            ArgumentTileLocation blockInput;
            if (filter != null && !filter.test(new ShapeDetectorBlock(level, blockPos, true))) continue;
            IBlockData blockState = level.a_(blockPos);
            boolean flag = false;
            if (mode.f.affect(level, blockPos)) {
                flag = true;
            }
            if ((blockInput = mode.e.filter(box, blockPos, block, level)) == null) {
                if (!flag) continue;
                ++i22;
                continue;
            }
            if (!blockInput.a(level, blockPos, 2 | (strict ? 816 : 256))) {
                if (!flag) continue;
                ++i22;
                continue;
            }
            if (!strict) {
                list.add(new A(blockPos.j(), blockState));
            }
            ++i22;
        }
        for (A updatedPosition : list) {
            level.a(updatedPosition.a, updatedPosition.b);
        }
        if (i22 == 0) {
            throw c.create();
        }
        int i3 = i22;
        source.a(() -> IChatBaseComponent.a("commands.fill.success", i3), true);
        return i22;
    }

    @FunctionalInterface
    static interface e<T, R> {
        public @Nullable R apply(T var1) throws CommandSyntaxException;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(net.minecraft.server.commands.CommandFill$b.a, net.minecraft.server.commands.CommandFill$c.a);
        public static final /* enum */ Mode b = new Mode(net.minecraft.server.commands.CommandFill$b.a, (area, pos, newBlock, level) -> pos.u() != area.h() && pos.u() != area.k() && pos.v() != area.i() && pos.v() != area.l() && pos.w() != area.j() && pos.w() != area.m() ? null : newBlock);
        public static final /* enum */ Mode c = new Mode(net.minecraft.server.commands.CommandFill$b.a, (area, pos, newBlock, level) -> pos.u() != area.h() && pos.u() != area.k() && pos.v() != area.i() && pos.v() != area.l() && pos.w() != area.j() && pos.w() != area.m() ? b : newBlock);
        public static final /* enum */ Mode d = new Mode((level, pos) -> level.b(pos, true), net.minecraft.server.commands.CommandFill$c.a);
        public final c e;
        public final b f;
        private static final /* synthetic */ Mode[] g;

        public static Mode[] values() {
            return (Mode[])g.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(b affector, c filter) {
            this.f = affector;
            this.e = filter;
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{a, b, c, d};
        }

        static {
            g = Mode.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public static final b a = (level, pos) -> false;

        public boolean affect(WorldServer var1, BlockPosition var2);
    }

    @FunctionalInterface
    public static interface c {
        public static final c a = (box, pos, block, level) -> block;

        public @Nullable ArgumentTileLocation filter(StructureBoundingBox var1, BlockPosition var2, ArgumentTileLocation var3, WorldServer var4);
    }
}

