/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import org.jspecify.annotations.Nullable;

public class CommandFunction {
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(contents -> IChatBaseComponent.b("commands.function.error.argument_not_compound", contents));
    static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(contents -> IChatBaseComponent.b("commands.function.scheduled.no_functions", contents));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((functionId, message) -> IChatBaseComponent.b("commands.function.instantiationFailure", functionId, message));
    public static final SuggestionProvider<CommandListenerWrapper> b = (context, suggestions) -> {
        CustomFunctionData functions = ((CommandListenerWrapper)context.getSource()).m().aC();
        ICompletionProvider.a(functions.e(), suggestions, "#");
        return ICompletionProvider.a(functions.d(), suggestions);
    };
    static final b<CommandListenerWrapper> e = new b<CommandListenerWrapper>(){

        public void signalResult(CommandListenerWrapper source, MinecraftKey function, int commands) {
            source.a(() -> IChatBaseComponent.a("commands.function.result", IChatBaseComponent.a(function), commands), true);
        }
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.b("with");
        for (final CommandData.c dataProvider : CommandData.c) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literalArgumentBuilder, argumentBuilder -> ((ArgumentBuilder)argumentBuilder.executes(new c(){

                @Override
                protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) throws CommandSyntaxException {
                    return dataProvider.a(context).a();
                }
            })).then(net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes((Command)new c(){

                @Override
                protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) throws CommandSyntaxException {
                    return CommandFunction.a(ArgumentNBTKey.a(context, "path"), dataProvider.a(context));
                }
            })));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("function").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(b).executes((Command)new c(){

            @Override
            protected @Nullable NBTTagCompound a(CommandContext<CommandListenerWrapper> context) {
                return null;
            }
        })).then(net.minecraft.commands.CommandDispatcher.a("arguments", ArgumentNBTTag.a()).executes((Command)new c(){

            @Override
            protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) {
                return ArgumentNBTTag.a(context, "arguments");
            }
        }))).then(literalArgumentBuilder))));
    }

    static NBTTagCompound a(ArgumentNBTKey.g nbtPath, CommandDataAccessor dataAccessor) throws CommandSyntaxException {
        NBTBase singleTag = CommandData.a(nbtPath, dataAccessor);
        if (singleTag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)singleTag;
            return compoundTag;
        }
        throw c.create((Object)singleTag.c().a());
    }

    public static CommandListenerWrapper a(CommandListenerWrapper source) {
        return source.a().b(LevelBasedPermissionSet.c);
    }

    public static <T extends ExecutionCommandSource<T>> void a(Collection<net.minecraft.commands.functions.CommandFunction<T>> functions, @Nullable NBTTagCompound arguments, T originalSource, T source, ExecutionControl<T> executionControl, b<T> callbacks, ChainModifiers chainModifiers) throws CommandSyntaxException {
        if (chainModifiers.c()) {
            CommandFunction.a(functions, arguments, originalSource, source, executionControl, callbacks);
        } else {
            CommandFunction.b(functions, arguments, originalSource, source, executionControl, callbacks);
        }
    }

    private static <T extends ExecutionCommandSource<T>> void a(@Nullable NBTTagCompound arguments, ExecutionControl<T> executionControl, CommandDispatcher<T> dispatcher, T source, net.minecraft.commands.functions.CommandFunction<T> function, MinecraftKey functionId, CommandResultCallback resultCallback, boolean returnParentFrame) throws CommandSyntaxException {
        try {
            InstantiatedFunction<T> instantiatedFunction = function.a(arguments, dispatcher);
            executionControl.a(new CallFunction<T>(instantiatedFunction, resultCallback, returnParentFrame).bind(source));
        }
        catch (FunctionInstantiationException var9) {
            throw a.create((Object)functionId, (Object)var9.a());
        }
    }

    private static <T extends ExecutionCommandSource<T>> CommandResultCallback a(T source, b<T> callbacks, MinecraftKey function, CommandResultCallback resultCallback) {
        return source.y() ? resultCallback : (success, result) -> {
            callbacks.a(source, function, result);
            resultCallback.onResult(success, result);
        };
    }

    private static <T extends ExecutionCommandSource<T>> void a(Collection<net.minecraft.commands.functions.CommandFunction<T>> functions, @Nullable NBTTagCompound arguments, T originalSource, T source, ExecutionControl<T> executionControl, b<T> callbacks) throws CommandSyntaxException {
        CommandDispatcher<T> commandDispatcher = originalSource.x();
        T executionCommandSource = source.a_();
        CommandResultCallback commandResultCallback = CommandResultCallback.chain(originalSource.q(), executionControl.b().d());
        for (net.minecraft.commands.functions.CommandFunction<T> commandFunction : functions) {
            MinecraftKey identifier = commandFunction.a();
            CommandResultCallback commandResultCallback1 = CommandFunction.a(originalSource, callbacks, identifier, commandResultCallback);
            CommandFunction.a(arguments, executionControl, commandDispatcher, executionCommandSource, commandFunction, identifier, commandResultCallback1, true);
        }
        executionControl.a(FallthroughTask.a());
    }

    private static <T extends ExecutionCommandSource<T>> void b(Collection<net.minecraft.commands.functions.CommandFunction<T>> functions, @Nullable NBTTagCompound arguments, T originalSource, T source, ExecutionControl<T> executionControl, b<T> callbacks) throws CommandSyntaxException {
        CommandDispatcher<T> commandDispatcher = originalSource.x();
        T executionCommandSource = source.a_();
        CommandResultCallback commandResultCallback = originalSource.q();
        if (!functions.isEmpty()) {
            if (functions.size() == 1) {
                net.minecraft.commands.functions.CommandFunction<T> commandFunction = functions.iterator().next();
                MinecraftKey identifier = commandFunction.a();
                CommandResultCallback commandResultCallback1 = CommandFunction.a(originalSource, callbacks, identifier, commandResultCallback);
                CommandFunction.a(arguments, executionControl, commandDispatcher, executionCommandSource, commandFunction, identifier, commandResultCallback1, false);
            } else if (commandResultCallback == CommandResultCallback.a) {
                for (net.minecraft.commands.functions.CommandFunction<T> commandFunction1 : functions) {
                    MinecraftKey identifier1 = commandFunction1.a();
                    CommandResultCallback commandResultCallback2 = CommandFunction.a(originalSource, callbacks, identifier1, commandResultCallback);
                    CommandFunction.a(arguments, executionControl, commandDispatcher, executionCommandSource, commandFunction1, identifier1, commandResultCallback2, false);
                }
            } else {
                class A {
                    boolean a;
                    int b;

                    A() {
                    }

                    public void a(int result) {
                        this.a = true;
                        this.b += result;
                    }
                }
                A accumulator = new A();
                CommandResultCallback commandResultCallback3 = (success, result) -> accumulator.a(result);
                for (net.minecraft.commands.functions.CommandFunction<T> commandFunction2 : functions) {
                    MinecraftKey identifier2 = commandFunction2.a();
                    CommandResultCallback commandResultCallback4 = CommandFunction.a(originalSource, callbacks, identifier2, commandResultCallback3);
                    CommandFunction.a(arguments, executionControl, commandDispatcher, executionCommandSource, commandFunction2, identifier2, commandResultCallback4, false);
                }
                executionControl.a((context, frame) -> {
                    if (accumulator.a) {
                        commandResultCallback.onSuccess(accumulator.b);
                    }
                });
            }
        }
    }

    public static interface b<T> {
        public void a(T var1, MinecraftKey var2, int var3);
    }

    static abstract class c
    extends CustomCommandExecutor.b<CommandListenerWrapper>
    implements CustomCommandExecutor.a<CommandListenerWrapper> {
        c() {
        }

        protected abstract @Nullable NBTTagCompound a(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        @Override
        public void a(CommandListenerWrapper source, ContextChain<CommandListenerWrapper> contextChain, ChainModifiers chainModifiers, ExecutionControl<CommandListenerWrapper> executionControl) throws CommandSyntaxException {
            CommandContext commandContext = contextChain.getTopContext().copyFor((Object)source);
            Pair<MinecraftKey, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>> functionCollection = ArgumentTag.c((CommandContext<CommandListenerWrapper>)commandContext, "name");
            Collection collection = (Collection)functionCollection.getSecond();
            if (collection.isEmpty()) {
                throw d.create((Object)IChatBaseComponent.a((MinecraftKey)functionCollection.getFirst()));
            }
            NBTTagCompound compoundTag = this.a((CommandContext<CommandListenerWrapper>)commandContext);
            CommandListenerWrapper commandSourceStack = CommandFunction.a(source);
            if (collection.size() == 1) {
                source.a(() -> IChatBaseComponent.a("commands.function.scheduled.single", IChatBaseComponent.a(((net.minecraft.commands.functions.CommandFunction)collection.iterator().next()).a())), true);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.function.scheduled.multiple", ChatComponentUtils.b(collection.stream().map(net.minecraft.commands.functions.CommandFunction::a).toList(), IChatBaseComponent::a)), true);
            }
            CommandFunction.a(collection, compoundTag, source, commandSourceStack, executionControl, e, chainModifiers);
        }
    }
}

