/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class CommandPlaySound {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.playsound.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        RequiredArgumentBuilder requiredArgumentBuilder = (RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sound", ArgumentMinecraftKeyRegistered.a()).suggests(CompletionProviders.a(CompletionProviders.b)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), CommandPlaySound.a(((CommandListenerWrapper)context.getSource()).j()), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), SoundCategory.a, ((CommandListenerWrapper)context.getSource()).e(), 1.0f, 1.0f, 0.0f));
        for (SoundCategory soundSource : SoundCategory.values()) {
            requiredArgumentBuilder.then(CommandPlaySound.a(soundSource));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("playsound").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then((ArgumentBuilder)requiredArgumentBuilder)));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(SoundCategory source) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b(source.a()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), CommandPlaySound.a(((CommandListenerWrapper)context.getSource()).j()), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), source, ((CommandListenerWrapper)context.getSource()).e(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), source, ((CommandListenerWrapper)context.getSource()).e(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), source, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("volume", FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), source, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), source, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), ((Float)context.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(net.minecraft.commands.CommandDispatcher.a("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), source, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), ((Float)context.getArgument("pitch", Float.class)).floatValue(), ((Float)context.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static Collection<EntityPlayer> a(@Nullable EntityPlayer player) {
        return player != null ? List.of(player) : List.of();
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, MinecraftKey sound, SoundCategory soundSource, Vec3D pos, float volume, float pitch, float minVolume) throws CommandSyntaxException {
        Holder<SoundEffect> holder = Holder.a(SoundEffect.a(sound));
        double d2 = MathHelper.j(holder.a().a(volume));
        WorldServer level = source.f();
        long randomLong = level.G_().g();
        ArrayList<EntityPlayer> list = new ArrayList<EntityPlayer>();
        for (EntityPlayer serverPlayer : targets) {
            if (serverPlayer.A() != level) continue;
            double d1 = pos.g - serverPlayer.dP();
            double d22 = pos.h - serverPlayer.dR();
            double d3 = pos.i - serverPlayer.dV();
            double d4 = d1 * d1 + d22 * d22 + d3 * d3;
            Vec3D vec3 = pos;
            float f2 = volume;
            if (d4 > d2) {
                if (minVolume <= 0.0f) continue;
                double squareRoot = Math.sqrt(d4);
                vec3 = new Vec3D(serverPlayer.dP() + d1 / squareRoot * 2.0, serverPlayer.dR() + d22 / squareRoot * 2.0, serverPlayer.dV() + d3 / squareRoot * 2.0);
                f2 = minVolume;
            }
            serverPlayer.g.b(new PacketPlayOutNamedSoundEffect(holder, soundSource, vec3.a(), vec3.b(), vec3.c(), f2, pitch, randomLong));
            list.add(serverPlayer);
        }
        int size = list.size();
        if (size == 0) {
            throw a.create();
        }
        if (size == 1) {
            source.a(() -> IChatBaseComponent.a("commands.playsound.success.single", IChatBaseComponent.a(sound), ((EntityPlayer)list.getFirst()).R_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.playsound.success.multiple", IChatBaseComponent.a(sound), size), true);
        }
        return size;
    }
}

