/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.world.level.storage.SaveData;
import org.slf4j.Logger;

public class CommandReload {
    private static final Logger a = LogUtils.getLogger();

    public static void a(Collection<String> selectedIds, CommandListenerWrapper source) {
        source.m().reloadResources(selectedIds, ServerResourcesReloadedEvent.Cause.COMMAND).exceptionally(throwable -> {
            a.warn("Failed to execute reload", throwable);
            source.b(IChatBaseComponent.c("commands.reload.failure"));
            return null;
        });
    }

    private static Collection<String> a(ResourcePackRepository packRepository, SaveData worldData, Collection<String> selectedIds) {
        packRepository.reload(true);
        ArrayList list = Lists.newArrayList(selectedIds);
        List<String> disabled = worldData.C().a().b();
        for (String string : packRepository.c()) {
            if (disabled.contains(string) || list.contains(string)) continue;
            list.add(string);
        }
        return list;
    }

    public static void reload(MinecraftServer server) {
        ResourcePackRepository packRepository = server.aE();
        SaveData worldData = server.bb();
        Collection<String> selectedIds = packRepository.e();
        Collection<String> collection = CommandReload.a(packRepository, worldData, selectedIds);
        server.reloadResources(collection, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("reload").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).executes(commandContext -> {
            CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)commandContext.getSource();
            MinecraftServer server = commandSourceStack.m();
            ResourcePackRepository packRepository = server.aE();
            SaveData worldData = server.bb();
            Collection<String> selectedIds = packRepository.e();
            Collection<String> collection = CommandReload.a(packRepository, worldData, selectedIds);
            commandSourceStack.a(() -> IChatBaseComponent.c("commands.reload.success"), true);
            CommandReload.a(collection, commandSourceStack);
            return 0;
        })));
    }
}

