/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.functions.MacroFunction;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.world.level.timers.CustomFunctionCallback;
import net.minecraft.world.level.timers.CustomFunctionCallbackTag;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;

public class CommandSchedule {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.schedule.same_tick"));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(functionName -> IChatBaseComponent.b("commands.schedule.cleared.failure", functionName));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.b("commands.schedule.macro", new Object[0]));
    private static final SuggestionProvider<CommandListenerWrapper> d = (context, builder) -> ICompletionProvider.b(((CommandListenerWrapper)context.getSource()).f().I.r().a(), builder);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("schedule").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("function").then(net.minecraft.commands.CommandDispatcher.a("function", ArgumentTag.a()).suggests(CommandFunction.b).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a()).executes(context -> CommandSchedule.a((CommandListenerWrapper)context.getSource(), ArgumentTag.b((CommandContext<CommandListenerWrapper>)context, "function"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), true))).then(net.minecraft.commands.CommandDispatcher.b("append").executes(context -> CommandSchedule.a((CommandListenerWrapper)context.getSource(), ArgumentTag.b((CommandContext<CommandListenerWrapper>)context, "function"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), false)))).then(net.minecraft.commands.CommandDispatcher.b("replace").executes(context -> CommandSchedule.a((CommandListenerWrapper)context.getSource(), ArgumentTag.b((CommandContext<CommandListenerWrapper>)context, "function"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), true))))))).then(net.minecraft.commands.CommandDispatcher.b("clear").then(net.minecraft.commands.CommandDispatcher.a("function", StringArgumentType.greedyString()).suggests(d).executes(context -> CommandSchedule.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"function")))))));
    }

    private static int a(CommandListenerWrapper source, Pair<MinecraftKey, Either<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>>> function, int time, boolean append) throws CommandSyntaxException {
        if (time == 0) {
            throw a.create();
        }
        long l2 = source.f().au() + (long)time;
        MinecraftKey identifier = (MinecraftKey)function.getFirst();
        CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents = source.f().I.H().r();
        Optional optional = ((Either)function.getSecond()).left();
        if (optional.isPresent()) {
            if (optional.get() instanceof MacroFunction) {
                throw c.create();
            }
            String string = identifier.toString();
            if (append) {
                scheduledEvents.a(string);
            }
            scheduledEvents.a(string, l2, new CustomFunctionCallback(identifier));
            source.a(() -> IChatBaseComponent.a("commands.schedule.created.function", IChatBaseComponent.a(identifier), time, l2), true);
        } else {
            String string = "#" + String.valueOf(identifier);
            if (append) {
                scheduledEvents.a(string);
            }
            scheduledEvents.a(string, l2, new CustomFunctionCallbackTag(identifier));
            source.a(() -> IChatBaseComponent.a("commands.schedule.created.tag", IChatBaseComponent.a(identifier), time, l2), true);
        }
        return Math.floorMod(l2, Integer.MAX_VALUE);
    }

    private static int a(CommandListenerWrapper source, String function) throws CommandSyntaxException {
        int i2 = source.f().I.H().r().a(function);
        if (i2 == 0) {
            throw b.create((Object)function);
        }
        source.a(() -> IChatBaseComponent.a("commands.schedule.cleared.success", i2, function), true);
        return i2;
    }
}

