/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;

public class CommandTag {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.tag.remove.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("tag").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.b("add").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.word()).executes(commandContext -> CommandTag.a((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandContext, "targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.b("remove").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.b(CommandTag.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandContext, "targets")), suggestionsBuilder)).executes(commandContext -> CommandTag.b((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandContext, "targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.b("list").executes(context -> CommandTag.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets")))))));
    }

    private static Collection<String> a(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            set.addAll(entity.aB());
        }
        return set;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> entities, String tagName) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : entities) {
            if (!entity.a(tagName)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw a.create();
        }
        if (entities.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.tag.add.success.single", new Object[]{tagName, ((Entity)entities.iterator().next()).R_()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.tag.add.success.multiple", new Object[]{tagName, entities.size()}), true);
        }
        return i2;
    }

    private static int b(CommandListenerWrapper source, Collection<? extends Entity> entities, String tagName) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : entities) {
            if (!entity.b(tagName)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw b.create();
        }
        if (entities.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.tag.remove.success.single", new Object[]{tagName, ((Entity)entities.iterator().next()).R_()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.tag.remove.success.multiple", new Object[]{tagName, entities.size()}), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            set.addAll(entity.aB());
        }
        if (entities.size() == 1) {
            Entity entity1 = entities.iterator().next();
            if (set.isEmpty()) {
                source.a(() -> IChatBaseComponent.a("commands.tag.list.single.empty", entity1.R_()), false);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.tag.list.single.success", entity1.R_(), set.size(), ChatComponentUtils.a(set)), false);
            }
        } else if (set.isEmpty()) {
            source.a(() -> IChatBaseComponent.a("commands.tag.list.multiple.empty", entities.size()), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.tag.list.multiple.success", entities.size(), set.size(), ChatComponentUtils.a(set)), false);
        }
        return set.size();
    }
}

