/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.Nullable;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("teleport").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandContext -> CommandTeleport.a((CommandListenerWrapper)commandContext.getSource(), Collections.singleton(((CommandListenerWrapper)commandContext.getSource()).h()), ((CommandListenerWrapper)commandContext.getSource()).f(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandContext, "location"), null, null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), Collections.singleton(((CommandListenerWrapper)context.getSource()).h()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).f(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).f(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("facing").then(net.minecraft.commands.CommandDispatcher.b("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).f(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).f(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).f(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, new LookAt.b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("tp").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).redirect(literalCommandNode)));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, Entity destination) throws CommandSyntaxException {
        for (Entity entity : targets) {
            CommandTeleport.a(source, entity, (WorldServer)destination.ao(), destination.dP(), destination.dR(), destination.dV(), EnumSet.noneOf(Relative.class), destination.ec(), destination.ee(), null);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.single", ((Entity)targets.iterator().next()).R_(), destination.R_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.multiple", targets.size(), destination.R_()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, WorldServer level, IVectorPosition position, @Nullable IVectorPosition rotation, @Nullable LookAt lookAt) throws CommandSyntaxException {
        Vec3D position1 = position.a(source);
        Vec2F vec2 = rotation == null ? null : rotation.b(source);
        for (Entity entity : targets) {
            Set<Relative> relatives = CommandTeleport.a(position, rotation, entity.ao().aq() == level.aq());
            if (vec2 == null) {
                CommandTeleport.a(source, entity, level, position1.g, position1.h, position1.i, relatives, entity.ec(), entity.ee(), lookAt);
                continue;
            }
            CommandTeleport.a(source, entity, level, position1.g, position1.h, position1.i, relatives, vec2.k, vec2.j, lookAt);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.single", ((Entity)targets.iterator().next()).R_(), CommandTeleport.a(position1.g), CommandTeleport.a(position1.h), CommandTeleport.a(position1.i)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.multiple", targets.size(), CommandTeleport.a(position1.g), CommandTeleport.a(position1.h), CommandTeleport.a(position1.i)), true);
        }
        return targets.size();
    }

    private static Set<Relative> a(IVectorPosition position, @Nullable IVectorPosition rotation, boolean absolute) {
        Set<Relative> set = Relative.b(position.a(), position.b(), position.c());
        Set set1 = absolute ? Relative.a(position.a(), position.b(), position.c()) : Set.of();
        Set<Relative> set2 = rotation == null ? Relative.k : Relative.a(rotation.b(), rotation.a());
        return Relative.a(set, set1, set2);
    }

    private static String a(double value) {
        return String.format(Locale.ROOT, "%f", value);
    }

    private static void a(CommandListenerWrapper source, Entity target, WorldServer level, double x2, double y2, double z2, Set<Relative> relatives, float yRot, float xRot, @Nullable LookAt lookAt) throws CommandSyntaxException {
        float f3;
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        if (!World.p(blockPos)) {
            throw a.create();
        }
        double d2 = relatives.contains((Object)Relative.a) ? x2 - target.dP() : x2;
        double d1 = relatives.contains((Object)Relative.b) ? y2 - target.dR() : y2;
        double d22 = relatives.contains((Object)Relative.c) ? z2 - target.dV() : z2;
        float f2 = relatives.contains((Object)Relative.d) ? yRot - target.ec() : yRot;
        float f1 = relatives.contains((Object)Relative.e) ? xRot - target.ee() : xRot;
        float f22 = MathHelper.f(f2);
        if (target.teleportTo(level, d2, d1, d22, relatives, f22, f3 = MathHelper.f(f1), true, PlayerTeleportEvent.TeleportCause.COMMAND)) {
            EntityLiving livingEntity;
            if (lookAt != null) {
                lookAt.perform(source, target);
            }
            if (!(target instanceof EntityLiving) || !(livingEntity = (EntityLiving)target).gj()) {
                target.k(target.dN().d(1.0, 0.0, 1.0));
                target.e(true);
            }
            if (target instanceof EntityCreature) {
                EntityCreature pathfinderMob = (EntityCreature)target;
                pathfinderMob.N().n();
            }
        }
    }
}

