/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class CommandTrigger {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.trigger.failed.unprimed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.trigger.failed.invalid"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("trigger").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).suggests((context, builder) -> CommandTrigger.a((CommandListenerWrapper)context.getSource(), builder)).executes(context -> CommandTrigger.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).i(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective")))).then(net.minecraft.commands.CommandDispatcher.b("add").then(net.minecraft.commands.CommandDispatcher.a("value", IntegerArgumentType.integer()).executes(context -> CommandTrigger.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).i(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(net.minecraft.commands.CommandDispatcher.b("set").then(net.minecraft.commands.CommandDispatcher.a("value", IntegerArgumentType.integer()).executes(context -> CommandTrigger.b((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).i(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))));
    }

    public static CompletableFuture<Suggestions> a(CommandListenerWrapper source, SuggestionsBuilder builder) {
        Entity entity = source.g();
        ArrayList list = Lists.newArrayList();
        if (entity != null) {
            ScoreboardServer scoreboard = source.m().aK();
            for (ScoreboardObjective objective : scoreboard.b()) {
                ReadOnlyScoreInfo playerScoreInfo;
                if (objective.d() != IScoreboardCriteria.d || (playerScoreInfo = scoreboard.d(entity, objective)) == null || playerScoreInfo.b()) continue;
                list.add(objective.c());
            }
        }
        return ICompletionProvider.b(list, builder);
    }

    private static int a(CommandListenerWrapper source, EntityPlayer player, ScoreboardObjective objective, int value) throws CommandSyntaxException {
        ScoreAccess score = CommandTrigger.a(source.m().aK(), (ScoreHolder)player, objective);
        int i2 = score.b(value);
        source.a(() -> IChatBaseComponent.a("commands.trigger.add.success", objective.h(), value), true);
        return i2;
    }

    private static int b(CommandListenerWrapper source, EntityPlayer player, ScoreboardObjective objective, int value) throws CommandSyntaxException {
        ScoreAccess score = CommandTrigger.a(source.m().aK(), (ScoreHolder)player, objective);
        score.a(value);
        source.a(() -> IChatBaseComponent.a("commands.trigger.set.success", objective.h(), value), true);
        return value;
    }

    private static int a(CommandListenerWrapper source, EntityPlayer player, ScoreboardObjective objective) throws CommandSyntaxException {
        ScoreAccess score = CommandTrigger.a(source.m().aK(), (ScoreHolder)player, objective);
        int i2 = score.b(1);
        source.a(() -> IChatBaseComponent.a("commands.trigger.simple.success", objective.h()), true);
        return i2;
    }

    private static ScoreAccess a(Scoreboard scoreboard, ScoreHolder scoreHolder, ScoreboardObjective objective) throws CommandSyntaxException {
        if (objective.d() != IScoreboardCriteria.d) {
            throw b.create();
        }
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.d(scoreHolder, objective);
        if (playerScoreInfo != null && !playerScoreInfo.b()) {
            ScoreAccess playerScore = scoreboard.c(scoreHolder, objective);
            playerScore.f();
            return playerScore;
        }
        throw a.create();
    }
}

