/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2F;

public class CommandWorldBorder {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.a("commands.worldborder.set.failed.big", Float.valueOf(5.999997E7f)));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.a("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType f = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType h = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.worldborder.damage.amount.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("worldborder").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).f().w().j() + DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), 0L))).then(net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a(0)).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).f().w().j() + DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), ((CommandListenerWrapper)context.getSource()).f().w().k() + (long)IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))))).then(net.minecraft.commands.CommandDispatcher.b("set").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), 0L))).then(net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a(0)).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), DoubleArgumentType.getDouble((CommandContext)context, (String)"distance"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))))).then(net.minecraft.commands.CommandDispatcher.b("center").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec2.a()).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), ArgumentVec2.a((CommandContext<CommandListenerWrapper>)context, "pos")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("damage").then(net.minecraft.commands.CommandDispatcher.b("amount").then(net.minecraft.commands.CommandDispatcher.a("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandWorldBorder.b((CommandListenerWrapper)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"damagePerBlock")))))).then(net.minecraft.commands.CommandDispatcher.b("buffer").then(net.minecraft.commands.CommandDispatcher.a("distance", FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"distance"))))))).then(net.minecraft.commands.CommandDispatcher.b("get").executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("warning").then(net.minecraft.commands.CommandDispatcher.b("distance").then(net.minecraft.commands.CommandDispatcher.a("distance", IntegerArgumentType.integer((int)0)).executes(context -> CommandWorldBorder.b((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"distance")))))).then(net.minecraft.commands.CommandDispatcher.b("time").then(net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a(0)).executes(context -> CommandWorldBorder.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))))));
    }

    private static int a(CommandListenerWrapper source, float distance) throws CommandSyntaxException {
        WorldBorder worldBorder = source.f().w();
        if (worldBorder.o() == (double)distance) {
            throw h.create();
        }
        worldBorder.b((double)distance);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.damage.buffer.success", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(distance))}), true);
        return (int)distance;
    }

    private static int b(CommandListenerWrapper source, float damagePerBlock) throws CommandSyntaxException {
        WorldBorder worldBorder = source.f().w();
        if (worldBorder.p() == (double)damagePerBlock) {
            throw i.create();
        }
        worldBorder.c((double)damagePerBlock);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.damage.amount.success", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(damagePerBlock))}), true);
        return (int)damagePerBlock;
    }

    private static int a(CommandListenerWrapper source, int time) throws CommandSyntaxException {
        WorldBorder worldBorder = source.f().w();
        if (worldBorder.r() == time) {
            throw f.create();
        }
        worldBorder.b(time);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.warning.time.success", new Object[]{CommandWorldBorder.a((long)time)}), true);
        return time;
    }

    private static int b(CommandListenerWrapper source, int distance) throws CommandSyntaxException {
        WorldBorder worldBorder = source.f().w();
        if (worldBorder.s() == distance) {
            throw g.create();
        }
        worldBorder.c(distance);
        source.a(() -> IChatBaseComponent.a("commands.worldborder.warning.distance.success", distance), true);
        return distance;
    }

    private static int a(CommandListenerWrapper source) {
        double size = source.f().w().j();
        source.a(() -> IChatBaseComponent.a("commands.worldborder.get", new Object[]{String.format(Locale.ROOT, "%.0f", size)}), false);
        return MathHelper.c(size + 0.5);
    }

    private static int a(CommandListenerWrapper source, Vec2F pos) throws CommandSyntaxException {
        WorldBorder worldBorder = source.f().w();
        if (worldBorder.h() == (double)pos.j && worldBorder.i() == (double)pos.k) {
            throw a.create();
        }
        if (!((double)Math.abs(pos.j) > 2.9999984E7) && !((double)Math.abs(pos.k) > 2.9999984E7)) {
            worldBorder.c(pos.j, pos.k);
            source.a(() -> IChatBaseComponent.a("commands.worldborder.center.success", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(pos.j)), String.format(Locale.ROOT, "%.2f", Float.valueOf(pos.k))}), true);
            return 0;
        }
        throw e.create();
    }

    private static int a(CommandListenerWrapper source, double newSize, long time) throws CommandSyntaxException {
        WorldServer level = source.f();
        WorldBorder worldBorder = level.w();
        double size = worldBorder.j();
        if (size == newSize) {
            throw b.create();
        }
        if (newSize < 1.0) {
            throw c.create();
        }
        if (newSize > 5.9999968E7) {
            throw d.create();
        }
        String string = String.format(Locale.ROOT, "%.1f", newSize);
        if (time > 0L) {
            worldBorder.a(size, newSize, time, level.au());
            if (newSize > size) {
                source.a(() -> IChatBaseComponent.a("commands.worldborder.set.grow", new Object[]{string, CommandWorldBorder.a(time)}), true);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.worldborder.set.shrink", new Object[]{string, CommandWorldBorder.a(time)}), true);
            }
        } else {
            worldBorder.a(newSize);
            source.a(() -> IChatBaseComponent.a("commands.worldborder.set.immediate", new Object[]{string}), true);
        }
        return (int)(newSize - size);
    }

    private static String a(long time) {
        return String.format(Locale.ROOT, "%.2f", (double)time / 20.0);
    }
}

