/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandXp {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.experience.set.points.invalid"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("experience").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("add").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.d()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("amount", IntegerArgumentType.integer()).executes(context -> CommandXp.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Unit.a))).then(net.minecraft.commands.CommandDispatcher.b("points").executes(context -> CommandXp.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Unit.a)))).then(net.minecraft.commands.CommandDispatcher.b("levels").executes(context -> CommandXp.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Unit.b))))))).then(net.minecraft.commands.CommandDispatcher.b("set").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.d()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("amount", IntegerArgumentType.integer((int)0)).executes(context -> CommandXp.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Unit.a))).then(net.minecraft.commands.CommandDispatcher.b("points").executes(context -> CommandXp.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Unit.a)))).then(net.minecraft.commands.CommandDispatcher.b("levels").executes(context -> CommandXp.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Unit.b))))))).then(net.minecraft.commands.CommandDispatcher.b("query").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.c()).then(net.minecraft.commands.CommandDispatcher.b("points").executes(context -> CommandXp.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.e((CommandContext<CommandListenerWrapper>)context, "target"), Unit.a)))).then(net.minecraft.commands.CommandDispatcher.b("levels").executes(context -> CommandXp.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.e((CommandContext<CommandListenerWrapper>)context, "target"), Unit.b)))))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("xp").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).redirect(literalCommandNode)));
    }

    private static int a(CommandListenerWrapper source, EntityPlayer player, Unit type) {
        int i2 = type.f.applyAsInt(player);
        source.a(() -> IChatBaseComponent.a("commands.experience.query." + type.e, player.R_(), i2), false);
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends EntityPlayer> targets, int amount, Unit type) {
        for (EntityPlayer entityPlayer : targets) {
            type.c.accept(entityPlayer, amount);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.experience.add." + type.e + ".success.single", amount, ((EntityPlayer)targets.iterator().next()).R_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.experience.add." + type.e + ".success.multiple", amount, targets.size()), true);
        }
        return targets.size();
    }

    private static int b(CommandListenerWrapper source, Collection<? extends EntityPlayer> targets, int amount, Unit type) throws CommandSyntaxException {
        int i2 = 0;
        for (EntityPlayer entityPlayer : targets) {
            if (!type.d.test(entityPlayer, amount)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw a.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.experience.set." + type.e + ".success.single", amount, ((EntityPlayer)targets.iterator().next()).R_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.experience.set." + type.e + ".success.multiple", amount, targets.size()), true);
        }
        return targets.size();
    }

    static final class Unit
    extends Enum<Unit> {
        public static final /* enum */ Unit a = new Unit("points", EntityHuman::d, (player, experience) -> {
            if (experience >= player.gU()) {
                return false;
            }
            player.a((int)experience);
            return true;
        }, player -> MathHelper.b(player.cu * (float)player.gU()));
        public static final /* enum */ Unit b = new Unit("levels", EntityPlayer::c, (player, experience) -> {
            player.b((int)experience);
            return true;
        }, player -> player.cs);
        public final BiConsumer<EntityPlayer, Integer> c;
        public final BiPredicate<EntityPlayer, Integer> d;
        public final String e;
        final ToIntFunction<EntityPlayer> f;
        private static final /* synthetic */ Unit[] g;

        public static Unit[] values() {
            return (Unit[])g.clone();
        }

        public static Unit valueOf(String name) {
            return Enum.valueOf(Unit.class, name);
        }

        private Unit(String name, BiConsumer<EntityPlayer, Integer> add, BiPredicate<EntityPlayer, Integer> set, ToIntFunction<EntityPlayer> query) {
            this.c = add;
            this.e = name;
            this.d = set;
            this.f = query;
        }

        private static /* synthetic */ Unit[] a() {
            return new Unit[]{a, b};
        }

        static {
            g = Unit.a();
        }
    }
}

