/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jspecify.annotations.Nullable;

public class DebugConfigCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("debugconfig").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.e))).then(net.minecraft.commands.CommandDispatcher.b("config").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.c()).executes(commandContext -> DebugConfigCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.e((CommandContext<CommandListenerWrapper>)commandContext, "target")))))).then(net.minecraft.commands.CommandDispatcher.b("unconfig").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentUUID.a()).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.b(DebugConfigCommand.a(((CommandListenerWrapper)commandContext.getSource()).m()), suggestionsBuilder)).executes(commandContext -> DebugConfigCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)commandContext, "target")))))).then(net.minecraft.commands.CommandDispatcher.b("dialog").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentUUID.a()).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.b(DebugConfigCommand.a(((CommandListenerWrapper)commandContext.getSource()).m()), suggestionsBuilder)).then(net.minecraft.commands.CommandDispatcher.a("dialog", ResourceOrIdArgument.d(context)).executes(commandContext -> DebugConfigCommand.a((CommandListenerWrapper)commandContext.getSource(), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)commandContext, "target"), ResourceOrIdArgument.d((CommandContext<CommandListenerWrapper>)commandContext, "dialog"))))))));
    }

    private static Iterable<String> a(MinecraftServer server) {
        HashSet<String> set = new HashSet<String>();
        for (NetworkManager connection : server.ak().e()) {
            PacketListener packetListener = connection.k();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) continue;
            ServerConfigurationPacketListenerImpl serverConfigurationPacketListenerImpl = (ServerConfigurationPacketListenerImpl)packetListener;
            set.add(serverConfigurationPacketListenerImpl.j().id().toString());
        }
        return set;
    }

    private static int a(CommandListenerWrapper source, EntityPlayer target) {
        GameProfile gameProfile = target.gI();
        target.g.o();
        source.a(() -> IChatBaseComponent.b("Switched player " + gameProfile.name() + "(" + String.valueOf(gameProfile.id()) + ") to config mode"), false);
        return 1;
    }

    private static @Nullable ServerConfigurationPacketListenerImpl a(MinecraftServer server, UUID target) {
        for (NetworkManager connection : server.ak().e()) {
            ServerConfigurationPacketListenerImpl serverConfigurationPacketListenerImpl;
            PacketListener packetListener = connection.k();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl) || !(serverConfigurationPacketListenerImpl = (ServerConfigurationPacketListenerImpl)packetListener).j().id().equals(target)) continue;
            return serverConfigurationPacketListenerImpl;
        }
        return null;
    }

    private static int a(CommandListenerWrapper source, UUID target) {
        ServerConfigurationPacketListenerImpl serverConfigurationPacketListenerImpl = DebugConfigCommand.a(source.m(), target);
        if (serverConfigurationPacketListenerImpl != null) {
            serverConfigurationPacketListenerImpl.m();
            return 1;
        }
        source.b(IChatBaseComponent.b("Can't find player to unconfig"));
        return 0;
    }

    private static int a(CommandListenerWrapper source, UUID target, Holder<Dialog> dialog) {
        ServerConfigurationPacketListenerImpl serverConfigurationPacketListenerImpl = DebugConfigCommand.a(source.m(), target);
        if (serverConfigurationPacketListenerImpl != null) {
            serverConfigurationPacketListenerImpl.b(new ClientboundShowDialogPacket(dialog));
            return 1;
        }
        source.b(IChatBaseComponent.b("Can't find player to talk to"));
        return 0;
    }
}

