/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.objects.PlayerSprite;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.component.ResolvableProfile;

public class FetchProfileCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("fetchprofile").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(net.minecraft.commands.CommandDispatcher.b("name").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.greedyString()).executes(context -> FetchProfileCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.b("id").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentUUID.a()).executes(context -> FetchProfileCommand.a((CommandListenerWrapper)context.getSource(), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "id")))))));
    }

    private static void a(CommandListenerWrapper source, GameProfile profile, String successKey, IChatBaseComponent resolved) {
        ResolvableProfile resolvableProfile = ResolvableProfile.a(profile);
        ResolvableProfile.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)resolvableProfile).ifSuccess(tag -> {
            String string = tag.toString();
            IChatMutableComponent mutableComponent = IChatBaseComponent.a(new PlayerSprite(resolvableProfile, true));
            ComponentSerialization.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)mutableComponent).ifSuccess(tag1 -> {
                String string1 = tag1.toString();
                source.a(() -> {
                    IChatMutableComponent component = ChatComponentUtils.a(List.of(IChatBaseComponent.c("commands.fetchprofile.copy_component").a(style -> style.a(new ChatClickable.CopyToClipboard(string))), IChatBaseComponent.c("commands.fetchprofile.give_item").a(style -> style.a(new ChatClickable.RunCommand("give @s minecraft:player_head[profile=" + string + "]"))), IChatBaseComponent.c("commands.fetchprofile.summon_mannequin").a(style -> style.a(new ChatClickable.RunCommand("summon minecraft:mannequin ~ ~ ~ {profile:" + string + "}"))), IChatBaseComponent.a("commands.fetchprofile.copy_text", mutableComponent.a(EnumChatFormat.p)).a(style -> style.a(new ChatClickable.CopyToClipboard(string1)))), CommonComponents.x, (T mutableComponent1) -> ChatComponentUtils.a(mutableComponent1.a(EnumChatFormat.k)));
                    return IChatBaseComponent.a(successKey, resolved, component);
                }, false);
            }).ifError(error -> source.b(IChatBaseComponent.a("commands.fetchprofile.failed_to_serialize", new Object[]{error.message()})));
        }).ifError(error -> source.b(IChatBaseComponent.a("commands.fetchprofile.failed_to_serialize", new Object[]{error.message()})));
    }

    private static int a(CommandListenerWrapper source, String name) {
        MinecraftServer server = source.m();
        ProfileResolver profileResolver = server.ar().g();
        SystemUtils.j().execute(() -> {
            IChatMutableComponent component = IChatBaseComponent.b(name);
            Optional<GameProfile> optional = profileResolver.a(name);
            server.execute(() -> optional.ifPresentOrElse(gameProfile -> FetchProfileCommand.a(source, gameProfile, "commands.fetchprofile.name.success", component), () -> source.b(IChatBaseComponent.a("commands.fetchprofile.name.failure", component))));
        });
        return 1;
    }

    private static int a(CommandListenerWrapper source, UUID id) {
        MinecraftServer server = source.m();
        ProfileResolver profileResolver = server.ar().g();
        SystemUtils.j().execute(() -> {
            IChatBaseComponent component = IChatBaseComponent.a(id);
            Optional<GameProfile> optional = profileResolver.a(id);
            server.execute(() -> optional.ifPresentOrElse(gameProfile -> FetchProfileCommand.a(source, gameProfile, "commands.fetchprofile.id.success", component), () -> source.b(IChatBaseComponent.a("commands.fetchprofile.id.failure", component))));
        });
        return 1;
    }
}

