/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileZipper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class PerfCommand {
    private static final Logger a = LogUtils.getLogger();
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.perf.notRunning"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.perf.alreadyRunning"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("perf").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.f))).then(net.minecraft.commands.CommandDispatcher.b("start").executes(commandContext -> PerfCommand.a((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("stop").executes(context -> PerfCommand.b((CommandListenerWrapper)context.getSource())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer server = source.m();
        if (server.aV()) {
            throw c.create();
        }
        Consumer<MethodProfilerResults> consumer = profileResults -> PerfCommand.a(source, profileResults);
        Consumer<Path> consumer1 = path -> PerfCommand.a(source, path, server);
        server.a(consumer, consumer1);
        source.a(() -> IChatBaseComponent.c("commands.perf.started"), false);
        return 0;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer server = source.m();
        if (!server.aV()) {
            throw b.create();
        }
        server.aX();
        return 0;
    }

    private static void a(CommandListenerWrapper source, Path path, MinecraftServer server) {
        String string1;
        String string = String.format(Locale.ROOT, "%s-%s-%s", SystemUtils.f(), server.bb().d(), SharedConstants.b().b());
        try {
            string1 = net.minecraft.util.FileUtils.a(MetricsPersister.a, string, ".zip");
        }
        catch (IOException var11) {
            source.b(IChatBaseComponent.c("commands.perf.reportFailed"));
            a.error("Failed to create report name", (Throwable)var11);
            return;
        }
        try (FileZipper fileZipper = new FileZipper(MetricsPersister.a.resolve(string1));){
            fileZipper.a(Paths.get("system.txt", new String[0]), server.b(new SystemReport()).a());
            fileZipper.a(path);
        }
        try {
            FileUtils.forceDelete((File)path.toFile());
        }
        catch (IOException var9) {
            a.warn("Failed to delete temporary profiling file {}", (Object)path, (Object)var9);
        }
        source.a(() -> IChatBaseComponent.a("commands.perf.reportSaved", new Object[]{string1}), false);
    }

    private static void a(CommandListenerWrapper source, MethodProfilerResults results) {
        if (results != MethodProfilerResultsEmpty.a) {
            int tickDuration = results.f();
            double d2 = (double)results.g() / (double)TimeRange.a;
            source.a(() -> IChatBaseComponent.a("commands.perf.stopped", new Object[]{String.format(Locale.ROOT, "%.2f", d2), tickDuration, String.format(Locale.ROOT, "%.2f", (double)tickDuration / d2)}), false);
        }
    }
}

