/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;
import org.jspecify.annotations.Nullable;

public class RandomCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.random.error.range_too_small"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("random").then(RandomCommand.a("value", false))).then(RandomCommand.a("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("reset").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("*").executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("includeWorldSeed", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.a("includeSequenceId", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sequence", ArgumentMinecraftKeyRegistered.a()).suggests(RandomCommand::a).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sequence")))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("includeWorldSeed", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.a("includeSequenceId", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeSequenceId"))))))))));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(String subcommand, boolean displayResult) {
        return (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b(subcommand).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"), null, displayResult))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sequence", ArgumentMinecraftKeyRegistered.a()).suggests(RandomCommand::a).requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.d))).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sequence"), displayResult))));
    }

    private static CompletableFuture<Suggestions> a(CommandContext<CommandListenerWrapper> context, SuggestionsBuilder suggestionsBuilder) {
        ArrayList list = Lists.newArrayList();
        ((CommandListenerWrapper)context.getSource()).f().T().a((identifier, randomSequence) -> list.add(identifier.toString()));
        return ICompletionProvider.b(list, suggestionsBuilder);
    }

    private static int a(CommandListenerWrapper source, CriterionConditionValue.IntegerRange range, @Nullable MinecraftKey sequence, boolean displayResult) throws CommandSyntaxException {
        RandomSource randomSequence = sequence != null ? source.f().a(sequence) : source.f().G_();
        int i2 = range.b().orElse(Integer.MIN_VALUE);
        int i1 = range.c().orElse(Integer.MAX_VALUE);
        long l2 = (long)i1 - (long)i2;
        if (l2 == 0L) {
            throw b.create();
        }
        if (l2 >= Integer.MAX_VALUE) {
            throw a.create();
        }
        int i22 = MathHelper.b(randomSequence, i2, i1);
        if (displayResult) {
            source.m().aj().a(IChatBaseComponent.a("commands.random.roll", source.b(), i22, i2, i1), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.random.sample.success", i22), false);
        }
        return i22;
    }

    private static int a(CommandListenerWrapper source, MinecraftKey sequence) throws CommandSyntaxException {
        WorldServer level = source.f();
        level.T().b(sequence, level.J());
        source.a(() -> IChatBaseComponent.a("commands.random.reset.success", IChatBaseComponent.a(sequence)), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, MinecraftKey sequence, int seed, boolean includeWorldSeed, boolean includeSequenceId) throws CommandSyntaxException {
        WorldServer level = source.f();
        level.T().a(sequence, level.J(), seed, includeWorldSeed, includeSequenceId);
        source.a(() -> IChatBaseComponent.a("commands.random.reset.success", IChatBaseComponent.a(sequence)), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source) {
        int i2 = source.f().T().a();
        source.a(() -> IChatBaseComponent.a("commands.random.reset.all.success", i2), false);
        return i2;
    }

    private static int a(CommandListenerWrapper source, int seed, boolean includeWorldSeed, boolean includeSequenceId) {
        RandomSequences randomSequences = source.f().T();
        randomSequences.a(seed, includeWorldSeed, includeSequenceId);
        int i2 = randomSequences.a();
        source.a(() -> IChatBaseComponent.a("commands.random.reset.all.success", i2), false);
        return i2;
    }
}

