/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.util.TimeRange;

public class TickCommand {
    private static final float a = 10000.0f;
    private static final String b = String.valueOf(20);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("tick").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.e))).then(net.minecraft.commands.CommandDispatcher.b("query").executes(commandContext -> TickCommand.a((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("rate").then(net.minecraft.commands.CommandDispatcher.a("rate", FloatArgumentType.floatArg((float)1.0f, (float)10000.0f)).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.a(new String[]{b}, suggestionsBuilder)).executes(commandContext -> TickCommand.a((CommandListenerWrapper)commandContext.getSource(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"rate")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("step").executes(commandContext -> TickCommand.b((CommandListenerWrapper)commandContext.getSource(), 1))).then(net.minecraft.commands.CommandDispatcher.b("stop").executes(commandContext -> TickCommand.b((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a(1)).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.a(new String[]{"1t", "1s"}, suggestionsBuilder)).executes(commandContext -> TickCommand.b((CommandListenerWrapper)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"time")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("sprint").then(net.minecraft.commands.CommandDispatcher.b("stop").executes(commandContext -> TickCommand.c((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a(1)).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.a(new String[]{"60s", "1d", "3d"}, suggestionsBuilder)).executes(commandContext -> TickCommand.a((CommandListenerWrapper)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"time")))))).then(net.minecraft.commands.CommandDispatcher.b("unfreeze").executes(commandContext -> TickCommand.a((CommandListenerWrapper)commandContext.getSource(), false)))).then(net.minecraft.commands.CommandDispatcher.b("freeze").executes(commandContext -> TickCommand.a((CommandListenerWrapper)commandContext.getSource(), true)))));
    }

    private static String a(long nanos) {
        return String.format(Locale.ROOT, "%.1f", Float.valueOf((float)nanos / (float)TimeRange.b));
    }

    private static int a(CommandListenerWrapper source, float tickRate) {
        ServerTickRateManager serverTickRateManager = source.m().aR();
        serverTickRateManager.a(tickRate);
        String string = String.format(Locale.ROOT, "%.1f", Float.valueOf(tickRate));
        source.a(() -> IChatBaseComponent.a("commands.tick.rate.success", new Object[]{string}), true);
        return (int)tickRate;
    }

    private static int a(CommandListenerWrapper source) {
        ServerTickRateManager serverTickRateManager = source.m().aR();
        String string = TickCommand.a(source.m().aS());
        float tickrate = serverTickRateManager.f();
        String string1 = String.format(Locale.ROOT, "%.1f", Float.valueOf(tickrate));
        if (serverTickRateManager.a()) {
            source.a(() -> IChatBaseComponent.c("commands.tick.status.sprinting"), false);
            source.a(() -> IChatBaseComponent.a("commands.tick.query.rate.sprinting", new Object[]{string1, string}), false);
        } else {
            if (serverTickRateManager.l()) {
                source.a(() -> IChatBaseComponent.c("commands.tick.status.frozen"), false);
            } else if (serverTickRateManager.h() < source.m().aS()) {
                source.a(() -> IChatBaseComponent.c("commands.tick.status.lagging"), false);
            } else {
                source.a(() -> IChatBaseComponent.c("commands.tick.status.running"), false);
            }
            String string2 = TickCommand.a(serverTickRateManager.h());
            source.a(() -> IChatBaseComponent.a("commands.tick.query.rate.running", new Object[]{string1, string, string2}), false);
        }
        long[] longs = Arrays.copyOf(source.m().aT(), source.m().aT().length);
        Arrays.sort(longs);
        String string3 = TickCommand.a(longs[longs.length / 2]);
        String string4 = TickCommand.a(longs[(int)((double)longs.length * 0.95)]);
        String string5 = TickCommand.a(longs[(int)((double)longs.length * 0.99)]);
        source.a(() -> IChatBaseComponent.a("commands.tick.query.percentiles", new Object[]{string3, string4, string5, longs.length}), false);
        return (int)tickrate;
    }

    private static int a(CommandListenerWrapper source, int sprintTime) {
        boolean flag = source.m().aR().b(sprintTime);
        if (flag) {
            source.a(() -> IChatBaseComponent.c("commands.tick.sprint.stop.success"), true);
        }
        source.a(() -> IChatBaseComponent.c("commands.tick.status.sprinting"), true);
        return 1;
    }

    private static int a(CommandListenerWrapper source, boolean frozen) {
        ServerTickRateManager serverTickRateManager = source.m().aR();
        if (frozen) {
            if (serverTickRateManager.a()) {
                serverTickRateManager.c();
            }
            if (serverTickRateManager.j()) {
                serverTickRateManager.b();
            }
        }
        serverTickRateManager.a(frozen);
        if (frozen) {
            source.a(() -> IChatBaseComponent.c("commands.tick.status.frozen"), true);
        } else {
            source.a(() -> IChatBaseComponent.c("commands.tick.status.running"), true);
        }
        return frozen ? 1 : 0;
    }

    private static int b(CommandListenerWrapper source, int ticks) {
        ServerTickRateManager serverTickRateManager = source.m().aR();
        boolean flag = serverTickRateManager.a(ticks);
        if (flag) {
            source.a(() -> IChatBaseComponent.a("commands.tick.step.success", ticks), true);
        } else {
            source.b(IChatBaseComponent.c("commands.tick.step.fail"));
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source) {
        ServerTickRateManager serverTickRateManager = source.m().aR();
        boolean flag = serverTickRateManager.b();
        if (flag) {
            source.a(() -> IChatBaseComponent.c("commands.tick.step.stop.success"), true);
            return 1;
        }
        source.b(IChatBaseComponent.c("commands.tick.step.stop.fail"));
        return 0;
    }

    private static int c(CommandListenerWrapper source) {
        ServerTickRateManager serverTickRateManager = source.m().aR();
        boolean flag = serverTickRateManager.c();
        if (flag) {
            source.a(() -> IChatBaseComponent.c("commands.tick.sprint.stop.success"), true);
            return 1;
        }
        source.b(IChatBaseComponent.c("commands.tick.sprint.stop.fail"));
        return 0;
    }
}

