/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.server.level.EntityPlayer;

public class TransferCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.transfer.error.no_players"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("transfer").requires(net.minecraft.commands.CommandDispatcher.a(net.minecraft.commands.CommandDispatcher.e))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("hostname", StringArgumentType.string()).executes(commandContext -> TransferCommand.a((CommandListenerWrapper)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"hostname"), 25565, List.of(((CommandListenerWrapper)commandContext.getSource()).i())))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("port", IntegerArgumentType.integer((int)1, (int)65535)).executes(commandContext -> TransferCommand.a((CommandListenerWrapper)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"hostname"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"port"), List.of(((CommandListenerWrapper)commandContext.getSource()).i())))).then(net.minecraft.commands.CommandDispatcher.a("players", ArgumentEntity.d()).executes(commandContext -> TransferCommand.a((CommandListenerWrapper)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"hostname"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"port"), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)commandContext, "players"))))))));
    }

    private static int a(CommandListenerWrapper source, String hostname, int port, Collection<EntityPlayer> players) throws CommandSyntaxException {
        if (players.isEmpty()) {
            throw a.create();
        }
        for (EntityPlayer serverPlayer : players) {
            serverPlayer.g.b(new ClientboundTransferPacket(hostname, port));
        }
        if (players.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.transfer.success.single", ((EntityPlayer)players.iterator().next()).R_(), hostname, port), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.transfer.success.multiple", players.size(), hostname, port), true);
        }
        return players.size();
    }
}

