/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import com.destroystokyo.paper.Metrics;
import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.console.PaperConsole;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonElement;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContext;
import io.papermc.paper.command.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import java.util.stream.Stream;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.jsonrpc.JsonRpcNotificationService;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.security.AuthenticationHandler;
import net.minecraft.server.jsonrpc.security.JsonRpcSslContextProvider;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.UtilColor;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R7.util.ForwardLogHandler;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger m = LogUtils.getLogger();
    private static final int n = 5000;
    private static final int o = 2;
    private final Queue<ServerCommand> serverCommandQueue = new ConcurrentLinkedQueue<ServerCommand>();
    private @Nullable RemoteStatusListener q;
    private @Nullable RemoteControlListener s;
    public DedicatedServerSettings t;
    private @Nullable ServerGUI u;
    private final @Nullable ServerTextFilter v;
    private @Nullable RemoteSampleLogger w;
    private boolean x;
    public ServerLinks y;
    private final Map<String, String> z;
    private @Nullable ManagementServer A;
    private long B;
    private static final AtomicInteger ASYNC_DEBUG_CHUNKS_COUNT = new AtomicInteger();

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, DedicatedServerSettings settings, DataFixer fixerUpper, Services services) {
        super(options, worldLoader, serverThread, storageSource, packRepository, worldStem, Proxy.NO_PROXY, fixerUpper, services, LoggingLevelLoadListener.a());
        this.t = settings;
        this.d(settings.a().h.get());
        this.v = ServerTextFilter.a(settings.a());
        this.y = DedicatedServer.a(settings);
        this.z = settings.a().i ? DedicatedServer.bQ() : Map.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> bQ() {
        Path path = Path.of("codeofconduct", new String[0]);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new IllegalArgumentException("Code of Conduct folder does not exist: " + String.valueOf(path));
        }
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            try (Stream<Path> stream = Files.list(path);){
                for (Path path1 : stream.toList()) {
                    String string = path1.getFileName().toString();
                    if (!string.endsWith(".txt")) continue;
                    String string1 = string.substring(0, string.length() - 4).toLowerCase(Locale.ROOT);
                    if (!path1.toRealPath(new LinkOption[0]).getParent().equals(path.toAbsolutePath())) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file \"" + string + "\" because it links to a file outside the allowed directory");
                    }
                    try {
                        String string2 = String.join((CharSequence)"\n", Files.readAllLines(path1, StandardCharsets.UTF_8));
                        builder.put((Object)string1, (Object)UtilColor.a(string2));
                    }
                    catch (IOException var9) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file " + string, var9);
                        return builder.build();
                    }
                }
            }
        }
        catch (IOException var11) {
            throw new IllegalArgumentException("Failed to read Code of Conduct folder", var11);
        }
    }

    private SslContext bR() {
        try {
            return JsonRpcSslContextProvider.a(this.a().v, this.a().w);
        }
        catch (Exception var2) {
            JsonRpcSslContextProvider.a();
            throw new IllegalStateException("Failed to configure TLS for the server management protocol", var2);
        }
    }

    @Override
    public boolean e() throws IOException {
        String proxyLink;
        Object bindAddress;
        int i2 = this.a().s;
        if (this.a().q) {
            String string = this.t.a().t;
            if (!SecurityConfig.a(string)) {
                throw new IllegalStateException("Invalid management server secret, must be 40 alphanumeric characters");
            }
            String string1 = this.a().r;
            HostAndPort hostAndPort = HostAndPort.fromParts((String)string1, (int)i2);
            SecurityConfig securityConfig = new SecurityConfig(string);
            String string2 = this.a().x;
            AuthenticationHandler authenticationHandler = new AuthenticationHandler(securityConfig, string2);
            m.info("Starting json RPC server on {}", (Object)hostAndPort);
            this.A = new ManagementServer(hostAndPort, authenticationHandler);
            MinecraftApi minecraftApi = MinecraftApi.a(this);
            minecraftApi.h().a(new JsonRpcNotificationService(minecraftApi, this.A));
            if (this.a().u) {
                SslContext sslContext = this.bR();
                this.A.a(minecraftApi, sslContext);
            } else {
                this.A.a(minecraftApi);
            }
        }
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                new PaperConsole(DedicatedServer.this).start();
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (HostAndPort handler : global.getHandlers()) {
            global.removeHandler((Handler)handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(m));
        m.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            m.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if (ServerEnvironment.userIsRootOrAdmin()) {
            m.warn("****************************");
            m.warn("YOU ARE RUNNING THIS SERVER AS AN ADMINISTRATIVE OR ROOT USER. THIS IS NOT ADVISED.");
            m.warn("YOU ARE OPENING YOURSELF UP TO POTENTIAL RISKS WHEN DOING THIS.");
            m.warn("FOR MORE INFORMATION, SEE https://madelinemiller.dev/blog/root-minecraft-server/");
            m.warn("****************************");
        }
        m.info("Loading properties");
        DedicatedServerProperties properties = this.t.a();
        if (this.X()) {
            this.a_("127.0.0.1");
        } else {
            this.e(properties.d);
            this.f(properties.e);
            this.a_(properties.f);
        }
        this.a(new DedicatedPlayerList(this, this.bd(), this.h));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        ((Object)((Object)ObfHelper.INSTANCE)).getClass();
        this.paperConfigurations.initializeGlobalConfiguration(this.bc());
        this.paperConfigurations.initializeWorldDefaultsConfiguration(this.bc());
        this.server.spark.enableEarlyIfRequested();
        if (this.bE()) {
            this.ar().f().save(false);
        }
        this.bA().loadAndSaveFiles();
        WatchdogThread.doStart(SpigotConfig.timeoutTime, SpigotConfig.restartOnCrash);
        thread.start();
        PaperCommands.registerCommands(this);
        this.server.spark.registerCommandBeforePlugins(this.server);
        Metrics.PaperMetrics.startMetrics();
        ((Object)((Object)VersionHistoryManager.INSTANCE)).getClass();
        m.info("Default game type: {}", (Object)properties.n.get());
        if (this.y().startsWith("unix:")) {
            if (!Epoll.isAvailable()) {
                m.error("**** INVALID CONFIGURATION!");
                m.error("You are trying to use a Unix domain socket but you're not on a supported OS.");
                return false;
            }
            if (!GlobalConfiguration.get().proxies.velocity.enabled && !SpigotConfig.bungee) {
                m.error("**** INVALID CONFIGURATION!");
                m.error("Unix domain sockets require IPs to be forwarded from a proxy.");
                return false;
            }
            bindAddress = new DomainSocketAddress(this.y().substring("unix:".length()));
        } else {
            InetAddress inetAddress = null;
            if (!this.y().isEmpty()) {
                inetAddress = InetAddress.getByName(this.y());
            }
            if (this.V() < 0) {
                this.b(properties.p);
            }
            bindAddress = new InetSocketAddress(inetAddress, this.V());
        }
        this.Y();
        m.info("Starting Minecraft server on {}:{}", (Object)(this.y().isEmpty() ? "*" : this.y()), (Object)this.V());
        try {
            this.ak().startTcpServerListener((SocketAddress)bindAddress);
        }
        catch (IOException var11) {
            m.warn("**** FAILED TO BIND TO PORT!");
            m.warn("The exception was: {}", (Object)var11.toString());
            m.warn("Perhaps a server is already running on that port?");
            throw new IllegalStateException("Failed to bind to port", var11);
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        boolean usingProxy = SpigotConfig.bungee || GlobalConfiguration.get().proxies.velocity.enabled;
        String proxyFlavor = GlobalConfiguration.get().proxies.velocity.enabled ? "Velocity" : "BungeeCord";
        String string = proxyLink = GlobalConfiguration.get().proxies.velocity.enabled ? "https://docs.papermc.io/velocity/security" : "http://www.spigotmc.org/wiki/firewall-guide/";
        if (!this.ae()) {
            m.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            m.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (usingProxy) {
                m.warn("Whilst this makes it possible to use {}, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.", (Object)proxyFlavor);
                m.warn("Please see {} for further information.", (Object)proxyLink);
            } else {
                m.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            m.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        this.w = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.bw(), RemoteDebugSampleType.a);
        long nanos = SystemUtils.d();
        this.j.f().a(!this.ae());
        m.info("Preparing level \"{}\"", (Object)this.j());
        this.loadLevel(this.g.f());
        long l2 = SystemUtils.d() - nanos;
        String string3 = String.format(Locale.ROOT, "%.3fs", (double)l2 / 1.0E9);
        m.info("Done preparing level \"{}\" ({})", (Object)this.j(), (Object)string3);
        this.initPostWorld();
        if (properties.y != null) {
            this.k.n().set(GameRules.S, properties.y, this.N());
        }
        if (properties.z) {
            m.info("Starting GS4 status listener");
            this.q = RemoteStatusListener.a(this);
        }
        if (properties.B) {
            m.info("Starting remote control listener");
            this.s = RemoteControlListener.a(this);
        }
        if (properties.V) {
            MinecraftServerBeans.a(this);
            m.info("JMX monitoring enabled");
        }
        this.C().a();
        return true;
    }

    public File getPluginsFolder() {
        return (File)this.options.valueOf("plugins");
    }

    @Override
    public boolean aO() {
        return this.t.a().l.get();
    }

    @Override
    public void g(boolean enforceWhitelist) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.l.a(this.bc(), enforceWhitelist));
    }

    @Override
    public boolean aP() {
        return this.t.a().af.get();
    }

    @Override
    public void h(boolean usingWhitelist) {
        new WhitelistToggleEvent(usingWhitelist).callEvent();
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.af.a(this.bc(), usingWhitelist));
    }

    @Override
    public void a(BooleanSupplier hasTimeLeft) {
        long l2;
        super.a(hasTimeLeft);
        if (this.A != null) {
            this.A.a();
        }
        long millis = SystemUtils.c();
        int i2 = this.bD();
        if (i2 > 0 && millis - this.B >= (l2 = (long)i2 * TimeRange.c)) {
            this.B = millis;
            this.C().f();
        }
    }

    @Override
    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        this.C().c();
        boolean flag = super.a(suppressLogs, flush, force);
        this.C().d();
        return flag;
    }

    @Override
    public boolean ag() {
        return this.t.a().g.get();
    }

    public void j(boolean allowFlight) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.g.a(this.bc(), allowFlight));
    }

    @Override
    public DedicatedServerProperties a() {
        return this.t.a();
    }

    public void a(EnumDifficulty difficulty) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.m.a(this.bc(), difficulty));
        this.t();
    }

    @Override
    public void t() {
    }

    public int bx() {
        return this.t.a().M.get();
    }

    public void e(int viewDistance) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.M.a(this.bc(), viewDistance));
        this.bA().a(viewDistance);
    }

    public int by() {
        return this.t.a().N.get();
    }

    public void f(int simulationDistance) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.N.a(this.bc(), simulationDistance));
        this.bA().b(simulationDistance);
    }

    @Override
    public SystemReport a(SystemReport report) {
        report.a("Is Modded", () -> this.T().b());
        report.a("Type", () -> "Dedicated Server (map_server.txt)");
        return report;
    }

    @Override
    public void a(Path path) throws IOException {
        DedicatedServerProperties properties = this.a();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", properties.T));
            bufferedWriter.write(String.format(Locale.ROOT, "gamemode=%s%n", properties.n.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", properties.Y.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", properties.S));
            bufferedWriter.write(String.format(Locale.ROOT, "view-distance=%d%n", properties.M.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", properties.N.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", properties.aj.d()));
            bufferedWriter.write(String.format(Locale.ROOT, "use-native=%s%n", properties.F));
            bufferedWriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", properties.L));
        }
    }

    @Override
    public void i() {
        if (this.v != null) {
            this.v.close();
        }
        if (this.u != null) {
            this.u.b();
        }
        if (this.s != null) {
            this.s.stopNonBlocking();
        }
        if (this.q != null) {
            // empty if block
        }
        if (this.A != null) {
            try {
                this.A.a(true);
            }
            catch (InterruptedException var2) {
                m.error("Interrupted while stopping the management server", (Throwable)var2);
            }
        }
        this.hasFullyShutdown = true;
        System.exit(this.abnormalExit ? 70 : 0);
    }

    @Override
    public void K() {
        super.K();
        this.bz();
    }

    public void a(String msg, CommandListenerWrapper source) {
        if (msg.equalsIgnoreCase("paper debug chunks --async")) {
            m.info("Scheduling async debug chunks");
            Runnable run = () -> {
                m.info("Async debug chunks executing");
                ChunkTaskScheduler.dumpAllChunkLoadInfo(this, false);
                ConsoleCommandSender sender = MinecraftServer.getServer().console;
                File file = ChunkTaskScheduler.getChunkDebugFile();
                sender.sendMessage((Component)Component.text((String)("Writing chunk information dump to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
                try {
                    JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(this), file);
                    sender.sendMessage((Component)Component.text((String)"Successfully written chunk information!", (TextColor)NamedTextColor.GREEN));
                }
                catch (Throwable thr) {
                    MinecraftServer.m.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Component)Component.text((String)"Failed to dump chunk information, see console", (TextColor)NamedTextColor.RED));
                }
            };
            Thread t2 = new Thread(run);
            t2.setName("Async debug thread #" + ASYNC_DEBUG_CHUNKS_COUNT.getAndIncrement());
            t2.setDaemon(true);
            t2.start();
            return;
        }
        this.serverCommandQueue.add(new ServerCommand(msg, source));
    }

    public void bz() {
        ServerCommand consoleInput;
        while ((consoleInput = this.serverCommandQueue.poll()) != null) {
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, consoleInput.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            consoleInput = new ServerCommand(event.getCommand(), consoleInput.b);
            this.aF().a(consoleInput.b, consoleInput.a);
        }
    }

    @Override
    public boolean n() {
        return true;
    }

    @Override
    public int o() {
        return this.a().L;
    }

    @Override
    public boolean p() {
        return this.a().F;
    }

    public DedicatedPlayerList bA() {
        return (DedicatedPlayerList)super.aj();
    }

    @Override
    public int r() {
        return this.t.a().O.get();
    }

    public void g(int maxPlayers) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.O.a(this.bc(), maxPlayers));
    }

    @Override
    public boolean q() {
        return true;
    }

    @Override
    public String b() {
        return this.y();
    }

    @Override
    public int d() {
        return this.V();
    }

    @Override
    public String h() {
        return this.ah();
    }

    public void bB() {
        if (this.u == null) {
            this.u = ServerGUI.a(this);
        }
    }

    public int bC() {
        return this.a().G.get();
    }

    public void h(int radius) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.G.a(this.bc(), radius));
    }

    @Override
    public boolean a(WorldServer level, BlockPosition pos, EntityHuman player) {
        int abs1;
        WorldData.a respawnData = level.C();
        if (level.aq() != respawnData.a()) {
            return false;
        }
        if (this.bA().k().d()) {
            return false;
        }
        if (this.bA().f(player.gJ())) {
            return false;
        }
        if (this.bC() <= 0) {
            return false;
        }
        BlockPosition blockPos = respawnData.b();
        int abs = MathHelper.a(pos.u() - blockPos.u());
        int max = Math.max(abs, abs1 = MathHelper.a(pos.w() - blockPos.w()));
        return max <= this.bC();
    }

    @Override
    public boolean an() {
        return this.a().W.get();
    }

    public void k(boolean repliesToStatus) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.W.a(this.bc(), repliesToStatus));
    }

    @Override
    public boolean ao() {
        return this.a().X.get();
    }

    public void l(boolean hidesOnlinePlayers) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.X.a(this.bc(), hidesOnlinePlayers));
    }

    @Override
    public LevelBasedPermissionSet k() {
        return this.a().H.get();
    }

    public void a(LevelBasedPermissionSet permissions) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.H.a(this.bc(), permissions));
    }

    @Override
    public PermissionSet l() {
        return this.a().I;
    }

    @Override
    public int aq() {
        return this.t.a().ad.get();
    }

    @Override
    public void d(int idleTimeout) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ad.a(this.bc(), idleTimeout));
    }

    public int bD() {
        return this.t.a().ae.get();
    }

    public void i(int heartbeatInterval) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ae.a(this.bc(), heartbeatInterval));
    }

    @Override
    public String ah() {
        return super.ah();
    }

    @Override
    public void d(String motd) {
        super.d(motd);
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.h.a(this.bc(), this.ah()));
    }

    @Override
    public boolean m() {
        return this.a().Q;
    }

    @Override
    public boolean c() {
        return this.a().R;
    }

    @Override
    public int au() {
        return this.a().S;
    }

    @Override
    public int ax() {
        return this.a().P;
    }

    @Override
    public boolean ay() {
        DedicatedServerProperties properties = this.a();
        return properties.ag && GlobalConfiguration.get().proxies.isProxyOnlineMode() && this.j.b();
    }

    @Override
    public boolean bn() {
        return this.a().ah;
    }

    protected boolean bE() {
        boolean flag = false;
        for (int i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                m.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bS();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (int var7 = 0; !flag1 && var7 <= 2; ++var7) {
            if (var7 > 0) {
                m.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bS();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (int var8 = 0; !flag2 && var8 <= 2; ++var8) {
            if (var8 > 0) {
                m.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bS();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (int var9 = 0; !flag3 && var9 <= 2; ++var9) {
            if (var9 > 0) {
                m.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bS();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (int var10 = 0; !flag4 && var10 <= 2; ++var10) {
            if (var10 > 0) {
                m.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bS();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bS() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bF() {
        return this.a().J;
    }

    @Override
    public int bl() {
        return this.a().K;
    }

    @Override
    public String s() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String command) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RemoteControlCommandListener rconConsoleSource, String s2) {
        if (s2.isBlank()) {
            return "";
        }
        rconConsoleSource.e();
        this.h(() -> {
            CommandListenerWrapper wrapper = rconConsoleSource.g();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.aF().a(wrapper, event.getCommand());
        });
        return rconConsoleSource.f();
    }

    @Override
    public void x() {
        this.C().b();
        super.x();
    }

    @Override
    public boolean a(NameAndId nameAndId) {
        return false;
    }

    @Override
    public int c(int trackingDistance) {
        return this.bG() * trackingDistance / 100;
    }

    public int bG() {
        return this.a().Y.get();
    }

    public void j(int entityBroadcastRangePercentage) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.Y.a(this.bc(), entityBroadcastRangePercentage));
    }

    @Override
    public String j() {
        return this.g.f();
    }

    @Override
    public boolean aZ() {
        return this.t.a().T;
    }

    @Override
    public ITextFilter a(EntityPlayer player) {
        return this.v != null ? this.v.a(player.gI()) : ITextFilter.e;
    }

    @Override
    public @Nullable EnumGamemode bf() {
        return this.bH() ? this.k.j() : null;
    }

    public boolean bH() {
        return this.t.a().k.get();
    }

    public void m(boolean forceGameMode) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.k.a(this.bc(), forceGameMode));
        this.b(this.bf());
    }

    public EnumGamemode bI() {
        return this.a().n.get();
    }

    public void c(EnumGamemode gameMode) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.n.a(this.bc(), gameMode));
        this.k.a(this.bI());
        this.b(this.bf());
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> ac() {
        return this.t.a().ab;
    }

    @Override
    public void aU() {
        super.aU();
        this.x = this.bw().a(DebugSubscriptions.a);
    }

    @Override
    public SampleLogger f() {
        return this.w;
    }

    @Override
    public boolean g() {
        return this.x;
    }

    @Override
    public boolean bq() {
        return this.t.a().ak.get();
    }

    public void n(boolean acceptsTransfers) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ak.a(this.bc(), acceptsTransfers));
    }

    @Override
    public ServerLinks bt() {
        return this.y;
    }

    @Override
    public int bu() {
        return this.t.a().ai.get();
    }

    public void k(int pauseWhenEmptySeconds) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ai.a(this.bc(), pauseWhenEmptySeconds));
    }

    private static ServerLinks a(DedicatedServerSettings settings) {
        Optional<URI> optional = DedicatedServer.a(settings.a());
        return optional.map(uri -> new ServerLinks(List.of(ServerLinks.KnownLinkType.a.a((URI)uri)))).orElse(ServerLinks.a);
    }

    private static Optional<URI> a(DedicatedServerProperties properties) {
        String string = properties.j;
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SystemUtils.a(string));
        }
        catch (Exception var3) {
            m.warn("Failed to parse bug link {}", (Object)string, (Object)var3);
            return Optional.empty();
        }
    }

    @Override
    public Map<String, String> ab() {
        return this.z;
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

