/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.world.level.gamerules.GameRules;
import org.slf4j.Logger;

public class ThreadWatchdog
implements Runnable {
    private static final Logger a = LogUtils.getLogger();
    private static final long b = 10000L;
    private static final int c = 1;
    private final DedicatedServer d;
    private final long e;

    public ThreadWatchdog(DedicatedServer server) {
        this.d = server;
        this.e = server.bF() * TimeRange.b;
    }

    @Override
    public void run() {
        while (this.d.z()) {
            long nextTickTime = this.d.az();
            long nanos = SystemUtils.d();
            long l2 = nanos - nextTickTime;
            if (l2 > this.e) {
                a.error(LogUtils.FATAL_MARKER, "A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)l2 / (float)TimeRange.a)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(this.d.aR().g() / (float)TimeRange.c)));
                a.error(LogUtils.FATAL_MARKER, "Considering it to be crashed, server will forcibly shutdown.");
                CrashReport crashReport = ThreadWatchdog.a("Watching Server", this.d.aw().threadId());
                this.d.b(crashReport.f());
                CrashReportSystemDetails crashReportCategory = crashReport.a("Performance stats");
                crashReportCategory.a("Random tick rate", () -> this.d.bb().n().b(GameRules.O));
                crashReportCategory.a("Level stats", () -> Streams.stream(this.d.P()).map(level -> String.valueOf(level.aq().a()) + ": " + level.L()).collect(Collectors.joining(",\n")));
                DispenserRegistry.a("Crash report:\n" + crashReport.a(ReportType.a));
                Path path = this.d.G().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
                if (crashReport.a(path, ReportType.a)) {
                    a.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
                } else {
                    a.error("We were unable to save this crash report to disk.");
                }
                this.a();
            }
            try {
                Thread.sleep((nextTickTime + this.e - nanos) / TimeRange.b);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static CrashReport a(String title, long threadId) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        StringBuilder stringBuilder = new StringBuilder();
        Error error = new Error("Watchdog");
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo.getThreadId() == threadId) {
                error.setStackTrace(threadInfo.getStackTrace());
            }
            stringBuilder.append(threadInfo);
            stringBuilder.append("\n");
        }
        CrashReport crashReport = new CrashReport(title, error);
        CrashReportSystemDetails crashReportCategory = crashReport.a("Thread Dump");
        crashReportCategory.a("Threads", stringBuilder);
        return crashReport;
    }

    private void a() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(this){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable var2) {
            Runtime.getRuntime().halt(1);
        }
    }
}

