/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;

public final class NumberRangeInput
extends Record
implements InputControl {
    private final int c;
    private final IChatBaseComponent d;
    private final String e;
    private final a f;
    public static final MapCodec<NumberRangeInput> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Dialog.b.optionalFieldOf("width", (Object)200).forGetter(NumberRangeInput::b), (App)ComponentSerialization.a.fieldOf("label").forGetter(NumberRangeInput::c), (App)Codec.STRING.optionalFieldOf("label_format", (Object)"options.generic_value").forGetter(NumberRangeInput::d), (App)net.minecraft.server.dialog.input.NumberRangeInput$a.a.forGetter(NumberRangeInput::e)).apply((Applicative)instance, NumberRangeInput::new));

    public NumberRangeInput(int width, IChatBaseComponent label, String labelFormat, a rangeInfo) {
        this.c = width;
        this.d = label;
        this.e = labelFormat;
        this.f = rangeInfo;
    }

    public MapCodec<NumberRangeInput> a() {
        return a;
    }

    public IChatBaseComponent a(String value) {
        return IChatBaseComponent.a(this.e, this.d, value);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NumberRangeInput.class, "width;label;labelFormat;rangeInfo", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NumberRangeInput.class, "width;label;labelFormat;rangeInfo", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NumberRangeInput.class, "width;label;labelFormat;rangeInfo", "c", "d", "e", "f"}, this, o2);
    }

    public int b() {
        return this.c;
    }

    public IChatBaseComponent c() {
        return this.d;
    }

    public String d() {
        return this.e;
    }

    public a e() {
        return this.f;
    }

    public record a(float b, float c, Optional<Float> d, Optional<Float> e) {
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("start").forGetter(a::b), (App)Codec.FLOAT.fieldOf("end").forGetter(a::c), (App)Codec.FLOAT.optionalFieldOf("initial").forGetter(a::d), (App)ExtraCodecs.v.optionalFieldOf("step").forGetter(a::e)).apply((Applicative)instance, a::new)).validate(rangeInfo -> {
            if (rangeInfo.d.isPresent()) {
                double d2 = rangeInfo.d.get().floatValue();
                double d1 = Math.min(rangeInfo.b, rangeInfo.c);
                double d22 = Math.max(rangeInfo.b, rangeInfo.c);
                if (d2 < d1 || d2 > d22) {
                    return DataResult.error(() -> "Initial value " + d2 + " is outside of range [" + d1 + ", " + d22 + "]");
                }
            }
            return DataResult.success((Object)rangeInfo);
        });

        public float a(float value) {
            float f3;
            int rounded;
            float f2 = MathHelper.h(value, this.b, this.c);
            if (this.e.isEmpty()) {
                return f2;
            }
            float f1 = this.e.get().floatValue();
            float f22 = this.f();
            float f4 = f22 + (float)(rounded = Math.round((f3 = f2 - f22) / f1)) * f1;
            if (!this.b(f4)) {
                return f4;
            }
            int i2 = rounded - MathHelper.m(rounded);
            return f22 + (float)i2 * f1;
        }

        private boolean b(float value) {
            float f2 = this.c(value);
            return (double)f2 < 0.0 || (double)f2 > 1.0;
        }

        private float f() {
            return this.d.isPresent() ? this.d.get().floatValue() : (this.b + this.c) / 2.0f;
        }

        public float a() {
            float f2 = this.f();
            return this.c(f2);
        }

        private float c(float value) {
            return this.b == this.c ? 0.5f : MathHelper.f(value, this.b, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "start;end;initial;step", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "start;end;initial;step", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "start;end;initial;step", "b", "c", "d", "e"}, this, o2);
        }
    }
}

