/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.TimeRange;
import org.bukkit.Bukkit;
import org.jspecify.annotations.Nullable;

public class GuiStatsComponent
extends JComponent {
    private static final DecimalFormat a = new DecimalFormat("########0.000", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private final int[] b = new int[256];
    private int c;
    private final @Nullable String[] d = new String[11];
    private final MinecraftServer e;
    private final Timer f;

    public GuiStatsComponent(MinecraftServer server) {
        this.e = server;
        this.setPreferredSize(new Dimension(456, 246));
        this.setMinimumSize(new Dimension(456, 246));
        this.setMaximumSize(new Dimension(456, 246));
        this.f = new Timer(500, actionEvent -> this.b());
        this.f.start();
        this.setBackground(Color.BLACK);
    }

    private void b() {
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        double[] tps = Bukkit.getTPS();
        CharSequence[] tpsAvg = new String[tps.length];
        for (int g2 = 0; g2 < tps.length; ++g2) {
            tpsAvg[g2] = GuiStatsComponent.format(tps[g2]);
        }
        this.d[0] = "Memory use: " + l2 / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.d[1] = "Avg tick: " + a.format((double)this.e.aS() / (double)TimeRange.b) + " ms";
        this.d[2] = "TPS from last 1m, 5m, 15m: " + String.join((CharSequence)", ", tpsAvg);
        this.b[this.c++ & 0xFF] = (int)(l2 * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int i2;
        graphics.setColor(new Color(0xFFFFFF));
        graphics.fillRect(0, 0, 456, 246);
        for (i2 = 0; i2 < 256; ++i2) {
            int i1 = this.b[i2 + this.c & 0xFF];
            graphics.setColor(new Color(i1 + 28 << 16));
            graphics.fillRect(i2, 100 - i1, 1, i1);
        }
        graphics.setColor(Color.BLACK);
        for (i2 = 0; i2 < this.d.length; ++i2) {
            String string = this.d[i2];
            if (string == null) continue;
            graphics.drawString(string, 32, 116 + i2 * 16);
        }
    }

    public void a() {
        this.f.stop();
    }

    private static String format(double tps) {
        return (tps > 21.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }
}

