/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.IncomingRpcMethod;
import net.minecraft.server.jsonrpc.JsonRPCErrors;
import net.minecraft.server.jsonrpc.JsonRPCUtils;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.OutgoingRpcMethod;
import net.minecraft.server.jsonrpc.PendingRpcRequest;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidRequestJsonRpcException;
import net.minecraft.server.jsonrpc.methods.MethodNotFoundJsonRpcException;
import net.minecraft.server.jsonrpc.methods.RemoteRpcErrorException;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.SystemUtils;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Connection
extends SimpleChannelInboundHandler<JsonElement> {
    private static final Logger a = LogUtils.getLogger();
    private static final AtomicInteger b = new AtomicInteger(0);
    private final JsonRpcLogger c;
    private final ClientInfo d;
    private final ManagementServer e;
    private final Channel f;
    private final MinecraftApi g;
    private final AtomicInteger h = new AtomicInteger();
    private final Int2ObjectMap<PendingRpcRequest<?>> i = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());

    public Connection(Channel channel, ManagementServer managementServer, MinecraftApi minecraftApi, JsonRpcLogger jsonRpcLogger) {
        this.d = ClientInfo.a(b.incrementAndGet());
        this.e = managementServer;
        this.g = minecraftApi;
        this.f = channel;
        this.c = jsonRpcLogger;
    }

    public void a() {
        long millis = SystemUtils.c();
        this.i.int2ObjectEntrySet().removeIf(entry -> {
            boolean flag = ((PendingRpcRequest)entry.getValue()).a(millis);
            if (flag) {
                ((PendingRpcRequest)entry.getValue()).b().completeExceptionally((Throwable)new ReadTimeoutException("RPC method " + String.valueOf(((PendingRpcRequest)entry.getValue()).a().h().a()) + " timed out waiting for response"));
            }
            return flag;
        });
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.c.a(this.d, "Management connection opened for {}", this.f.remoteAddress());
        super.channelActive(ctx);
        this.e.a(this);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.c.a(this.d, "Management connection closed for {}", this.f.remoteAddress());
        super.channelInactive(ctx);
        this.e.b(this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable exception) throws Exception {
        if (exception.getCause() instanceof JsonParseException) {
            this.f.writeAndFlush((Object)JsonRPCErrors.a.a(exception.getMessage()));
        } else {
            super.exceptionCaught(ctx, exception);
            this.f.close().awaitUninterruptibly();
        }
    }

    protected void a(ChannelHandlerContext ctx, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject jsonObject = this.a(element.getAsJsonObject());
            if (jsonObject != null) {
                this.f.writeAndFlush((Object)jsonObject);
            }
        } else if (element.isJsonArray()) {
            this.f.writeAndFlush((Object)this.a(element.getAsJsonArray().asList()));
        } else {
            this.f.writeAndFlush((Object)JsonRPCErrors.b.a((String)null));
        }
    }

    private JsonArray a(List<JsonElement> requests) {
        JsonArray jsonArray = new JsonArray();
        requests.stream().map(jsonElement -> this.a(jsonElement.getAsJsonObject())).filter(Objects::nonNull).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }

    public void a(Holder.c<? extends OutgoingRpcMethod<Void, ?>> method) {
        this.a(method, null, false);
    }

    public <Params> void a(Holder.c<? extends OutgoingRpcMethod<Params, ?>> method, Params params) {
        this.a(method, params, false);
    }

    public <Result> CompletableFuture<Result> b(Holder.c<? extends OutgoingRpcMethod<Void, Result>> method) {
        return this.a(method, null, true);
    }

    public <Params, Result> CompletableFuture<Result> b(Holder.c<? extends OutgoingRpcMethod<Params, Result>> method, Params params) {
        return this.a(method, params, true);
    }

    @Contract(value="_,_,false->null;_,_,true->!null")
    private <Params, Result> @Nullable CompletableFuture<Result> a(Holder.c<? extends OutgoingRpcMethod<Params, ? extends Result>> method, @Nullable Params params, boolean expectResponse) {
        List<JsonElement> list;
        List<JsonElement> list2 = list = params != null ? List.of(Objects.requireNonNull(method.a().a(params))) : List.of();
        if (expectResponse) {
            CompletableFuture completableFuture = new CompletableFuture();
            int i2 = this.h.incrementAndGet();
            long l2 = SystemUtils.c.get(TimeUnit.MILLISECONDS);
            this.i.put(i2, new PendingRpcRequest(method, completableFuture, l2 + 5000L));
            this.f.writeAndFlush((Object)JsonRPCUtils.a(i2, method.h().a(), list));
            return completableFuture;
        }
        this.f.writeAndFlush((Object)JsonRPCUtils.a(null, method.h().a(), list));
        return null;
    }

    @VisibleForTesting
    @Nullable JsonObject a(JsonObject json) {
        try {
            JsonElement requestId = JsonRPCUtils.a(json);
            String methodName = JsonRPCUtils.b(json);
            JsonElement result = JsonRPCUtils.d(json);
            JsonElement params = JsonRPCUtils.c(json);
            JsonObject error = JsonRPCUtils.e(json);
            if (methodName != null && result == null && error == null) {
                return requestId != null && !Connection.a(requestId) ? JsonRPCErrors.b.a("Invalid request id - only String, Number and NULL supported") : this.a(requestId, methodName, params);
            }
            if (methodName == null && result != null && error == null && requestId != null) {
                if (Connection.b(requestId)) {
                    this.a(requestId.getAsInt(), result);
                } else {
                    a.warn("Received respose {} with id {} we did not request", (Object)result, (Object)requestId);
                }
                return null;
            }
            return methodName == null && result == null && error != null ? this.a(requestId, error) : JsonRPCErrors.b.a((JsonElement)Objects.requireNonNullElse(requestId, JsonNull.INSTANCE));
        }
        catch (Exception var7) {
            a.error("Error while handling rpc request", (Throwable)var7);
            return JsonRPCErrors.e.a("Unknown error handling request - check server logs for stack trace");
        }
    }

    private static boolean a(JsonElement requestId) {
        return requestId.isJsonNull() || ChatDeserializer.b(requestId) || ChatDeserializer.a(requestId);
    }

    private static boolean b(JsonElement responseId) {
        return ChatDeserializer.b(responseId);
    }

    private @Nullable JsonObject a(@Nullable JsonElement requestId, String method, @Nullable JsonElement params) {
        boolean flag = requestId != null;
        try {
            JsonElement jsonElement = this.a(method, params);
            return jsonElement != null && flag ? JsonRPCUtils.a(requestId, jsonElement) : null;
        }
        catch (InvalidParameterJsonRpcException var6) {
            a.debug("Invalid parameter invocation {}: {}, {}", new Object[]{method, params, var6.getMessage()});
            return flag ? JsonRPCErrors.d.a(requestId, var6.getMessage()) : null;
        }
        catch (EncodeJsonRpcException var7) {
            a.error("Failed to encode json rpc response {}: {}", (Object)method, (Object)var7.getMessage());
            return flag ? JsonRPCErrors.e.a(requestId, var7.getMessage()) : null;
        }
        catch (InvalidRequestJsonRpcException var8) {
            return flag ? JsonRPCErrors.b.a(requestId, var8.getMessage()) : null;
        }
        catch (MethodNotFoundJsonRpcException var9) {
            return flag ? JsonRPCErrors.c.a(requestId, var9.getMessage()) : null;
        }
        catch (Exception var10) {
            a.error("Error while dispatching rpc method {}", (Object)method, (Object)var10);
            return flag ? JsonRPCErrors.e.a(requestId) : null;
        }
    }

    public @Nullable JsonElement a(String method, @Nullable JsonElement requestId) {
        MinecraftKey identifier = MinecraftKey.c(method);
        if (identifier == null) {
            throw new InvalidRequestJsonRpcException("Failed to parse method value: " + method);
        }
        Optional<IncomingRpcMethod<?, ?>> optional = BuiltInRegistries.aC.b(identifier);
        if (optional.isEmpty()) {
            throw new MethodNotFoundJsonRpcException("Method not found: " + method);
        }
        if (optional.get().b().a()) {
            try {
                return this.g.a(() -> ((IncomingRpcMethod)optional.get()).a(this.g, requestId, this.d)).join();
            }
            catch (CompletionException var8) {
                Throwable throwable = var8.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw var8;
            }
        }
        return optional.get().a(this.g, requestId, this.d);
    }

    private void a(int id, JsonElement result) {
        PendingRpcRequest pendingRpcRequest = (PendingRpcRequest)this.i.remove(id);
        if (pendingRpcRequest == null) {
            a.warn("Received unknown response (id: {}): {}", (Object)id, (Object)result);
        } else {
            pendingRpcRequest.a(result);
        }
    }

    private @Nullable JsonObject a(@Nullable JsonElement requestId, JsonObject error) {
        PendingRpcRequest pendingRpcRequest;
        if (requestId != null && Connection.b(requestId) && (pendingRpcRequest = (PendingRpcRequest)this.i.remove(requestId.getAsInt())) != null) {
            pendingRpcRequest.b().completeExceptionally(new RemoteRpcErrorException(requestId, error));
        }
        a.error("Received error (id: {}): {}", (Object)requestId, (Object)error);
        return null;
    }
}

