/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import org.jspecify.annotations.Nullable;

public interface IncomingRpcMethod<Params, Result> {
    public MethodInfo<Params, Result> a();

    public a b();

    public JsonElement a(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> b<Void, Result> a(e<Result> parameterlessFunction) {
        return new b(parameterlessFunction);
    }

    public static <Params, Result> b<Params, Result> a(f<Params, Result> parameterFunction) {
        return new b<Params, Result>(parameterFunction);
    }

    public static <Result> b<Void, Result> a(Function<MinecraftApi, Result> parameterlessFunction) {
        return new b(parameterlessFunction);
    }

    public static class b<Params, Result> {
        private String a = "";
        private @Nullable ParamInfo<Params> b;
        private @Nullable ResultInfo<Result> c;
        private boolean d = true;
        private boolean e = true;
        private @Nullable e<Result> f;
        private @Nullable f<Params, Result> g;

        public b(e<Result> parameterlessFunction) {
            this.f = parameterlessFunction;
        }

        public b(f<Params, Result> parameterFunction) {
            this.g = parameterFunction;
        }

        public b(Function<MinecraftApi, Result> parameterlessFunction) {
            this.f = (api, client) -> parameterlessFunction.apply(api);
        }

        public b<Params, Result> a(String description) {
            this.a = description;
            return this;
        }

        public b<Params, Result> a(String name, Schema<Result> schema) {
            this.c = new ResultInfo<Result>(name, schema.b());
            return this;
        }

        public b<Params, Result> b(String name, Schema<Params> schema) {
            this.b = new ParamInfo<Params>(name, schema.b());
            return this;
        }

        public b<Params, Result> a() {
            this.d = false;
            return this;
        }

        public b<Params, Result> b() {
            this.e = false;
            return this;
        }

        public IncomingRpcMethod<Params, Result> c() {
            if (this.c == null) {
                throw new IllegalStateException("No response defined");
            }
            a attributes = new a(this.e, this.d);
            MethodInfo<Params, Result> methodInfo = new MethodInfo<Params, Result>(this.a, this.b, this.c);
            if (this.f != null) {
                return new d<Params, Result>(methodInfo, attributes, this.f);
            }
            if (this.g != null) {
                if (this.b == null) {
                    throw new IllegalStateException("No param schema defined");
                }
                return new c<Params, Result>(methodInfo, attributes, this.g);
            }
            throw new IllegalStateException("No method defined");
        }

        public IncomingRpcMethod<?, ?> a(IRegistry<IncomingRpcMethod<?, ?>> registry, String namespace) {
            return this.a(registry, MinecraftKey.b(namespace));
        }

        private IncomingRpcMethod<?, ?> a(IRegistry<IncomingRpcMethod<?, ?>> registry, MinecraftKey id) {
            return IRegistry.a(registry, id, this.c());
        }
    }

    @FunctionalInterface
    public static interface e<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface f<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record d<Params, Result>(MethodInfo<Params, Result> a, a b, e<Result> c) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement a(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params == null || params.isJsonArray() && params.getAsJsonArray().isEmpty()) {
                if (this.a.b().isPresent()) {
                    throw new IllegalArgumentException("Parameterless method unexpectedly has parameter description");
                }
                Result object = this.c.apply(api, client);
                if (this.a.c().isEmpty()) {
                    throw new IllegalStateException("No result codec defined");
                }
                return (JsonElement)this.a.c().get().c().j().encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(InvalidParameterJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "info;attributes;supplier", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "info;attributes;supplier", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "info;attributes;supplier", "a", "b", "c"}, this, o2);
        }
    }

    public record c<Params, Result>(MethodInfo<Params, Result> a, a b, f<Params, Result> c) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement a(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params != null && (params.isJsonArray() || params.isJsonObject())) {
                JsonElement jsonElement1;
                if (this.a.b().isEmpty()) {
                    throw new IllegalArgumentException("Method defined as having parameters without describing them");
                }
                if (params.isJsonObject()) {
                    String string = this.a.b().get().b();
                    JsonElement jsonElement = params.getAsJsonObject().get(string);
                    if (jsonElement == null) {
                        throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", string));
                    }
                    jsonElement1 = jsonElement;
                } else {
                    JsonArray asJsonArray = params.getAsJsonArray();
                    if (asJsonArray.isEmpty() || asJsonArray.size() > 1) {
                        throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                    }
                    jsonElement1 = asJsonArray.get(0);
                }
                Object orThrow = this.a.b().get().c().j().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement1).getOrThrow(InvalidParameterJsonRpcException::new);
                Result object = this.c.apply(api, orThrow, client);
                if (this.a.c().isEmpty()) {
                    throw new IllegalStateException("No result codec defined");
                }
                return (JsonElement)this.a.c().get().c().j().encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(EncodeJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected params as array or named");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "info;attributes;function", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "info;attributes;function", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "info;attributes;function", "a", "b", "c"}, this, o2);
        }
    }

    public record a(boolean a, boolean b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this, o2);
        }
    }
}

