/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import org.jspecify.annotations.Nullable;

public class JsonRPCUtils {
    public static final String a = "2.0";
    public static final String b = "1.3.2";

    public static JsonObject a(JsonElement requestId, JsonElement result) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jsonrpc", a);
        jsonObject.add("id", requestId);
        jsonObject.add("result", result);
        return jsonObject;
    }

    public static JsonObject a(@Nullable Integer requestId, MinecraftKey method, List<JsonElement> params) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jsonrpc", a);
        if (requestId != null) {
            jsonObject.addProperty("id", (Number)requestId);
        }
        jsonObject.addProperty("method", method.toString());
        if (!params.isEmpty()) {
            JsonArray jsonArray = new JsonArray(params.size());
            for (JsonElement jsonElement : params) {
                jsonArray.add(jsonElement);
            }
            jsonObject.add("params", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public static JsonObject a(JsonElement requestId, String message, int code, @Nullable String data) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jsonrpc", a);
        jsonObject.add("id", requestId);
        JsonObject jsonObject1 = new JsonObject();
        jsonObject1.addProperty("code", (Number)code);
        jsonObject1.addProperty("message", message);
        if (data != null && !data.isBlank()) {
            jsonObject1.addProperty("data", data);
        }
        jsonObject.add("error", (JsonElement)jsonObject1);
        return jsonObject;
    }

    public static @Nullable JsonElement a(JsonObject json) {
        return json.get("id");
    }

    public static @Nullable String b(JsonObject json) {
        return ChatDeserializer.a(json, "method", null);
    }

    public static @Nullable JsonElement c(JsonObject json) {
        return json.get("params");
    }

    public static @Nullable JsonElement d(JsonObject json) {
        return json.get("result");
    }

    public static @Nullable JsonObject e(JsonObject json) {
        return ChatDeserializer.a(json, "error", null);
    }
}

