/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.server.jsonrpc.Connection;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.security.AuthenticationHandler;
import net.minecraft.server.jsonrpc.websocket.JsonToWebSocketEncoder;
import net.minecraft.server.jsonrpc.websocket.WebSocketToJsonCodec;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ManagementServer {
    private static final Logger a = LogUtils.getLogger();
    private final HostAndPort b;
    final AuthenticationHandler c;
    private @Nullable Channel d;
    private final NioEventLoopGroup e;
    private final Set<Connection> f = Sets.newIdentityHashSet();

    public ManagementServer(HostAndPort hostAndPort, AuthenticationHandler authenticationHandler) {
        this.b = hostAndPort;
        this.c = authenticationHandler;
        this.e = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Management server IO #%d").setDaemon(true).build());
    }

    public ManagementServer(HostAndPort hostAndPort, AuthenticationHandler authenticationHandler, NioEventLoopGroup nioEventLoopGroup) {
        this.b = hostAndPort;
        this.c = authenticationHandler;
        this.e = nioEventLoopGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Connection connection) {
        Set<Connection> set = this.f;
        synchronized (set) {
            this.f.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b(Connection connection) {
        Set<Connection> set = this.f;
        synchronized (set) {
            this.f.remove((Object)connection);
        }
    }

    public void a(MinecraftApi api) {
        this.b(api, null);
    }

    public void a(MinecraftApi api, SslContext context) {
        this.b(api, context);
    }

    private void b(final MinecraftApi api, final @Nullable SslContext context) {
        final JsonRpcLogger jsonRpcLogger = new JsonRpcLogger();
        ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelPipeline = channel.pipeline();
                if (context != null) {
                    channelPipeline.addLast(new ChannelHandler[]{context.newHandler(channel.alloc())});
                }
                channelPipeline.addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{ManagementServer.this.c}).addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/")}).addLast(new ChannelHandler[]{new WebSocketToJsonCodec()}).addLast(new ChannelHandler[]{new JsonToWebSocketEncoder()}).addLast(new ChannelHandler[]{new Connection(channel, ManagementServer.this, api, jsonRpcLogger)});
            }
        }).group((EventLoopGroup)this.e).localAddress(this.b.getHost(), this.b.getPort())).bind();
        this.d = channelFuture.channel();
        channelFuture.syncUninterruptibly();
        a.info("Json-RPC Management connection listening on {}:{}", (Object)this.b.getHost(), (Object)this.b());
    }

    public void a(boolean shutdownThreads) throws InterruptedException {
        if (this.d != null) {
            this.d.close().sync();
            this.d = null;
        }
        this.f.clear();
        if (shutdownThreads) {
            this.e.shutdownGracefully().sync();
        }
    }

    public void a() {
        this.a(Connection::a);
    }

    public int b() {
        return this.d != null ? ((InetSocketAddress)this.d.localAddress()).getPort() : this.b.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(Consumer<Connection> action) {
        Set<Connection> set = this.f;
        synchronized (set) {
            this.f.forEach(action);
        }
    }
}

