/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.api.ReferenceUtil;
import net.minecraft.server.jsonrpc.api.SchemaComponent;
import net.minecraft.server.jsonrpc.methods.BanlistService;
import net.minecraft.server.jsonrpc.methods.DiscoveryService;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.IpBanlistService;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.jsonrpc.methods.OperatorService;
import net.minecraft.server.jsonrpc.methods.PlayerService;
import net.minecraft.server.jsonrpc.methods.ServerStateService;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.gamerules.GameRuleType;

public final class Schema<T>
extends Record {
    private final Optional<URI> y;
    private final List<String> z;
    private final Optional<Schema<?>> A;
    private final Map<String, Schema<?>> B;
    private final List<String> C;
    private final Codec<T> D;
    public static final Codec<? extends Schema<?>> a = Codec.recursive((String)"Schema", codec -> RecordCodecBuilder.create(instance -> instance.group((App)ReferenceUtil.a.optionalFieldOf("$ref").forGetter(Schema::e), (App)ExtraCodecs.a(Codec.STRING).optionalFieldOf("type", List.of()).forGetter(Schema::f), (App)codec.optionalFieldOf("items").forGetter(Schema::g), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)codec).optionalFieldOf("properties", Map.of()).forGetter(Schema::h), (App)Codec.STRING.listOf().optionalFieldOf("enum", List.of()).forGetter(Schema::i)).apply((Applicative)instance, (optional, list, optional1, map, list1) -> null))).validate(schema -> schema == null ? DataResult.error(() -> "Should not deserialize schema") : DataResult.success((Object)schema));
    private static final List<SchemaComponent<?>> E = new ArrayList();
    public static final Schema<Boolean> b = Schema.a("boolean", Codec.BOOL);
    public static final Schema<Integer> c = Schema.a("integer", Codec.INT);
    public static final Schema<Either<Boolean, Integer>> d = Schema.a(List.of("boolean", "integer"), Codec.either((Codec)Codec.BOOL, (Codec)Codec.INT));
    public static final Schema<Float> e = Schema.a("number", Codec.FLOAT);
    public static final Schema<String> f = Schema.a("string", Codec.STRING);
    public static final Schema<UUID> g = Schema.a("string", UUIDUtil.a);
    public static final Schema<DiscoveryService.c> h = Schema.a("string", DiscoveryService.c.a.codec());
    public static final SchemaComponent<EnumDifficulty> i = Schema.b("difficulty", Schema.a(EnumDifficulty::values, EnumDifficulty.e));
    public static final SchemaComponent<EnumGamemode> j = Schema.b("game_type", Schema.a(EnumGamemode::values, EnumGamemode.f));
    public static final Schema<PermissionLevel> k = Schema.a("integer", PermissionLevel.g);
    public static final SchemaComponent<PlayerDto> l = Schema.b("player", Schema.a(PlayerDto.a.codec()).a("id", g).a("name", f));
    public static final SchemaComponent<DiscoveryService.b> m = Schema.b("version", Schema.a(DiscoveryService.b.a.codec()).a("name", f).a("protocol", c));
    public static final SchemaComponent<ServerStateService.a> n = Schema.b("server_state", Schema.a(ServerStateService.a.a).a("started", b).a("players", l.a().d()).a("version", m.a()));
    public static final Schema<GameRuleType> o = Schema.a(GameRuleType::values);
    public static final SchemaComponent<GameRulesService.a<?>> p = Schema.b("typed_game_rule", Schema.a(GameRulesService.a.a).a("key", f).a("value", d).a("type", o));
    public static final SchemaComponent<GameRulesService.a<?>> q = Schema.b("untyped_game_rule", Schema.a(GameRulesService.a.b).a("key", f).a("value", d));
    public static final SchemaComponent<Message> r = Schema.b("message", Schema.a(Message.a).a("literal", f).a("translatable", f).a("translatableParams", f.d()));
    public static final SchemaComponent<ServerStateService.b> s = Schema.b("system_message", Schema.a(ServerStateService.b.a).a("message", r.a()).a("overlay", b).a("receivingPlayers", l.a().d()));
    public static final SchemaComponent<PlayerService.a> t = Schema.b("kick_player", Schema.a(PlayerService.a.a.codec()).a("message", r.a()).a("player", l.a()));
    public static final SchemaComponent<OperatorService.b> u = Schema.b("operator", Schema.a(OperatorService.b.a.codec()).a("player", l.a()).a("bypassesPlayerLimit", b).a("permissionLevel", c));
    public static final SchemaComponent<IpBanlistService.a> v = Schema.b("incoming_ip_ban", Schema.a(IpBanlistService.a.a.codec()).a("player", l.a()).a("ip", f).a("reason", f).a("source", f).a("expires", f));
    public static final SchemaComponent<IpBanlistService.c> w = Schema.b("ip_ban", Schema.a(IpBanlistService.c.a.codec()).a("ip", f).a("reason", f).a("source", f).a("expires", f));
    public static final SchemaComponent<BanlistService.b> x = Schema.b("user_ban", Schema.a(BanlistService.b.a.codec()).a("player", l.a()).a("reason", f).a("source", f).a("expires", f));

    public Schema(Optional<URI> reference, List<String> type, Optional<Schema<?>> items, Map<String, Schema<?>> properties, List<String> enumValues, Codec<T> codec) {
        this.y = reference;
        this.z = type;
        this.A = items;
        this.B = properties;
        this.C = enumValues;
        this.D = codec;
    }

    public static <T> Codec<Schema<T>> a() {
        return a;
    }

    public Schema<T> b() {
        return new Schema<T>(this.y, this.z, this.A.map(Schema::b), this.B.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Schema)entry.getValue()).b())), this.C, this.D);
    }

    private static <T> SchemaComponent<T> b(String reference, Schema<T> schema) {
        SchemaComponent<T> schemaComponent = new SchemaComponent<T>(reference, ReferenceUtil.a(reference), schema);
        E.add(schemaComponent);
        return schemaComponent;
    }

    public static List<SchemaComponent<?>> c() {
        return E;
    }

    public static <T> Schema<T> a(URI reference, Codec<T> codec) {
        return new Schema<T>(Optional.of(reference), List.of(), Optional.empty(), Map.of(), List.of(), codec);
    }

    public static <T> Schema<T> a(String type, Codec<T> codec) {
        return Schema.a(List.of(type), codec);
    }

    public static <T> Schema<T> a(List<String> types, Codec<T> codec) {
        return new Schema<T>(Optional.empty(), types, Optional.empty(), Map.of(), List.of(), codec);
    }

    public static <E extends Enum<E>> Schema<E> a(Supplier<E[]> valuesGetter) {
        return Schema.a(valuesGetter, INamable.a(valuesGetter));
    }

    public static <E extends Enum<E>> Schema<E> a(Supplier<E[]> valuesGetter, Codec<E> codec) {
        List<String> list = Stream.of((Enum[])valuesGetter.get()).map(object -> ((INamable)((Object)object)).c()).toList();
        return Schema.b(list, codec);
    }

    public static <T> Schema<T> b(List<String> values, Codec<T> codec) {
        return new Schema<T>(Optional.empty(), List.of("string"), Optional.empty(), Map.of(), values, codec);
    }

    public static <T> Schema<List<T>> a(Schema<?> items, Codec<T> codec) {
        return new Schema<List<T>>(Optional.empty(), List.of("array"), Optional.of(items), Map.of(), List.of(), codec.listOf());
    }

    public static <T> Schema<T> a(Codec<T> codec) {
        return new Schema<T>(Optional.empty(), List.of("object"), Optional.empty(), Map.of(), List.of(), codec);
    }

    private static <T> Schema<T> a(Map<String, Schema<?>> fields, Codec<T> codec) {
        return new Schema<T>(Optional.empty(), List.of("object"), Optional.empty(), fields, List.of(), codec);
    }

    public Schema<T> a(String name, Schema<?> schema) {
        HashMap map = new HashMap(this.B);
        map.put(name, schema);
        return Schema.a(map, this.D);
    }

    public Schema<List<T>> d() {
        return Schema.a(this, this.D);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Schema.class, "reference;type;items;properties;enumValues;codec", "y", "z", "A", "B", "C", "D"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Schema.class, "reference;type;items;properties;enumValues;codec", "y", "z", "A", "B", "C", "D"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Schema.class, "reference;type;items;properties;enumValues;codec", "y", "z", "A", "B", "C", "D"}, this, o2);
    }

    public Optional<URI> e() {
        return this.y;
    }

    public List<String> f() {
        return this.z;
    }

    public Optional<Schema<?>> g() {
        return this.A;
    }

    public Map<String, Schema<?>> h() {
        return this.B;
    }

    public List<String> i() {
        return this.C;
    }

    public Codec<T> j() {
        return this.D;
    }
}

