/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftAllowListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftAllowListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftBanListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftBanListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftExecutorService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftExecutorServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftOperatorListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftOperatorListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftPlayerListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftPlayerListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerSettingsService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerSettingsServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerStateService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerStateServiceImpl;
import net.minecraft.server.notifications.NotificationManager;

public class MinecraftApi {
    private final NotificationManager a;
    private final MinecraftAllowListService b;
    private final MinecraftBanListService c;
    private final MinecraftPlayerListService d;
    private final MinecraftGameRuleService e;
    private final MinecraftOperatorListService f;
    private final MinecraftServerSettingsService g;
    private final MinecraftServerStateService h;
    private final MinecraftExecutorService i;

    public MinecraftApi(NotificationManager notificationManager, MinecraftAllowListService allowListService, MinecraftBanListService banListService, MinecraftPlayerListService minecraftPlayerListService, MinecraftGameRuleService gameRuleService, MinecraftOperatorListService minecraftOperatorListService, MinecraftServerSettingsService minecraftServerSettingsService, MinecraftServerStateService minecraftServerStateService, MinecraftExecutorService executorService) {
        this.a = notificationManager;
        this.b = allowListService;
        this.c = banListService;
        this.d = minecraftPlayerListService;
        this.e = gameRuleService;
        this.f = minecraftOperatorListService;
        this.g = minecraftServerSettingsService;
        this.h = minecraftServerStateService;
        this.i = executorService;
    }

    public <V> CompletableFuture<V> a(Supplier<V> supplier) {
        return this.i.a(supplier);
    }

    public CompletableFuture<Void> a(Runnable task) {
        return this.i.a(task);
    }

    public MinecraftAllowListService a() {
        return this.b;
    }

    public MinecraftBanListService b() {
        return this.c;
    }

    public MinecraftPlayerListService c() {
        return this.d;
    }

    public MinecraftGameRuleService d() {
        return this.e;
    }

    public MinecraftOperatorListService e() {
        return this.f;
    }

    public MinecraftServerSettingsService f() {
        return this.g;
    }

    public MinecraftServerStateService g() {
        return this.h;
    }

    public NotificationManager h() {
        return this.a;
    }

    public static MinecraftApi a(DedicatedServer server) {
        JsonRpcLogger jsonRpcLogger = new JsonRpcLogger();
        MinecraftAllowListServiceImpl minecraftAllowListServiceImpl = new MinecraftAllowListServiceImpl(server, jsonRpcLogger);
        MinecraftBanListServiceImpl minecraftBanListServiceImpl = new MinecraftBanListServiceImpl(server, jsonRpcLogger);
        MinecraftPlayerListServiceImpl minecraftPlayerListServiceImpl = new MinecraftPlayerListServiceImpl(server, jsonRpcLogger);
        MinecraftGameRuleServiceImpl minecraftGameRuleServiceImpl = new MinecraftGameRuleServiceImpl(server, jsonRpcLogger);
        MinecraftOperatorListServiceImpl minecraftOperatorListServiceImpl = new MinecraftOperatorListServiceImpl(server, jsonRpcLogger);
        MinecraftServerSettingsServiceImpl minecraftServerSettingsServiceImpl = new MinecraftServerSettingsServiceImpl(server, jsonRpcLogger);
        MinecraftServerStateServiceImpl minecraftServerStateServiceImpl = new MinecraftServerStateServiceImpl(server, jsonRpcLogger);
        MinecraftExecutorServiceImpl minecraftExecutorService = new MinecraftExecutorServiceImpl(server);
        return new MinecraftApi(server.C(), minecraftAllowListServiceImpl, minecraftBanListServiceImpl, minecraftPlayerListServiceImpl, minecraftGameRuleServiceImpl, minecraftOperatorListServiceImpl, minecraftServerSettingsServiceImpl, minecraftServerStateServiceImpl, minecraftExecutorService);
    }
}

