/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Set;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelDuplexHandler {
    private final Logger b = LogUtils.getLogger();
    private static final AttributeKey<Boolean> c = AttributeKey.valueOf((String)"authenticated");
    private static final AttributeKey<Boolean> d = AttributeKey.valueOf((String)"websocket_auth_allowed");
    private static final String e = "minecraft-v1";
    private static final String f = "minecraft-v1,";
    public static final String a = "Bearer ";
    private final SecurityConfig g;
    private final Set<String> h;

    public AuthenticationHandler(SecurityConfig securityConfig, String allowedOrigins) {
        this.g = securityConfig;
        this.h = Sets.newHashSet((Object[])allowedOrigins.split(","));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Boolean _boolean;
        String clientIp = this.a(ctx);
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            a securityCheckResult = this.a(httpRequest);
            if (!securityCheckResult.b()) {
                this.b.debug("Authentication rejected for connection with ip {}: {}", (Object)clientIp, (Object)securityCheckResult.c());
                ctx.channel().attr(c).set((Object)false);
                this.a(ctx, securityCheckResult.c());
                return;
            }
            ctx.channel().attr(c).set((Object)true);
            if (securityCheckResult.d()) {
                ctx.channel().attr(d).set((Object)Boolean.TRUE);
            }
        }
        if (Boolean.TRUE.equals(_boolean = (Boolean)ctx.channel().attr(c).get())) {
            super.channelRead(ctx, msg);
        } else {
            this.b.debug("Dropping unauthenticated connection with ip {}", (Object)clientIp);
            ctx.close();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        HttpResponse httpResponse;
        if (msg instanceof HttpResponse && (httpResponse = (HttpResponse)msg).status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && ctx.channel().attr(d).get() != null && ((Boolean)ctx.channel().attr(d).get()).equals(Boolean.TRUE)) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)e);
        }
        super.write(ctx, msg, promise);
    }

    private a a(HttpRequest request) {
        String string = this.c(request);
        if (string != null) {
            return this.a(string) ? net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a() : net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Invalid API key");
        }
        String string1 = this.d(request);
        if (string1 != null) {
            if (!this.b(request)) {
                return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Origin Not Allowed");
            }
            return this.a(string1) ? net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a(true) : net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Invalid API key");
        }
        return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Missing API key");
    }

    private boolean b(HttpRequest request) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        return string != null && !string.isEmpty() && this.h.contains(string);
    }

    private @Nullable String c(HttpRequest request) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        return string != null && string.startsWith(a) ? string.substring(a.length()).trim() : null;
    }

    private @Nullable String d(HttpRequest request) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        return string != null && string.startsWith(f) ? string.substring(f.length()).trim() : null;
    }

    public boolean a(String key) {
        if (key.isEmpty()) {
            return false;
        }
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        byte[] bytes1 = this.g.b().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(bytes, bytes1);
    }

    private String a(ChannelHandlerContext ctx) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetSocketAddress.getAddress().getHostAddress();
    }

    private void a(ChannelHandlerContext ctx, String message) {
        String string = "{\"error\":\"Unauthorized\",\"message\":\"" + message + "\"}";
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])bytes));
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)defaultFullHttpResponse).addListener(future -> ctx.close());
    }

    static class a {
        private final boolean a;
        private final String b;
        private final boolean c;

        private a(boolean allowed, String reason, boolean tokenSentInSecWebsocketProtocol) {
            this.a = allowed;
            this.b = reason;
            this.c = tokenSentInSecWebsocketProtocol;
        }

        public static a a() {
            return new a(true, null, false);
        }

        public static a a(boolean tokenSentInSecWebsocketProtocol) {
            return new a(true, null, tokenSentInSecWebsocketProtocol);
        }

        public static a a(String reason) {
            return new a(false, reason, false);
        }

        public boolean b() {
            return this.a;
        }

        public String c() {
            return this.b;
        }

        public boolean d() {
            return this.c;
        }
    }
}

