/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TriState;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ChunkMapDistance
implements ChunkSystemDistanceManager,
ChunkTickDistanceManager {
    private static final Logger a = LogUtils.getLogger();
    static final int c = ChunkLevel.a(FullChunkStatus.d);
    final Long2ObjectMap<ObjectSet<EntityPlayer>> d = new Long2ObjectOpenHashMap();
    public final TicketStorage g;
    private final PositionCountingAreaMap<EntityPlayer> spawnChunkTracker = new PositionCountingAreaMap();

    protected ChunkMapDistance(TicketStorage ticketStorage, Executor dispatcher, Executor mainThreadExecutor) {
        this.g = ticketStorage;
        TaskScheduler<Runnable> taskScheduler = TaskScheduler.a("player ticket throttler", mainThreadExecutor);
        this.g.moonrise$setChunkMap(this.moonrise$getChunkMap());
    }

    @Override
    public final ChunkHolderManager moonrise$getChunkHolderManager() {
        return this.moonrise$getChunkMap().r.moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Override
    public final void moonrise$addPlayer(EntityPlayer player, SectionPosition pos) {
        this.spawnChunkTracker.add(player, pos.a(), pos.c(), 8);
    }

    @Override
    public final void moonrise$removePlayer(EntityPlayer player, SectionPosition pos) {
        this.spawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(EntityPlayer player, SectionPosition oldPos, SectionPosition newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.a(), newPos.c(), 8);
        }
    }

    @Override
    public final boolean moonrise$hasAnyNearbyNarrow(int chunkX, int chunkZ) {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean a(long var1);

    protected abstract @Nullable PlayerChunk b(long var1);

    protected abstract @Nullable PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean a(PlayerChunkMap chunkMap) {
        return this.moonrise$getChunkHolderManager().processTicketUpdates();
    }

    public void a(SectionPosition sectionPos, EntityPlayer player) {
        ChunkCoordIntPair chunkPos = sectionPos.r();
        long packedChunkPos = chunkPos.b();
        ((ObjectSet)this.d.computeIfAbsent(packedChunkPos, l2 -> new ObjectOpenHashSet())).add((Object)player);
    }

    public void b(SectionPosition sectionPos, EntityPlayer player) {
        ChunkCoordIntPair chunkPos = sectionPos.r();
        long packedChunkPos = chunkPos.b();
        ObjectSet set = (ObjectSet)this.d.get(packedChunkPos);
        if (set != null) {
            set.remove((Object)player);
        }
        if (set == null || set.isEmpty()) {
            this.d.remove(packedChunkPos);
        }
    }

    private int e() {
        throw new UnsupportedOperationException();
    }

    public boolean c(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public int a(long chunkPos, boolean simulate) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder == null ? ChunkHolderManager.MAX_TICKET_LEVEL + 1 : chunkHolder.getTicketLevel();
    }

    protected void a(int viewDistance) {
        this.moonrise$getChunkMap().a(viewDistance);
    }

    public void b(int simulationDistance) {
        int clamped = MathHelper.a(simulationDistance, 0, MoonriseConstants.MAX_VIEW_DISTANCE);
        this.moonrise$getChunkMap().r.moonrise$getPlayerChunkLoader().setTickDistance(clamped);
    }

    public int a() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    public TriState e(long chunkPos) {
        return this.spawnChunkTracker.hasObjectsNear(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) ? TriState.c : TriState.b;
    }

    public void a(LongConsumer action) {
        ReferenceList<Chunk> chunks = this.moonrise$getChunkMap().r.moonrise$getEntityTickingChunks();
        Chunk[] raw = chunks.getRawDataUnchecked();
        int size = chunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        for (int i2 = 0; i2 < size; ++i2) {
            Chunk chunk = raw[i2];
            action.accept(CoordinateUtils.getChunkKey(chunk.f()));
        }
    }

    public LongIterator b() {
        return this.spawnChunkTracker.getPositions().iterator();
    }

    public String c() {
        return "N/A";
    }

    public boolean d() {
        return this.g.c();
    }

    class a
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected a(int maxDistance) {
            super(maxDistance + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = maxDistance;
            this.a.defaultReturnValue((byte)(maxDistance + 2));
        }

        @Override
        protected int c(long sectionPos) {
            return this.a.get(sectionPos);
        }

        @Override
        protected void a(long sectionPos, int level) {
            byte b2 = level > this.b ? this.a.remove(sectionPos) : this.a.put(sectionPos, (byte)level);
            this.a(sectionPos, (int)b2, level);
        }

        protected void a(long chunkPos, int oldLevel, int newLevel) {
        }

        @Override
        protected int b(long pos) {
            return this.f(pos) ? 0 : Integer.MAX_VALUE;
        }

        private boolean f(long chunkPos) {
            ObjectSet set = (ObjectSet)ChunkMapDistance.this.d.get(chunkPos);
            return set != null && !set.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }
    }
}

