/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.attribute.BedRule;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.pig.EntityPig;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.NautilusInventoryMenu;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman
implements ChunkSystemServerPlayer {
    private static final Logger cB = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cC = 32;
    private static final int cD = 10;
    private static final int cE = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    public static final String f = "Dimension";
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cG = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cH = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final AttributeModifier cI = new AttributeModifier(MinecraftKey.b("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.c);
    private static final boolean cJ = false;
    private static final boolean cK = false;
    public PlayerConnection g;
    private final MinecraftServer cL;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cM;
    private final ServerStatisticManager cN;
    private float cO = Float.MIN_VALUE;
    private int cP = Integer.MIN_VALUE;
    private int cQ = Integer.MIN_VALUE;
    private int cR = Integer.MIN_VALUE;
    private int cU = Integer.MIN_VALUE;
    private int cV = Integer.MIN_VALUE;
    private float cW = -1.0E8f;
    private int cX = -99999999;
    private boolean cY = true;
    public int cZ = -99999999;
    private EnumChatVisibility da = EnumChatVisibility.a;
    public ParticleStatus db = ParticleStatus.a;
    private boolean dc = true;
    private long dd = SystemUtils.c();
    private @Nullable net.minecraft.world.entity.Entity de;
    public boolean df;
    public boolean i = false;
    private final RecipeBookServer dg;
    private @Nullable Vec3D dh;
    private int di;
    private boolean dj;
    private int dk = 2;
    public String dl = null;
    public Locale adventure$locale = Locale.US;
    private @Nullable Vec3D dm;
    private @Nullable Vec3D dn;
    private @Nullable Vec3D do;
    private SectionPosition dp = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView dq = ChunkTrackingView.a;
    private @Nullable RespawnConfig dr;
    private final ITextFilter ds;
    private boolean dt;
    private boolean du;
    private boolean dv = false;
    public WardenSpawnTracker dw = new WardenSpawnTracker();
    private @Nullable BlockPosition dx;
    private Vec3D dy = Vec3D.c;
    private Input dz = Input.b;
    private final Set<EntityEnderPearl> dA = new HashSet<EntityEnderPearl>();
    private long dB;
    private NBTTagCompound dC = new NBTTagCompound();
    private NBTTagCompound dD = new NBTTagCompound();
    public final ContainerSynchronizer dE = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.eo().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> component) {
                return ((HashCode)component.a(this.b).getOrThrow(string -> new IllegalArgumentException("Failed to hash " + String.valueOf(component) + ": " + string))).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> items, ItemStack carried, int[] remoteDataSlots) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowItems(container.l, container.k(), items, carried));
            for (int i2 = 0; i2 < remoteDataSlots.length; ++i2) {
                this.b(container, i2, remoteDataSlots[i2]);
            }
        }

        @Override
        public void sendOffHandSlotChange() {
            this.a((Container)EntityPlayer.this.cm, 45, EntityPlayer.this.cm.b(45).g().v());
        }

        @Override
        public void a(Container container, int slot, ItemStack stack) {
            EntityPlayer.this.g.b(new PacketPlayOutSetSlot(container.l, container.k(), slot, stack));
        }

        @Override
        public void a(Container containerMenu, ItemStack stack) {
            EntityPlayer.this.g.b(new ClientboundSetCursorItemPacket(stack));
        }

        @Override
        public void a(Container container, int id, int value) {
            this.b(container, id, value);
        }

        private void b(Container container, int id, int value) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowData(container.l, id, value));
        }

        @Override
        public RemoteSlot a() {
            return new RemoteSlot.a(arg_0 -> this.b.getUnchecked(arg_0));
        }
    };
    private final ICrafting dF = new ICrafting(){

        @Override
        public void a(Container containerToSend, int dataSlotIndex, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gK()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gK(), stack);
            }
        }

        @Override
        public void slotChanged(Container containerToSend, int dataSlotIndex, ItemStack oldStack, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gK()) {
                if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gK(), stack);
                    return;
                }
                PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), dataSlotIndex, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                event.callEvent();
                if (event.shouldTriggerAdvancements()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gK(), stack);
                }
            }
        }

        @Override
        public void a(Container containerMenu, int dataSlotIndex, int value) {
        }
    };
    private @Nullable RemoteChatSession dG;
    public final @Nullable Object j;
    private final ICommandListener dH = new ICommandListener(){

        @Override
        public boolean x_() {
            return EntityPlayer.this.A().U().a(GameRules.R);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent message) {
            EntityPlayer.this.a(message);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private Set<DebugSubscription<?>> dI = Set.of();
    private int dJ;
    public boolean k;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public @Nullable PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public @Nullable String lastKnownName;
    public String displayName;
    public Component adventure$displayName;
    public @Nullable IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean suppressTrackerForLogin = false;
    public boolean isRealPlayer;
    public @Nullable PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PlayerQuitEvent.QuitReason quitReason = null;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public @Nullable WeatherType weatherType = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public EntityPlayer(MinecraftServer server, WorldServer level, GameProfile gameProfile, ClientInformation clientInformation) {
        super(level, gameProfile);
        this.cL = server;
        this.ds = server.a(this);
        this.h = server.b(this);
        this.h.a(this.b((EnumGamemode)null), null);
        this.dg = new RecipeBookServer((recipe, output) -> server.aJ().a(recipe, output));
        this.cN = server.aj().getPlayerStats(this);
        this.cM = server.aj().f(this);
        this.updateOptionsNoEvents(clientInformation);
        this.j = null;
        this.displayName = this.da();
        this.adventure$displayName = Component.text((String)this.da());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.fq();
    }

    @Override
    public BlockPosition a(WorldServer level, BlockPosition pos) {
        CompletableFuture<Vec3D> completableFuture = PlayerSpawnFinder.a(level, pos);
        level.G.g.b(completableFuture::isDone);
        return BlockPosition.a(completableFuture.join());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.dw = input.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.dn = input.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = input.a("seenCredits", false);
        input.a("recipeBook", RecipeBookServer.b.a).ifPresent(packed -> this.dg.a((RecipeBookServer.b)packed, (ResourceKey<IRecipe<?>> key) -> this.cL.aJ().b((ResourceKey<IRecipe<?>>)key).isPresent()));
        this.getBukkitEntity().readExtraData(input);
        if (this.gr()) {
            this.gs();
        }
        this.dr = input.a("respawn", RespawnConfig.a).orElse(null);
        this.dv = input.a("spawn_extra_particles_on_fall", false);
        this.dx = input.a("raid_omen_position", BlockPosition.a).orElse(null);
        this.loadGameTypes(input);
    }

    private void loadGameTypes(ValueInput input) {
        if (this.cL.bf() != null && this.cL.bf() != EntityPlayer.a(input, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.cL.w().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.h.a(this.cL.bf(), EnumGamemode.e);
            } else {
                this.h.a(EntityPlayer.a(input, "playerGameType"), EntityPlayer.a(input, "previousPlayerGameType"));
            }
            return;
        }
        this.h.a(this.b(EntityPlayer.a(input, "playerGameType")), EntityPlayer.a(input, "previousPlayerGameType"));
        this.b(input.a("ShoulderEntityLeft", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
        this.c(input.a("ShoulderEntityRight", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dw);
        this.g(output);
        output.a("seenCredits", this.i);
        output.b("entered_nether_pos", Vec3D.a, this.dn);
        this.e(output);
        output.a("recipeBook", RecipeBookServer.b.a, this.dg.b());
        output.a(f, this.A().aq().a().toString());
        output.b("respawn", RespawnConfig.a, this.dr);
        output.a("spawn_extra_particles_on_fall", this.dv);
        output.b("raid_omen_position", BlockPosition.a, this.dx);
        this.f(output);
        if (!this.al().j()) {
            output.a("ShoulderEntityLeft", NBTTagCompound.a, this.al());
        }
        if (!this.am().j()) {
            output.a("ShoulderEntityRight", NBTTagCompound.a, this.am());
        }
        this.getBukkitEntity().setExtraData(output);
    }

    private void e(ValueOutput output) {
        net.minecraft.world.entity.Entity rootVehicle = this.du();
        net.minecraft.world.entity.Entity vehicle = this.dz();
        boolean persistVehicle = true;
        if (vehicle != null) {
            for (net.minecraft.world.entity.Entity topVehicle = vehicle; topVehicle != null; topVehicle = topVehicle.dz()) {
                if (topVehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && vehicle != null && rootVehicle != this && rootVehicle.dt() && !rootVehicle.eh()) {
            ValueOutput valueOutput = output.a("RootVehicle");
            valueOutput.a("Attach", UUIDUtil.a, vehicle.cY());
            rootVehicle.c(valueOutput.a("Entity"));
        }
    }

    public void b(ValueInput input) {
        Optional<ValueInput> optional = input.a("RootVehicle");
        if (!optional.isEmpty()) {
            WorldServer serverLevel = this.A();
            net.minecraft.world.entity.Entity entity = EntityTypes.a(optional.get().b("Entity"), (net.minecraft.world.level.World)serverLevel, EntitySpawnReason.r, entity2 -> !serverLevel.addWithUUID(entity2, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity2);
            if (entity != null) {
                UUID uuid = optional.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cY().equals(uuid)) {
                    this.a(entity, true, false);
                } else {
                    for (net.minecraft.world.entity.Entity entity1 : entity.dr()) {
                        if (!entity1.cY().equals(uuid)) continue;
                        this.a(entity1, true, false);
                        break;
                    }
                }
                if (!this.cq()) {
                    cB.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (net.minecraft.world.entity.Entity entity1x : entity.dr()) {
                        entity1x.discard(null);
                    }
                }
            }
        }
    }

    private void f(ValueOutput output) {
        if (!this.dA.isEmpty()) {
            ValueOutput.b valueOutputList = output.b(d);
            for (EntityEnderPearl thrownEnderpearl : this.dA) {
                if (thrownEnderpearl.ao().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (thrownEnderpearl.eh()) {
                    cB.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput valueOutput = valueOutputList.a();
                thrownEnderpearl.c(valueOutput);
                valueOutput.a(e, net.minecraft.world.level.World.g, thrownEnderpearl.ao().aq());
            }
        }
    }

    public void c(ValueInput input) {
        input.d(d).forEach(this::e);
    }

    private void e(ValueInput input) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = input.a(e, net.minecraft.world.level.World.g);
        if (!optional.isEmpty()) {
            WorldServer level = this.A().s().a(optional.get());
            if (level != null) {
                net.minecraft.world.entity.Entity entity = EntityTypes.a(input, (net.minecraft.world.level.World)level, EntitySpawnReason.r, entity1 -> !level.c(entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(level, entity.dM());
                } else {
                    cB.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cB.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(WorldServer level) {
        if (level == null) {
            throw new IllegalArgumentException("level can't be null");
        }
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    public void a(int experiencePoints) {
        float f1;
        float f2 = this.gU();
        float f22 = MathHelper.a((float)experiencePoints / f2, 0.0f, f1 = (f2 - 1.0f) / f2);
        if (f22 != this.cu) {
            this.cu = f22;
            this.cZ = -1;
        }
    }

    public void b(int level) {
        if (level != this.cs) {
            this.cs = level;
            this.cZ = -1;
        }
    }

    @Override
    public void c(int levels) {
        if (levels != 0) {
            super.c(levels);
            this.cZ = -1;
        }
    }

    @Override
    public void a(ItemStack enchantedItem, int cost) {
        super.a(enchantedItem, cost);
        this.cZ = -1;
    }

    public void a(Container menu) {
        menu.a(this.dF);
        menu.a(this.dE);
    }

    public void c() {
        this.a(this.cm);
    }

    @Override
    public void g_() {
        super.g_();
        this.g.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void P_() {
        super.P_();
        this.g.b(new ClientboundPlayerCombatEndPacket(this.fo()));
    }

    @Override
    public void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        net.minecraft.world.entity.Entity camera;
        if (this.joining) {
            this.joining = false;
        }
        this.g.r();
        this.h.a();
        this.dw.a();
        if (this.ax > 0) {
            --this.ax;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.cn.d();
            if (this.cn != this.cm) {
                this.cm.broadcastNonContainerSlotChanges();
            }
            this.containerUpdateDelay = this.A().paperConfig().tickRates.containerUpdate;
        }
        if (this.cn != this.cm && (this.fE() || !this.cn.b(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cn = this.cm;
        }
        if ((camera = this.N()) != this) {
            if (camera.cb()) {
                this.a(camera.dP(), camera.dR(), camera.dV(), camera.ec(), camera.ee());
                this.A().p().a(this);
                if (this.gB()) {
                    this.d((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.d((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.dh != null) {
            CriterionTriggers.v.a(this, this.dh, this.at - this.di);
        }
        this.m();
        this.n();
        this.hu();
        this.cM.a(this, true);
    }

    private void hu() {
        AttributeModifiable attribute2;
        AttributeModifiable attribute1;
        AttributeModifiable attribute = this.h(GenericAttributes.h);
        if (attribute != null) {
            if (this.ha()) {
                attribute.a(cF);
            } else {
                attribute.e(cF);
            }
        }
        if ((attribute1 = this.h(GenericAttributes.l)) != null) {
            if (this.ha()) {
                attribute1.a(cG);
            } else {
                attribute1.e(cG);
            }
        }
        if ((attribute2 = this.h(GenericAttributes.I)) != null) {
            if (this.cz()) {
                attribute2.a(cI);
            } else {
                attribute2.e(cI);
            }
        }
    }

    public void h() {
        try {
            if (this.valid && !this.au() || !this.dD()) {
                super.g();
                if (!this.cn.b(this)) {
                    this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
                    this.cn = this.cm;
                }
                this.co.a(this);
                this.a(StatisticList.k);
                this.a(StatisticList.l);
                if (this.cb()) {
                    this.a(StatisticList.m);
                }
                if (this.cx()) {
                    this.a(StatisticList.o);
                }
                if (!this.gr()) {
                    this.a(StatisticList.n);
                }
            }
            for (int i2 = 0; i2 < this.gK().b(); ++i2) {
                ItemStack item = this.gK().a(i2);
                if (item.f()) continue;
                this.i(item);
            }
            if (this.eZ() != this.cW || this.cX != this.co.a() || this.co.d() == 0.0f != this.cY) {
                this.g.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.co.a(), this.co.d()));
                this.cW = this.eZ();
                this.cX = this.co.a();
                boolean bl = this.cY = this.co.d() == 0.0f;
            }
            if (this.eZ() + this.fX() != this.cO) {
                this.cO = this.eZ() + this.fX();
                this.a(IScoreboardCriteria.h, MathHelper.d(this.cO));
            }
            if (this.co.a() != this.cP) {
                this.cP = this.co.a();
                this.a(IScoreboardCriteria.i, MathHelper.d((float)this.cP));
            }
            if (this.cK() != this.cQ) {
                this.cQ = this.cK();
                this.a(IScoreboardCriteria.j, MathHelper.d((float)this.cQ));
            }
            if (this.fn() != this.cR) {
                this.cR = this.fn();
                this.a(IScoreboardCriteria.k, MathHelper.d((float)this.cR));
            }
            if (this.ct != this.cV) {
                this.cV = this.ct;
                this.a(IScoreboardCriteria.l, MathHelper.d((float)this.cV));
            }
            if (this.maxHealthCache != (double)this.fq()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cs != this.cU) {
                this.cU = this.cs;
                this.a(IScoreboardCriteria.m, MathHelper.d((float)this.cU));
            }
            if (this.ct != this.cZ) {
                this.cZ = this.ct;
                this.g.b(new PacketPlayOutExperience(this.cu, this.ct, this.cs));
            }
            if (this.at % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cs;
            }
            if (this.oldLevel != this.cs) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cs);
                this.oldLevel = this.cs;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().t();
            }
        }
        catch (Throwable var4) {
            CrashReport crashReport = CrashReport.a(var4, "Ticking player");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Player being ticked");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    private void i(ItemStack stack) {
        Packet<?> updatePacket;
        MapId mapId = stack.a(DataComponents.T);
        WorldMap savedData = ItemWorldMap.a(mapId, (net.minecraft.world.level.World)this.A());
        if (savedData != null && (updatePacket = savedData.a(mapId, this)) != null) {
            this.g.b(updatePacket);
        }
    }

    @Override
    protected void i() {
        if (this.A().av() == EnumDifficulty.a && this.A().U().a(GameRules.G).booleanValue()) {
            if (this.at % 20 == 0) {
                float saturationLevel;
                if (this.eZ() < this.fq()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((saturationLevel = this.co.d()) < 20.0f) {
                    this.co.b(saturationLevel + 1.0f);
                }
            }
            if (this.at % 10 == 0 && this.co.c()) {
                this.co.a(this.co.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        this.e(this.al());
        this.e(this.am());
        if ((this.an > 0.5 || this.by() || this.gL().b || this.gr() || this.aJ) && !this.A().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.k();
        }
    }

    private void e(NBTTagCompound tag) {
        EntityTypes entityType;
        if (!(tag.j() || tag.b("Silent", false) || this.as.a(200) != 0 || (entityType = (EntityTypes)tag.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aW || EntityParrot.a((net.minecraft.world.level.World)this.A(), (net.minecraft.world.entity.Entity)this))) {
            this.A().a(null, this.dP(), this.dR(), this.dV(), EntityParrot.a((net.minecraft.world.level.World)this.A(), this.as), this.dB(), 1.0f, EntityParrot.a(this.as));
        }
    }

    public boolean a(NBTTagCompound tag) {
        if (this.cq() || !this.aV() || this.by() || this.aJ) {
            return false;
        }
        if (this.al().j()) {
            this.b(tag);
            this.dB = this.A().au();
            return true;
        }
        if (this.am().j()) {
            this.c(tag);
            this.dB = this.A().au();
            return true;
        }
        return false;
    }

    @Override
    public void k() {
        if (this.dB + 20L < this.A().au()) {
            if (this.respawnEntityOnShoulder(this.al())) {
                this.b(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.am())) {
                this.c(new NBTTagCompound());
            }
        }
    }

    public net.minecraft.world.entity.Entity releaseLeftShoulderEntity() {
        net.minecraft.world.entity.Entity entity = this.respawnEntityOnShoulder0(this.al());
        if (entity != null) {
            this.b(new NBTTagCompound());
        }
        return entity;
    }

    public net.minecraft.world.entity.Entity releaseRightShoulderEntity() {
        net.minecraft.world.entity.Entity entity = this.respawnEntityOnShoulder0(this.am());
        if (entity != null) {
            this.c(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound tag) {
        return this.respawnEntityOnShoulder0(tag) != null;
    }

    private @Nullable net.minecraft.world.entity.Entity respawnEntityOnShoulder0(NBTTagCompound tag) {
        WorldServer scopedCollector = this.A();
        if (scopedCollector instanceof WorldServer) {
            WorldServer serverLevel = scopedCollector;
            if (!tag.j()) {
                try (ProblemReporter.j scopedCollectorx = new ProblemReporter.j(this.es(), cB);){
                    net.minecraft.world.entity.Entity entity2 = EntityTypes.a(TagValueInput.a(scopedCollectorx.a(() -> ".shoulder"), (HolderLookup.a)serverLevel.J_(), tag), (net.minecraft.world.level.World)serverLevel, EntitySpawnReason.r).map(entity -> {
                        if (entity instanceof EntityTameableAnimal) {
                            EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)entity;
                            tamableAnimal.i(this);
                        }
                        entity.a_(this.dP(), this.dR() + (double)0.7f, this.dV());
                        return serverLevel.addWithUUID((net.minecraft.world.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY) ? entity : null;
                    }).orElse(null);
                    return entity2;
                }
            }
        }
        return null;
    }

    @Override
    public void l() {
        if (this.eZ() > 0.0f && this.dm != null) {
            CriterionTriggers.Z.a(this, this.dm);
        }
        this.dm = null;
        super.l();
    }

    public void m() {
        if (this.an > 0.0 && this.dm == null) {
            this.dm = this.dI();
            if (this.cz != null && this.cz.h <= this.dm.h) {
                CriterionTriggers.ag.a(this, this.cz, this.cA);
            }
        }
    }

    public void n() {
        if (this.dz() != null && this.dz().bN()) {
            if (this.do == null) {
                this.do = this.dI();
            } else {
                CriterionTriggers.aa.a(this, this.do);
            }
        }
        if (!(this.do == null || this.dz() != null && this.dz().bN())) {
            this.do = null;
        }
    }

    private void a(IScoreboardCriteria criteria, int points) {
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(criteria, this, scoreAccess -> scoreAccess.a(points));
    }

    private static boolean shouldKeepDeathEventItem(PlayerDeathEvent event, ItemStack item) {
        List itemsToKeep = event.getItemsToKeep();
        if (EnchantmentManager.a(item, EnchantmentEffectComponents.E) || itemsToKeep.isEmpty() || item.f()) {
            return false;
        }
        org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
        Iterator iterator = itemsToKeep.iterator();
        while (iterator.hasNext()) {
            org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
            if (!bukkitStack.equals((Object)itemStack)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private void sendClientboundPlayerCombatKillPacket(boolean displayMessage, IChatBaseComponent deathMessage) {
        if (displayMessage && deathMessage != CommonComponents.a) {
            this.g.a(new ClientboundPlayerCombatKillPacket(this.aA(), deathMessage), PacketSendListener.a(() -> {
                int i2 = 256;
                String string = deathMessage.a(256);
                IChatMutableComponent component = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(string).a(EnumChatFormat.o));
                IChatMutableComponent component1 = IChatBaseComponent.a("death.attack.even_more_magic", this.R_()).a(style -> style.a(new ChatHoverable.e(component)));
                return new ClientboundPlayerCombatKillPacket(this.aA(), component1);
            }));
        } else {
            this.g.b(new ClientboundPlayerCombatKillPacket(this.aA(), CommonComponents.a));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        boolean keepInventory;
        boolean flag;
        boolean showDeathMessage = flag = this.A().U().a(GameRules.T).booleanValue();
        if (this.eh()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.gK().b());
        boolean bl = keepInventory = this.A().U().a(GameRules.s) != false || this.au();
        if (!keepInventory) {
            for (ItemStack item : this.gK().getContents()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.E)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false, null)));
            }
        }
        if (!this.au() && this.e(this.A())) {
            this.b(this.A(), damageSource, this.bI > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.fo().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damageSource, loot, PaperAdventure.asAdventure(defaultMessage), showDeathMessage, keepInventory);
        if (event.isCancelled()) {
            if (this.eZ() <= 0.0f) {
                this.x((float)event.getReviveHealth());
            }
            return;
        }
        this.c(GameEvent.p);
        if (this.cn != this.cm) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        TextComponent apiDeathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        IChatBaseComponent deathScreenMessage = PaperAdventure.asVanilla((Component)(event.deathScreenMessageOverride() != null ? event.deathScreenMessageOverride() : apiDeathMessage));
        if (apiDeathMessage != null && apiDeathMessage != Component.empty() && event.getShowDeathMessages()) {
            IChatBaseComponent deathMessage = PaperAdventure.asVanilla((Component)apiDeathMessage);
            this.sendClientboundPlayerCombatKillPacket(event.getShowDeathMessages(), deathScreenMessage);
            ScoreboardTeam team = this.cI();
            if (team == null || ((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.a) {
                this.cL.aj().a(deathMessage, false);
            } else if (((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                this.cL.aj().a((EntityHuman)this, deathMessage);
            } else if (((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                this.cL.aj().b(this, deathMessage);
            }
        } else {
            this.sendClientboundPlayerCombatKillPacket(event.getShowDeathMessages(), deathScreenMessage);
        }
        this.k();
        if (this.A().U().a(GameRules.o).booleanValue()) {
            this.hv();
        }
        if (event.shouldDropExperience()) {
            this.b(this.A(), damageSource.d());
        }
        if (!event.getKeepInventory()) {
            for (int i2 = 0; i2 < this.gK().j().size(); ++i2) {
                if (EntityPlayer.shouldKeepDeathEventItem(event, this.gK().j().get(i2))) continue;
                this.gK().j().set(i2, ItemStack.l);
            }
            for (EnumItemSlot value : EnumItemSlot.j) {
                if (!this.gK().n.has(value) || EntityPlayer.shouldKeepDeathEventItem(event, this.gK().n.a(value))) continue;
                this.gK().n.a(value, ItemStack.l);
            }
            if (!event.getItemsToKeep().isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : event.getItemsToKeep()) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
        }
        this.d((net.minecraft.world.entity.Entity)this);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving killCredit = this.fp();
        if (killCredit != null) {
            this.b(StatisticList.h.b(killCredit.ay()));
            killCredit.a((net.minecraft.world.entity.Entity)this, damageSource);
            this.e(killCredit);
        }
        this.A().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.P);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aT();
        this.k(0);
        this.d(false);
        this.fo().c();
        this.d(Optional.of(GlobalPos.a(this.A().aq(), this.dK())));
        this.g.s();
    }

    private void hv() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.dK()).c(32.0, 10.0, 32.0);
        this.A().a(EntityInsentient.class, aabb, IEntitySelector.f).stream().filter(mob -> mob instanceof IEntityAngerable).forEach(mob -> ((IEntityAngerable)((Object)mob)).a_(this.A(), this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        if (entity != this) {
            super.a(entity, damageSource);
            ScoreboardServer scoreboard = this.A().i();
            this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.S);
                this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.Q);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damageSource);
        }
    }

    private void a(ScoreHolder scoreHolder, ScoreHolder teamMember, IScoreboardCriteria[] criteria) {
        int id;
        ScoreboardTeam playersTeam = this.getBukkitEntity().getScoreboard().getHandle().e(teamMember.da());
        if (playersTeam != null && (id = playersTeam.o().b()) >= 0 && id < criteria.length) {
            this.A().getCraftServer().getScoreboardManager().forAllObjectives(criteria[id], scoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        EntityHuman player1;
        EntityArrow abstractArrow;
        net.minecraft.world.entity.Entity entity;
        EntityHuman player;
        if (this.a(level, damageSource)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity2 = damageSource.d();
        if (entity2 instanceof EntityHuman && !this.a(player = (EntityHuman)entity2) || entity2 instanceof EntityArrow && (entity = (abstractArrow = (EntityArrow)entity2).p()) instanceof EntityHuman && !this.a(player1 = (EntityHuman)entity)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(level, damageSource, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.g.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman other) {
        return this.hw() && super.a(other);
    }

    private boolean hw() {
        return this.A().X();
    }

    public @Nullable TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean useCharge, TeleportTransition.a postTeleportTransition, PlayerRespawnEvent.RespawnReason respawnReason) {
        RespawnResult result = this.findRespawnPositionAndUseSpawnBlock0(useCharge, postTeleportTransition, respawnReason);
        return result == null ? null : result.transition();
    }

    public @Nullable RespawnResult findRespawnPositionAndUseSpawnBlock0(boolean useCharge, TeleportTransition.a postTeleportTransition, PlayerRespawnEvent.RespawnReason respawnReason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        Runnable consumeAnchorCharge = null;
        RespawnConfig respawnConfig = this.V();
        WorldServer level = this.cL.a(RespawnConfig.b(respawnConfig));
        if (level != null && respawnConfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(level, respawnConfig, useCharge);
            if (optional.isPresent()) {
                RespawnPosAngle respawnPosAngle = optional.get();
                isBedSpawn = respawnPosAngle.isBedSpawn();
                isAnchorSpawn = respawnPosAngle.isAnchorSpawn();
                consumeAnchorCharge = respawnPosAngle.consumeAnchorCharge();
                teleportTransition = new TeleportTransition(level, respawnPosAngle.a(), Vec3D.c, respawnPosAngle.b(), respawnPosAngle.c(), postTeleportTransition);
            } else {
                teleportTransition = TeleportTransition.b(this, postTeleportTransition);
            }
        } else {
            teleportTransition = TeleportTransition.a(this, postTeleportTransition);
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (net.minecraft.world.level.World)teleportTransition.b(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, teleportTransition.g(), respawnReason);
        this.A().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.g.isDisconnected()) {
            return null;
        }
        if (location.equals((Object)respawnEvent.getRespawnLocation()) && consumeAnchorCharge != null) {
            consumeAnchorCharge.run();
        }
        location = respawnEvent.getRespawnLocation();
        return new RespawnResult(new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause()), isBedSpawn, isAnchorSpawn);
    }

    public boolean o() {
        return this.i(GenericAttributes.J) > 0.0;
    }

    @Override
    protected void a(Holder<AttributeBase> attribute) {
        if (attribute.a(GenericAttributes.J)) {
            ServerWaypointManager waypointManager = this.A().j();
            if (this.fw().c(attribute) > 0.0) {
                waypointManager.a(this);
            } else {
                waypointManager.c(this);
            }
        }
        super.a(attribute);
    }

    public static Optional<RespawnPosAngle> a(WorldServer level, RespawnConfig respawnConfig, boolean useCharge) {
        WorldData.a respawnData = respawnConfig.b;
        BlockPosition blockPos = respawnData.b();
        float yaw = respawnData.d();
        float pitch = respawnData.e();
        boolean flag = respawnConfig.c;
        IBlockData blockState = level.a_(blockPos);
        Block block = blockState.b();
        if (block instanceof BlockRespawnAnchor && (flag || blockState.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(level, blockPos)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.cb, level, blockPos);
            Runnable consumeAnchorCharge = null;
            if (!flag && useCharge && optional.isPresent()) {
                consumeAnchorCharge = () -> level.a(blockPos, (IBlockData)blockState.b(BlockRespawnAnchor.d, blockState.c(BlockRespawnAnchor.d) - 1), 3);
            }
            Runnable finalConsumeAnchorCharge = consumeAnchorCharge;
            return optional.map(pos -> RespawnPosAngle.of(pos, blockPos, 0.0f, false, true, finalConsumeAnchorCharge));
        }
        if (block instanceof BlockBed && level.c().a(EnvironmentAttributes.C, blockPos).b(level)) {
            return BlockBed.a(EntityTypes.cb, (ICollisionAccess)level, blockPos, blockState.c(BlockFacingHorizontal.f), yaw).map(pos -> RespawnPosAngle.of(pos, blockPos, 0.0f, true, false, null));
        }
        if (!flag) {
            return Optional.empty();
        }
        boolean isPossibleToRespawnInThis = block.a(blockState);
        IBlockData blockState1 = level.a_(blockPos.d());
        boolean isPossibleToRespawnInThis1 = blockState1.b().a(blockState1);
        return isPossibleToRespawnInThis && isPossibleToRespawnInThis1 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.1, (double)blockPos.w() + 0.5), yaw, pitch, false, false, null)) : Optional.empty();
    }

    public void p() {
        this.aw();
        this.A().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    public @Nullable EntityPlayer a(TeleportTransition teleportTransition) {
        PlayerTeleportEvent tpEvent;
        TileEntity tileEntity;
        if (this.gr()) {
            return null;
        }
        if (this.eh()) {
            return null;
        }
        if (teleportTransition.g()) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer level = teleportTransition.b();
        WorldServer serverLevel = this.A();
        ResourceKey<WorldDimension> resourceKey = serverLevel.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        Location exit = CraftLocation.toBukkit(absolutePosition.a(), (net.minecraft.world.level.World)level, absolutePosition.c(), absolutePosition.d());
        if (this.aG != null && this.aG.a((BlockEndGateway)Blocks.lB) && (tileEntity = this.A().c_(this.aG.c())) instanceof TileEntityEndGateway) {
            TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((Player)this.getBukkitEntity(), enter, exit.clone(), (EndGateway)new CraftEndGateway((World)this.A().getWorld(), theEndGatewayBlockEntity));
        } else {
            tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit.clone(), teleportTransition.cause());
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled()) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            level = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTransition = new TeleportTransition(level, CraftLocation.toVec3(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
        }
        if (!teleportTransition.h()) {
            this.ad();
        }
        if (level.aq() == serverLevel.aq()) {
            this.g.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
            this.g.m();
            teleportTransition.j().onTransition(this);
            return this;
        }
        this.df = true;
        WorldData levelData = level.D_();
        this.g.b(new PacketPlayOutRespawn(this.b(level), 3));
        this.g.b(new PacketPlayOutServerDifficulty(levelData.p(), levelData.q()));
        PlayerList playerList = this.cL.aj();
        playerList.d(this);
        this.aG = null;
        serverLevel.a(this, Entity.RemovalReason.e);
        this.ej();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("moving");
        if (resourceKey == WorldDimension.b && level.getTypeKey() == WorldDimension.c) {
            this.dn = this.dI();
        }
        profilerFiller.c();
        profilerFiller.a("placing");
        this.a(level);
        this.g.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        this.g.m();
        level.d(this);
        profilerFiller.c();
        this.h(serverLevel);
        this.gf();
        this.g.b(new PacketPlayOutAbilities(this.gL()));
        playerList.a(this, level);
        playerList.e(this);
        playerList.c(this);
        teleportTransition.j().onTransition(this);
        this.cZ = -1;
        this.cW = -1.0f;
        this.cX = -1;
        this.a(teleportTransition, serverLevel);
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)serverLevel.getWorld());
        this.A().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.gg()) {
            this.gf();
        }
        return this;
    }

    @Override
    public void a(float yRot, boolean yRelative, float xRot, boolean xRelative) {
        super.a(yRot, yRelative, xRot, xRelative);
        this.g.b(new ClientboundPlayerRotationPacket(yRot, yRelative, xRot, xRelative));
    }

    public void h(WorldServer level) {
        ResourceKey<net.minecraft.world.level.World> resourceKey = level.aq();
        ResourceKey<net.minecraft.world.level.World> resourceKey1 = this.A().aq();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(level);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.A());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourceKey;
            maindimensionkey1 = resourceKey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourceKey || maindimensionkey1 != resourceKey1) {
            CriterionTriggers.w.a(this, resourceKey, resourceKey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.dn != null) {
            CriterionTriggers.D.a(this, this.dn);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.dn = null;
        }
    }

    @Override
    public boolean a(EntityPlayer player) {
        return player.au() ? this.N() == this : !this.au() && super.a(player);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, int quantity) {
        super.a(entity, quantity);
        this.cn.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition bedPos, EnumDirection direction) {
        BedRule bedRule = this.A().c().a(EnvironmentAttributes.C, bedPos);
        if (bedRule.d()) {
            return Either.left(EntityHuman.EnumBedResult.EXPLOSION);
        }
        if (!this.gr() && this.cb()) {
            boolean canSleep = bedRule.a(this.A());
            boolean canSetSpawn = bedRule.b(this.A());
            if (!canSetSpawn && !canSleep) {
                return Either.left(bedRule.a());
            }
            if (!this.a(bedPos, direction)) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (this.b(bedPos, direction)) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (canSetSpawn) {
                this.setRespawnPosition(new RespawnConfig(WorldData.a.a(this.A().aq(), bedPos, this.ec(), this.ee()), false), true, PlayerSetSpawnEvent.Cause.BED);
            }
            if (!canSleep) {
                return Either.left(bedRule.a());
            }
            if (!this.ha()) {
                double d2 = 8.0;
                double d1 = 5.0;
                Vec3D vec3 = Vec3D.c(bedPos);
                List<EntityMonster> entitiesOfClass = this.A().a(EntityMonster.class, new AxisAlignedBB(vec3.a() - 8.0, vec3.b() - 5.0, vec3.c() - 8.0, vec3.a() + 8.0, vec3.b() + 5.0, vec3.c() + 8.0), (? super T monster) -> monster.a(this.A(), this));
                if (!entitiesOfClass.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.d);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.c);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition bedPos, boolean force) {
        EnumDirection direction = this.A().a_(bedPos).c(BlockFacingHorizontal.f);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(bedPos, direction);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.c) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, bedPos, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(bedPos, force).ifRight(unit -> {
            this.a(StatisticList.ar);
            CriterionTriggers.r.a(this);
        });
        if (!this.A().g()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        this.A().h();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3 = Vec3D.c(pos);
        return Math.abs(this.dP() - vec3.a()) <= 3.0 && Math.abs(this.dR() - vec3.b()) <= 2.0 && Math.abs(this.dV() - vec3.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.d();
        return !this.h(blockPos) || !this.h(blockPos.a(direction.g()));
    }

    @Override
    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        if (!this.gr()) {
            return;
        }
        CraftBlock bed = CraftBlock.at(this.A(), this.gp().orElse(this.dK()));
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)this.getBukkitEntity(), (org.bukkit.block.Block)bed, true);
        if (!event.callEvent()) {
            return;
        }
        if (this.gr()) {
            this.A().p().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(wakeImmediately, updateLevelForSleepingPlayers);
        if (this.g != null) {
            this.g.teleport(this.dP(), this.dR(), this.dV(), this.ec(), this.ee(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return super.a(level, damageSource) || this.S() && !damageSource.a(DamageTypes.m) || !this.g.q() || !this.A().paperConfig().collisions.allowPlayerCrammingDamage && damageSource.a(DamageTypes.h);
    }

    @Override
    protected void b(WorldServer level, BlockPosition pos) {
        if (!this.au()) {
            super.b(level, pos);
        }
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.dv && onGround && this.an > 0.0) {
            Vec3D vec3 = pos.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.an, 0.0, 200.0);
            this.A().a(new ParticleParamBlock(Particles.b, state), vec3.g, vec3.h, vec3.i, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.dv = false;
        }
        super.a(y2, onGround, state, pos);
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity) {
        super.a(entity);
        this.cz = this.dI();
        this.cA = entity;
        this.w(entity != null && entity.ay() == EntityTypes.bP);
    }

    @Override
    protected void q() {
        if (this.A().y().i()) {
            super.q();
        }
    }

    @Override
    public void a(TileEntitySign signEntity, boolean isFrontText) {
        this.g.b(new PacketPlayOutBlockChange(this.A(), signEntity.aD_()));
        this.g.b(new PacketPlayOutOpenSignEditor(signEntity.aD_(), isFrontText));
    }

    @Override
    public void b(Holder<Dialog> dialog) {
        this.g.b(new ClientboundShowDialogPacket(dialog));
    }

    public int nextContainerCounter() {
        this.dJ = this.dJ % 100 + 1;
        return this.dJ;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory menu) {
        if (menu == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container abstractContainerMenu = menu.createMenu(this.dJ, this.gK(), this);
        IChatBaseComponent title = null;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.setTitle(menu.R_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, abstractContainerMenu, cancelled);
            abstractContainerMenu = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (abstractContainerMenu == null && !cancelled) {
                if (menu instanceof IInventory) {
                    IInventory container = (IInventory)((Object)menu);
                    container.b(this);
                } else if (menu instanceof BlockChest.DoubleInventory) {
                    BlockChest.DoubleInventory doubleInventory = (BlockChest.DoubleInventory)menu;
                    doubleInventory.container.b(this);
                } else if (!this.cl.b((TileEntityEnderChest)null)) {
                    this.cl.b(this);
                }
                return OptionalInt.empty();
            }
        }
        if (abstractContainerMenu == null) {
            if (this.au()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cn = abstractContainerMenu;
        if (!this.fE()) {
            this.g.b(new PacketPlayOutOpenWindow(abstractContainerMenu.l, abstractContainerMenu.a(), Objects.requireNonNullElseGet(title, abstractContainerMenu::getTitle)));
        }
        this.a(abstractContainerMenu);
        return OptionalInt.of(this.dJ);
    }

    @Override
    public void a(int containerId, MerchantRecipeList offers, int level, int xp, boolean showProgress, boolean canRestock) {
        this.g.b(new PacketPlayOutOpenWindowMerchant(containerId, offers, level, xp, showProgress, canRestock));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dJ, this.gK(), inventory, horse, horse.ad_());
        container.setTitle(horse.R_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.b(this);
            return;
        }
        if (this.cn != this.cm) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int inventoryColumns = horse.ad_();
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dJ, inventoryColumns, horse.aA()));
        this.cn = container;
        this.a(this.cn);
    }

    @Override
    public void a(AbstractNautilus nautilus, IInventory inventory) {
        this.nextContainerCounter();
        Container menu = new NautilusInventoryMenu(this.dJ, this.gK(), inventory, nautilus, nautilus.hk());
        menu.setTitle(nautilus.R_());
        menu = CraftEventFactory.callInventoryOpenEvent(this, menu);
        if (menu == null) {
            inventory.b(this);
            return;
        }
        if (this.cn != this.cm) {
            this.r();
        }
        int inventoryColumns = nautilus.hk();
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dJ, inventoryColumns, nautilus.aA()));
        this.cn = menu;
        this.a(this.cn);
    }

    @Override
    public void a(ItemStack stack, EnumHand hand) {
        if (stack.c(DataComponents.ac)) {
            if (WrittenBookContent.a(stack, this.C(), this)) {
                this.cn.d();
            }
            this.g.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.g.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::d));
    }

    @Override
    public void r() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.g.b(new PacketPlayOutCloseWindow(this.cn.l));
        this.s();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.g.b(new PacketPlayOutCloseWindow(this.cn.l));
        this.cn = this.cm;
    }

    @Override
    public void s() {
        this.cn.a(this);
        this.cm.a(this.cn);
        this.cn = this.cm;
    }

    @Override
    public void t() {
        double x2 = this.dP();
        double y2 = this.dR();
        double z2 = this.dV();
        super.t();
        this.p(this.dP() - x2, this.dR() - y2, this.dV() - z2);
    }

    public void a(double dx, double dy, double dz) {
        if (!this.cq() && !EntityPlayer.q(dx, dy, dz)) {
            if (this.cB()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.D, rounded);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.w, rounded);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.by()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.s, rounded);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.fl()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.aV()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    if (this.cA()) {
                        this.a(StatisticList.r, rounded);
                        this.causeFoodExhaustion(this.A().spigotConfig.sprintMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cz()) {
                        this.a(StatisticList.q, rounded);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, rounded);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.gj()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.C, rounded);
            } else {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 25) {
                    this.a(StatisticList.v, rounded);
                }
            }
        }
    }

    private void p(double dx, double dy, double dz) {
        if (this.cq() && !EntityPlayer.q(dx, dy, dz)) {
            int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
            net.minecraft.world.entity.Entity vehicle = this.dz();
            if (vehicle instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, rounded);
            } else if (vehicle instanceof AbstractBoat) {
                this.a(StatisticList.y, rounded);
            } else if (vehicle instanceof EntityPig) {
                this.a(StatisticList.z, rounded);
            } else if (vehicle instanceof EntityHorseAbstract) {
                this.a(StatisticList.B, rounded);
            } else if (vehicle instanceof EntityStrider) {
                this.a(StatisticList.E, rounded);
            } else if (vehicle instanceof HappyGhast) {
                this.a(StatisticList.A, rounded);
            } else if (vehicle instanceof AbstractNautilus) {
                this.a(StatisticList.F, rounded);
            }
        }
    }

    private static boolean q(double dx, double dy, double dz) {
        return dx == 0.0 && dy == 0.0 && dz == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cN.b(this, stat, amount);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, scoreAccess -> scoreAccess.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cN.a(this, stat, 0);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.dg.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> items) {
        CriterionTriggers.ae.a(this, recipe.a(), items);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
        List<RecipeHolder<?>> list = recipes.stream().flatMap(key -> this.cL.aJ().b((ResourceKey<IRecipe<?>>)key).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.dg.b(recipes, this);
    }

    @Override
    public void u() {
        super.u();
        this.a(StatisticList.G);
        if (this.cA()) {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int xpPoints) {
        if (xpPoints != 0) {
            super.d(xpPoints);
            this.cZ = -1;
        }
    }

    public void v() {
        this.dj = true;
        this.ce();
        if (this.cq() && this.dz() instanceof EntityPlayer) {
            this.cf();
        }
        if (this.gr()) {
            this.a(true, false);
        }
    }

    public boolean w() {
        return this.dj;
    }

    public void x() {
        this.cW = -1.0E8f;
        this.cZ = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    public void Q_() {
        if (!this.bT.f() && this.fZ()) {
            this.g.b(new PacketPlayOutEntityStatus(this, 9));
            super.Q_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.g.b(new PacketPlayOutLookAt(anchor, target.g, target.h, target.i));
    }

    public void a(ArgumentAnchor.Anchor fromAnchor, net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor toAnchor) {
        Vec3D vec3 = toAnchor.a(entity);
        super.a(fromAnchor, vec3);
        this.g.b(new PacketPlayOutLookAt(fromAnchor, entity, toAnchor));
    }

    public void a(EntityPlayer that, boolean keepEverything) {
        this.dw = that.dw;
        this.dG = that.dG;
        this.h.a(that.h.b(), that.h.c());
        this.z();
        this.fw().b(that.fw());
        if (keepEverything) {
            this.x(that.eZ());
            this.co = that.co;
            for (MobEffect mobEffect : that.eW()) {
            }
            this.g(that);
            this.aG = that.aG;
        } else if (this.A().U().a(GameRules.s).booleanValue() || that.au()) {
            this.g(that);
        }
        this.cv = that.cv;
        this.cl = that.cl;
        this.aD().a(Avatar.t, that.aD().a(Avatar.t));
        this.cZ = -1;
        this.cW = -1.0f;
        this.cX = -1;
        this.i = that.i;
        this.dn = that.dn;
        this.dq = that.dq;
        this.dI = that.dI;
        this.b(that.al());
        this.c(that.am());
        this.d(that.hk());
        this.gy().a(that.gy());
    }

    private void g(EntityHuman player) {
        this.gK().a(player.gK());
        this.cs = player.cs;
        this.ct = player.ct;
        this.cu = player.cu;
        this.q(player.gF());
    }

    @Override
    protected void a(MobEffect effectInstance, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.aA(), effectInstance, true));
        if (effectInstance.a(MobEffects.y)) {
            this.di = this.at;
            this.dh = this.dI();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect effectInstance, boolean forced, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, forced, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.aA(), effectInstance, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> effects) {
        super.c(effects);
        for (MobEffect mobEffectInstance : effects) {
            this.g.b(new PacketPlayOutRemoveEntityEffect(this.aA(), mobEffectInstance.c()));
            if (!mobEffectInstance.a(MobEffects.y)) continue;
            this.dh = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.teleportTo(x2, y2, z2, PlayerTeleportEvent.TeleportCause.DISMOUNT);
    }

    @Override
    public void b(double x2, double y2, double z2) {
        this.teleportTo(x2, y2, z2, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(double x2, double y2, double z2, PlayerTeleportEvent.TeleportCause cause) {
        this.g.teleport(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k), cause);
    }

    @Override
    public void c(double dx, double dy, double dz) {
        this.g.a(new PositionMoveRotation(new Vec3D(dx, dy, dz), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag;
        if (this.gr()) {
            this.a(true, true);
        }
        if (setCamera) {
            this.d((net.minecraft.world.entity.Entity)this);
        }
        if (flag = super.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, cause)) {
            this.r(relativeMovements.contains((Object)Relative.d) ? this.cS() + yaw : yaw);
            this.g.l();
        }
        return flag;
    }

    @Override
    public void d(double x2, double y2, double z2) {
        super.d(x2, y2, z2);
        this.g.m();
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.A().p().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void c(net.minecraft.world.entity.Entity target) {
        this.A().p().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void z() {
        if (this.g != null) {
            this.g.b(new PacketPlayOutAbilities(this.gL()));
            this.M();
        }
    }

    public WorldServer A() {
        return (WorldServer)super.ao();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && !event.isCancelled();
    }

    public @Nullable PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean isSpectator = this.au();
        PlayerGameModeChangeEvent event = this.h.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null) {
            return null;
        }
        if (event.isCancelled()) {
            return event;
        }
        this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.k();
            this.cf();
            this.gf();
            EnchantmentManager.a(this);
        } else {
            this.d((net.minecraft.world.entity.Entity)this);
            if (isSpectator) {
                EnchantmentManager.a(this.A(), (EntityLiving)this);
            }
        }
        this.z();
        this.fY();
        return event;
    }

    @Override
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener B() {
        return this.dH;
    }

    public CommandListenerWrapper C() {
        return new CommandListenerWrapper(this.B(), this.dI(), this.cl(), this.A(), this.I(), this.aq(), this.R_(), this.cL, this);
    }

    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.x(overlay)) {
            this.g.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    int i2 = 256;
                    String string = message.a(256);
                    IChatMutableComponent component = IChatBaseComponent.b(string).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", component).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundChatType) {
        this.sendChatMessage(message, filtered, boundChatType, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundChatType, @Nullable IChatBaseComponent unsigned) {
        if (this.hy()) {
            message.sendToPlayer(this, filtered, boundChatType, unsigned);
        }
    }

    public String D() {
        String string;
        SocketAddress socketAddress = this.g.n();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            string = InetAddresses.toAddrString((InetAddress)inetSocketAddress.getAddress());
        } else {
            string = "<unknown>";
        }
        return string;
    }

    public void a(ClientInformation clientInformation) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), (Map)SystemUtils.a(new IdentityHashMap(), (? super T map) -> {
            map.put(ClientOption.LOCALE, clientInformation.b());
            map.put(ClientOption.VIEW_DISTANCE, clientInformation.c());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientInformation.d().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientInformation.e());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientInformation.f()));
            map.put(ClientOption.MAIN_HAND, clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientInformation.h());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientInformation.i());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientInformation.j().name()));
        })).callEvent();
        if (this.at() != clientInformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.cL.server.getPluginManager().callEvent((Event)event);
        }
        if (this.dl == null || !this.dl.equals(clientInformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientInformation.b());
            this.cL.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientInformation);
    }

    public void updateOptionsNoEvents(ClientInformation clientInformation) {
        this.dl = clientInformation.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.dl), Locale.US);
        this.dk = clientInformation.c();
        this.da = clientInformation.d();
        this.dc = clientInformation.e();
        this.dt = clientInformation.h();
        this.du = clientInformation.i();
        this.db = clientInformation.j();
        this.aD().a(Avatar.t, (byte)clientInformation.f());
        this.aD().a(Avatar.s, clientInformation.g());
    }

    public ClientInformation E() {
        byte i2 = this.aD().a(Avatar.t);
        return new ClientInformation(this.dl, this.dk, this.da, this.dc, i2, this.at(), this.dt, this.du, this.db);
    }

    public boolean F() {
        return this.dc;
    }

    public EnumChatVisibility G() {
        return this.da;
    }

    private boolean x(boolean overlay) {
        return this.da != EnumChatVisibility.c || overlay;
    }

    private boolean hy() {
        return this.da == EnumChatVisibility.a;
    }

    public int H() {
        return this.dk;
    }

    public void a(ServerPing serverStatus) {
        this.g.b(new ClientboundServerDataPacket(serverStatus.a(), serverStatus.d().map(ServerPing.a::a)));
    }

    @Override
    public PermissionSet I() {
        return this.cL.b(this.gJ());
    }

    public void J() {
        this.dd = SystemUtils.c();
    }

    public ServerStatisticManager K() {
        return this.cN;
    }

    public RecipeBookServer L() {
        return this.dg;
    }

    @Override
    protected void M() {
        if (this.au()) {
            this.eU();
            this.l(true);
        } else {
            super.M();
        }
    }

    public net.minecraft.world.entity.Entity N() {
        return this.de == null ? this : this.de;
    }

    public void d(@Nullable net.minecraft.world.entity.Entity entityToSpectate) {
        net.minecraft.world.entity.Entity camera = this.N();
        net.minecraft.world.entity.Entity entity = this.de = entityToSpectate == null ? this : entityToSpectate;
        if (camera != this.de) {
            net.minecraft.world.level.World world;
            if (this.de == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.de = camera;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity(), (Entity)entityToSpectate.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.de = camera;
                    return;
                }
            }
            if ((world = this.de.ao()) instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                this.teleportTo(serverLevel, this.de.dP(), this.de.dR(), this.de.dV(), Set.of(), this.ec(), this.ee(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entityToSpectate != null) {
                this.A().p().a(this);
            }
            this.g.b(new PacketPlayOutCamera(this.de));
            this.g.m();
        }
    }

    @Override
    protected void O() {
        if (!this.df) {
            super.O();
        }
    }

    @Override
    public void e(net.minecraft.world.entity.Entity target) {
        if (this.au()) {
            this.d(target);
        } else {
            super.e(target);
        }
    }

    public long P() {
        return this.dd;
    }

    public @Nullable IChatBaseComponent Q() {
        return this.listName;
    }

    public int R() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.hf();
    }

    public boolean S() {
        return this.df;
    }

    public void T() {
        this.df = false;
    }

    public AdvancementDataPlayer U() {
        return this.cM;
    }

    public @Nullable RespawnConfig V() {
        return this.dr;
    }

    public void b(EntityPlayer player) {
        this.a(player.dr, false);
    }

    public void a(@Nullable RespawnConfig respawnConfig, boolean displayInChat) {
        this.setRespawnPosition(respawnConfig, displayInChat, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    public boolean setRespawnPosition(@Nullable RespawnConfig respawnConfig, boolean displayInChat, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean actuallyDisplayInChat = false;
        if (respawnConfig != null) {
            actuallyDisplayInChat = displayInChat && !respawnConfig.a(this.dr);
            spawnLoc = CraftLocation.toBukkit((BaseBlockPosition)respawnConfig.a().b(), (net.minecraft.world.level.World)this.cL.a(respawnConfig.a().a()));
            spawnLoc.setYaw(respawnConfig.a().d());
            spawnLoc.setPitch(respawnConfig.a().e());
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, respawnConfig != null && respawnConfig.b(), cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), actuallyDisplayInChat, actuallyDisplayInChat ? PaperAdventure.asAdventure(cH) : null);
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            respawnConfig = new RespawnConfig(WorldData.a.a(((CraftWorld)event.getLocation().getWorld()).getHandle().aq(), CraftLocation.toBlockPosition(event.getLocation()), event.getLocation().getYaw(), event.getLocation().getPitch()), event.isForced());
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
        }
        this.dr = respawnConfig;
        return true;
    }

    public SectionPosition W() {
        return this.dp;
    }

    public void a(SectionPosition sectionPos) {
        this.dp = sectionPos;
    }

    public ChunkTrackingView X() {
        return this.dq;
    }

    public void a(ChunkTrackingView chunkTrackingView) {
        this.dq = chunkTrackingView;
    }

    @Override
    public EntityItem drop(ItemStack droppedItem, boolean dropAround, boolean traceItem, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        WorldMap mapData;
        ItemStack itemStack;
        EntityItem itemEntity = super.drop(droppedItem, dropAround, traceItem, callEvent, entityOperation);
        ItemStack itemStack2 = itemStack = itemEntity != null ? itemEntity.e() : ItemStack.l;
        if (traceItem && !itemStack.f()) {
            this.a(StatisticList.f.b(itemStack.h()), itemStack.N());
            this.a(StatisticList.H);
        }
        if (itemStack.a(Items.tY) && (mapData = ItemWorldMap.b(itemStack, (net.minecraft.world.level.World)this.A())) != null) {
            mapData.a(this, itemStack);
        }
        return itemEntity;
    }

    public ITextFilter Y() {
        return this.ds;
    }

    public void a(WorldServer level) {
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    private static @Nullable EnumGamemode a(ValueInput input, String key) {
        return input.a(key, EnumGamemode.h).orElse(null);
    }

    private EnumGamemode b(@Nullable EnumGamemode gameType) {
        EnumGamemode forcedGameType = this.cL.bf();
        if (forcedGameType != null) {
            return forcedGameType;
        }
        return gameType != null ? gameType : this.cL.w();
    }

    private void g(ValueOutput output) {
        output.a("playerGameType", EnumGamemode.h, this.h.b());
        EnumGamemode previousGameModeForPlayer = this.h.c();
        output.b("previousPlayerGameType", EnumGamemode.h, previousGameModeForPlayer);
    }

    @Override
    public boolean Z() {
        return this.dt;
    }

    public boolean c(EntityPlayer player) {
        return player != this && (this.dt || player.dt);
    }

    @Override
    public boolean c(WorldServer level, BlockPosition pos) {
        return super.c(level, pos) && level.a((net.minecraft.world.entity.Entity)this, pos);
    }

    @Override
    protected void a_(ItemStack usingItem) {
        CriterionTriggers.Y.a(this, usingItem);
        super.a_(usingItem);
    }

    public boolean drop(boolean dropStack) {
        PlayerInventory inventory = this.gK();
        ItemStack itemStack = inventory.a(dropStack);
        this.cn.b(inventory, inventory.g()).ifPresent(slot -> this.cn.a(slot, inventory.h()));
        if (this.bT.f()) {
            this.gf();
        }
        return this.a(itemStack, false, true) != null;
    }

    @Override
    public void b(ItemStack stack) {
        if (!this.gK().g(stack)) {
            this.a(stack, false);
        }
    }

    public boolean aa() {
        return this.du;
    }

    @Override
    public Optional<WardenSpawnTracker> ab() {
        return Optional.of(this.dw);
    }

    public void b(boolean spawnExtraParticlesOnFall) {
        this.dv = spawnExtraParticlesOnFall;
    }

    @Override
    public void a(EntityItem itemEntity) {
        super.a(itemEntity);
        net.minecraft.world.entity.Entity owner = itemEntity.p();
        if (owner != null) {
            CriterionTriggers.T.a(this, itemEntity.e(), owner);
        }
    }

    public void a(RemoteChatSession chatSession) {
        this.dG = chatSession;
    }

    public @Nullable RemoteChatSession ac() {
        return this.dG != null && this.dG.b() ? null : this.dG;
    }

    @Override
    public void a(double xDistance, double zDistance) {
        this.cy = (float)(MathHelper.d(zDistance, xDistance) * 180.0 / 3.1415927410125732 - (double)this.ec());
        this.g.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force, boolean triggerEvents) {
        if (super.a(entity, force, triggerEvents)) {
            entity.k(this);
            this.g.a(new PositionMoveRotation(this.dI(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                this.cL.aj().a(livingEntity, this.g);
            }
            this.g.b(new PacketPlayOutMount(entity));
            return true;
        }
        return false;
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity vehicle = this.dz();
        super.removeVehicle(suppressCancellation);
        if (vehicle instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)vehicle;
            for (MobEffect mobEffectInstance : livingEntity.eW()) {
                this.g.b(new PacketPlayOutRemoveEntityEffect(vehicle.aA(), mobEffectInstance.c()));
            }
        }
        if (vehicle != null) {
            this.g.b(new PacketPlayOutMount(vehicle));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer level) {
        return new CommonPlayerSpawnInfo(level.ap(), level.aq(), BiomeManager.a(level.J()), this.h.b(), this.h.c(), level.ar(), level.I(), this.hk(), this.aN(), level.V());
    }

    public void c(BlockPosition raidOmenPosition) {
        this.dx = raidOmenPosition;
    }

    public void ae() {
        this.dx = null;
    }

    public @Nullable BlockPosition af() {
        return this.dx;
    }

    @Override
    public Vec3D ag() {
        net.minecraft.world.entity.Entity vehicle = this.dz();
        return vehicle != null && vehicle.dl() != this ? vehicle.ag() : this.dy;
    }

    @Override
    public Vec3D ah() {
        net.minecraft.world.entity.Entity vehicle = this.dz();
        return vehicle != null && vehicle.dl() != this ? vehicle.ah() : this.dy;
    }

    public void a(Vec3D knownMovement) {
        this.dy = knownMovement;
    }

    @Override
    protected float a(net.minecraft.world.entity.Entity entity, float damage, DamageSource damageSource) {
        return EnchantmentManager.a(this.A(), this.eq(), entity, damageSource, damage);
    }

    @Override
    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        super.a(item, slot);
        this.b(StatisticList.d.b(item));
    }

    public Input ai() {
        return this.dz;
    }

    public void a(Input lastClientInput) {
        this.dz = lastClientInput;
    }

    public Vec3D aj() {
        float f2;
        float f3 = this.dz.c() == this.dz.d() ? 0.0f : (f2 = this.dz.c() ? 1.0f : -1.0f);
        float f1 = this.dz.a() == this.dz.b() ? 0.0f : (this.dz.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.ec());
    }

    public void a(EntityEnderPearl enderPearl) {
        this.dA.add(enderPearl);
    }

    public void b(EntityEnderPearl enderPearl) {
        this.dA.remove(enderPearl);
    }

    public Set<EntityEnderPearl> ak() {
        return this.dA;
    }

    public NBTTagCompound al() {
        return this.dC;
    }

    public void b(NBTTagCompound tag) {
        this.dC = tag;
        this.b(EntityPlayer.d(tag));
    }

    public NBTTagCompound am() {
        return this.dD;
    }

    public void c(NBTTagCompound tag) {
        this.dD = tag;
        this.c(EntityPlayer.d(tag));
    }

    public long c(EntityEnderPearl enderPearl) {
        net.minecraft.world.level.World world = enderPearl.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ChunkCoordIntPair chunkPos = enderPearl.dM();
            this.a(enderPearl);
            serverLevel.l();
            return EntityPlayer.a(serverLevel, chunkPos) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer level, ChunkCoordIntPair pos) {
        if (!level.paperConfig().misc.legacyEnderPearlBehavior) {
            level.p().b(TicketType.n, pos, 2);
        }
        return TicketType.n.g();
    }

    public void a(Set<DebugSubscription<?>> subscriptions) {
        this.dI = Set.copyOf(subscriptions);
    }

    public Set<DebugSubscription<?>> an() {
        return !this.cL.bw().a(this) ? Set.of() : this.dI;
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.A().al() + this.timeOffset;
        }
        return this.A().al() - this.A().al() % 24000L + this.timeOffset;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weatherType != null) {
            return;
        }
        if (plugin) {
            this.weatherType = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weatherType == null) {
            if (oldRain != newRain) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weatherType == WeatherType.DOWNFALL || this.weatherType == null) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weatherType == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weatherType == WeatherType.DOWNFALL ? (this.pluginRainPosition += 0.01f) : (this.pluginRainPosition -= 0.01f);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weatherType = null;
        this.setPlayerWeather(this.A().D_().h() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.da() + " at " + this.dP() + "," + this.dR() + "," + this.dV() + ")";
    }

    @Override
    public boolean fE() {
        return super.fE() || this.g != null && this.g.isDisconnected();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.cu;
            this.newTotalExp = this.ct;
            this.newLevel = this.cs;
        }
        this.x(this.fq());
        this.gf();
        this.j(this.cJ());
        this.h(0);
        this.an = 0.0;
        this.co = new FoodMetaData();
        this.cs = this.newLevel;
        this.ct = this.newTotalExp;
        this.cu = 0.0f;
        this.bw = 0;
        this.p(0);
        this.bt = 0;
        this.setArrowCount(0, true);
        this.bs = 0;
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).cr = true;
        this.cn = this.cm;
        this.bH = null;
        ((EntityLiving)this).cs = null;
        ((EntityLiving)this).cn = new CombatTracker(this);
        this.cZ = -1;
        if (this.keepLevel) {
            this.cu = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.m(0.0, 0.0, 0.0);
        ((EntityLiving)this).cG = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public static final class RespawnConfig
    extends Record {
        private final WorldData.a b;
        private final boolean c;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldData.a.b.forGetter(RespawnConfig::a), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::b)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(WorldData.a respawnData, boolean forced) {
            this.b = respawnData;
            this.c = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig respawnConfig) {
            return respawnConfig != null ? respawnConfig.a().a() : net.minecraft.world.level.World.h;
        }

        public boolean a(@Nullable RespawnConfig respawnConfig) {
            return respawnConfig != null && this.b.c().equals(respawnConfig.b.c());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this, o2);
        }

        public WorldData.a a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }
    }

    public record RespawnResult(TeleportTransition transition, boolean isBedSpawn, boolean isAnchorSpawn) {
    }

    public record RespawnPosAngle(Vec3D a, float b, float c, boolean isBedSpawn, boolean isAnchorSpawn, @Nullable Runnable consumeAnchorCharge) {
        public static RespawnPosAngle of(Vec3D position, BlockPosition towardsPos, float pitch, boolean isBedSpawn, boolean isAnchorSpawn, @Nullable Runnable consumeAnchorCharge) {
            return new RespawnPosAngle(position, RespawnPosAngle.a(position, towardsPos), pitch, isBedSpawn, isAnchorSpawn, consumeAnchorCharge);
        }

        private static float a(Vec3D position, BlockPosition towardsPos) {
            Vec3D vec3 = Vec3D.c(towardsPos).d(position).d();
            return (float)MathHelper.g(MathHelper.d(vec3.i, vec3.g) * 180.0 / 3.1415927410125732 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn;consumeAnchorCharge", "a", "b", "c", "isBedSpawn", "isAnchorSpawn", "consumeAnchorCharge"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn;consumeAnchorCharge", "a", "b", "c", "isBedSpawn", "isAnchorSpawn", "consumeAnchorCharge"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn;consumeAnchorCharge", "a", "b", "c", "isBedSpawn", "isAnchorSpawn", "consumeAnchorCharge"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final Optional<ResourceKey<net.minecraft.world.level.World>> c;
        private final Optional<Vec3D> d;
        private final Optional<Vec2F> e;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.level.World.g.optionalFieldOf(EntityPlayer.f).forGetter(c::a), (App)Vec3D.a.optionalFieldOf("Pos").forGetter(c::b), (App)Vec2F.i.optionalFieldOf("Rotation").forGetter(c::c)).apply((Applicative)instance, c::new));
        public static final c b = new c(Optional.empty(), Optional.empty(), Optional.empty());

        public c(Optional<ResourceKey<net.minecraft.world.level.World>> dimension, Optional<Vec3D> position, Optional<Vec2F> rotation) {
            this.c = dimension;
            this.d = position;
            this.e = rotation;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this, o2);
        }

        public Optional<ResourceKey<net.minecraft.world.level.World>> a() {
            return this.c;
        }

        public Optional<Vec3D> b() {
            return this.d;
        }

        public Optional<Vec2F> c() {
            return this.e;
        }
    }
}

