/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityFireball;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.minecart.MinecartBehavior;
import net.minecraft.world.entity.vehicle.minecart.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 1;
    private static final double d = 7.62939453125E-6;
    public static final int a = 60;
    private static final int e = 400;
    private final WorldServer f;
    private final Entity g;
    private final int h;
    private final boolean i;
    private final a j;
    private final VecDeltaCodec k = new VecDeltaCodec();
    private byte l;
    private byte m;
    private byte n;
    private Vec3D o;
    private int p;
    private int q;
    private List<Entity> r = ImmutableList.of();
    private boolean s;
    private boolean t;
    private @Nullable List<DataWatcher.c<?>> u;
    private final Set<ServerPlayerConnection> trackedPlayers;
    private boolean forceStateResync;

    public EntityTrackerEntry(WorldServer level, Entity entity, int updateInterval, boolean trackDelta, a synchronizer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.f = level;
        this.j = synchronizer;
        this.g = entity;
        this.h = updateInterval;
        this.i = trackDelta;
        this.k.e(entity.dJ());
        this.o = entity.dN();
        this.l = MathHelper.e(entity.ec());
        this.m = MathHelper.e(entity.ee());
        this.n = MathHelper.e(entity.cS());
        this.t = entity.aV();
        this.u = entity.aD().c();
    }

    public void onPlayerAdd() {
        this.forceStateResync = true;
    }

    public void a() {
        Entity entity;
        if (this.g.moonrise$isHardColliding()) {
            this.q = 9999;
        }
        this.g.aI();
        List<Entity> passengers = this.g.dn();
        if (!passengers.equals(this.r)) {
            this.j.a(new PacketPlayOutMount(this.g), (EntityPlayer serverPlayer1) -> passengers.contains(serverPlayer1) == this.r.contains(serverPlayer1));
            entity = this.g;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.g.b(new PacketPlayOutMount(this.g));
            }
            this.r = passengers;
        }
        if (!this.trackedPlayers.isEmpty() && (entity = this.g) instanceof EntityItemFrame) {
            MapId mapId;
            WorldMap savedData;
            EntityItemFrame itemFrame = (EntityItemFrame)entity;
            ItemStack item = itemFrame.w();
            if (this.f.paperConfig().maps.itemFrameCursorUpdateInterval > 0 && this.p % this.f.paperConfig().maps.itemFrameCursorUpdateInterval == 0 && item.h() instanceof ItemWorldMap && (savedData = ItemWorldMap.a(mapId = itemFrame.cachedMapId, (World)this.f)) != null) {
                for (ServerPlayerConnection serverPlayerConnection : this.trackedPlayers) {
                    EntityPlayer serverPlayer = serverPlayerConnection.p();
                    savedData.a(serverPlayer, item);
                    Packet<?> updatePacket = savedData.a(mapId, serverPlayer);
                    if (updatePacket == null) continue;
                    serverPlayer.g.b(updatePacket);
                }
            }
            this.g();
        }
        if (this.forceStateResync || this.p % this.h == 0 || this.g.aF || this.g.aD().a()) {
            boolean flag;
            byte b2 = MathHelper.e(this.g.ec());
            byte b1 = MathHelper.e(this.g.ee());
            boolean bl = flag = Math.abs(b2 - this.l) >= 1 || Math.abs(b1 - this.m) >= 1;
            if (this.g.cq()) {
                if (flag) {
                    this.j.a(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.aA(), b2, b1, this.g.aV()));
                    this.l = b2;
                    this.m = b1;
                }
                this.k.e(this.g.dJ());
                this.g();
                this.s = true;
            } else {
                EntityMinecartAbstract abstractMinecart;
                MinecartBehavior minecartBehavior;
                Entity entity2 = this.g;
                if (entity2 instanceof EntityMinecartAbstract && (minecartBehavior = (abstractMinecart = (EntityMinecartAbstract)entity2).q()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior newMinecartBehavior = (NewMinecartBehavior)minecartBehavior;
                    this.a(newMinecartBehavior, b2, b1, flag);
                } else {
                    Vec3D deltaMovement;
                    double d2;
                    boolean flag5;
                    ++this.q;
                    Vec3D vec3D = this.g.dJ();
                    Vec3D base = this.k.b;
                    double vec3_dx = vec3D.g - base.g;
                    double vec3_dy = vec3D.h - base.h;
                    double vec3_dz = vec3D.i - base.i;
                    boolean flag1 = vec3_dx * vec3_dx + vec3_dy * vec3_dy + vec3_dz * vec3_dz >= 7.62939453125E-6;
                    Packet<PacketListenerPlayOut> packet = null;
                    boolean flag2 = flag1 || this.p % 60 == 0;
                    boolean flag3 = false;
                    boolean flag4 = false;
                    long l2 = this.k.a(vec3D);
                    long l1 = this.k.b(vec3D);
                    long l22 = this.k.c(vec3D);
                    boolean bl2 = flag5 = l2 < -32768L || l2 > 32767L || l1 < -32768L || l1 > 32767L || l22 < -32768L || l22 > 32767L;
                    if (this.forceStateResync || this.g.az() || flag5 || this.q > 400 || this.s || this.t != this.g.aV()) {
                        this.t = this.g.aV();
                        this.q = 0;
                        packet = ClientboundEntityPositionSyncPacket.a(this.g);
                        flag3 = true;
                        flag4 = true;
                    } else if (!(flag2 && flag || this.g instanceof EntityArrow)) {
                        if (flag2) {
                            packet = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.g.aA(), (short)l2, (short)l1, (short)l22, this.g.aV());
                            flag3 = true;
                        } else if (flag) {
                            packet = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.aA(), b2, b1, this.g.aV());
                            flag4 = true;
                        }
                    } else {
                        packet = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.g.aA(), (short)l2, (short)l1, (short)l22, b2, b1, this.g.aV());
                        flag3 = true;
                        flag4 = true;
                    }
                    if ((this.g.aF || this.i || this.g instanceof EntityLiving && ((EntityLiving)this.g).gj()) && ((d2 = (deltaMovement = this.g.dN()).g(this.o)) > 1.0E-7 || d2 > 0.0 && deltaMovement.h() == 0.0)) {
                        this.o = deltaMovement;
                        Entity entity3 = this.g;
                        if (entity3 instanceof EntityFireball) {
                            EntityFireball abstractHurtingProjectile = (EntityFireball)entity3;
                            this.j.a(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.g.aA(), this.o), new ClientboundProjectilePowerPacket(abstractHurtingProjectile.aA(), abstractHurtingProjectile.d))));
                        } else {
                            this.j.a(new PacketPlayOutEntityVelocity(this.g.aA(), this.o));
                        }
                    }
                    if (packet != null) {
                        this.j.a(packet);
                    }
                    this.g();
                    if (flag3) {
                        this.k.e(vec3D);
                    }
                    if (flag4) {
                        this.l = b2;
                        this.m = b1;
                    }
                    this.s = false;
                }
            }
            byte b22 = MathHelper.e(this.g.cS());
            if (Math.abs(b22 - this.n) >= 1) {
                this.j.a(new PacketPlayOutEntityHeadRotation(this.g, b22));
                this.n = b22;
            }
            this.g.aF = false;
            this.forceStateResync = false;
        }
        ++this.p;
        if (this.g.ah) {
            boolean cancelled = false;
            if (this.g instanceof EntityPlayer) {
                Vector velocity;
                Player player = (Player)this.g.getBukkitEntity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, (velocity = player.getVelocity()).clone());
                if (!event.callEvent()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (cancelled) {
                return;
            }
            this.g.ah = false;
            this.j.b(new PacketPlayOutEntityVelocity(this.g));
        }
    }

    private void a(NewMinecartBehavior behavior, byte yRot, byte xRot, boolean dirty) {
        this.g();
        if (behavior.e.isEmpty()) {
            boolean flag1;
            Vec3D deltaMovement = this.g.dN();
            double d2 = deltaMovement.g(this.o);
            Vec3D vec3 = this.g.dJ();
            boolean flag = this.k.d(vec3).h() >= 7.62939453125E-6;
            boolean bl = flag1 = flag || this.p % 60 == 0;
            if (flag1 || dirty || d2 > 1.0E-7) {
                this.j.a(new ClientboundMoveMinecartPacket(this.g.aA(), List.of(new NewMinecartBehavior.a(this.g.dI(), this.g.dN(), this.g.ec(), this.g.ee(), 1.0f))));
            }
        } else {
            this.j.a(new ClientboundMoveMinecartPacket(this.g.aA(), List.copyOf(behavior.e)));
            behavior.e.clear();
        }
        this.l = yRot;
        this.m = xRot;
        this.k.e(this.g.dI());
    }

    public void a(EntityPlayer player) {
        this.g.e(player);
        player.g.b(new PacketPlayOutEntityDestroy(this.g.aA()));
    }

    public void b(EntityPlayer player) {
        ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        this.a(player, list::add);
        player.g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        this.g.d(player);
    }

    public void a(EntityPlayer player, Consumer<Packet<PacketListenerPlayOut>> consumer) {
        Leashable leashable;
        Object syncableAttributes;
        Entity entity;
        this.g.aI();
        if (this.g.eh()) {
            return;
        }
        Packet<PacketListenerPlayOut> addEntityPacket = this.g.a(this);
        consumer.accept(addEntityPacket);
        if (this.u != null) {
            consumer.accept(new PacketPlayOutEntityMetadata(this.g.aA(), this.u));
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            syncableAttributes = livingEntity.fw().c();
            if (this.g.aA() == player.aA()) {
                ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth((Collection<AttributeModifiable>)syncableAttributes, false);
            }
            if (!syncableAttributes.isEmpty()) {
                consumer.accept(new PacketPlayOutUpdateAttributes(this.g.aA(), (Collection<AttributeModifiable>)syncableAttributes));
            }
        }
        if ((syncableAttributes = this.g) instanceof EntityLiving) {
            EntityLiving livingEntityx = (EntityLiving)syncableAttributes;
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                ItemStack itemBySlot = livingEntityx.a(equipmentSlot);
                if (itemBySlot.f()) continue;
                list.add(Pair.of((Object)equipmentSlot, (Object)itemBySlot.v()));
            }
            if (!list.isEmpty()) {
                consumer.accept(new PacketPlayOutEntityEquipment(this.g.aA(), list, true));
            }
            ((EntityLiving)this.g).K();
        }
        if (!this.g.dn().isEmpty()) {
            consumer.accept(new PacketPlayOutMount(this.g));
        }
        if (this.g.cq()) {
            consumer.accept(new PacketPlayOutMount(this.g.dz()));
        }
        if ((entity = this.g) instanceof Leashable && (leashable = (Leashable)((Object)entity)).S_()) {
            consumer.accept(new PacketPlayOutAttachEntity(this.g, leashable.C()));
        }
    }

    public Vec3D b() {
        return this.k.a();
    }

    public Vec3D c() {
        return this.o;
    }

    public float d() {
        return MathHelper.a(this.m);
    }

    public float e() {
        return MathHelper.a(this.l);
    }

    public float f() {
        return MathHelper.a(this.n);
    }

    private void g() {
        DataWatcher entityData = this.g.aD();
        List<DataWatcher.c<?>> list = entityData.b();
        if (list != null) {
            this.u = entityData.c();
            this.j.b(new PacketPlayOutEntityMetadata(this.g.aA(), list));
        }
        if (this.g instanceof EntityLiving) {
            Set<AttributeModifiable> attributesToSync = ((EntityLiving)this.g).fw().a();
            if (!attributesToSync.isEmpty()) {
                Entity entity = this.g;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    serverPlayer.getBukkitEntity().injectScaledMaxHealth(attributesToSync, false);
                }
                this.j.b(new PacketPlayOutUpdateAttributes(this.g.aA(), attributesToSync));
            }
            attributesToSync.clear();
        }
    }

    public static interface a {
        public void a(Packet<? super PacketListenerPlayOut> var1);

        public void b(Packet<? super PacketListenerPlayOut> var1);

        public void a(Packet<? super PacketListenerPlayOut> var1, Predicate<EntityPlayer> var2);
    }
}

