/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemChunkMap;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends SimpleRegionStorage
implements PlayerChunk.b,
GeneratingChunkMap,
ChunkSystemChunkMap {
    private static final ChunkResult<List<IChunkAccess>> d = ChunkResult.a("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> e = CompletableFuture.completedFuture(d);
    private static final byte f = -1;
    private static final byte g = 0;
    private static final byte h = 1;
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 200;
    private static final int k = 20;
    private static final int l = 10000;
    private static final int m = 128;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final WorldServer r;
    private final LightEngineThreaded s;
    private final IAsyncTaskHandler<Runnable> t;
    private final RandomState u;
    private final ChunkGeneratorStructureState v;
    private final TicketStorage w;
    private final VillagePlace x;
    public final LongSet y = new LongOpenHashSet();
    private boolean z;
    private final ChunkStatusUpdateListener C;
    public final a D;
    private final String E;
    private final PlayerMap F = new PlayerMap();
    public final Int2ObjectMap<EntityTracker> G = new Int2ObjectOpenHashMap();
    private final Long2ByteMap H = new Long2ByteOpenHashMap();
    public int M;
    public final WorldGenContext N;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public final void moonrise$writeFinishCallback(ChunkCoordIntPair pos) throws IOException {
        this.e(pos);
    }

    public PlayerChunkMap(WorldServer level, Convertable.ConversionSession levelStorageAccess, DataFixer fixerUpper, StructureTemplateManager structureManager, Executor dispatcher, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess lightChunk, ChunkGenerator generator, ChunkStatusUpdateListener chunkStatusListener, Supplier<WorldPersistentData> overworldDataStorage, TicketStorage ticketStorage, int serverViewDistance, boolean sync) {
        super(new RegionStorageInfo(levelStorageAccess.f(), level.aq(), "chunk"), levelStorageAccess.a(level.aq()).resolve("region"), fixerUpper, sync, DataFixTypes.d, PersistentStructureLegacy.a(level.aq(), overworldDataStorage, fixerUpper));
        Path dimensionPath = levelStorageAccess.a(level.aq());
        this.E = dimensionPath.getFileName().toString();
        this.r = level;
        IRegistryCustom registryAccess = level.J_();
        long seed = level.J();
        ChunkGenerator randomGenerator = generator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract noiseBasedChunkGenerator = (ChunkGeneratorAbstract)randomGenerator;
            this.u = RandomState.a(noiseBasedChunkGenerator.h().a(), registryAccess.f(Registries.bm), seed);
        } else {
            this.u = RandomState.a(GeneratorSettingBase.e(), registryAccess.f(Registries.bm), seed);
        }
        this.v = generator.createState(registryAccess.f(Registries.br), this.u, seed, level.spigotConfig);
        this.t = mainThreadExecutor;
        ConsecutiveExecutor consecutiveExecutor = new ConsecutiveExecutor(dispatcher, "worldgen");
        this.C = chunkStatusListener;
        ConsecutiveExecutor consecutiveExecutor1 = new ConsecutiveExecutor(dispatcher, "light");
        this.s = new LightEngineThreaded(lightChunk, this, this.r.F_().e(), consecutiveExecutor1, null);
        this.D = new a(ticketStorage, dispatcher, mainThreadExecutor);
        this.w = ticketStorage;
        this.x = new VillagePlace(new RegionStorageInfo(levelStorageAccess.f(), level.aq(), "poi"), dimensionPath.resolve("poi"), fixerUpper, sync, registryAccess, level.s(), level);
        this.a(serverViewDistance);
        this.N = new WorldGenContext(level, generator, structureManager, this.s, null, this::f);
    }

    private void f(ChunkCoordIntPair chunkPos) {
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.r.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.ay().f().ordinal();
        ReferenceList<EntityPlayer> inRange = this.r.moonrise$getNearbyPlayers().getPlayers(entity.dM(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = index;
            backingSet[i2].mobCounts[n2] = backingSet[i2].mobCounts[n2] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, EnumCreatureType mobCategory) {
        if (!this.r.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<EntityPlayer> inRange = this.r.moonrise$getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = idx;
            backingSet[i2].mobBackoffCounts[n2] = backingSet[i2].mobBackoffCounts[n2] + 1;
        }
    }

    public int getMobCountNear(EntityPlayer player, EnumCreatureType mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    protected ChunkGenerator a() {
        return this.N.b();
    }

    protected ChunkGeneratorStructureState b() {
        return this.v;
    }

    protected RandomState c() {
        return this.u;
    }

    public boolean a(EntityPlayer player, int x2, int z2) {
        return this.r.moonrise$getPlayerChunkLoader().isChunkSent(player, x2, z2);
    }

    private boolean b(EntityPlayer player, int x2, int z2) {
        return this.r.moonrise$getPlayerChunkLoader().isChunkSent(player, x2, z2, true);
    }

    protected LightEngineThreaded d() {
        return this.s;
    }

    public @Nullable PlayerChunk a(long chunkPos) {
        NewChunkHolder holder = this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    public @Nullable PlayerChunk b(long chunkPos) {
        NewChunkHolder holder = this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    public @Nullable ChunkStatus c(long chunkPos) {
        PlayerChunk visibleChunkIfPresent = this.b(chunkPos);
        return visibleChunkIfPresent != null ? visibleChunkIfPresent.u() : null;
    }

    protected IntSupplier d(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    public String a(ChunkCoordIntPair pos) {
        PlayerChunk visibleChunkIfPresent = this.b(pos.b());
        if (visibleChunkIfPresent == null) {
            return "null";
        }
        String string = visibleChunkIfPresent.j() + "\n";
        ChunkStatus latestStatus = visibleChunkIfPresent.u();
        IChunkAccess latestChunk = visibleChunkIfPresent.p();
        if (latestStatus != null) {
            string = string + "St: \u00a7" + latestStatus.b() + String.valueOf(latestStatus) + "\u00a7r\n";
        }
        if (latestChunk != null) {
            string = string + "Ch: \u00a7" + latestChunk.n().b() + String.valueOf(latestChunk.n()) + "\u00a7r\n";
        }
        FullChunkStatus fullStatus = visibleChunkIfPresent.s();
        string = string + "\u00a7" + fullStatus.ordinal() + String.valueOf((Object)fullStatus);
        return string + "\u00a7r";
    }

    CompletableFuture<ChunkResult<List<IChunkAccess>>> a(PlayerChunk chunkHolder, int range, IntFunction<ChunkStatus> statusGetter) {
        throw new UnsupportedOperationException();
    }

    public ReportedException a(IllegalStateException exception, String details) {
        StringBuilder stringBuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = chunk -> chunk.t().forEach(pair -> {
            ChunkStatus chunkStatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completableFuture = (CompletableFuture)pair.getSecond();
            if (completableFuture != null && completableFuture.isDone() && completableFuture.join() == null) {
                stringBuilder.append(chunk.r()).append(" - status: ").append(chunkStatus).append(" future: ").append(completableFuture).append(System.lineSeparator());
            }
        });
        stringBuilder.append("Updating:").append(System.lineSeparator());
        PlatformHooks.get().getUpdatingChunkHolders(this.r).forEach(consumer);
        stringBuilder.append("Visible:").append(System.lineSeparator());
        PlatformHooks.get().getVisibleChunkHolders(this.r).forEach(consumer);
        CrashReport crashReport = CrashReport.a(exception, "Chunk loading");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk loading");
        crashReportCategory.a("Details", details);
        crashReportCategory.a("Futures", stringBuilder);
        return new ReportedException(crashReport);
    }

    public CompletableFuture<ChunkResult<Chunk>> a(PlayerChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable PlayerChunk a(long chunkPos, int newLevel, @Nullable PlayerChunk holder, int oldLevel) {
        throw new UnsupportedOperationException();
    }

    private void a(ChunkCoordIntPair chunkPos, IntSupplier queueLevelGetter, int ticketLevel, IntConsumer queueLevelSetter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void a(boolean flush) {
        this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false, false);
    }

    protected void a(BooleanSupplier hasMoreTime) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("poi");
        this.x.a(hasMoreTime);
        profilerFiller.b("chunk_unload");
        if (!this.r.z()) {
            this.b(hasMoreTime);
        }
        profilerFiller.c();
    }

    public boolean e() {
        throw new UnsupportedOperationException();
    }

    private void b(BooleanSupplier hasMoreTime) {
        this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    private void c(BooleanSupplier hasMoreTime) {
        throw new UnsupportedOperationException();
    }

    private void a(long chunkPos, PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    protected boolean f() {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<IChunkAccess> g(ChunkCoordIntPair chunkPos) {
        throw new UnsupportedOperationException();
    }

    private IChunkAccess a(Throwable exception, ChunkCoordIntPair chunkPos) {
        boolean flag1;
        Throwable throwable;
        Throwable throwable2;
        if (exception instanceof CompletionException) {
            CompletionException completionException = (CompletionException)exception;
            v0 = completionException.getCause();
        } else {
            v0 = throwable2 = exception;
        }
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)throwable2;
            throwable = reportedException.getCause();
        } else {
            throwable = throwable2;
        }
        Throwable throwable1 = throwable;
        boolean flag = throwable1 instanceof Error;
        boolean bl = flag1 = throwable1 instanceof IOException || throwable1 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.r.s().a(throwable1, this.n(), chunkPos);
            return this.h(chunkPos);
        }
        CrashReport crashReport = CrashReport.a(exception, "Exception loading chunk");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk being loaded");
        crashReportCategory.a("pos", chunkPos);
        this.i(chunkPos);
        throw new ReportedException(crashReport);
    }

    private IChunkAccess h(ChunkCoordIntPair chunkPos) {
        this.i(chunkPos);
        return new ProtoChunk(chunkPos, ChunkConverter.a, this.r, this.r.at(), null);
    }

    private void i(ChunkCoordIntPair chunkPos) {
        this.H.put(chunkPos.b(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair chunkPos, ChunkType chunkType) {
        return this.H.put(chunkPos.b(), (byte)(chunkType == ChunkType.a ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder e(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void a(GenerationChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(GenerationChunkHolder chunk, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkGenerationTask a(ChunkStatus targetStatus, ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    private void a(ChunkGenerationTask task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void g() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> b(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    private void a(PlayerChunk chunkHolder, Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> c(PlayerChunk chunk) {
        throw new UnsupportedOperationException();
    }

    Stream<PlayerChunk> a(ChunkStatus status) {
        int i2 = ChunkLevel.a(status);
        return this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders().stream().filter(holder -> holder.j() <= i2);
    }

    private boolean a(PlayerChunk chunk, long gameTime) {
        throw new UnsupportedOperationException();
    }

    public boolean a(IChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean j(ChunkCoordIntPair chunkPos) {
        throw new UnsupportedOperationException();
    }

    public void a(int viewDistance) {
        int clamped = MathHelper.a(viewDistance, 2, MoonriseConstants.MAX_VIEW_DISTANCE);
        if (clamped == this.M) {
            return;
        }
        this.M = clamped;
        this.r.moonrise$getPlayerChunkLoader().setLoadDistance(this.M + 1);
    }

    int b(EntityPlayer player) {
        return PlatformHooks.get().getSendViewDistance(player);
    }

    private void a(EntityPlayer player, ChunkCoordIntPair chunkPos) {
        throw new UnsupportedOperationException();
    }

    private static void a(EntityPlayer player, Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void b(EntityPlayer player, ChunkCoordIntPair chunkPos) {
    }

    @Override
    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair pos) {
        CompletableFuture<Optional<NBTTagCompound>> ret = new CompletableFuture<Optional<NBTTagCompound>>();
        MoonriseRegionFileIO.loadDataAsync(this.r, pos.h, pos.i, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (data, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(Optional.ofNullable(data));
            }
        }, false);
        return ret;
    }

    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair pos, Supplier<NBTTagCompound> tag) {
        MoonriseRegionFileIO.scheduleSave(this.r, pos.h, pos.i, tag.get(), MoonriseRegionFileIO.RegionFileType.CHUNK_DATA);
        return null;
    }

    @Override
    public CompletableFuture<Void> b(boolean flush) {
        try {
            MoonriseRegionFileIO.flush(this.r);
            if (flush) {
                MoonriseRegionFileIO.flushRegionStorages(this.r);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    public @Nullable Chunk f(long chunkPos) {
        PlayerChunk visibleChunkIfPresent = this.b(chunkPos);
        return visibleChunkIfPresent == null ? null : visibleChunkIfPresent.e();
    }

    public int h() {
        return PlatformHooks.get().getVisibleChunkHolderCount(this.r);
    }

    public ChunkMapDistance i() {
        return this.D;
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        for (PlayerChunk entry : PlatformHooks.get().getVisibleChunkHolders(this.r)) {
            long longKey = entry.d.b();
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(longKey);
            PlayerChunk chunkHolder = entry;
            Optional<IChunkAccess> optional = Optional.ofNullable(chunkHolder.p());
            Optional<Object> optional1 = optional.flatMap(chunk -> chunk instanceof Chunk ? Optional.of((Chunk)chunk) : Optional.empty());
            csvOutput.a(chunkPos.h, chunkPos.i, chunkHolder.j(), optional.isPresent(), optional.map(IChunkAccess::n).orElse(null), optional1.map(Chunk::G).orElse(null), PlayerChunkMap.a(chunkHolder.c()), PlayerChunkMap.a(chunkHolder.a()), PlayerChunkMap.a(chunkHolder.b()), this.w.b(longKey, false), this.b(chunkPos), optional1.map(chunk -> chunk.J().size()).orElse(0), this.w.b(longKey, true), this.D.a(longKey, true), optional1.map(chunk -> chunk.q().a()).orElse(0), optional1.map(chunk -> chunk.r().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<ChunkResult<Chunk>> future) {
        try {
            ChunkResult chunkResult = future.getNow(null);
            if (chunkResult != null) {
                return chunkResult.a() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException var2) {
            return "failed " + var2.getCause().getMessage();
        }
        catch (CancellationException var3) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> k(ChunkCoordIntPair pos) {
        return this.d(pos).thenApplyAsync(optional -> optional.map(this::a), SystemUtils.h().a("upgradeChunk"));
    }

    public NBTTagCompound a(NBTTagCompound tag) {
        return this.upgradeChunkTag(tag, -1, PlayerChunkMap.a(this.r.getTypeKey(), this.a().c()), this.r);
    }

    public static NBTTagCompound a(ResourceKey<WorldDimension> stemKey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> generator) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("dimension", stemKey.a().toString());
        generator.ifPresent(resourceKey -> compoundTag.a("generator", resourceKey.a().toString()));
        return compoundTag;
    }

    private boolean isChunkNearPlayer(PlayerChunkMap chunkMap, ChunkCoordIntPair chunkPos, Chunk levelChunk) {
        ChunkData chunkData = levelChunk.moonrise$getChunkHolder().holderData;
        NearbyPlayers.TrackedChunk nearbyPlayers = chunkData.nearbyPlayers;
        if (nearbyPlayers == null) {
            return false;
        }
        ReferenceList<EntityPlayer> players = nearbyPlayers.getPlayers(NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            double blockRange;
            PlayerNaturallySpawnCreaturesEvent event = raw[i2].playerNaturallySpawnedEvent;
            if (event == null || event.isCancelled() || !chunkMap.playerIsCloseEnoughForSpawning(raw[i2], chunkPos, blockRange = (double)((event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4)))) continue;
            return true;
        }
        return false;
    }

    void a(List<Chunk> output) {
        ReferenceList<Chunk> tickingChunks = this.r.moonrise$getPlayerTickingChunks();
        Chunk[] raw = tickingChunks.getRawDataUnchecked();
        int size = tickingChunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        for (int i2 = 0; i2 < size; ++i2) {
            Chunk levelChunk = raw[i2];
            if (!this.isChunkNearPlayer(this, levelChunk.f(), levelChunk)) continue;
            output.add(levelChunk);
        }
    }

    void a(Consumer<Chunk> action) {
        this.D.a(chunkPos -> {
            Chunk tickingChunk;
            PlayerChunk chunkHolder = this.b(chunkPos);
            if (chunkHolder != null && (tickingChunk = chunkHolder.d()) != null) {
                action.accept(tickingChunk);
            }
        });
    }

    public boolean b(ChunkCoordIntPair chunkPos) {
        return this.anyPlayerCloseEnoughForSpawning(chunkPos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkPos, boolean reducedRange) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkPos, reducedRange);
    }

    boolean a(BlockPosition pos, int radius) {
        Vec3D vec3 = new Vec3D(pos);
        for (EntityPlayer serverPlayer : this.F.a()) {
            if (!this.a(serverPlayer, vec3, radius)) continue;
            return true;
        }
        return false;
    }

    private boolean l(ChunkCoordIntPair chunkPos) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkPos, false);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkCoordIntPair chunkPos, boolean reducedRange) {
        ReferenceList<EntityPlayer> players = this.r.moonrise$getNearbyPlayers().getPlayers(chunkPos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            EntityPlayer serverPlayer = raw[i2];
            double blockRange = 16384.0;
            if (reducedRange) {
                PlayerNaturallySpawnCreaturesEvent event = serverPlayer.playerNaturallySpawnedEvent;
                if (event == null || event.isCancelled()) continue;
                blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
            }
            if (!this.playerIsCloseEnoughForSpawning(serverPlayer, chunkPos, blockRange)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> c(ChunkCoordIntPair chunkPos) {
        ReferenceList<EntityPlayer> players = this.r.moonrise$getNearbyPlayers().getPlayers(chunkPos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return new ArrayList<EntityPlayer>();
        }
        ArrayList<EntityPlayer> ret = null;
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            EntityPlayer player = raw[i2];
            if (!this.playerIsCloseEnoughForSpawning(player, chunkPos, 16384.0)) continue;
            if (ret == null) {
                ret = new ArrayList(len - i2);
                ret.add(player);
                continue;
            }
            ret.add(player);
        }
        return ret == null ? new ArrayList<EntityPlayer>() : ret;
    }

    public boolean playerIsCloseEnoughForSpawning(EntityPlayer player, ChunkCoordIntPair chunkPos, double range) {
        if (player.au()) {
            return false;
        }
        double d2 = PlayerChunkMap.a(chunkPos, player.dI());
        return d2 < range;
    }

    private boolean a(EntityPlayer player, Vec3D pos, int radius) {
        if (player.au()) {
            return false;
        }
        double d2 = player.dI().f(pos);
        return d2 < (double)radius;
    }

    private static double a(ChunkCoordIntPair chunkPos, Vec3D pos) {
        double d2 = SectionPosition.a(chunkPos.h, 8);
        double d1 = SectionPosition.a(chunkPos.i, 8);
        double d22 = d2 - pos.g;
        double d3 = d1 - pos.i;
        return d22 * d22 + d3 * d3;
    }

    private boolean c(EntityPlayer player) {
        return player.au() && this.r.U().a(GameRules.ab) == false;
    }

    void a(EntityPlayer player, boolean track) {
        boolean flag = this.c(player);
        boolean flag1 = this.F.d(player);
        if (track) {
            this.F.a(player, flag);
            this.d(player);
            if (!flag) {
                this.D.a(SectionPosition.a(player), player);
                this.D.moonrise$addPlayer(player, SectionPosition.a(player));
            }
            player.a(ChunkTrackingView.a);
            PlatformHooks.get().addPlayerToDistanceMaps(this.r, player);
        } else {
            SectionPosition lastSectionPos = player.W();
            this.F.a(player);
            if (!flag1) {
                this.D.b(lastSectionPos, player);
                this.D.moonrise$removePlayer(player, SectionPosition.a(player));
            }
            PlatformHooks.get().removePlayerFromDistanceMaps(this.r, player);
        }
    }

    private void d(EntityPlayer player) {
        SectionPosition sectionPos = SectionPosition.a(player);
        player.a(sectionPos);
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        SectionPosition lastSectionPos = player.W();
        SectionPosition sectionPos = SectionPosition.a(player);
        boolean flag = this.F.e(player);
        boolean flag1 = this.c(player);
        boolean bl = flag2 = lastSectionPos.s() != sectionPos.s();
        if (flag2 || flag != flag1) {
            this.d(player);
            this.D.moonrise$updatePlayer(player, lastSectionPos, sectionPos, flag, flag1);
            if (!flag) {
                this.D.b(lastSectionPos, player);
            }
            if (!flag1) {
                this.D.a(sectionPos, player);
            }
            if (!flag && flag1) {
                this.F.b(player);
            }
            if (flag && !flag1) {
                this.F.c(player);
            }
        }
        PlatformHooks.get().updateMaps(this.r, player);
    }

    private void e(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void a(EntityPlayer player, ChunkTrackingView chunkTrackingView) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair pos, boolean boundaryOnly) {
        PlayerChunk holder = this.b(pos.b());
        if (holder == null) {
            return new ArrayList<EntityPlayer>();
        }
        return holder.moonrise$getPlayers(boundaryOnly);
    }

    public void a(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.ao() != this.r || this.G.containsKey(entity.aA())) {
            i.error("Illegal ChunkMap::addEntity for world " + this.r.getWorld().getName() + ": " + String.valueOf(entity) + (this.G.containsKey(entity.aA()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).suppressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> type = entity.ay();
            int i2 = type.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int updateInterval = type.p();
                if (this.G.containsKey(entity.aA())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker trackedEntity = new EntityTracker(entity, i2, updateInterval, type.q());
                this.G.put(entity.aA(), (Object)trackedEntity);
                if (entity.moonrise$getTrackedEntity() != null) {
                    throw new IllegalStateException("Entity is already tracked");
                }
                entity.moonrise$setTrackedEntity(trackedEntity);
                trackedEntity.a(this.r.E());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    this.a(serverPlayer, true);
                    for (EntityTracker trackedEntity1 : this.G.values()) {
                        if (trackedEntity1.c == serverPlayer) continue;
                        trackedEntity1.b(serverPlayer);
                    }
                }
            }
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity) {
        EntityTracker trackedEntity1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            this.a(serverPlayer, false);
            for (EntityTracker trackedEntity : this.G.values()) {
                trackedEntity.a(serverPlayer);
            }
        }
        if ((trackedEntity1 = (EntityTracker)this.G.remove(entity.aA())) != null) {
            trackedEntity1.a();
        }
        entity.moonrise$setTrackedEntity(null);
    }

    private void newTrackerTick() {
        ServerEntityLookup entityLookup = (ServerEntityLookup)this.r.moonrise$getEntityLookup();
        ReferenceList<net.minecraft.world.entity.Entity> trackerEntities = entityLookup.trackerEntities;
        net.minecraft.world.entity.Entity[] trackerEntitiesRaw = trackerEntities.getRawDataUnchecked();
        int len = trackerEntities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = trackerEntitiesRaw[i2];
            EntityTracker tracker = entity.moonrise$getTrackedEntity();
            if (tracker == null) continue;
            tracker.moonrise$tick(entity.moonrise$getChunkData().nearbyPlayers);
            if (!tracker.moonrise$hasPlayers() && !entity.moonrise$getChunkStatus().a(FullChunkStatus.d)) continue;
            tracker.b.a();
        }
    }

    protected void j() {
        this.newTrackerTick();
    }

    public void a(net.minecraft.world.entity.Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        EntityTracker trackedEntity = (EntityTracker)this.G.get(entity.aA());
        if (trackedEntity != null) {
            trackedEntity.a(packet);
        }
    }

    public void a(net.minecraft.world.entity.Entity entity, Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> filter) {
        EntityTracker trackedEntity = (EntityTracker)this.G.get(entity.aA());
        if (trackedEntity != null) {
            trackedEntity.a(packet, filter);
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        EntityTracker trackedEntity = (EntityTracker)this.G.get(entity.aA());
        if (trackedEntity != null) {
            trackedEntity.b(packet);
        }
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        EntityTracker trackedEntity = (EntityTracker)this.G.get(entity.aA());
        return trackedEntity != null && !trackedEntity.f.isEmpty();
    }

    public void a(EntityPlayer player, Consumer<net.minecraft.world.entity.Entity> action) {
        for (EntityTracker trackedEntity : this.G.values()) {
            if (!trackedEntity.f.contains(player.g)) continue;
            action.accept(trackedEntity.c);
        }
    }

    public void b(List<IChunkAccess> chunks) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess chunkAccess : chunks) {
            Chunk levelChunk;
            ChunkCoordIntPair pos = chunkAccess.f();
            Chunk levelChunk1 = chunkAccess instanceof Chunk ? (levelChunk = (Chunk)chunkAccess) : this.r.d(pos.h, pos.i);
            for (EntityPlayer serverPlayer : this.a(pos, false)) {
                map.computeIfAbsent(serverPlayer, serverPlayer1 -> new ArrayList()).add(levelChunk1);
            }
        }
        map.forEach((serverPlayer1, list) -> serverPlayer1.g.b(ClientboundChunksBiomesPacket.a(list)));
    }

    protected VillagePlace k() {
        return this.x;
    }

    public String l() {
        return this.E;
    }

    void a(ChunkCoordIntPair chunkPos, FullChunkStatus fullChunkStatus) {
        this.C.onChunkStatusChange(chunkPos, fullChunkStatus);
    }

    public void a(ChunkCoordIntPair chunkPos, int range) {
    }

    public void b(Consumer<Chunk> action) {
        for (PlayerChunk chunkHolder : this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders()) {
            Chunk chunkToSend = chunkHolder.e();
            if (chunkToSend == null) continue;
            action.accept(chunkToSend);
        }
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    public class a
    extends ChunkMapDistance
    implements ChunkSystemDistanceManager {
        protected a(TicketStorage ticketStorage, Executor dispatcher, Executor mainThreadExecutor) {
            super(ticketStorage, dispatcher, mainThreadExecutor);
        }

        @Override
        public final PlayerChunkMap moonrise$getChunkMap() {
            return PlayerChunkMap.this;
        }

        @Override
        protected boolean a(long chunkPos) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected @Nullable PlayerChunk b(long chunkPos) {
            return PlayerChunkMap.this.a(chunkPos);
        }

        @Override
        protected @Nullable PlayerChunk a(long chunkPos, int newLevel, @Nullable PlayerChunk holder, int oldLevel) {
            return PlayerChunkMap.this.a(chunkPos, newLevel, holder, oldLevel);
        }
    }

    public class EntityTracker
    implements EntityTrackerEntry.a,
    EntityTrackerTrackedEntity {
        public final EntityTrackerEntry b;
        final net.minecraft.world.entity.Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        private long lastChunkUpdate = -1L;
        private NearbyPlayers.TrackedChunk lastTrackedChunk;

        @Override
        public final void moonrise$tick(NearbyPlayers.TrackedChunk chunk) {
            EntityPlayer player;
            if (chunk == null) {
                this.moonrise$clearPlayers();
                return;
            }
            ReferenceList<EntityPlayer> players = chunk.getPlayers(NearbyPlayers.NearbyMapType.VIEW_DISTANCE);
            if (players == null) {
                this.moonrise$clearPlayers();
                return;
            }
            long lastChunkUpdate = this.lastChunkUpdate;
            long currChunkUpdate = chunk.getUpdateCount();
            NearbyPlayers.TrackedChunk lastTrackedChunk = this.lastTrackedChunk;
            this.lastChunkUpdate = currChunkUpdate;
            this.lastTrackedChunk = chunk;
            EntityPlayer[] playersRaw = players.getRawDataUnchecked();
            int len = players.size();
            for (int i2 = 0; i2 < len; ++i2) {
                player = playersRaw[i2];
                this.b(player);
            }
            if (lastChunkUpdate != currChunkUpdate || lastTrackedChunk != chunk) {
                for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                    player = conn.p();
                    if (players.contains(player)) continue;
                    this.a(player);
                }
            }
        }

        @Override
        public final void moonrise$removeNonTickThreadPlayers() {
            boolean foundToRemove = false;
            for (ServerPlayerConnection conn : this.f) {
                if (TickThread.isTickThreadFor(conn.p())) continue;
                foundToRemove = true;
                break;
            }
            if (!foundToRemove) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                EntityPlayer player = conn.p();
                if (TickThread.isTickThreadFor(player)) continue;
                this.a(player);
            }
        }

        @Override
        public final void moonrise$clearPlayers() {
            this.lastChunkUpdate = -1L;
            this.lastTrackedChunk = null;
            if (this.f.isEmpty()) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                EntityPlayer player = conn.p();
                this.a(player);
            }
        }

        @Override
        public final boolean moonrise$hasPlayers() {
            return !this.f.isEmpty();
        }

        public EntityTracker(net.minecraft.world.entity.Entity entity, int range, int updateInterval, boolean trackDelta) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.r, entity, updateInterval, trackDelta, this, this.f);
            this.c = entity;
            this.d = range;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object other) {
            return other instanceof EntityTracker && ((EntityTracker)other).c.aA() == this.c.aA();
        }

        public int hashCode() {
            return this.c.aA();
        }

        @Override
        public void a(Packet<? super PacketListenerPlayOut> packet) {
            for (ServerPlayerConnection serverPlayerConnection : this.f) {
                serverPlayerConnection.b(packet);
            }
        }

        @Override
        public void b(Packet<? super PacketListenerPlayOut> packet) {
            this.a(packet);
            net.minecraft.world.entity.Entity entity = this.c;
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                serverPlayer.g.b(packet);
            }
        }

        @Override
        public void a(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> filter) {
            for (ServerPlayerConnection serverPlayerConnection : this.f) {
                if (!filter.test(serverPlayerConnection.p())) continue;
                serverPlayerConnection.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverPlayerConnection : this.f) {
                this.b.a(serverPlayerConnection.p());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.g)) {
                this.b.a(player);
                if (this.f.isEmpty()) {
                    PlayerChunkMap.this.r.W().b(this.c);
                }
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double rangeY;
                boolean flag;
                double vec3_dx = player.dP() - this.c.dP();
                double vec3_dz = player.dV() - this.c.dV();
                int playerViewDistance = PlayerChunkMap.this.b(player);
                double d1 = vec3_dx * vec3_dx + vec3_dz * vec3_dz;
                double d2 = Math.min(this.b(), playerViewDistance * 16);
                double d22 = d2 * d2;
                boolean bl = flag = d1 <= d22;
                if (flag && PlayerChunkMap.this.r.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)PlayerChunkMap.this.r.paperConfig().entities.trackingRangeY.get(this.c, -1)) != -1.0) {
                    double vec3_dy = player.dR() - this.c.dR();
                    flag = vec3_dy * vec3_dy <= rangeY * rangeY;
                }
                boolean bl2 = flag = flag && this.c.a(player) && PlayerChunkMap.this.a(player, this.c.dM().h, this.c.dM().i);
                if (flag && !player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.g)) {
                        if (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.c.getBukkitEntity()).callEvent()) {
                            this.b.b(player);
                            if (this.f.size() == 1) {
                                PlayerChunkMap.this.r.W().a(this.c);
                            }
                            PlayerChunkMap.this.r.W().a(player, this.c);
                        }
                        this.b.onPlayerAdd();
                    }
                } else {
                    this.a(player);
                }
            }
        }

        private int a(int trackingDistance) {
            return PlayerChunkMap.this.r.s().c(trackingDistance);
        }

        private int b() {
            net.minecraft.world.entity.Entity entity = this.c;
            int range = this.d;
            if (entity.dn() == ImmutableList.of()) {
                return this.a(range);
            }
            List passengers = (List)entity.dr();
            int len = passengers.size();
            for (int i2 = 0; i2 < len; ++i2) {
                net.minecraft.world.entity.Entity passenger = (net.minecraft.world.entity.Entity)passengers.get(i2);
                range = Math.max(range, PlatformHooks.get().modifyEntityTrackingRange(passenger, passenger.ay().o() << 4));
            }
            return this.a(range);
        }

        public void a(List<EntityPlayer> playersList) {
            for (EntityPlayer serverPlayer : playersList) {
                this.b(serverPlayer);
            }
        }
    }
}

