/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.util.MCUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final double a = 1.0;
    private static final Logger b = LogUtils.getLogger();
    public WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode e = EnumGamemode.e;
    private @Nullable EnumGamemode f;
    private boolean g;
    private int h;
    private BlockPosition i = BlockPosition.c;
    private int j;
    private boolean k;
    private BlockPosition l = BlockPosition.c;
    private int m;
    private int n = -1;
    public boolean captureSentBlockEntities = false;
    public boolean capturedBlockEntity = false;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer player) {
        this.d = player;
        this.c = player.A();
    }

    @Deprecated
    @DoNotUse
    public boolean a(EnumGamemode gameModeForPlayer) {
        PlayerGameModeChangeEvent event = this.changeGameModeForPlayer(gameModeForPlayer, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && !event.isCancelled();
    }

    public @Nullable PlayerGameModeChangeEvent changeGameModeForPlayer(EnumGamemode gameModeForPlayer, PlayerGameModeChangeEvent.Cause playerGameModeChangeCause, @Nullable Component cancelMessage) {
        if (gameModeForPlayer == this.e) {
            return null;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)gameModeForPlayer.a()), playerGameModeChangeCause, cancelMessage);
        if (!event.callEvent()) {
            return event;
        }
        PlayerAbilities abilities = this.d.gL();
        this.a(gameModeForPlayer, this.e);
        if (abilities.b && gameModeForPlayer != EnumGamemode.d && this.f()) {
            abilities.b = false;
        }
        this.d.z();
        this.c.s().aj().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.c, this.d), this.d);
        this.c.h();
        if (gameModeForPlayer == EnumGamemode.b) {
            this.d.hr();
        }
        return event;
    }

    protected void a(EnumGamemode gameModeForPlayer, @Nullable EnumGamemode previousGameModeForPlayer) {
        this.f = previousGameModeForPlayer;
        this.e = gameModeForPlayer;
        PlayerAbilities abilities = this.d.gL();
        gameModeForPlayer.a(abilities);
    }

    private boolean f() {
        List<VoxelShape> list = Entity.a((Entity)this.d, this.c, this.d.dj());
        return list.isEmpty() && this.d.b(1.0) < 1.0;
    }

    public EnumGamemode b() {
        return this.e;
    }

    public @Nullable EnumGamemode c() {
        return this.f;
    }

    public boolean d() {
        return this.e.h();
    }

    public boolean e() {
        return this.e.g();
    }

    public void a() {
        this.j = (int)this.c.getLagCompensationTick();
        if (this.k) {
            IBlockData blockState = this.c.getBlockStateIfLoaded(this.l);
            if (blockState == null || blockState.l()) {
                this.k = false;
            } else {
                float f2 = this.a(blockState, this.l, this.m);
                if (f2 >= 1.0f) {
                    this.k = false;
                    this.a(this.l);
                }
            }
        } else if (this.g) {
            IBlockData blockState = this.c.getBlockStateIfLoaded(this.i);
            if (blockState == null) {
                this.g = false;
                return;
            }
            if (blockState.l()) {
                this.c.a(this.d.aA(), this.i, -1);
                this.n = -1;
                this.g = false;
            } else {
                this.a(blockState, this.i, this.h);
            }
        }
    }

    private float a(IBlockData state, BlockPosition pos, int startTick) {
        int i2 = this.j - startTick;
        float f2 = state.a(this.d, this.d.A(), pos) * (float)(i2 + 1);
        int i1 = (int)(f2 * 10.0f);
        if (i1 != this.n) {
            this.c.a(this.d.aA(), pos, i1);
            this.n = i1;
        }
        return f2;
    }

    private void a(BlockPosition pos, boolean terminate, int sequence, String message) {
        if (SharedConstants.U) {
            b.debug("Server ACK {} {} {} {}", new Object[]{sequence, pos, terminate, message});
        }
    }

    public void a(BlockPosition pos, PacketPlayInBlockDig.EnumPlayerDigType action, EnumDirection face, int maxBuildHeight, int sequence) {
        if (!this.d.a(pos, 1.0)) {
            return;
        }
        if (pos.v() > maxBuildHeight) {
            this.d.g.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
            this.a(pos, false, sequence, "too high");
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((Entity)this.d, pos)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, face, this.d.gK().h(), EnumHand.a);
                this.d.g.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
                this.a(pos, false, sequence, "may not interact");
                this.capturedBlockEntity = true;
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, face, this.d.gK().h(), EnumHand.a);
            if (event.isCancelled()) {
                this.capturedBlockEntity = true;
                return;
            }
            if (this.d.gL().d) {
                this.a(pos, sequence, "creative destroy");
                return;
            }
            if (this.d.fx().a(Items.xU) && ((ItemDebugStick)Items.xU).a(this.d, this.c.a_(pos), this.c, pos, false, this.d.fx())) {
                return;
            }
            if (this.d.a((World)this.c, pos, this.e)) {
                this.d.g.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
                this.a(pos, false, sequence, "block action restricted");
                return;
            }
            this.h = this.j;
            float f2 = 1.0f;
            IBlockData blockState = this.c.a_(pos);
            if (event.useInteractedBlock() != Event.Result.DENY && !blockState.l()) {
                EnchantmentManager.a(this.c, this.d.fx(), this.d, this.d, EnumItemSlot.a, Vec3D.b(pos), blockState, item -> this.d.a((Item)item, EnumItemSlot.a));
                blockState.a((World)this.c, pos, this.d);
                f2 = blockState.a(this.d, this.d.A(), pos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, pos, face, this.d.gK().h(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!blockState.l() && f2 >= 1.0f) {
                this.a(pos, sequence, "insta mine");
            } else {
                if (this.g) {
                    this.d.g.b(new PacketPlayOutBlockChange(this.i, this.c.a_(this.i)));
                    this.a(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.g = true;
                this.i = pos.j();
                int i2 = (int)(f2 * 10.0f);
                this.c.a(this.d.aA(), pos, i2);
                this.a(pos, true, sequence, "actual start of destroying");
                this.n = i2;
            }
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (pos.equals(this.i)) {
                int i1 = this.j - this.h;
                IBlockData blockStatex = this.c.a_(pos);
                if (!blockStatex.l()) {
                    float f1 = blockStatex.a(this.d, this.d.A(), pos) * (float)(i1 + 1);
                    if (f1 >= 0.7f) {
                        this.g = false;
                        this.c.a(this.d.aA(), pos, -1);
                        this.a(pos, sequence, "destroyed");
                        return;
                    }
                    if (!this.k) {
                        this.g = false;
                        this.k = true;
                        this.l = pos;
                        this.m = this.h;
                    }
                }
            }
            this.a(pos, true, sequence, "stopped destroying");
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.g = false;
            if (!Objects.equals(this.i, pos) && !BlockPosition.c.equals(this.i)) {
                b.debug("Mismatch in destroy block pos: {} {}", (Object)this.i, (Object)pos);
                IBlockData type = this.c.getBlockStateIfLoaded(this.i);
                if (type != null) {
                    this.c.a(this.d.aA(), this.i, -1);
                    this.a(pos, true, sequence, "aborted mismatched destroying");
                }
                this.i = BlockPosition.c;
            }
            this.c.a(this.d.aA(), pos, -1);
            this.a(pos, true, sequence, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.d, pos, this.d.gK().h());
        }
        this.c.chunkPacketBlockController.onPlayerLeftClickBlock(this, pos, action, face, maxBuildHeight, sequence);
    }

    public void a(BlockPosition pos, int sequence, String message) {
        if (this.a(pos)) {
            this.a(pos, true, sequence, message);
        } else {
            this.d.g.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
            this.a(pos, false, sequence, message);
        }
    }

    public boolean a(BlockPosition pos) {
        IBlockData blockState = this.c.a_(pos);
        CraftBlock bblock = CraftBlock.at(this.c, pos);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean canAttackBlock = !this.d.fx().a(blockState, this.c, pos, (EntityHuman)this.d);
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(canAttackBlock);
            IBlockData updatedBlockState = this.c.a_(pos);
            Block block = updatedBlockState.b();
            if (!event.isCancelled() && !this.e() && this.d.d(block.m())) {
                ItemStack itemInHand = this.d.a(EnumItemSlot.a);
                event.setExpToDrop(block.getExpDrop(updatedBlockState, this.c, pos, itemInHand, true));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (canAttackBlock) {
                    return false;
                }
                if (!this.captureSentBlockEntities) {
                    TileEntity blockEntity = this.c.c_(pos);
                    if (blockEntity != null) {
                        this.d.g.b(blockEntity.ax_());
                    }
                } else {
                    this.capturedBlockEntity = true;
                }
                return false;
            }
        }
        if ((blockState = this.c.a_(pos)).l()) {
            return false;
        }
        TileEntity blockEntity = this.c.c_(pos);
        Block block = blockState.b();
        if (!(!(block instanceof GameMasterBlock) || this.d.hi() || block instanceof BlockCommand && this.d.ha() && this.d.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.c.a(pos, blockState, blockState, 3);
            return false;
        }
        if (this.d.a((World)this.c, pos, this.e)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList<EntityItem>();
        IBlockData blockState1 = block.a((World)this.c, pos, blockState, this.d);
        boolean flag = this.c.a(pos, false);
        if (SharedConstants.U) {
            b.info("server broke {} {} -> {}", new Object[]{pos, blockState1, this.c.a_(pos)});
        }
        if (flag) {
            block.a((GeneratorAccess)this.c, pos, blockState1);
        }
        ItemStack mainHandStack = null;
        boolean isCorrectTool = false;
        if (!this.d.gM()) {
            ItemStack mainHandItem = this.d.fx();
            ItemStack itemStack = mainHandItem.v();
            boolean hasCorrectToolForDrops = this.d.d(blockState1);
            mainHandStack = itemStack;
            isCorrectTool = hasCorrectToolForDrops;
            mainHandItem.a(this.c, blockState1, pos, (EntityHuman)this.d);
            if (flag && hasCorrectToolForDrops) {
                block.playerDestroy(this.c, this.d, pos, blockState1, blockEntity, itemStack, event.isDropItems(), false);
            }
        }
        List<EntityItem> itemsToDrop = this.c.captureDrops;
        this.c.captureDrops = null;
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, itemsToDrop);
        }
        if (flag) {
            blockState.b().popExperience(this.c, pos, event.getExpToDrop(), this.d);
        }
        if (mainHandStack != null && flag && isCorrectTool && event.isDropItems() && block instanceof BlockBeehive && blockEntity instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)blockEntity;
            CriterionTriggers.M.a(this.d, blockState, mainHandStack, beehiveBlockEntity.f());
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer player, World level, ItemStack stack, EnumHand hand) {
        ItemStack itemStack;
        if (this.e == EnumGamemode.d) {
            return EnumInteractionResult.e;
        }
        if (player.hh().a(stack)) {
            return EnumInteractionResult.e;
        }
        int count = stack.N();
        int damageValue = stack.o();
        ItemStack stackBeforeUse = stack.v();
        EnumInteractionResult interactionResult = stack.a(level, (EntityHuman)player, hand);
        if (interactionResult instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d success = (EnumInteractionResult.d)interactionResult;
            itemStack = Objects.requireNonNullElse(success.d(), player.b(hand));
        } else {
            itemStack = player.b(hand);
        }
        if (itemStack == stack && itemStack.N() == count && itemStack.a(player) <= 0 && itemStack.o() == damageValue) {
            return interactionResult;
        }
        if (interactionResult instanceof EnumInteractionResult.a && itemStack.a(player) > 0 && !player.fZ()) {
            return interactionResult;
        }
        if (stack != itemStack) {
            player.a(hand, itemStack);
        }
        if (itemStack.f()) {
            player.a(hand, ItemStack.l);
        }
        if (!player.fZ()) {
            if (MCUtil.clientPredictsInteraction((EntityHuman)player, Blocks.a.m(), stackBeforeUse)) {
                player.cm.forceHeldSlot(hand);
            }
            player.cm.d();
        }
        return interactionResult;
    }

    public EnumInteractionResult a(EntityPlayer player, World level, ItemStack stack, EnumHand hand, MovingObjectPositionBlock hitResult) {
        EnumInteractionResult interactionResult1;
        BlockPosition blockPos = hitResult.b();
        IBlockData blockState = level.a_(blockPos);
        boolean cancelledBlock = false;
        boolean cancelledItem = false;
        if (!blockState.b().a(level.Q())) {
            return EnumInteractionResult.d;
        }
        if (this.e == EnumGamemode.d) {
            ITileInventory menuProvider = blockState.a(level, blockPos);
            boolean bl = cancelledBlock = !(menuProvider instanceof ITileInventory);
        }
        if (player.hh().a(stack)) {
            cancelledItem = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, blockPos, hitResult.c(), stack, cancelledBlock, cancelledItem, hand, hitResult.g());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockPos.j();
        this.interactHand = hand;
        this.interactItemStack = stack.v();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (blockState.b() instanceof BlockCake) {
                player.getBukkitEntity().sendHealthUpdate();
            } else if (blockState.a(Blocks.pZ) || blockState.a(Blocks.pY) || blockState.b() instanceof BlockCommand) {
                player.g.b(new PacketPlayOutCloseWindow(this.d.cn.l));
            }
            if (MCUtil.clientPredictsInteraction((EntityHuman)this.d, blockState, stack)) {
                this.d.cn.b();
            } else {
                this.d.cn.forceHeldSlot(hand);
            }
            this.d.resyncUsingItem(this.d);
            return event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.e;
        }
        if (this.e == EnumGamemode.d) {
            ITileInventory menuProvider = blockState.a(level, blockPos);
            if (menuProvider != null && player.a(menuProvider).isPresent()) {
                return EnumInteractionResult.c;
            }
            return EnumInteractionResult.e;
        }
        boolean flag = !player.fx().f() || !player.fy().f();
        boolean flag1 = player.gA() && flag;
        ItemStack itemStack = stack.v();
        if (!flag1) {
            EnumInteractionResult interactionResult = blockState.a(player.b(hand), level, player, hand, hitResult);
            if (interactionResult.a()) {
                CriterionTriggers.O.a(player, blockPos, itemStack);
                return interactionResult;
            }
            if (interactionResult instanceof EnumInteractionResult.f && hand == EnumHand.a && (interactionResult1 = blockState.a(level, player, hitResult)).a()) {
                CriterionTriggers.P.a(player, blockPos);
                return interactionResult1;
            }
        }
        if (!stack.f() && !this.interactResult) {
            ItemActionContext useOnContext = new ItemActionContext(player, hand, hitResult);
            if (player.gv()) {
                int count = stack.N();
                interactionResult1 = stack.a(useOnContext);
                stack.e(count);
            } else {
                interactionResult1 = stack.a(useOnContext);
            }
            if (interactionResult1.a()) {
                CriterionTriggers.O.a(player, blockPos, itemStack);
            }
            return interactionResult1;
        }
        if (this.interactResult && this.interactResult != cancelledItem) {
            this.d.resyncUsingItem(this.d);
        }
        return EnumInteractionResult.e;
    }

    public void a(WorldServer level) {
        this.c = level;
    }
}

