/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.jspecify.annotations.Nullable;

public interface ServerEntityGetter
extends IEntityAccess {
    public WorldServer a();

    default public @Nullable EntityHuman a(PathfinderTargetCondition targetingConditions, EntityLiving source) {
        return this.a(this.E(), targetingConditions, source, source.dP(), source.dR(), source.dV());
    }

    default public @Nullable EntityHuman a(PathfinderTargetCondition targetingConditions, EntityLiving source, double x2, double y2, double z2) {
        return this.a(this.E(), targetingConditions, source, x2, y2, z2);
    }

    default public @Nullable EntityHuman a(PathfinderTargetCondition targetingConditions, double x2, double y2, double z2) {
        return this.a(this.E(), targetingConditions, null, x2, y2, z2);
    }

    default public <T extends EntityLiving> @Nullable T a(Class<? extends T> entityClass, PathfinderTargetCondition targetingConditions, @Nullable EntityLiving source, double x2, double y2, double z2, AxisAlignedBB area) {
        return (T)this.a(this.a(entityClass, area, (? super T entity) -> true), targetingConditions, source, x2, y2, z2);
    }

    default public @Nullable EntityLiving a(TagKey<EntityTypes<?>> types, PathfinderTargetCondition targetingConditions, @Nullable EntityLiving source, double x2, double y2, double z2, AxisAlignedBB area) {
        double d2 = Double.MAX_VALUE;
        EntityLiving livingEntity = null;
        for (EntityLiving livingEntity1 : this.a(EntityLiving.class, area, (? super T livingEntity2) -> livingEntity2.ay().a(types))) {
            double d1;
            if (!targetingConditions.a(this.a(), source, livingEntity1) || !((d1 = livingEntity1.h(x2, y2, z2)) < d2)) continue;
            d2 = d1;
            livingEntity = livingEntity1;
        }
        return livingEntity;
    }

    default public <T extends EntityLiving> @Nullable T a(List<? extends T> entities, PathfinderTargetCondition targetingConditions, @Nullable EntityLiving source, double x2, double y2, double z2) {
        double d2 = -1.0;
        EntityLiving livingEntity = null;
        for (EntityLiving livingEntity1 : entities) {
            if (!targetingConditions.a(this.a(), source, livingEntity1)) continue;
            double d1 = livingEntity1.h(x2, y2, z2);
            if (d2 != -1.0 && !(d1 < d2)) continue;
            d2 = d1;
            livingEntity = livingEntity1;
        }
        return (T)livingEntity;
    }

    default public List<EntityHuman> a(PathfinderTargetCondition targetingConditions, EntityLiving source, AxisAlignedBB area) {
        ArrayList<EntityHuman> list = new ArrayList<EntityHuman>();
        for (EntityHuman entityHuman : this.E()) {
            if (!area.e(entityHuman.dP(), entityHuman.dR(), entityHuman.dV()) || !targetingConditions.a(this.a(), source, entityHuman)) continue;
            list.add(entityHuman);
        }
        return list;
    }

    default public <T extends EntityLiving> List<T> a(Class<T> entityClass, PathfinderTargetCondition targetingConditions, EntityLiving source, AxisAlignedBB area) {
        List<EntityLiving> entitiesOfClass = this.a(entityClass, area, (? super T entity) -> true);
        ArrayList<EntityLiving> list = new ArrayList<EntityLiving>();
        for (EntityLiving livingEntity : entitiesOfClass) {
            if (!targetingConditions.a(this.a(), source, livingEntity)) continue;
            list.add(livingEntity);
        }
        return list;
    }
}

