/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ExtraCodecs;

public class Ticket<T>
implements Comparable<Ticket>,
ChunkSystemTicket<T> {
    public static final MapCodec<Ticket> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.aB.q().fieldOf("type").forGetter(Ticket::a), (App)ExtraCodecs.q.fieldOf("level").forGetter(Ticket::b), (App)Codec.LONG.optionalFieldOf("ticks_left", (Object)0L).forGetter(ticket -> ticket.d)).apply((Applicative)instance, (type, level, ticks) -> new Ticket((TicketType)type, (int)level, (long)ticks)));
    private final TicketType b;
    private final int c;
    private long d;
    private T identifier;

    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    public final long moonrise$getRemoveDelay() {
        return this.d;
    }

    @Override
    public final void moonrise$setRemoveDelay(long removeDelay) {
        this.d = removeDelay;
    }

    @Override
    public final T moonrise$getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void moonrise$setIdentifier(T identifier) {
        if (identifier == null != (((ChunkSystemTicketType)this.b).moonrise$getIdentifierComparator() == null)) {
            throw new IllegalStateException("Nullability of identifier should match nullability of comparator");
        }
        this.identifier = identifier;
    }

    @Override
    public final int compareTo(Ticket ticket) {
        int levelCompare = Integer.compare(this.c, ticket.c);
        if (levelCompare != 0) {
            return levelCompare;
        }
        int typeCompare = Long.compare(((ChunkSystemTicketType)this.b).moonrise$getId(), ((ChunkSystemTicketType)ticket.b).moonrise$getId());
        if (typeCompare != 0) {
            return typeCompare;
        }
        Comparator<T> comparator = ((ChunkSystemTicketType)this.b).moonrise$getIdentifierComparator();
        return comparator == null ? 0 : comparator.compare(this.identifier, ticket.identifier);
    }

    public Ticket(TicketType type, int ticketLevel) {
        this(type, ticketLevel, null);
    }

    public Ticket(TicketType type, int ticketLevel, Object identifier) {
        this(type, ticketLevel, type.g(), identifier);
    }

    public Ticket(TicketType type, int ticketLevel, long ticksLeft) {
        this(type, ticketLevel, ticksLeft, null);
    }

    private Ticket(TicketType type, int ticketLevel, long ticksLeft, Object identifier) {
        this.identifier = identifier;
        this.b = type;
        this.c = ticketLevel;
        this.d = ticksLeft;
    }

    public String toString() {
        return "Ticket[" + String.valueOf(this.b) + " " + this.c + " (" + String.valueOf(this.identifier) + ")] to die in " + this.d;
    }

    public TicketType a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public void c() {
        this.d = this.b.g();
    }

    public void d() {
        if (this.b.f()) {
            --this.d;
        }
    }

    public boolean e() {
        return this.b.f() && this.d < 0L;
    }
}

