/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.LevelDebugSynchronizers;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.equine.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityEnderPearl;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.MoonPhase;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R7.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R7.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;

public class WorldServer
extends net.minecraft.world.level.World
implements ServerEntityGetter,
GeneratorAccessSeed,
ChunkSystemServerLevel,
ChunkSystemLevelReader,
ChunkTickServerLevel {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider B = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger C = LogUtils.getLogger();
    private static final int D = 300;
    private static final int E = 65536;
    final List<EntityPlayer> F = Lists.newArrayList();
    public final ChunkProviderServer G;
    private final MinecraftServer H;
    public final WorldDataServer I;
    final EntityTickList J = new EntityTickList();
    private final ServerWaypointManager K;
    private final EnvironmentAttributeSystem L;
    private final GameEventDispatcher N;
    public boolean e;
    private final SleepStatus O;
    private int P;
    private final PortalTravelAgent Q;
    private final TickListServer<Block> R = new TickListServer(this::d);
    private final TickListServer<FluidType> S = new TickListServer(this::d);
    private final PathTypeCache T = new PathTypeCache();
    final Set<EntityInsentient> U = new ObjectOpenHashSet();
    volatile boolean V;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> W = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> X = new ArrayList<BlockActionData>(64);
    private boolean Y;
    private final List<MobSpawner> Z;
    private @Nullable EnderDragonBattle aa;
    final Int2ObjectMap<EntityComplexPart> ab = new Int2ObjectOpenHashMap();
    private final StructureManager ac;
    private final StructureCheck ad;
    private final boolean ae;
    private final RandomSequences af;
    final LevelDebugSynchronizers ag = new LevelDebugSynchronizers(this);
    public final Convertable.ConversionSession levelStorageAccess;
    public final UUID uuid;
    public final LevelLoadListener levelLoadListener;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final Chunk[] EMPTY_LEVEL_CHUNKS = new Chunk[0];
    private final ReferenceList<Chunk> loadedChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<Chunk> tickingChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<Chunk> entityTickingChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<Chunk> playerTickingChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final Long2IntOpenHashMap playerTickingRequests = new Long2IntOpenHashMap();
    private final SimpleThreadUnsafeRandom simpleRandom = new SimpleThreadUnsafeRandom(RandomSupport.a());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;

    @Override
    public @Nullable Chunk getChunkIfLoaded(int x2, int z2) {
        return this.G.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.levelStorageAccess.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB box) {
        int minBlockX = MathHelper.c(box.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.c(box.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.c(box.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.c(box.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.p();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB box, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.c(box.a - 1.0E-7) - 3;
        int minBlockZ = MathHelper.c(box.c - 1.0E-7) - 3;
        int maxBlockX = MathHelper.c(box.d + 1.0E-7) + 3;
        int maxBlockZ = MathHelper.c(box.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunks(minChunkX, minChunkZ, maxChunkX, maxChunkZ, priority, onLoad);
    }

    public final void loadChunks(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    public @Nullable EntityHuman c(UUID uuid) {
        EntityPlayer player = this.s().aj().b(uuid);
        return player != null && ((net.minecraft.world.entity.Entity)player).ao() == this ? player : null;
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.G.a(chunkX, chunkZ);
    }

    @Override
    public final IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.H.moonrise$executeMidTickTasks();
    }

    @Override
    public final IChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, chunkStatus, priority, onLoad, null);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad, Consumer<IChunkAccess> onEachLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (onEachLoad != null) {
                onEachLoad.accept((IChunkAccess)chunk);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    if (onLoad != null) {
                        onLoad.accept(Collections.unmodifiableList(ret));
                    }
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                PlatformHooks.get().scheduleChunkLoad(this, cx, cz, ChunkStatus.n, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkProviderServer chunkSource = this.G;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.b(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void moonrise$issueEmergencySave() {
        this.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(true, true, true, true);
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getPlayerTickingChunks() {
        return this.playerTickingChunks;
    }

    @Override
    public final void moonrise$markChunkForPlayerTicking(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        if (!this.playerTickingRequests.containsKey(CoordinateUtils.getChunkKey(pos))) {
            return;
        }
        this.playerTickingChunks.add(chunk);
    }

    @Override
    public final void moonrise$removeChunkForPlayerTicking(Chunk chunk) {
        this.playerTickingChunks.remove(chunk);
    }

    @Override
    public final void moonrise$addPlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot add ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (this.playerTickingRequests.addTo(chunkKey, 1) != 0) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.add((Chunk)chunkHolder.getCurrentChunk());
    }

    @Override
    public final void moonrise$removePlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot remove ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int val = this.playerTickingRequests.addTo(chunkKey, -1);
        if (val <= 0) {
            throw new IllegalStateException("Negative counter");
        }
        if (val != 1) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.remove((Chunk)chunkHolder.getCurrentChunk());
    }

    public WorldServer(MinecraftServer server, Executor dispatcher, Convertable.ConversionSession levelStorageAccess, WorldDataServer serverLevelData, ResourceKey<net.minecraft.world.level.World> dimension, WorldDimension levelStem, boolean isDebug, long biomeZoomSeed, List<MobSpawner> customSpawners, boolean tickTime, @Nullable RandomSequences randomSequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(serverLevelData, dimension, server.bc(), levelStem.a(), false, isDebug, biomeZoomSeed, server.bl(), gen, biomeProvider, env, spigotConfig -> server.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(levelStorageAccess.c.f(), serverLevelData.d(), dimension.a(), spigotConfig, server.bc(), serverLevelData.n())), dispatcher);
        this.levelStorageAccess = levelStorageAccess;
        this.uuid = WorldUUID.getOrCreate(levelStorageAccess.c.f().toFile());
        this.levelLoadListener = new LoggingLevelLoadListener(false, this);
        this.ae = tickTime;
        this.H = server;
        this.Z = customSpawners;
        this.I = serverLevelData;
        ChunkGenerator chunkGenerator = levelStem.b();
        this.I.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager biomeSource = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.H.bc().f(Registries.aS), chunkGenerator.d());
            if (chunkGenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract noiseBased = (ChunkGeneratorAbstract)chunkGenerator;
                chunkGenerator = new ChunkGeneratorAbstract((WorldChunkManager)biomeSource, noiseBased.e);
            } else if (chunkGenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat flatLevel = (ChunkProviderFlat)chunkGenerator;
                chunkGenerator = new ChunkProviderFlat(flatLevel.h(), biomeSource);
            }
        }
        if (gen != null) {
            chunkGenerator = new CustomChunkGenerator(this, chunkGenerator, gen);
        }
        boolean flag = server.aZ();
        DataFixer fixerUpper = server.aA();
        this.G = new ChunkProviderServer(this, levelStorageAccess, fixerUpper, server.ba(), dispatcher, chunkGenerator, this.spigotConfig.viewDistance, this.spigotConfig.simulationDistance, flag, null, () -> server.N().A());
        this.G.h().b();
        this.Q = new PortalTravelAgent(this);
        if (this.am()) {
            this.ak();
        }
        this.f = this.A().a(PersistentRaid.a(this.ap()));
        if (!server.X()) {
            serverLevelData.a(server.w());
        }
        long seed = server.bb().x().c();
        this.ad = new StructureCheck(this.G.o(), this.J_(), server.ba(), this.getTypeKey(), chunkGenerator, this.G.i(), this, chunkGenerator.d(), seed, fixerUpper);
        this.ac = new StructureManager(this, this.I.x(), this.ad);
        this.aa = this.aq() == net.minecraft.world.level.World.j && this.ap().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.I.x().c(), this.I.B()) : null;
        this.O = new SleepStatus();
        this.N = new GameEventDispatcher(this);
        this.af = Objects.requireNonNullElseGet(randomSequences, () -> this.A().a(RandomSequences.b));
        this.K = new ServerWaypointManager();
        this.L = EnvironmentAttributeSystem.a().a(this).a();
        this.aj();
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new a()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(levelStorageAccess.f(), dimension, "entities"), levelStorageAccess.a(dimension).resolve("entities"), server.aZ()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController(this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController(this, this.chunkTaskScheduler);
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.p().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle dragonFight) {
        this.aa = dragonFight;
    }

    public void a(int clearTime, int weatherTime, boolean isRaining, boolean isThundering) {
        this.I.a(clearTime);
        this.I.c(weatherTime);
        this.I.b(weatherTime);
        this.I.setRaining(isRaining, WeatherChangeEvent.Cause.COMMAND);
        this.I.setThundering(isThundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int x2, int y2, int z2) {
        return this.p().g().d().getNoiseBiome(x2, y2, z2, this.p().i().b());
    }

    public StructureManager b() {
        return this.ac;
    }

    @Override
    public EnvironmentAttributeSystem c() {
        return this.L;
    }

    public void a(BooleanSupplier hasTimeLeft) {
        boolean hasActiveTickets;
        int i2;
        GameProfilerFiller profilerFiller = Profiler.a();
        this.Y = true;
        TickRateManager tickRateManager = this.y();
        boolean runsNormally = tickRateManager.i();
        if (runsNormally) {
            profilerFiller.a("world border");
            this.w().t();
            profilerFiller.b("weather");
            this.aC();
            profilerFiller.c();
        }
        if (this.O.a(i2 = this.U().a(GameRules.K).intValue()) && this.O.a(i2, this.F)) {
            long newDayTime = this.z.c() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, newDayTime - newDayTime % 24000L - this.al());
            if (this.U().a(GameRules.a).booleanValue() && event.callEvent()) {
                this.b(this.al() + event.getSkipAmount());
            }
            if (!event.isCancelled()) {
                this.aA();
            }
            if (this.U().a(GameRules.b).booleanValue() && this.ao()) {
                this.k();
            }
        }
        this.aj();
        if (runsNormally) {
            this.d();
        }
        profilerFiller.a("tickPending");
        if (!this.ar() && runsNormally) {
            long l2 = this.au();
            profilerFiller.a("blockTicks");
            this.R.a(l2, this.paperConfig().environment.maxBlockTicks, this::c);
            profilerFiller.b("fluidTicks");
            this.S.a(l2, this.paperConfig().environment.maxFluidTicks, this::a);
            profilerFiller.c();
        }
        profilerFiller.b("raid");
        if (runsNormally) {
            this.f.a(this);
        }
        profilerFiller.b("chunkSource");
        this.p().a(hasTimeLeft, true);
        profilerFiller.b("blockEvents");
        if (runsNormally) {
            this.aD();
        }
        this.Y = false;
        profilerFiller.c();
        boolean bl = hasActiveTickets = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || this.G.k();
        if (hasActiveTickets) {
            this.l();
        }
        if (runsNormally) {
            ++this.P;
        }
        if (this.P < 300) {
            profilerFiller.a("entities");
            if (this.aa != null && runsNormally) {
                profilerFiller.a("dragonFight");
                this.aa.c();
                profilerFiller.c();
            }
            ActivationRange.activateEntities(this);
            this.J.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.eh() && !tickRateManager.a((net.minecraft.world.entity.Entity)entity)) {
                    profilerFiller.a("checkDespawn");
                    entity.dW();
                    profilerFiller.c();
                    net.minecraft.world.entity.Entity vehicle = entity.dz();
                    if (vehicle != null) {
                        if (!vehicle.eh() && vehicle.z((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.cf();
                    }
                    profilerFiller.a("tick");
                    this.a(this::a, entity);
                    profilerFiller.c();
                }
            });
            profilerFiller.b("blockEntities");
            this.ai();
            profilerFiller.c();
        }
        profilerFiller.a("entityManagement");
        profilerFiller.c();
        profilerFiller.a("debugSynchronizers");
        if (this.ag.a(DebugSubscriptions.o)) {
            this.r.a((BlockPosition blockPos) -> this.ag.b((BlockPosition)blockPos, DebugSubscriptions.o, blockPos));
        } else {
            this.r.a(null);
        }
        this.ag.a(this.H.bw());
        profilerFiller.c();
        this.c().b();
    }

    @Override
    public boolean a(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void d() {
        if (this.ae) {
            long l2 = this.z.b() + 1L;
            this.I.a(l2);
            Profiler.a().a("scheduledFunctions");
            this.I.r().a(this.H, l2);
            Profiler.a().c();
            if (this.U().a(GameRules.a).booleanValue()) {
                this.b(this.z.c() + 1L);
            }
        }
    }

    public void b(long time) {
        this.I.b(time);
    }

    public long e() {
        return this.al() / 24000L;
    }

    public void a(boolean spawnEnemies) {
        for (MobSpawner customSpawner : this.Z) {
            customSpawner.a(this, spawnEnemies);
        }
    }

    private void aA() {
        this.O.a();
        this.F.stream().filter(EntityLiving::gr).collect(Collectors.toList()).forEach(player -> player.a(false, false));
    }

    private void optimiseRandomTick(Chunk chunk, int tickSpeed) {
        ChunkSection[] sections = chunk.d();
        int minSection = WorldUtil.getMinSection(this);
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkCoordIntPair cpos = chunk.f();
        int offsetX = cpos.h << 4;
        int offsetZ = cpos.i << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            ChunkSection section = sections[sectionIndex];
            DataPaletteBlock<IBlockData> states = section.h;
            if (!section.e()) continue;
            ShortList tickList = section.moonrise$getTickingBlockList();
            for (int i2 = 0; i2 < tickSpeed; ++i2) {
                Fluid fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.f() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                IBlockData state = states.a(location);
                BlockPosition pos = new BlockPosition(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.b(this, pos, simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.y()).f()) continue;
                fluidState.a(this, pos, (RandomSource)simpleRandom);
            }
        }
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        ChunkCoordIntPair pos = chunk.f();
        int minBlockX = pos.e();
        int minBlockZ = pos.f();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int i2 = 0; i2 < randomTickSpeed; ++i2) {
                if (simpleRandom.a(48) != 0) continue;
                this.a(this.a(minBlockX, 0, minBlockZ, 15));
            }
        }
        profilerFiller.b("tickBlocks");
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        profilerFiller.c();
    }

    public void a(Chunk chunk) {
        BlockPosition blockPos;
        ChunkCoordIntPair pos = chunk.f();
        boolean isRaining = this.ao();
        int minBlockX = pos.e();
        int minBlockZ = pos.f();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("thunder");
        if (!this.paperConfig().environment.disableThunder && isRaining && this.an() && this.spigotConfig.thunderChance > 0 && this.y.a(this.spigotConfig.thunderChance) == 0 && this.v(blockPos = this.b(this.a(minBlockX, 0, minBlockZ, 15)))) {
            EntityLightning lightningBolt;
            EntityHorseSkeleton skeletonHorse;
            boolean flag;
            DifficultyDamageScaler currentDifficultyAt = this.c(blockPos);
            boolean bl = flag = this.U().a(GameRules.V) != false && this.y.j() < (double)currentDifficultyAt.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockPos.e()).a(TagsBlock.aj);
            if (flag && (skeletonHorse = EntityTypes.bo.a(this, EntitySpawnReason.h)) != null) {
                skeletonHorse.x(true);
                skeletonHorse.d_(0);
                skeletonHorse.a_(blockPos.u(), blockPos.v(), blockPos.w());
                this.addFreshEntity(skeletonHorse, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((lightningBolt = EntityTypes.aB.a(this, EntitySpawnReason.h)) != null) {
                lightningBolt.f(Vec3D.c(blockPos));
                lightningBolt.a(flag);
                this.strikeLightning(lightningBolt, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        profilerFiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition pos) {
        BlockPosition heightmapPos = this.a(HeightMap.Type.e, pos);
        BlockPosition blockPos = heightmapPos.e();
        BiomeBase biome = this.z(heightmapPos).a();
        if (biome.a(this, blockPos)) {
            CraftEventFactory.handleBlockFormEvent(this, blockPos, Blocks.eq.m(), 3, null);
        }
        if (this.ao()) {
            BiomeBase.Precipitation precipitationAt;
            int i2 = this.U().a(GameRules.C);
            if (i2 > 0 && biome.b(this, heightmapPos)) {
                IBlockData blockState = this.a_(heightmapPos);
                if (blockState.a(Blocks.ep)) {
                    int layersValue = blockState.c(BlockSnow.c);
                    if (layersValue < Math.min(i2, 8)) {
                        IBlockData blockState1 = (IBlockData)blockState.b(BlockSnow.c, layersValue + 1);
                        Block.a(blockState, blockState1, this, heightmapPos);
                        CraftEventFactory.handleBlockFormEvent(this, heightmapPos, blockState1, 3, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent(this, heightmapPos, Blocks.ep.m(), 3, null);
                }
            }
            if ((precipitationAt = biome.a(blockPos, this.V())) != BiomeBase.Precipitation.a) {
                IBlockData blockState2 = this.a_(blockPos);
                blockState2.b().a(blockState2, (net.minecraft.world.level.World)this, blockPos, precipitationAt);
            }
        }
    }

    public Optional<BlockPosition> K(BlockPosition pos) {
        Optional<BlockPosition> optional = this.F().e(poiType -> poiType.a(PoiTypes.t), blockPos -> blockPos.v() == this.a(HeightMap.Type.b, blockPos.u(), blockPos.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockPos -> blockPos.b(1));
    }

    protected BlockPosition b(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition heightmapPos = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.K(heightmapPos);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB aabb = AxisAlignedBB.a(heightmapPos, heightmapPos.h(this.aw() + 1)).g(3.0);
        List<EntityLiving> entitiesOfClass = this.a(EntityLiving.class, aabb, (? super T entity) -> entity.cb() && this.k(entity.dK()) && !entity.au());
        if (!entitiesOfClass.isEmpty()) {
            return entitiesOfClass.get(this.y.a(entitiesOfClass.size())).dK();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (heightmapPos.v() == this.K_() - 1) {
            heightmapPos = heightmapPos.b(2);
        }
        return heightmapPos;
    }

    public boolean f() {
        return this.Y;
    }

    public boolean g() {
        return this.U().a(GameRules.K) <= 100;
    }

    private void aB() {
        if (this.g() && (!this.s().X() || this.s().q())) {
            int i2 = this.U().a(GameRules.K);
            IChatMutableComponent component = this.O.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.O.b(), this.O.b(i2));
            for (EntityPlayer serverPlayer : this.F) {
                serverPlayer.a(component, true);
            }
        }
    }

    public void h() {
        if (!this.F.isEmpty() && this.O.a(this.F)) {
            this.aB();
        }
    }

    public ScoreboardServer i() {
        return this.H.aK();
    }

    public ServerWaypointManager j() {
        return this.K;
    }

    @Override
    public DifficultyDamageScaler c(BlockPosition pos) {
        long l2 = 0L;
        float f2 = 0.0f;
        IChunkAccess chunk = this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()), ChunkStatus.n, false);
        if (chunk != null) {
            l2 = chunk.w();
            f2 = this.d(pos);
        }
        return new DifficultyDamageScaler(this.av(), this.al(), l2, f2);
    }

    public float d(BlockPosition pos) {
        MoonPhase moonPhase = this.L.a(EnvironmentAttributes.p, pos);
        return DimensionManager.k[moonPhase.a()];
    }

    private void aC() {
        boolean isRaining = this.ao();
        if (this.am()) {
            if (this.U().a(GameRules.b).booleanValue()) {
                int clearWeatherTime = this.I.e();
                int thunderTime = this.I.g();
                int rainTime = this.I.i();
                boolean isThundering = this.z.f();
                boolean isRaining1 = this.z.h();
                if (clearWeatherTime > 0) {
                    --clearWeatherTime;
                    thunderTime = isThundering ? 0 : 1;
                    rainTime = isRaining1 ? 0 : 1;
                    isThundering = false;
                    isRaining1 = false;
                } else {
                    if (thunderTime > 0) {
                        if (--thunderTime == 0) {
                            isThundering = !isThundering;
                        }
                    } else {
                        thunderTime = isThundering ? d.a(this.y) : B.a(this.y);
                    }
                    if (rainTime > 0) {
                        if (--rainTime == 0) {
                            isRaining1 = !isRaining1;
                        }
                    } else {
                        rainTime = isRaining1 ? c.a(this.y) : b.a(this.y);
                    }
                }
                this.I.b(thunderTime);
                this.I.c(rainTime);
                this.I.a(clearWeatherTime);
                this.I.setThundering(isThundering, ThunderChangeEvent.Cause.NATURAL);
                this.I.setRaining(isRaining1, WeatherChangeEvent.Cause.NATURAL);
            }
            this.w = this.x;
            this.x = this.z.f() ? (this.x += 0.01f) : (this.x -= 0.01f);
            this.x = MathHelper.a(this.x, 0.0f, 1.0f);
            this.u = this.v;
            this.v = this.z.h() ? (this.v += 0.01f) : (this.v -= 0.01f);
            this.v = MathHelper.a(this.v, 0.0f, 1.0f);
        }
        for (EntityPlayer player : this.F) {
            if (player.A() != this) continue;
            player.tickWeather();
        }
        if (isRaining != this.ao()) {
            for (EntityPlayer player : this.F) {
                if (player.A() != this) continue;
                player.setPlayerWeather(!isRaining ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (EntityPlayer player : this.F) {
            if (player.A() != this) continue;
            player.updateWeather(this.u, this.v, this.w, this.x);
        }
    }

    @VisibleForTesting
    public void k() {
        this.I.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.I.h()) {
            this.I.c(0);
        }
        this.I.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.I.f()) {
            this.I.b(0);
        }
    }

    public void l() {
        this.P = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        IBlockData blockState = this.a_(pos);
        Fluid fluidState = blockState.y();
        if (fluidState.b(fluid)) {
            fluidState.a(this, pos, blockState);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.H.moonrise$executeMidTickTasks();
        }
    }

    private void c(BlockPosition pos, Block block) {
        IBlockData blockState = this.a_(pos);
        if (blockState.a(block)) {
            blockState.a(this, pos, this.y);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.H.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            entity.bP();
            GameProfilerFiller profilerFiller = Profiler.a();
            ++entity.at;
            ++entity.totalEntityAge;
            profilerFiller.a(() -> BuiltInRegistries.g.b(entity.ay()).toString());
            profilerFiller.f("tickNonPassenger");
            boolean isActive = ActivationRange.checkIfActive(entity);
            if (isActive) {
                entity.g();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            profilerFiller.c();
            for (net.minecraft.world.entity.Entity entity1 : entity.dn()) {
                this.tickPassenger(entity, entity1, isActive);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void tickPassenger(net.minecraft.world.entity.Entity ridingEntity, net.minecraft.world.entity.Entity passengerEntity, boolean isActive) {
        if (passengerEntity.eh() || passengerEntity.dz() != ridingEntity) {
            passengerEntity.cf();
        } else if (passengerEntity instanceof EntityHuman || this.J.c(passengerEntity)) {
            passengerEntity.bP();
            ++passengerEntity.at;
            ++passengerEntity.totalEntityAge;
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a(() -> BuiltInRegistries.g.b(passengerEntity.ay()).toString());
            profilerFiller.f("tickPassenger");
            if (isActive) {
                passengerEntity.t();
                passengerEntity.postTick();
            } else {
                passengerEntity.k(Vec3D.c);
                passengerEntity.inactiveTick();
                ridingEntity.k(passengerEntity);
            }
            profilerFiller.c();
            for (net.minecraft.world.entity.Entity entity : passengerEntity.dn()) {
                this.tickPassenger(passengerEntity, entity, isActive);
            }
        }
    }

    public void a(BlockPosition pos, IBlockData state) {
        boolean flag;
        IBlockData blockState = this.a_(pos);
        Block block = blockState.b();
        boolean bl = flag = !state.a(block);
        if (flag) {
            state.a(this, pos, false);
        }
        this.a(pos, blockState.b());
        if (blockState.q()) {
            this.b(pos, block);
        }
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        EntityHuman player;
        return !(entity instanceof EntityHuman && (this.H.a(this, pos, player = (EntityHuman)entity) || !this.w().a(pos)));
    }

    public void saveIncrementally(boolean doFull) {
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.c(false);
        }
        if (doFull) {
            this.I.a(this.H.aN().a(this.J_()));
            this.levelStorageAccess.a(this.H.bc(), this.I, this.H.aj().r());
        }
    }

    public void a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) {
        this.save(progress, flush, skipSave, false);
    }

    public void save(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave, boolean close) {
        ChunkProviderServer chunkSource = this.p();
        if (!skipSave) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progress != null) {
                progress.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.c(flush);
            if (progress != null) {
                progress.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            if (!close) {
                chunkSource.a(flush);
            }
        }
        if (close) {
            try {
                chunkSource.close(!skipSave);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        WorldServer serverLevel1 = this;
        this.I.a(this.H.aN().a(this.J_()));
        this.levelStorageAccess.a(this.H.bc(), this.I, this.H.aj().r());
    }

    private void c(boolean join) {
        if (this.aa != null) {
            this.I.a(this.aa.b());
        }
        WorldPersistentData dataStorage = this.p().m();
        if (join) {
            dataStorage.b();
        } else {
            dataStorage.a();
        }
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(typeTest, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output) {
        this.a(typeTest, predicate, output, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output, int maxResults) {
        this.M().a(typeTest, (U entity) -> {
            if (predicate.test(entity)) {
                output.add((Object)entity);
                if (output.size() >= maxResults) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> m() {
        return this.a(EntityTypes.T, EntityLiving::cb);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int maxResults) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer serverPlayer : this.F) {
            if (!predicate.test(serverPlayer)) continue;
            list.add(serverPlayer);
            if (list.size() < maxResults) continue;
            return list;
        }
        return list;
    }

    public @Nullable EntityPlayer n() {
        List<EntityPlayer> players = this.a(EntityLiving::cb);
        return players.isEmpty() ? null : players.get(this.y.a(players.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            this.c(serverPlayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer player) {
        this.c(player);
    }

    public void b(EntityPlayer player) {
        this.c(player);
    }

    private void c(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.d(player.cY());
        if (entity != null) {
            C.warn("Force-added player with duplicate UUID {}", (Object)player.cY());
            entity.aw();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.m.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.eh()) {
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).e().f()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.dp().map(net.minecraft.world.entity.Entity::cY).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void b(Chunk chunk) {
        for (TileEntity blockEntity : chunk.J().values()) {
            if (!(blockEntity instanceof IInventory)) continue;
            for (HumanEntity human : Lists.newArrayList(((IInventory)((Object)blockEntity)).getViewers())) {
                ((CraftHumanEntity)human).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.K();
        chunk.c(this);
        this.ag.a(chunk.f());
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int breakerId, BlockPosition pos, int progress) {
        EntityHuman breakerPlayer = null;
        net.minecraft.world.entity.Entity entity = this.a(breakerId);
        if (entity instanceof EntityHuman) {
            breakerPlayer = (EntityHuman)entity;
        }
        if (entity != null) {
            float progressFloat = (float)MathHelper.a(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        for (EntityPlayer serverPlayer : this.H.aj().t()) {
            if (serverPlayer.A() != this || serverPlayer.aA() == breakerId) continue;
            double d2 = (double)pos.u() - serverPlayer.dP();
            double d1 = (double)pos.v() - serverPlayer.dR();
            double d22 = (double)pos.w() - serverPlayer.dV();
            if (breakerPlayer != null && !serverPlayer.getBukkitEntity().canSee(breakerPlayer.getBukkitEntity()) || !(d2 * d2 + d1 * d1 + d22 * d22 < 1024.0)) continue;
            serverPlayer.g.b(new PacketPlayOutBlockBreakAnimation(breakerId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory source, float volume, float pitch, long seed) {
        EntityHuman player;
        this.H.aj().a(entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null, x2, y2, z2, sound.a().a(volume), this.aq(), new PacketPlayOutNamedSoundEffect(sound, source, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity sourceEntity, Holder<SoundEffect> sound, SoundCategory source, float volume, float pitch, long seed) {
        EntityHuman player;
        this.H.aj().a(entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null, sourceEntity.dP(), sourceEntity.dR(), sourceEntity.dV(), sound.a().a(volume), this.aq(), new PacketPlayOutEntitySound(sound, source, sourceEntity, volume, pitch, seed));
    }

    @Override
    public void b(int id, BlockPosition pos, int data) {
        if (this.U().a(GameRules.q).booleanValue()) {
            this.H.aj().t().forEach(player -> {
                Vec3D vec31;
                if (player.A() == this) {
                    Vec3D vec3 = Vec3D.b(pos);
                    if (player.g(vec3) < (double)MathHelper.i(32)) {
                        vec31 = vec3;
                    } else {
                        Vec3D vec32 = vec3.d(player.dI()).d();
                        vec31 = player.dI().e(vec32.c(32.0));
                    }
                } else {
                    vec31 = player.dI();
                }
                player.g.b(new PacketPlayOutWorldEvent(id, BlockPosition.a(vec31), data, true));
            });
        } else {
            this.a(null, id, pos, data);
        }
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, int type, BlockPosition pos, int data) {
        EntityHuman player;
        this.H.aj().a(entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null, pos.u(), pos.v(), pos.w(), 64.0, this.aq(), new PacketPlayOutWorldEvent(type, pos, data, false));
    }

    public int o() {
        return this.F_().j();
    }

    @Override
    public void a(Holder<GameEvent> gameEvent, Vec3D pos, GameEvent.a context) {
        if (this.getChunkIfLoadedImmediately(MathHelper.c(pos.g) >> 4, MathHelper.c(pos.i) >> 4) == null) {
            return;
        }
        this.N.a(gameEvent, pos, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape collisionShape1;
        VoxelShape collisionShape;
        if (this.V) {
            String string = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.p().a(pos);
        this.T.a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(collisionShape = oldState.g(this, pos), collisionShape1 = newState.g(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            try {
                for (EntityInsentient mob : this.U) {
                    NavigationAbstract navigation = mob.N();
                    if (!navigation.b(pos)) continue;
                    list.add(navigation);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.a(pos, oldState, newState, flags);
                return;
            }
            try {
                this.V = true;
                for (NavigationAbstract pathNavigation : list) {
                    pathNavigation.i();
                }
            }
            finally {
                this.V = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block block) {
        if (this.populating) {
            return;
        }
        if (this.captureBlockStates) {
            return;
        }
        this.a(pos, block, ExperimentalRedstoneUtils.a(this, null, null));
    }

    @Override
    public void a(BlockPosition pos, Block block, @Nullable Orientation orientation) {
        if (this.captureBlockStates) {
            return;
        }
        this.r.a(pos, block, null, orientation);
    }

    @Override
    public void a(BlockPosition pos, Block block, EnumDirection facing, @Nullable Orientation orientation) {
        this.r.a(pos, block, facing, orientation);
    }

    @Override
    public void b(BlockPosition pos, Block block, @Nullable Orientation orientation) {
        this.r.a(pos, block, orientation);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) {
        this.r.a(state, pos, block, orientation, movedByPiston);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte state) {
        this.p().a(entity, new PacketPlayOutEntityStatus(entity, state));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.p().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer p() {
        return this.G;
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> explosionSound) {
        this.explode0(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, blockParticles, explosionSound);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> explosionSound) {
        return this.explode0(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, blockParticles, explosionSound, null);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> explosionSound, @Nullable Consumer<ServerExplosion> configurator) {
        Explosion.Effect blockInteraction = switch (explosionInteraction) {
            default -> throw new MatchException(null, null);
            case World.a.a -> Explosion.Effect.a;
            case World.a.b -> this.a(GameRules.e);
            case World.a.c -> {
                if (this.U().a(GameRules.F).booleanValue()) {
                    yield this.a(GameRules.E);
                }
                yield Explosion.Effect.a;
            }
            case World.a.d -> this.a(GameRules.ae);
            case World.a.e -> Explosion.Effect.d;
            case World.a.STANDARD -> Explosion.Effect.b;
        };
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        ServerExplosion serverExplosion = new ServerExplosion(this, source, damageSource, damageCalculator, vec3, radius, fire, blockInteraction);
        if (configurator != null) {
            configurator.accept(serverExplosion);
        }
        int i2 = serverExplosion.i();
        if (serverExplosion.wasCanceled) {
            return serverExplosion;
        }
        ParticleParam particleOptions = serverExplosion.l() ? smallExplosionParticles : largeExplosionParticles;
        for (EntityPlayer serverPlayer : this.F) {
            if (!(serverPlayer.g(vec3) < 4096.0)) continue;
            Optional<Vec3D> optional = Optional.ofNullable(serverExplosion.j().get(serverPlayer));
            serverPlayer.g.b(new PacketPlayOutExplosion(vec3, radius, i2, optional, particleOptions, explosionSound, blockParticles));
        }
        return serverExplosion;
    }

    private Explosion.Effect a(GameRule<Boolean> decayGameRule) {
        return this.U().a(decayGameRule) != false ? Explosion.Effect.c : Explosion.Effect.b;
    }

    @Override
    public void a(BlockPosition pos, Block block, int eventId, int eventParam) {
        this.W.add((Object)new BlockActionData(pos, block, eventId, eventParam));
    }

    private void aD() {
        this.X.clear();
        while (!this.W.isEmpty()) {
            BlockActionData blockEventData = (BlockActionData)this.W.removeFirst();
            if (this.r(blockEventData.a())) {
                if (!this.a(blockEventData)) continue;
                this.H.aj().a(null, blockEventData.a().u(), blockEventData.a().v(), blockEventData.a().w(), 64.0, this.aq(), new PacketPlayOutBlockAction(blockEventData.a(), blockEventData.b(), blockEventData.c(), blockEventData.d()));
                continue;
            }
            this.X.add(blockEventData);
        }
        this.W.addAll(this.X);
    }

    private boolean a(BlockActionData event) {
        IBlockData blockState = this.a_(event.a());
        return blockState.a(event.b()) && blockState.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d());
    }

    public TickListServer<Block> q() {
        return this.R;
    }

    public TickListServer<FluidType> r() {
        return this.S;
    }

    @Override
    public MinecraftServer s() {
        return this.H;
    }

    public PortalTravelAgent t() {
        return this.Q;
    }

    public StructureTemplateManager u() {
        return this.H.ba();
    }

    public <T extends ParticleParam> int a(T options, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(null, options, false, false, x2, y2, z2, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleParam> int a(T options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(null, options, overrideLimiter, alwaysShow, x2, y2, z2, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleParam> int sendParticlesSource(@Nullable net.minecraft.world.entity.Entity sender, T options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(this.F, sender, options, overrideLimiter, alwaysShow, x2, y2, z2, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleParam> int sendParticlesSource(List<EntityPlayer> receivers, @Nullable net.minecraft.world.entity.Entity sender, T options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        PacketPlayOutWorldParticles clientboundLevelParticlesPacket = new PacketPlayOutWorldParticles(options, overrideLimiter, alwaysShow, x2, y2, z2, (float)xDist, (float)yDist, (float)zDist, (float)speed, count);
        int i2 = 0;
        for (int i1 = 0; i1 < receivers.size(); ++i1) {
            EntityPlayer serverPlayer = receivers.get(i1);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(serverPlayer, overrideLimiter, x2, y2, z2, clientboundLevelParticlesPacket)) continue;
            ++i2;
        }
        return i2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer player, T particle, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int count, double xDist, double yDist, double zDist, double maxSpeed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, overrideLimiter, alwaysShow, posX, posY, posZ, (float)xDist, (float)yDist, (float)zDist, (float)maxSpeed, count);
        return this.a(player, overrideLimiter, posX, posY, posZ, packet);
    }

    private boolean a(EntityPlayer player, boolean overrideLimiter, double x2, double y2, double z2, Packet<?> packet) {
        if (player.A() != this) {
            return false;
        }
        BlockPosition blockPos = player.dK();
        if (blockPos.a(new Vec3D(x2, y2, z2), overrideLimiter ? 512.0 : 32.0)) {
            player.g.b(packet);
            return true;
        }
        return false;
    }

    @Override
    public @Nullable net.minecraft.world.entity.Entity a(int id) {
        return this.M().a(id);
    }

    @Override
    public @Nullable net.minecraft.world.entity.Entity a(UUID id) {
        net.minecraft.world.entity.Entity entity = this.d(id);
        if (entity != null) {
            return entity;
        }
        for (WorldServer serverLevel : this.s().P()) {
            net.minecraft.world.entity.Entity entity1;
            if (serverLevel == this || (entity1 = serverLevel.d(id)) == null) continue;
            return entity1;
        }
        return null;
    }

    @Override
    public @Nullable EntityHuman b(UUID id) {
        return this.s().aj().b(id);
    }

    @Deprecated
    public @Nullable net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.M().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.ab.get(id);
    }

    @Override
    public Collection<EntityComplexPart> v() {
        return this.ab.values();
    }

    public @Nullable BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipKnownStructures) {
        if (!this.I.x().d()) {
            return null;
        }
        Optional optional = this.J_().f(Registries.bs).a(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.p().g().a(this, (HolderSet)optional.get(), pos, radius, skipKnownStructures);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    public @Nullable Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> biomePredicate, BlockPosition pos, int radius, int horizontalStep, int verticalStep) {
        return this.p().g().d().a(pos, radius, horizontalStep, verticalStep, biomePredicate, this.p().i().b(), this);
    }

    @Override
    public WorldBorder w() {
        WorldBorder worldBorder = this.A().a(WorldBorder.d);
        worldBorder.a(this.z.b());
        return worldBorder;
    }

    public CraftingManager x() {
        return this.H.aJ();
    }

    @Override
    public TickRateManager y() {
        return this.H.aR();
    }

    @Override
    public boolean z() {
        return this.e;
    }

    public WorldPersistentData A() {
        return this.p().m();
    }

    @Override
    public @Nullable WorldMap a(MapId mapId) {
        WorldPersistentData storage = this.s().N().A();
        Optional<PersistentBase> cacheEntry = storage.b.get(WorldMap.a(mapId));
        if (cacheEntry == null) {
            WorldMap mapData = storage.b(WorldMap.a(mapId));
            if (mapData != null) {
                mapData.id = mapId;
                new MapInitializeEvent((MapView)mapData.mapView).callEvent();
                return mapData;
            }
            return null;
        }
        Object var5_6 = cacheEntry.orElse(null);
        if (var5_6 instanceof WorldMap) {
            WorldMap mapItemSavedData = var5_6;
            mapItemSavedData.id = mapId;
            return mapItemSavedData;
        }
        return null;
    }

    public void a(MapId mapId, WorldMap data) {
        data.id = mapId;
        MapInitializeEvent event = new MapInitializeEvent((MapView)data.mapView);
        event.callEvent();
        this.s().N().A().a(WorldMap.a(mapId), data);
    }

    public MapId B() {
        return this.s().N().A().a(PersistentIdCounts.b).b();
    }

    @Override
    public void a(WorldData.a respawnData) {
        if (!this.I.a().positionEquals(respawnData)) {
            Location previousLocation = this.getWorld().getSpawnLocation();
            this.I.a(respawnData);
            this.H.aj().a(new PacketPlayOutSpawnPosition(respawnData), this.aq());
            this.H.bI();
            new SpawnChangeEvent((World)this.getWorld(), previousLocation).callEvent();
        }
        if (this.H.N().I.respawnDimension != this.aq()) {
            this.H.N().I.respawnDimension = this.aq();
            this.H.bI();
        }
    }

    @Override
    public WorldData.a C() {
        return this.s().aI();
    }

    public LongSet D() {
        return this.G.l();
    }

    public boolean a(int chunkX, int chunkZ, boolean add) {
        boolean flag = this.G.a(new ChunkCoordIntPair(chunkX, chunkZ), add);
        if (add && flag) {
            this.d(chunkX, chunkZ);
        }
        return flag;
    }

    public List<EntityPlayer> E() {
        return this.F;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(oldState);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newState))) {
            BlockPosition blockPos = pos.j();
            optional.ifPresent(holder -> this.s().execute(() -> {
                this.F().a(blockPos);
                this.ag.c(blockPos);
            }));
            optional1.ifPresent(holder -> this.s().execute(() -> {
                VillagePlaceRecord poiRecord;
                if (optional.isEmpty() && this.F().a(blockPos, (Holder<VillagePlaceType> ignored) -> true)) {
                    this.F().a(blockPos);
                }
                if ((poiRecord = this.F().a(blockPos, (Holder<VillagePlaceType>)holder)) != null) {
                    this.ag.a(poiRecord);
                }
            }));
        }
    }

    public VillagePlace F() {
        return this.p().n();
    }

    public boolean e(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition pos) {
        return this.e(pos.k());
    }

    public boolean a(BlockPosition pos, int sections) {
        return sections <= 6 && this.b(SectionPosition.a(pos)) <= sections;
    }

    public int b(SectionPosition pos) {
        return this.F().a(pos);
    }

    public PersistentRaid G() {
        return this.f;
    }

    public @Nullable Raid f(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean g(BlockPosition pos) {
        return this.f(pos) != null;
    }

    public void a(ReputationEvent type, net.minecraft.world.entity.Entity target, ReputationHandler host) {
        host.a(type, target);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedWriter3;
        PlayerChunkMap chunkMap = this.p().a;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", chunkMap.i().a()));
            SpawnerCreature.d lastSpawnState = this.p().p();
            if (lastSpawnState != null) {
                for (Object2IntMap.Entry entry : lastSpawnState.b().object2IntEntrySet()) {
                    bufferedWriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedWriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.q.size()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.q().a()));
            bufferedWriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.r().a()));
            bufferedWriter.write("distance_manager: " + chunkMap.i().c() + "\n");
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.p().f()));
        }
        CrashReport crashReport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashReport);
        try (BufferedWriter bufferedWriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedWriter1.write(crashReport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedWriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedWriter2 != null) {
            ((Writer)bufferedWriter2).close();
        }
        if ((bufferedWriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            ((Writer)bufferedWriter3).close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedWriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedWriter4, this.M().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedWriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedWriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent customName = entity.as();
            IChatBaseComponent displayName = entity.R_();
            csvOutput.a(entity.dP(), entity.dR(), entity.dV(), entity.cY(), BuiltInRegistries.g.b(entity.ay()), entity.cb(), displayName.getString(), customName != null ? customName.getString() : null);
        }
    }

    private void a(Writer output) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("type").a(output);
        for (TickingBlockEntity tickingBlockEntity : this.q) {
            BlockPosition pos = tickingBlockEntity.c();
            csvOutput.a(pos.u(), pos.v(), pos.w(), tickingBlockEntity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox boundingBox) {
        this.W.removeIf(blockEventData -> boundingBox.b(blockEventData.a()));
    }

    @Override
    public float a(EnumDirection direction, boolean shade) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> H() {
        return this.M().a();
    }

    public String toString() {
        return "ServerLevel[" + this.I.d() + "]";
    }

    public boolean I() {
        return this.I.y();
    }

    @Override
    public long J() {
        return this.I.x().c();
    }

    public @Nullable EnderDragonBattle K() {
        return this.aa;
    }

    @Override
    public WorldServer a() {
        return this;
    }

    @VisibleForTesting
    public String L() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.F.size(), this.moonrise$getEntityLookup().getDebugInfo(), WorldServer.a(this.moonrise$getEntityLookup().a(), (T entity) -> BuiltInRegistries.g.b(entity.ay()).toString()), this.q.size(), WorldServer.a(this.q, TickingBlockEntity::d), this.q().a(), this.r().a(), this.P());
    }

    private static <T> String a(Iterable<T> objects, Function<T, String> typeGetter) {
        try {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap();
            for (T object : objects) {
                String string = typeGetter.apply(object);
                map.addTo((Object)string, 1);
            }
            return map.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> (String)entry.getKey() + ":" + entry.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception var6) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> M() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void c(Chunk chunk) {
        chunk.d(this.au());
    }

    public void a(IChunkAccess chunk) {
        this.H.execute(() -> this.ad.a(chunk.f(), chunk.g()));
    }

    public PathTypeCache N() {
        return this.T;
    }

    public void a(ChunkCoordIntPair chunkPos, int radius) {
        List<ChunkCoordIntPair> list = ChunkCoordIntPair.a(chunkPos, radius).toList();
        this.G.g.b(() -> {
            for (ChunkCoordIntPair chunkPos1 : list) {
                if (this.c(chunkPos1.b())) continue;
                return false;
            }
            return true;
        });
    }

    public boolean O() {
        return this.D_().p() != EnumDifficulty.a && this.U().a(GameRules.V) != false && this.U().a(GameRules.W) != false;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String P() {
        return "Chunks[S] W: " + this.G.e() + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    public boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean h(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean i(BlockPosition pos) {
        return this.b(new ChunkCoordIntPair(pos));
    }

    public boolean b(ChunkCoordIntPair chunkPos) {
        return this.G.a.b(chunkPos);
    }

    public boolean j(BlockPosition pos) {
        int i2 = this.U().a(GameRules.n);
        return i2 == -1 || this.G.a.a(pos, i2);
    }

    public boolean c(ChunkCoordIntPair chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady() && this.w().a(chunkPos);
    }

    @Override
    public FeatureFlagSet Q() {
        return this.H.bb().J();
    }

    @Override
    public PotionBrewer R() {
        return this.H.br();
    }

    @Override
    public FuelValues S() {
        return this.H.bs();
    }

    public RandomSource a(MinecraftKey location) {
        return this.af.a(location, this.J());
    }

    public RandomSequences T() {
        return this.af;
    }

    public GameRules U() {
        return this.I.n();
    }

    public List<EntityPlayer> getPlayersForGlobalSoundGamerule() {
        return this.U().a(GameRules.q) != false ? this.s().aj().k : this.E();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    @Deprecated
    public void checkCapturedTreeStateForObserverNotify(BlockPosition pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().v() == pos.v() && this.a_(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlags(), 512);
        }
    }

    @Override
    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashReportCategory = super.a(report);
        crashReportCategory.a("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashReportCategory;
    }

    @Override
    public int V() {
        return this.G.g().f();
    }

    @Override
    public void a(TileEntity entity) {
        super.a(entity);
        this.ag.a(entity);
    }

    public LevelDebugSynchronizers W() {
        return this.ag;
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    public boolean a(net.minecraft.world.level.World level) {
        return level.aq() != net.minecraft.world.level.World.i || this.U().a(GameRules.c) != false;
    }

    public boolean X() {
        return this.U().a(GameRules.M);
    }

    public boolean Y() {
        return this.U().a(GameRules.f);
    }

    public boolean Z() {
        return this.U().a(GameRules.U);
    }

    @Override
    public @Nullable EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.H.aj().b(uuid);
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
            WaypointTransmitter waypointTransmitter;
            if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).gx()) {
                WorldServer.this.j().a(waypointTransmitter);
            }
            entity.bP();
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof WaypointTransmitter) {
                WaypointTransmitter waypointTransmitter = (WaypointTransmitter)((Object)entity);
                WorldServer.this.j().c(waypointTransmitter);
            }
            WorldServer.this.i().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.J.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.J.b(entity);
            if (WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && WorldServer.this.paperConfig().misc.legacyEnderPearlBehavior && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.d((net.minecraft.world.entity.Entity)null);
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            WaypointTransmitter waypointTransmitter;
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                WorldServer.this.F.add(serverPlayer);
                if (serverPlayer.o()) {
                    WorldServer.this.j().a(serverPlayer);
                }
                WorldServer.this.h();
            }
            if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).gx()) {
                WorldServer.this.j().a(waypointTransmitter);
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                WorldServer.this.U.add(mob);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                for (EntityComplexPart enderDragonPart : enderDragon.gM()) {
                    WorldServer.this.ab.put(enderDragonPart.aA(), (Object)enderDragonPart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
            WorldServer.this.p().b(entity);
            if (entity.origin == null) {
                entity.origin = entity.dI();
            }
            if (entity.originWorld == null) {
                entity.originWorld = WorldServer.this.getWorld().getUID();
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                for (WorldServer level : WorldServer.this.s().P()) {
                    for (Optional<PersistentBase> savedData : level.A().b.values()) {
                        PersistentBase persistentBase;
                        if (savedData.isEmpty() || !((persistentBase = savedData.get()) instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)persistentBase;
                        map.q.remove(player);
                        if (!map.p.removeIf(holdingPlayer -> holdingPlayer.a == player)) continue;
                        map.s.remove(player.ap().getString());
                    }
                }
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.ei() != Entity.RemovalReason.a)) {
                Object merchant;
                CraftEntity craftEntity = entity.getBukkitEntity();
                if (craftEntity instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.p().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                WorldServer.this.F.remove(serverPlayer);
                WorldServer.this.j().c(serverPlayer);
                WorldServer.this.h();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                WorldServer.this.U.remove(mob);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                for (HumanEntity enderDragonPart : enderDragon.gM()) {
                    WorldServer.this.ab.remove(enderDragonPart.aA());
                }
            }
            entity.a(DynamicGameEventListener::b);
            WorldServer.this.ag.b(entity);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.H.aj().k) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

