/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.player.PlayerHandshakeEvent;
import com.destroystokyo.paper.network.PaperNetworkClient;
import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final IChatBaseComponent b = IChatBaseComponent.c("disconnect.ignoring_status_request");
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final Map<InetAddress, Long> throttleTracker = new HashMap<InetAddress, Long>();
    private static int throttleCounter = 0;
    private static final boolean BYPASS_HOSTCHECK = Boolean.getBoolean("Paper.bypassHostCheck");
    private final MinecraftServer c;
    private final NetworkManager d;

    public HandshakeListener(MinecraftServer server, NetworkManager connection) {
        this.c = server;
        this.d = connection;
    }

    @Override
    public void a(PacketHandshakingInSetProtocol packet) {
        this.d.hostname = packet.e() + ":" + packet.f();
        switch (packet.g()) {
            case b: {
                this.a(packet, false);
                break;
            }
            case a: {
                ServerPing status = this.c.as();
                this.d.a(StatusProtocols.d);
                if (this.c.an() && status != null) {
                    this.d.a(StatusProtocols.b, new PacketStatusListener(status, this.d));
                    break;
                }
                this.d.a(b);
                break;
            }
            case c: {
                if (!this.c.bq()) {
                    this.d.a(LoginProtocols.d);
                    IChatMutableComponent component = IChatBaseComponent.c("multiplayer.disconnect.transfers_disabled");
                    this.d.a(new PacketLoginOutDisconnect(component));
                    this.d.a(component);
                    break;
                }
                this.a(packet, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)packet.g()));
            }
        }
        this.d.protocolVersion = packet.b();
        this.d.virtualHost = PaperNetworkClient.prepareVirtualHost(packet.e(), packet.f());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PacketHandshakingInSetProtocol packet, boolean transferred) {
        SocketAddress socketAddress;
        block19: {
            this.d.a(LoginProtocols.d);
            try {
                SocketAddress socketAddress2;
                long connectionThrottle = this.c.server.getConnectionThrottle();
                boolean isUnixDomainSocket = this.d.k.localAddress() instanceof DomainSocketAddress;
                if (connectionThrottle <= 0L || isUnixDomainSocket || !((socketAddress2 = this.d.d()) instanceof InetSocketAddress) || ((InetSocketAddress)(socketAddress = (InetSocketAddress)socketAddress2)).isUnresolved() || ((InetSocketAddress)socketAddress).getAddress().isLoopbackAddress()) break block19;
                long currentTime = System.currentTimeMillis();
                InetAddress address = ((InetSocketAddress)socketAddress).getAddress();
                Map<InetAddress, Long> map = throttleTracker;
                synchronized (map) {
                    if (throttleTracker.containsKey(address) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                        throttleTracker.put(address, currentTime);
                        IChatBaseComponent chatmessage = PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.connectionThrottle);
                        this.d.a(new PacketLoginOutDisconnect(chatmessage));
                        this.d.a(chatmessage);
                        return;
                    }
                    throttleTracker.put(address, currentTime);
                    if (++throttleCounter > 200) {
                        throttleCounter = 0;
                        throttleTracker.values().removeIf(time -> time > connectionThrottle);
                    }
                }
            }
            catch (Throwable t2) {
                LogManager.getLogger().debug("Failed to check connection throttle", t2);
            }
        }
        if (packet.b() != SharedConstants.b().d()) {
            TextComponent adventureComponent = packet.b() < SharedConstants.b().d() ? LegacyComponentSerializer.legacySection().deserialize(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.b().c())) : LegacyComponentSerializer.legacySection().deserialize(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.b().c()));
            IChatBaseComponent component = PaperAdventure.asVanilla((Component)adventureComponent);
            this.d.a(new PacketLoginOutDisconnect(component));
            this.d.a(component);
        } else {
            this.d.a(LoginProtocols.b, new LoginListener(this.c, this.d, transferred));
            boolean proxyLogicEnabled = SpigotConfig.bungee;
            boolean handledByEvent = false;
            if (PlayerHandshakeEvent.getHandlerList().getRegisteredListeners().length != 0) {
                SocketAddress socketAddress3 = this.d.l;
                String hostnameOfRemote = socketAddress3 instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress3).getHostString() : InetAddress.getLoopbackAddress().getHostAddress();
                PlayerHandshakeEvent event = new PlayerHandshakeEvent(packet.e(), hostnameOfRemote, !proxyLogicEnabled);
                if (event.callEvent()) {
                    if (event.isFailed()) {
                        IChatBaseComponent message = PaperAdventure.asVanilla(event.failMessage());
                        this.d.a(new PacketLoginOutDisconnect(message));
                        this.d.a(message);
                        return;
                    }
                    if (event.getServerHostname() != null) {
                        packet = new PacketHandshakingInSetProtocol(packet.b(), event.getServerHostname(), packet.f(), packet.g());
                        this.d.hostname = event.getServerHostname();
                    }
                    if (event.getSocketAddressHostname() != null) {
                        this.d.l = new InetSocketAddress(event.getSocketAddressHostname(), socketAddress3 instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress3).getPort() : 0);
                    }
                    this.d.spoofedUUID = event.getUniqueId();
                    this.d.spoofedProfile = (Property[])gson.fromJson(event.getPropertiesJson(), Property[].class);
                    handledByEvent = true;
                }
            }
            String[] split = packet.e().split("\u0000");
            if (!handledByEvent && proxyLogicEnabled) {
                if (split.length != 3 && split.length != 4 || !BYPASS_HOSTCHECK && !HOST_PATTERN.matcher(split[1]).matches()) {
                    message = IChatBaseComponent.b("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                    this.d.a(new PacketLoginOutDisconnect(message));
                    this.d.a(message);
                    return;
                }
                socketAddress = this.d.d();
                this.d.hostname = split[0];
                this.d.l = new InetSocketAddress(split[1], socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getPort() : 0);
                this.d.spoofedUUID = UndashedUuid.fromStringLenient((String)split[2]);
                if (split.length == 4) {
                    this.d.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                }
            } else if ((split.length == 3 || split.length == 4) && HOST_PATTERN.matcher(split[1]).matches()) {
                message = IChatBaseComponent.b("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.d.a(new PacketLoginOutDisconnect(message));
                this.d.a(message);
            }
        }
    }

    @Override
    public void a(DisconnectionDetails details) {
    }

    @Override
    public boolean c() {
        return this.d.i();
    }
}

