/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.proxy.VelocityProxy;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.connection.PaperPlayerLoginConnection;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.connection.PlayerLoginConnection;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.notifications.ServerActivityMonitor;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener {
    private static final AtomicInteger b = new AtomicInteger(0);
    static final Logger c = LogUtils.getLogger();
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("User Authenticator #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(c)).build());
    private static final int d = 600;
    private final byte[] e;
    final MinecraftServer f;
    public final NetworkManager g;
    final ServerActivityMonitor h;
    public volatile EnumProtocolState i = EnumProtocolState.a;
    private int j;
    public @Nullable String k;
    public @Nullable GameProfile l;
    private final String m = "";
    public final boolean n;
    public boolean iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation = false;
    private int velocityLoginMessageId = -1;
    public @Nullable UUID requestedUuid;
    private final PaperPlayerLoginConnection paperLoginConnection;
    private volatile boolean disconnecting = false;

    public LoginListener(MinecraftServer server, NetworkManager connection, boolean transferred) {
        this.f = server;
        this.g = connection;
        this.h = this.f.H();
        this.e = Ints.toByteArray((int)RandomSource.a().f());
        this.n = transferred;
        this.paperLoginConnection = new PaperPlayerLoginConnection(this);
    }

    @Override
    public void d() {
        if (this.disconnecting) {
            return;
        }
        if (this.paperLoginConnection.isAwaitingCookies()) {
            this.tickTimeout();
            return;
        }
        if (this.i == EnumProtocolState.e) {
            this.c(Objects.requireNonNull(this.l));
        }
        if (this.i == EnumProtocolState.f && !this.a(Objects.requireNonNull(this.l))) {
            this.d(this.l);
        }
        this.tickTimeout();
    }

    public void tickTimeout() {
        if (this.j++ == 600) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String reason) {
        this.a(PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacySection().deserialize(reason)));
    }

    @Override
    public boolean c() {
        return this.g.i();
    }

    public void a(IChatBaseComponent reason) {
        try {
            c.info("Disconnecting {}: {}", (Object)this.e(), (Object)reason.getString());
            this.g.a(new PacketLoginOutDisconnect(reason));
            this.g.a(reason);
            this.disconnecting = true;
        }
        catch (Exception var3) {
            c.error("Error whilst disconnecting player", (Throwable)var3);
        }
    }

    private boolean a(GameProfile profile) {
        return this.f.aj().b(profile.id()) != null;
    }

    @Override
    public void a(DisconnectionDetails details) {
        c.info("{} lost connection: {}", (Object)this.e(), (Object)details.a().getString());
    }

    public String e() {
        String loggableAddress = this.g.a(this.f.bn());
        return this.k != null ? this.k + " (" + loggableAddress + ")" : loggableAddress;
    }

    @Override
    public void a(PacketLoginInStart packet) {
        Validate.validState((this.i == EnumProtocolState.a ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        if (GlobalConfiguration.get().proxies.isProxyOnlineMode() && GlobalConfiguration.get().unsupportedSettings.performUsernameValidation && !this.iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation) {
            Validate.validState((boolean)UtilColor.isReasonablePlayerName(packet.b()), (String)"Invalid characters in username", (Object[])new Object[0]);
        }
        this.requestedUuid = packet.e();
        this.k = packet.b();
        GameProfile singleplayerProfile = this.f.W();
        if (singleplayerProfile != null && this.k.equalsIgnoreCase(singleplayerProfile.name())) {
            this.b(singleplayerProfile);
        } else if (this.f.ae() && !this.g.e()) {
            this.i = EnumProtocolState.b;
            this.g.a(new PacketLoginOutEncryptionBegin("", this.f.U().getPublic().getEncoded(), this.e, true));
        } else {
            if (GlobalConfiguration.get().proxies.velocity.enabled) {
                this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                buf.l(4);
                PacketLoginOutCustomPayload packet1 = new PacketLoginOutCustomPayload(this.velocityLoginMessageId, new PacketLoginOutCustomPayload.PlayerInfoChannelPayload(VelocityProxy.PLAYER_INFO_CHANNEL, buf));
                this.g.a(packet1);
                return;
            }
            authenticatorPool.execute(() -> {
                try {
                    GameProfile gameprofile = this.createOfflineProfile(this.k);
                    gameprofile = this.callPlayerPreLoginEvents(gameprofile);
                    c.info("UUID of player {} is {}", (Object)gameprofile.name(), (Object)gameprofile.id());
                    this.b(gameprofile);
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + this.k, ex);
                }
            });
        }
    }

    void b(GameProfile authenticatedProfile) {
        this.l = authenticatedProfile;
        this.i = EnumProtocolState.e;
    }

    private void c(GameProfile profile) {
        PlayerList playerList = this.f.aj();
        IChatBaseComponent component = CraftEventFactory.handleLoginResult(playerList.canPlayerLogin(this.g.d(), new NameAndId(profile)), (PlayerConnection)this.paperLoginConnection, this.g, profile, this.f, true);
        if (component != null) {
            this.a(component);
        } else {
            boolean flag;
            if (this.f.ax() >= 0 && !this.g.e()) {
                this.g.a(new PacketLoginOutSetCompression(this.f.ax()), PacketSendListener.a(() -> this.g.a(this.f.ax(), true)));
            }
            if (flag = playerList.disconnectAllPlayersWithProfile(profile)) {
                this.i = EnumProtocolState.f;
            } else {
                this.d(profile);
            }
        }
    }

    private void d(GameProfile profile) {
        this.i = EnumProtocolState.g;
        this.g.a(new PacketLoginOutSuccess(profile));
        this.f.ar().paper().filledProfileCache().add(profile);
    }

    @Override
    public void a(PacketLoginInEncryptionBegin packet) {
        String string;
        Validate.validState((this.i == EnumProtocolState.b ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey _private = this.f.U().getPrivate();
            if (!packet.a(this.e, _private)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packet.a(_private);
            string = new BigInteger(MinecraftEncryption.a("", this.f.U().getPublic(), secretKey)).toString(16);
            this.i = EnumProtocolState.c;
            this.g.setEncryptionKey(secretKey);
        }
        catch (CryptographyException var7) {
            throw new IllegalStateException("Protocol error", var7);
        }
        authenticatorPool.execute(new Runnable(){

            @Override
            public void run() {
                String string1 = Objects.requireNonNull(LoginListener.this.k, "Player name not initialized");
                try {
                    ProfileResult profileResult = LoginListener.this.f.ar().c().hasJoinedServer(string1, string, this.a());
                    if (profileResult != null) {
                        GameProfile gameProfile = profileResult.profile();
                        if (!LoginListener.this.g.i()) {
                            return;
                        }
                        gameProfile = LoginListener.this.callPlayerPreLoginEvents(gameProfile);
                        c.info("UUID of player {} is {}", (Object)gameProfile.name(), (Object)gameProfile.id());
                        LoginListener.this.h.b();
                        LoginListener.this.b(gameProfile);
                    } else if (LoginListener.this.f.X()) {
                        c.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.b(LoginListener.this.createOfflineProfile(string1));
                    } else {
                        LoginListener.this.a(IChatBaseComponent.c("multiplayer.disconnect.unverified_username"));
                        c.error("Username '{}' tried to join with an invalid session", (Object)string1);
                    }
                }
                catch (AuthenticationUnavailableException var4) {
                    if (LoginListener.this.f.X()) {
                        c.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.b(LoginListener.this.createOfflineProfile(string1));
                    } else {
                        LoginListener.this.a(PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.authenticationServersDown));
                        c.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception ex) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    c.warn("Exception verifying {}", (Object)string1, (Object)ex);
                }
            }

            private @Nullable InetAddress a() {
                SocketAddress remoteAddress = LoginListener.this.g.d();
                return LoginListener.this.f.af() && remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getAddress() : null;
            }
        });
    }

    private GameProfile callPlayerPreLoginEvents(GameProfile gameprofile) throws Exception {
        if (this.velocityLoginMessageId == -1 && GlobalConfiguration.get().proxies.velocity.enabled) {
            this.disconnect("This server requires you to connect with Velocity.");
            return gameprofile;
        }
        String playerName = gameprofile.name();
        InetAddress address = ((InetSocketAddress)this.g.d()).getAddress();
        UUID uniqueId = gameprofile.id();
        final CraftServer server = this.f.server;
        InetAddress rawAddress = ((InetSocketAddress)this.g.k.remoteAddress()).getAddress();
        PlayerProfile profile = CraftPlayerProfile.asBukkitCopy(gameprofile);
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, rawAddress, uniqueId, this.n, profile, this.g.hostname, (PlayerLoginConnection)this.paperLoginConnection);
        server.getPluginManager().callEvent((Event)asyncEvent);
        profile = asyncEvent.getPlayerProfile();
        profile.complete(true);
        gameprofile = CraftPlayerProfile.asAuthlibCopy(profile);
        playerName = gameprofile.name();
        uniqueId = gameprofile.id();
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.kickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            this.f.processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.a(PaperAdventure.asVanilla(event.kickMessage()));
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.a(PaperAdventure.asVanilla(asyncEvent.kickMessage()));
        }
        return gameprofile;
    }

    @Override
    public void a(ServerboundCustomQueryAnswerPacket packet) {
        try {
            this.handleCustomQueryPacket0(packet);
        }
        catch (Throwable throwable) {
            ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.e();
            if (payload != null) {
                payload.buffer.release();
            }
            throw throwable;
        }
        ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.e();
        if (payload != null) {
            payload.buffer.release();
        }
    }

    private void handleCustomQueryPacket0(ServerboundCustomQueryAnswerPacket packet) {
        if (GlobalConfiguration.get().proxies.velocity.enabled && packet.b() == this.velocityLoginMessageId) {
            ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.e();
            if (payload == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            PacketDataSerializer buf = payload.buffer;
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            int version = buf.l();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.g.d();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.g.l = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            this.l = VelocityProxy.createProfile(buf);
            authenticatorPool.execute(() -> {
                try {
                    GameProfile gameprofile = this.callPlayerPreLoginEvents(this.l);
                    c.info("UUID of player {} is {}", (Object)gameprofile.name(), (Object)gameprofile.id());
                    this.b(gameprofile);
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + this.l.name(), ex);
                }
            });
            return;
        }
        this.a(ServerCommonPacketListenerImpl.c);
    }

    @Override
    public void a(ServerboundLoginAcknowledgedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.bv());
        Validate.validState((this.i == EnumProtocolState.g ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        this.g.a(ConfigurationProtocols.d);
        CommonListenerCookie commonListenerCookie = CommonListenerCookie.a(Objects.requireNonNull(this.l), this.n);
        ServerConfigurationPacketListenerImpl serverConfigurationPacketListenerImpl = new ServerConfigurationPacketListenerImpl(this.f, this.g, commonListenerCookie);
        this.g.a(ConfigurationProtocols.b, serverConfigurationPacketListenerImpl);
        serverConfigurationPacketListenerImpl.l();
        this.i = EnumProtocolState.h;
    }

    @Override
    public void a(CrashReport crashReport, CrashReportSystemDetails category) {
        category.a("Login phase", () -> this.i.toString());
    }

    @Override
    public void a(ServerboundCookieResponsePacket packet) {
        if (this.paperLoginConnection.handleCookieResponse(packet)) {
            return;
        }
        this.a(ServerCommonPacketListenerImpl.c);
    }

    protected GameProfile createOfflineProfile(String s2) {
        UUID uuid = this.g.spoofedUUID != null ? this.g.spoofedUUID : UUIDUtil.a(s2);
        ImmutableMultimap.Builder props = ImmutableMultimap.builder();
        if (this.g.spoofedProfile != null) {
            for (Property property : this.g.spoofedProfile) {
                if (!HandshakeListener.PROP_PATTERN.matcher(property.name()).matches()) continue;
                props.put((Object)property.name(), (Object)property);
            }
        }
        return new GameProfile(uuid, s2, new PropertyMap((Multimap)props.build()));
    }

    public static final class EnumProtocolState
    extends Enum<EnumProtocolState> {
        public static final /* enum */ EnumProtocolState a = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState b = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState c = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState d = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState e = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState f = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState g = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState h = new EnumProtocolState();
        private static final /* synthetic */ EnumProtocolState[] i;

        public static EnumProtocolState[] values() {
            return (EnumProtocolState[])i.clone();
        }

        public static EnumProtocolState valueOf(String name) {
            return Enum.valueOf(EnumProtocolState.class, name);
        }

        private static /* synthetic */ EnumProtocolState[] a() {
            return new EnumProtocolState[]{a, b, c, d, e, f, g, h};
        }

        static {
            i = EnumProtocolState.a();
        }
    }
}

