/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.craftbukkit.v1_21_R7.CraftChunk;
import org.bukkit.entity.Player;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger c = LogUtils.getLogger();
    public static final float a = 0.01f;
    public static final float b = 64.0f;
    private static final float d = 9.0f;
    private static final int e = 10;
    private final LongSet f = new LongOpenHashSet();
    private final boolean g;
    private float h = 9.0f;
    private float i;
    private int j;
    private int k = 1;

    public PlayerChunkSender(boolean memoryConnection) {
        this.g = memoryConnection;
    }

    public void a(Chunk chunk) {
        this.f.add(chunk.f().b());
    }

    public void a(EntityPlayer player, ChunkCoordIntPair chunkPos) {
        if (!this.f.remove(chunkPos.b()) && player.cb()) {
            player.g.b(new PacketPlayOutUnloadChunk(chunkPos));
            if (PlayerChunkUnloadEvent.getHandlerList().getRegisteredListeners().length > 0) {
                new PlayerChunkUnloadEvent(player.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)player.getBukkitEntity()).callEvent();
            }
        }
    }

    public void a(EntityPlayer player) {
        if (this.j < this.k) {
            float max = Math.max(1.0f, this.h);
            this.i = Math.min(this.i + this.h, max);
            if (!(this.i < 1.0f) && !this.f.isEmpty()) {
                WorldServer serverLevel = player.A();
                PlayerChunkMap chunkMap = serverLevel.p().a;
                List<Chunk> list = this.a(chunkMap, player.dM());
                if (!list.isEmpty()) {
                    PlayerConnection serverGamePacketListenerImpl = player.g;
                    ++this.j;
                    serverGamePacketListenerImpl.b(ClientboundChunkBatchStartPacket.a);
                    for (Chunk levelChunk : list) {
                        PlayerChunkSender.a(serverGamePacketListenerImpl, serverLevel, levelChunk);
                    }
                    serverGamePacketListenerImpl.b(new ClientboundChunkBatchFinishedPacket(list.size()));
                    this.i -= (float)list.size();
                }
            }
        }
    }

    public static void a(PlayerConnection packetListener, WorldServer level, Chunk chunk) {
        boolean shouldModify = level.chunkPacketBlockController.shouldModify(packetListener.g, chunk);
        packetListener.b(new ClientboundLevelChunkWithLightPacket(chunk, level.C_(), null, null, shouldModify));
        if (PlayerChunkLoadEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerChunkLoadEvent((org.bukkit.Chunk)new CraftChunk(chunk), (Player)packetListener.p().getBukkitEntity()).callEvent();
        }
        ChunkCoordIntPair pos = chunk.f();
        if (SharedConstants.M) {
            c.debug("SEN {}", (Object)pos);
        }
        level.W().a(packetListener.g, chunk.f());
    }

    private List<Chunk> a(PlayerChunkMap chunkMap, ChunkCoordIntPair chunkPos) {
        int floor = MathHelper.b(this.i);
        List<Chunk> list = !this.g && this.f.size() > floor ? ((List)this.f.stream().collect(Comparators.least((int)floor, Comparator.comparingInt(chunkPos::c)))).stream().mapToLong(Long::longValue).mapToObj(chunkMap::f).filter(Objects::nonNull).toList() : this.f.longStream().mapToObj(chunkMap::f).filter(Objects::nonNull).sorted(Comparator.comparingInt(levelChunk1 -> chunkPos.b(levelChunk1.f()))).toList();
        for (Chunk levelChunk : list) {
            this.f.remove(levelChunk.f().b());
        }
        return list;
    }

    public void a(float desiredBatchSize) {
        --this.j;
        float f2 = this.h = Double.isNaN(desiredBatchSize) ? 0.01f : MathHelper.a(desiredBatchSize, 0.01f, 64.0f);
        if (this.j == 0) {
            this.i = 1.0f;
        }
        this.k = 10;
    }

    public boolean a(long chunkPos) {
        return this.f.contains(chunkPos);
    }
}

