/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.connection.PaperPlayerGameConnection;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.connection.configuration.PlayerConnectionReconfigureEvent;
import io.papermc.paper.event.packet.ClientTickEndEvent;
import io.papermc.paper.event.packet.UncheckedSignChangeEvent;
import io.papermc.paper.event.player.CartographyItemEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickBlockEvent;
import io.papermc.paper.event.player.PlayerPickEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.Translator;
import net.minecraft.EnumChatFormat;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSubscriptionRequestPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TickThrottler;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftInput;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftVector;
import org.bukkit.craftbukkit.v1_21_R7.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements GameProtocols.a,
PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger i = LogUtils.getLogger();
    private static final int j = -1;
    private static final int k = 4096;
    private static final int l = 80;
    private static final int m = 5;
    public static final int f = 60;
    private static final IChatBaseComponent n = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent o = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int p = 1000;
    public EntityPlayer g;
    public final PlayerChunkSender h;
    private int q;
    private int r = -1;
    private final TickThrottler s = new TickThrottler(20, 200);
    private final TickThrottler tabSpamThrottler;
    private final TickThrottler t;
    private final TickThrottler recipeSpamPackets;
    private double u;
    private double v;
    private double w;
    private double x;
    private double y;
    private double z;
    private @Nullable net.minecraft.world.entity.Entity A;
    private double B;
    private double C;
    private double D;
    private double E;
    private double F;
    private double G;
    private @Nullable Vec3D H;
    private int I;
    private int J;
    private boolean K;
    private int L;
    private boolean M;
    private int N;
    private int O;
    private int P;
    private boolean Q;
    private int lastTick;
    private int allowedPlayerTicks;
    private int lastDropTick;
    private int lastBookTick;
    private int dropCount;
    private boolean hasMoved;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private float lastPitch;
    private float lastYaw;
    private boolean justTeleported;
    private @Nullable RemoteChatSession R;
    private boolean hasLoggedExpiry;
    private SignedMessageChain.b S;
    private final LastSeenMessagesValidator T;
    private int U;
    private final MessageSignatureCache V;
    private final FutureChain W;
    private boolean X;
    private boolean Y;
    private int Z;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private final ClientTickEndEvent tickEndEvent;
    public final PaperPlayerGameConnection playerGameConnection;
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.m)).build());
    private int limitedPackets;
    private long lastLimitedPacket;

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player, CommonListenerCookie cookie) {
        super(server, connection, cookie);
        this.tabSpamThrottler = new TickThrottler(GlobalConfiguration.get().spamLimiter.tabSpamIncrement, GlobalConfiguration.get().spamLimiter.tabSpamLimit);
        this.t = new TickThrottler(20, 1480);
        this.recipeSpamPackets = new TickThrottler(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement, GlobalConfiguration.get().spamLimiter.recipeSpamLimit);
        this.lastTick = MinecraftServer.currentTick;
        this.allowedPlayerTicks = 1;
        this.lastDropTick = MinecraftServer.currentTick;
        this.lastBookTick = MinecraftServer.currentTick;
        this.dropCount = 0;
        this.hasMoved = false;
        this.lastPosX = Double.MAX_VALUE;
        this.lastPosY = Double.MAX_VALUE;
        this.lastPosZ = Double.MAX_VALUE;
        this.lastPitch = Float.MAX_VALUE;
        this.lastYaw = Float.MAX_VALUE;
        this.justTeleported = false;
        this.hasLoggedExpiry = false;
        this.T = new LastSeenMessagesValidator(20);
        this.V = MessageSignatureCache.a();
        this.lastLimitedPacket = -1L;
        this.y();
        this.h = new PlayerChunkSender(connection.e());
        this.g = player;
        player.g = this;
        player.Y().a();
        this.S = SignedMessageChain.b.unsigned(player.cY(), server::ay);
        this.W = new FutureChain(server.chatExecutor);
        this.tickEndEvent = new ClientTickEndEvent((Player)player.getBukkitEntity());
        this.playerGameConnection = new PaperPlayerGameConnection(this);
    }

    @Override
    public PlayerCommonConnection getApiConnection() {
        return this.playerGameConnection;
    }

    @Override
    public Audience getAudience() {
        return this.getCraftPlayer();
    }

    @Override
    public void d() {
        if (this.r > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.r));
            this.r = -1;
        }
        if (this.d.I() || !this.t()) {
            this.e();
            this.s.b();
            this.t.b();
            this.tabSpamThrottler.b();
            this.recipeSpamPackets.b();
            if (this.g.P() > 0L && this.d.aq() > 0 && SystemUtils.c() - this.g.P() > TimeUnit.MINUTES.toMillis(this.d.aq()) && !this.g.k) {
                this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
            }
        }
    }

    private boolean t() {
        this.m();
        this.g.Y = this.g.dP();
        this.g.Z = this.g.dR();
        this.g.aa = this.g.dV();
        this.g.h();
        this.g.a(this.u, this.v, this.w, this.g.ec(), this.g.ee());
        ++this.q;
        this.P = this.O;
        if (this.K && !this.g.gr() && !this.g.cq() && !this.g.fa()) {
            if (++this.L > this.a(this.g)) {
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return true;
            }
        } else {
            this.K = false;
            this.L = 0;
        }
        this.A = this.g.du();
        if (this.A != this.g && this.A.dl() == this.g) {
            this.B = this.A.dP();
            this.C = this.A.dR();
            this.D = this.A.dV();
            this.E = this.A.dP();
            this.F = this.A.dR();
            this.G = this.A.dV();
            if (this.M && this.A.dl() == this.g) {
                if (++this.N > this.a(this.A)) {
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return true;
                }
            } else {
                this.M = false;
                this.N = 0;
            }
        } else {
            this.A = null;
            this.M = false;
            this.N = 0;
        }
        if (!this.hasLoggedExpiry && this.R != null && this.R.d().b().a()) {
            i.info("Player profile key for {} has expired!", (Object)this.g.aq());
            this.hasLoggedExpiry = true;
        }
        return false;
    }

    private int a(net.minecraft.world.entity.Entity entity) {
        double gravity = entity.bt();
        if (gravity < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d2 = 0.08 / gravity;
        return MathHelper.e(80.0 * Math.max(d2, 1.0));
    }

    public void l() {
        this.L = 0;
        this.N = 0;
    }

    public void m() {
        this.u = this.g.dP();
        this.v = this.g.dR();
        this.w = this.g.dV();
        this.x = this.g.dP();
        this.y = this.g.dR();
        this.z = this.g.dV();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.X;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) || this.X && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.g.gI();
    }

    private <T, R> CompletableFuture<R> a(T message, BiFunction<ITextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(this.g.Y(), (ITextFilter)message).thenApply(result -> {
            if (!this.c()) {
                i.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return result;
        });
    }

    private CompletableFuture<FilteredText> a(String text) {
        return this.a(text, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> texts) {
        return this.a(texts, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        Input lastInput;
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (!packet.b().equals(this.g.ai())) {
            PlayerInputEvent event = new PlayerInputEvent((Player)this.g.getBukkitEntity(), (org.bukkit.Input)new CraftInput(packet.b()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if ((lastInput = this.g.ai()).f() != packet.b().f()) {
            PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.b().f());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled() && this.q()) {
                this.g.h(packet.b().f());
            }
        }
        this.g.a(packet.b());
        if (this.q()) {
            this.g.J();
        }
        if (packet.b().f() && this.g.A().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.g.k();
        }
    }

    private static boolean b(double x2, double y2, double z2, float yRot, float xRot) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)xRot) || !Floats.isFinite((float)yRot);
    }

    private static double a(double value) {
        return MathHelper.a(value, -3.0E7, 3.0E7);
    }

    private static double b(double value) {
        return MathHelper.a(value, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (PlayerConnection.b(packet.b().a(), packet.b().b(), packet.b().c(), packet.e(), packet.f())) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else if (!this.u() && this.q()) {
            net.minecraft.world.entity.Entity rootVehicle = this.g.du();
            if (this.H != null || this.g.fE() || rootVehicle.eh()) {
                return;
            }
            if (rootVehicle != this.g && rootVehicle.dl() == this.g && rootVehicle == this.A) {
                boolean teleportBack;
                EntityLiving livingEntity;
                double d2;
                double d1;
                double d3;
                WorldServer serverLevel = this.g.A();
                double prevX = this.g.dP();
                double prevY = this.g.dR();
                double prevZ = this.g.dV();
                float prevYaw = this.g.ec();
                float prevPitch = this.g.ee();
                double x2 = rootVehicle.dP();
                double y2 = rootVehicle.dR();
                double z2 = rootVehicle.dV();
                double toX = d3 = PlayerConnection.a(packet.b().a());
                double toY = d1 = PlayerConnection.b(packet.b().b());
                double toZ = d2 = PlayerConnection.a(packet.b().c());
                float f2 = MathHelper.f(packet.e());
                float f1 = MathHelper.f(packet.f());
                double d32 = d3 - this.B;
                double d4 = d1 - this.C;
                double d5 = d2 - this.D;
                double d6 = rootVehicle.dN().h();
                double d7 = d32 * d32 + d4 * d4 + d5 * d5;
                double currDeltaX = toX - x2;
                double currDeltaY = toY - y2;
                double currDeltaZ = toZ - z2;
                d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = toX - this.E;
                double otherFieldY = toY - this.F;
                double otherFieldZ = toZ - this.G;
                d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.O;
                int i2 = this.O - this.P;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    i.debug(this.g.da() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.g.gL().b ? (double)(this.g.gL().m * 20.0f) : (double)(this.g.gL().n * 10.0f);
                speed *= 2.0;
                if (!(!this.g.A().paperConfig().chunks.preventMovingIntoUnloadedChunks || serverLevel.areChunksLoadedForMove(this.g.dj().b(new Vec3D(toX, toY, toZ).d(this.g.dI()))) && serverLevel.areChunksLoadedForMove(rootVehicle.dj().b(new Vec3D(toX, toY, toZ).d(rootVehicle.dI()))))) {
                    this.e.a(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                if (d7 - d6 > Math.max(100.0, MathHelper.n(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed)) && !this.h()) {
                    i.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{rootVehicle.aq(), this.g.aq(), d32, d4, d5});
                    this.b(PacketPlayOutVehicleMove.a(rootVehicle));
                    return;
                }
                AxisAlignedBB boundingBox = rootVehicle.dj();
                d32 = d3 - this.E;
                d4 = d1 - this.F;
                d5 = d2 - this.G;
                boolean flag = rootVehicle.af;
                if (rootVehicle instanceof EntityLiving && (livingEntity = (EntityLiving)rootVehicle).fl()) {
                    livingEntity.l();
                }
                rootVehicle.a(EnumMoveType.b, new Vec3D(d32, d4, d5));
                boolean didCollide = toX != rootVehicle.dP() || toY != rootVehicle.dR() || toZ != rootVehicle.dV();
                double verticalDelta = d4;
                d32 = d3 - rootVehicle.dP();
                d4 = d1 - rootVehicle.dR();
                if (d4 > -0.5 || d4 < 0.5) {
                    d4 = 0.0;
                }
                d5 = d2 - rootVehicle.dV();
                d7 = d32 * d32 + d4 * d4 + d5 * d5;
                boolean flag1 = false;
                if (d7 > SpigotConfig.movedWronglyThreshold) {
                    flag1 = true;
                    i.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{rootVehicle.aq(), this.g.aq(), Math.sqrt(d7)});
                }
                if (!(teleportBack = flag1)) {
                    AxisAlignedBB newBox = rootVehicle.dj();
                    if (didCollide || !boundingBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(serverLevel, rootVehicle, boundingBox, newBox);
                    }
                }
                if (teleportBack) {
                    rootVehicle.a(x2, y2, z2, f2, f1);
                    this.b(PacketPlayOutVehicleMove.a(rootVehicle));
                    rootVehicle.aX();
                    return;
                }
                rootVehicle.a(d3, d1, d2, f2, f1);
                this.g.a(d3, d1, d2, this.g.ec(), this.g.ee());
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = prevX;
                    this.lastPosY = prevY;
                    this.lastPosZ = prevZ;
                    this.lastYaw = prevYaw;
                    this.lastPitch = prevPitch;
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = CraftLocation.toBukkit(packet.b(), player.getWorld(), packet.e(), packet.f());
                double delta = MathHelper.n(this.lastPosX - to.getX()) + MathHelper.n(this.lastPosY - to.getY()) + MathHelper.n(this.lastPosZ - to.getZ());
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.g.fE()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.internalTeleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.g.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.g.A().p().a(this.g);
                Vec3D vec3 = new Vec3D(rootVehicle.dP() - x2, rootVehicle.dR() - y2, rootVehicle.dV() - z2);
                this.a(vec3);
                rootVehicle.a(packet.g(), vec3);
                rootVehicle.a(vec3.g, vec3.h, vec3.i, packet.g());
                this.g.a(vec3.g, vec3.h, vec3.i);
                this.M = verticalDelta >= -0.03125 && !flag && !this.d.ag() && !rootVehicle.em() && !rootVehicle.br() && this.b(rootVehicle);
                this.E = rootVehicle.dP();
                this.F = rootVehicle.dR();
                this.G = rootVehicle.dV();
            }
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.dj().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.c(box.a);
        int minY = MathHelper.c(box.b);
        int minZ = MathHelper.c(box.c);
        int maxX = MathHelper.c(box.d);
        int maxY = MathHelper.c(box.e);
        int maxZ = MathHelper.c(box.f);
        net.minecraft.world.level.World level = entity.ao();
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData blockState = level.getBlockStateIfLoaded(pos);
                    if (blockState == null || blockState.l()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (packet.b() == this.I) {
            if (this.H == null) {
                this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.g.a(this.H.g, this.H.h, this.H.i, this.g.ec(), this.g.ee());
            this.x = this.H.g;
            this.y = this.H.h;
            this.z = this.H.i;
            this.g.T();
            this.H = null;
            this.g.A().p().a(this.g);
        }
    }

    @Override
    public void a(ServerboundPlayerLoadedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.x();
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        CraftingManager.d recipeFromDisplay = this.d.aJ().a(packet.b());
        if (recipeFromDisplay != null) {
            this.g.L().d(recipeFromDisplay.b().a());
        }
    }

    @Override
    public void a(ServerboundSelectBundleItemPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.g.cn.a(packet.b(), packet.e());
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        CraftEventFactory.callRecipeBookSettingsEvent(this.g, packet.b(), packet.e(), packet.f());
        this.g.L().a(packet.b(), packet.e(), packet.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (packet.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey identifier = Objects.requireNonNull(packet.f());
            AdvancementHolder advancementHolder = this.d.aB().a(identifier);
            if (advancementHolder != null) {
                this.g.U().a(advancementHolder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        int index;
        if (!(this.tabSpamThrottler.isIncrementAndUnderThreshold() || this.d.aj().f(this.g.gJ()) || this.d.a(this.g.gJ()))) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        if (packet.e().length() > 64 && ((index = packet.e().indexOf(32)) == -1 || index >= 64)) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> this.handleCustomCommandSuggestions0(packet));
    }

    private void handleCustomCommandSuggestions0(PacketPlayInTabComplete packet) {
        Object completions;
        StringReader stringReader = new StringReader(packet.e());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), packet.e(), true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (event.isCancelled()) {
                return;
            }
            this.d.scheduleOnMain(() -> this.sendServerSuggestions(packet, stringReader));
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.e(), stringReader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            Iterator iterator = completions.iterator();
            while (iterator.hasNext()) {
                AsyncTabCompleteEvent.Completion completion = (AsyncTabCompleteEvent.Completion)iterator.next();
                Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                if (intSuggestion != null) {
                    builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    continue;
                }
                builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
            }
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.e.a(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        }
    }

    private static Suggestions limitTo(Suggestions suggestions, int size) {
        return suggestions.getList().size() <= size ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, size));
    }

    private void sendServerSuggestions(PacketPlayInTabComplete packet, StringReader stringReader) {
        ParseResults<CommandListenerWrapper> parseResults = this.d.aF().a().parse(stringReader, this.g.C());
        if (!parseResults.getExceptions().isEmpty() && parseResults.getExceptions().values().stream().anyMatch(e2 -> e2 instanceof TagParseCommandSyntaxException)) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        this.d.aF().a().getCompletionSuggestions(parseResults).thenAccept(suggestions -> {
            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
            }
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.b(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (!(this.g.hi() || this.g.ha() && this.g.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.g.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract baseCommandBlock = null;
            TileEntityCommand commandBlockEntity = null;
            BlockPosition pos = packet.b();
            TileEntity blockEntity = this.g.A().c_(pos);
            if (blockEntity instanceof TileEntityCommand) {
                TileEntityCommand commandBlockEntity1;
                commandBlockEntity = commandBlockEntity1 = (TileEntityCommand)blockEntity;
                baseCommandBlock = commandBlockEntity1.a();
            }
            String command = packet.e();
            boolean isTrackOutput = packet.f();
            if (baseCommandBlock != null) {
                TileEntityCommand.Type mode = commandBlockEntity.l();
                IBlockData blockState = this.g.A().a_(pos);
                EnumDirection direction = blockState.c(BlockCommand.b);
                IBlockData blockState1 = switch (packet.i()) {
                    case TileEntityCommand.Type.a -> Blocks.lD.m();
                    case TileEntityCommand.Type.b -> Blocks.lC.m();
                    default -> Blocks.gC.m();
                };
                IBlockData blockState2 = (IBlockData)((IBlockData)blockState1.b(BlockCommand.b, direction)).b(BlockCommand.c, packet.g());
                if (blockState2 != blockState) {
                    this.g.A().a(pos, blockState2, 2);
                    blockEntity.c(blockState2);
                    this.g.A().q(pos).a(blockEntity);
                }
                baseCommandBlock.a(command);
                baseCommandBlock.a(isTrackOutput);
                if (!isTrackOutput) {
                    baseCommandBlock.b((IChatBaseComponent)null);
                }
                commandBlockEntity.b(packet.h());
                if (mode != packet.i()) {
                    commandBlockEntity.f();
                }
                if (this.g.A().Y()) {
                    baseCommandBlock.a(this.g.A());
                }
                if (!UtilColor.b(command)) {
                    this.g.a(IChatBaseComponent.a(this.g.A().Y() ? "advMode.setCommand.success" : "advMode.setCommand.disabled", new Object[]{command}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (!(this.g.hi() || this.g.ha() && this.g.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.g.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandBlock = packet.a(this.g.A());
            if (commandBlock != null) {
                boolean isCommandBlockEnabled;
                String command = packet.b();
                commandBlock.a(command);
                commandBlock.a(packet.e());
                if (!packet.e()) {
                    commandBlock.b((IChatBaseComponent)null);
                }
                if (isCommandBlockEnabled = this.g.A().Y()) {
                    commandBlock.a(this.g.A());
                }
                if (!UtilColor.b(command)) {
                    this.g.a(IChatBaseComponent.a(isCommandBlockEnabled ? "advMode.setCommand.success" : "advMode.setCommand.disabled", new Object[]{command}));
                }
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromBlockPacket packet) {
        boolean flag;
        IBlockData blockState;
        net.minecraft.world.item.ItemStack cloneItemStack;
        WorldServer serverLevel = this.g.A();
        PlayerConnectionUtils.a(packet, this, serverLevel);
        BlockPosition blockPos = packet.b();
        if (this.g.a(blockPos, 1.0) && serverLevel.t(blockPos) && !(cloneItemStack = (blockState = serverLevel.a_(blockPos)).a((IWorldReader)serverLevel, blockPos, flag = this.g.gv() && packet.e())).f()) {
            if (flag && this.g.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                PlayerConnection.a(blockState, serverLevel, blockPos, cloneItemStack);
            }
            this.tryPickItem(cloneItemStack, blockPos, null, packet.e());
        }
    }

    private static void a(IBlockData state, WorldServer level, BlockPosition pos, net.minecraft.world.item.ItemStack stack) {
        TileEntity blockEntity;
        TileEntity tileEntity = blockEntity = state.x() ? level.c_(pos) : null;
        if (blockEntity != null) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(blockEntity.v(), i);){
                TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, level.J_());
                blockEntity.f(tagValueOutput);
                blockEntity.b(tagValueOutput);
                ItemBlock.a(stack, blockEntity.s(), tagValueOutput);
                stack.b(blockEntity.t());
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromEntityPacket packet) {
        net.minecraft.world.item.ItemStack pickResult;
        WorldServer serverLevel = this.g.A();
        PlayerConnectionUtils.a(packet, this, serverLevel);
        net.minecraft.world.entity.Entity entityOrPart = serverLevel.b(packet.b());
        if (entityOrPart != null && this.g.b(entityOrPart, 3.0) && (pickResult = entityOrPart.dZ()) != null && !pickResult.f()) {
            this.tryPickItem(pickResult, null, entityOrPart, packet.e());
        }
    }

    private void tryPickItem(net.minecraft.world.item.ItemStack stack, @Nullable BlockPosition blockPos, @Nullable net.minecraft.world.entity.Entity entity, boolean includeData) {
        if (stack.a(this.g.A().Q())) {
            PlayerPickEntityEvent event;
            PlayerInventory inventory = this.g.gK();
            int i2 = inventory.d(stack);
            int sourceSlot = i2;
            int targetSlot = PlayerInventory.f(sourceSlot) ? sourceSlot : inventory.l();
            CraftPlayer bukkitPlayer = this.g.getBukkitEntity();
            Object object = event = entity != null ? new PlayerPickEntityEvent((Player)bukkitPlayer, (Entity)entity.getBukkitEntity(), includeData, targetSlot, sourceSlot) : new PlayerPickBlockEvent((Player)bukkitPlayer, (Block)CraftBlock.at(this.g.A(), blockPos), includeData, targetSlot, sourceSlot);
            if (!event.callEvent()) {
                return;
            }
            i2 = event.getSourceSlot();
            if (i2 != -1) {
                if (PlayerInventory.f(i2) && PlayerInventory.f(event.getTargetSlot())) {
                    inventory.d(event.getTargetSlot());
                } else {
                    inventory.pickSlot(i2, event.getTargetSlot());
                }
            } else if (this.g.gv()) {
                inventory.addAndPickItem(stack, event.getTargetSlot());
            }
            this.b(new PacketPlayOutHeldItemSlot(inventory.g()));
            this.g.cm.d();
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.g.K();
            }
        }
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        Container container = this.g.cn;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil anvilMenu = (ContainerAnvil)container;
            if (!anvilMenu.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)anvilMenu);
                return;
            }
            anvilMenu.a(packet.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        Container container = this.g.cn;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon beaconMenu = (ContainerBeacon)container;
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
                return;
            }
            beaconMenu.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition pos = packet.b();
            IBlockData blockState = this.g.A().a_(pos);
            TileEntity tileEntity = this.g.A().c_(pos);
            if (tileEntity instanceof TileEntityStructure) {
                TileEntityStructure structureBlockEntity = (TileEntityStructure)tileEntity;
                structureBlockEntity.a(packet.f());
                structureBlockEntity.a(packet.g());
                structureBlockEntity.a(packet.h());
                structureBlockEntity.a(packet.i());
                structureBlockEntity.a(packet.j());
                structureBlockEntity.a(packet.k());
                structureBlockEntity.b(packet.l());
                structureBlockEntity.a(packet.m());
                structureBlockEntity.b(packet.n());
                structureBlockEntity.e(packet.o());
                structureBlockEntity.f(packet.p());
                structureBlockEntity.a(packet.q());
                structureBlockEntity.a(packet.r());
                if (structureBlockEntity.f()) {
                    String structureName = structureBlockEntity.d();
                    if (packet.e() == TileEntityStructure.UpdateType.b) {
                        if (structureBlockEntity.D()) {
                            this.g.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{structureName}), false);
                        } else {
                            this.g.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{structureName}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.c) {
                        if (!structureBlockEntity.F()) {
                            this.g.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{structureName}), false);
                        } else if (structureBlockEntity.a(this.g.A())) {
                            this.g.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{structureName}), false);
                        } else {
                            this.g.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{structureName}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.d) {
                        if (structureBlockEntity.C()) {
                            this.g.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{structureName}), false);
                        } else {
                            this.g.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.g.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packet.g()}), false);
                }
                structureBlockEntity.e();
                this.g.A().a(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void a(ServerboundSetTestBlockPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition blockPos = packet.b();
            IBlockData blockState = this.g.A().a_(blockPos);
            TileEntity tileEntity = this.g.A().c_(blockPos);
            if (tileEntity instanceof TestBlockEntity) {
                TestBlockEntity testBlockEntity = (TestBlockEntity)tileEntity;
                testBlockEntity.a(packet.e());
                testBlockEntity.a(packet.f());
                testBlockEntity.e();
                this.g.A().a(blockPos, blockState, testBlockEntity.o(), 3);
            }
        }
    }

    @Override
    public void a(ServerboundTestInstanceBlockActionPacket packet) {
        TileEntity tileEntity;
        PlayerConnectionUtils.a(packet, this, this.g.A());
        BlockPosition blockPos = packet.b();
        if (this.g.hi() && (tileEntity = this.g.A().c_(blockPos)) instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testInstanceBlockEntity = (TestInstanceBlockEntity)tileEntity;
            if (packet.e() != ServerboundTestInstanceBlockActionPacket.a.b && packet.e() != ServerboundTestInstanceBlockActionPacket.a.a) {
                testInstanceBlockEntity.a(packet.f());
                if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.d) {
                    testInstanceBlockEntity.a(this.g::a);
                } else if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.e) {
                    testInstanceBlockEntity.b(this.g::a);
                } else if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.f) {
                    testInstanceBlockEntity.c(this.g::a);
                } else if (packet.e() == ServerboundTestInstanceBlockActionPacket.a.g) {
                    testInstanceBlockEntity.d(this.g::a);
                }
                IBlockData blockState = this.g.A().a_(blockPos);
                this.g.A().a(blockPos, Blocks.a.m(), blockState, 3);
            } else {
                IRegistry<GameTestInstance> registry = this.g.eo().f(Registries.bv);
                Optional optional = packet.f().a().flatMap(registry::a);
                IChatBaseComponent component = optional.isPresent() ? ((GameTestInstance)((Holder.c)optional.get()).a()).c() : IChatBaseComponent.c("test_instance.description.no_test").a(EnumChatFormat.m);
                Optional<Object> optional1 = packet.e() == ServerboundTestInstanceBlockActionPacket.a.b ? packet.f().a().flatMap(resourceKey -> TestInstanceBlockEntity.a(this.g.A(), resourceKey)) : Optional.empty();
                this.e.a(new ClientboundTestInstanceBlockStatus(component, optional1));
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition pos = packet.b();
            IBlockData blockState = this.g.A().a_(pos);
            TileEntity tileEntity = this.g.A().c_(pos);
            if (tileEntity instanceof TileEntityJigsaw) {
                TileEntityJigsaw jigsawBlockEntity = (TileEntityJigsaw)tileEntity;
                jigsawBlockEntity.a(packet.e());
                jigsawBlockEntity.b(packet.f());
                jigsawBlockEntity.a(ResourceKey.a(Registries.bt, packet.g()));
                jigsawBlockEntity.a(packet.h());
                jigsawBlockEntity.a(packet.i());
                jigsawBlockEntity.a(packet.k());
                jigsawBlockEntity.b(packet.j());
                jigsawBlockEntity.e();
                this.g.A().a(pos, blockState, blockState, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.hi()) {
            BlockPosition pos = packet.b();
            TileEntity tileEntity = this.g.A().c_(pos);
            if (tileEntity instanceof TileEntityJigsaw) {
                TileEntityJigsaw jigsawBlockEntity = (TileEntityJigsaw)tileEntity;
                jigsawBlockEntity.a(this.g.A(), packet.e(), packet.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        int item = packet.b();
        Container container = this.g.cn;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant merchantMenu = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(item, merchantMenu);
            if (tradeSelectEvent.isCancelled()) {
                this.g.cn.b();
                return;
            }
            if (!merchantMenu.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)merchantMenu);
                return;
            }
            merchantMenu.e(item);
            merchantMenu.h(item);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        IntOr.Disabled pageMax = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
        if (!this.cserver.isPrimaryThread() && pageMax.enabled()) {
            List<String> pageList = packet.e();
            long byteTotal = 0L;
            int maxBookPageSize = pageMax.intValue();
            double multiplier = Math.clamp(GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier, 0.3, 1.0);
            long byteAllowed = maxBookPageSize;
            for (String page : pageList) {
                int byteLength = page.getBytes(StandardCharsets.UTF_8).length;
                byteTotal += (long)byteLength;
                int length = page.length();
                int multiByteCharacters = 0;
                if (byteLength != length) {
                    for (char c2 : page.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multiByteCharacters;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.clamp((double)length / 255.0, 0.1, 1.0) * multiplier);
                if (multiByteCharacters <= 1) continue;
                byteAllowed -= (long)multiByteCharacters;
            }
            if (byteTotal > byteAllowed) {
                i.warn("{} tried to send a book too large. Book size: {} - Allowed: {} - Pages: {}", new Object[]{this.g.da(), byteTotal, byteAllowed, pageList.size()});
                this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.b("Book too large!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.b("Book edited too quickly!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int slot = packet.b();
        if (PlayerInventory.f(slot) || slot == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.f();
            optional.ifPresent(list::add);
            list.addAll(packet.e());
            Consumer<List> consumer = optional.isPresent() ? texts -> this.a((FilteredText)texts.get(0), texts.subList(1, texts.size()), slot) : list1 -> this.a((List<FilteredText>)list1, slot);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> pages, int index) {
        net.minecraft.world.item.ItemStack handItem = this.g.gK().a(index);
        net.minecraft.world.item.ItemStack item = handItem.v();
        if (item.c(DataComponents.ab)) {
            List<Filterable<String>> list = pages.stream().map(this::a).toList();
            item.b(DataComponents.ab, new WritableBookContent(list));
            this.g.gK().a(index, CraftEventFactory.handleEditBookEvent(this.g, index, handItem, item));
        }
    }

    private void a(FilteredText title, List<FilteredText> pages, int index) {
        net.minecraft.world.item.ItemStack item = this.g.gK().a(index);
        if (item.c(DataComponents.ab)) {
            net.minecraft.world.item.ItemStack itemStack = item.a((IMaterial)Items.wl);
            itemStack.e(DataComponents.ab);
            List<Filterable<IChatBaseComponent>> list = pages.stream().map(filteredText -> this.a((FilteredText)filteredText).a(IChatBaseComponent::b)).toList();
            itemStack.b(DataComponents.ac, new WrittenBookContent(this.a(title), this.g.aq(), 0, list, true));
            CraftEventFactory.handleEditBookEvent(this.g, index, item, itemStack);
            this.g.gK().a(index, item);
        }
    }

    private Filterable<String> a(FilteredText filteredText) {
        return this.g.Z() ? Filterable.a(filteredText.b()) : Filterable.a(filteredText);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.I().hasPermission(Permissions.b) && (entity = this.g.A().a(packet.e())) != null) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(entity.es(), i);){
                TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, entity.eo());
                entity.d(tagValueOutput);
                NBTTagCompound compoundTag = tagValueOutput.b();
                this.b(new PacketPlayOutNBTQuery(packet.b(), compoundTag));
            }
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket packet) {
        CrafterMenu crafterMenu;
        Object object;
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (!this.g.au() && packet.e() == this.g.cn.l && (object = this.g.cn) instanceof CrafterMenu && (object = (crafterMenu = (CrafterMenu)object).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)object;
            crafterBlockEntity.a(packet.b(), packet.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.I().hasPermission(Permissions.b)) {
            TileEntity blockEntity = this.g.A().c_(packet.e());
            NBTTagCompound compoundTag = blockEntity != null ? blockEntity.c(this.g.eo()) : null;
            this.b(new PacketPlayOutNBTQuery(packet.b(), compoundTag));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (PlayerConnection.b(packet.a(0.0), packet.b(0.0), packet.c(0.0), packet.a(0.0f), packet.b(0.0f))) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer serverLevel = this.g.A();
            if (!this.g.k && !this.g.fE()) {
                if (this.q == 0) {
                    this.m();
                }
                if (this.q()) {
                    float f1;
                    float f2;
                    float toYaw = f2 = MathHelper.f(packet.a(this.g.ec()));
                    float toPitch = f1 = MathHelper.f(packet.b(this.g.ee()));
                    if (this.u()) {
                        this.g.b(f2, f1);
                    } else {
                        double d2;
                        double d1;
                        double d3;
                        double toX = d3 = PlayerConnection.a(packet.a(this.g.dP()));
                        double toY = d1 = PlayerConnection.b(packet.b(this.g.dR()));
                        double toZ = d2 = PlayerConnection.a(packet.c(this.g.dV()));
                        if (this.g.cq()) {
                            this.g.a(this.g.dP(), this.g.dR(), this.g.dV(), f2, f1);
                            this.g.A().p().a(this.g);
                            this.allowedPlayerTicks = 20;
                        } else {
                            double prevX = this.g.dP();
                            double prevY = this.g.dR();
                            double prevZ = this.g.dV();
                            float prevYaw = this.g.ec();
                            float prevPitch = this.g.ee();
                            double x2 = this.g.dP();
                            double y2 = this.g.dR();
                            double z2 = this.g.dV();
                            double d32 = d3 - this.u;
                            double d4 = d1 - this.v;
                            double d5 = d2 - this.w;
                            double d6 = this.g.dN().h();
                            double d7 = d32 * d32 + d4 * d4 + d5 * d5;
                            double currDeltaX = toX - prevX;
                            double currDeltaY = toY - prevY;
                            double currDeltaZ = toZ - prevZ;
                            d7 = Math.max(d7, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                            double otherFieldX = d3 - this.x;
                            double otherFieldY = d1 - this.y;
                            double otherFieldZ = d2 - this.z;
                            d7 = Math.max(d7, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                            if (this.g.gr()) {
                                if (d7 > 1.0) {
                                    this.a(this.g.dP(), this.g.dR(), this.g.dV(), f2, f1);
                                }
                            } else {
                                PlayerFailMoveEvent event;
                                PlayerFailMoveEvent event2;
                                boolean didCollide;
                                boolean flag;
                                boolean isFallFlying = this.g.gj();
                                if (serverLevel.y().i()) {
                                    PlayerFailMoveEvent event3;
                                    ++this.O;
                                    int i2 = this.O - this.P;
                                    this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                    this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                    this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                    if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                        i.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.g.aq(), (Object)i2);
                                        i2 = 1;
                                    }
                                    this.allowedPlayerTicks = packet.i || d7 > 0.0 ? --this.allowedPlayerTicks : 20;
                                    double speed = this.g.gL().b ? (double)(this.g.gL().m * 20.0f) : (double)(this.g.gL().n * 10.0f);
                                    if (!(!this.g.A().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.g.dP() == toX && this.g.dV() == toZ || serverLevel.areChunksLoadedForMove(this.g.dj().b(new Vec3D(toX, toY, toZ).d(this.g.dI()))) || (event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                        this.internalTeleport(PositionMoveRotation.a(this.g), Collections.emptySet());
                                        return;
                                    }
                                    if (this.a(isFallFlying)) {
                                        PlayerFailMoveEvent event4;
                                        float f22;
                                        float f3 = f22 = isFallFlying ? 300.0f : 100.0f;
                                        if (d7 - d6 > Math.max((double)f22, MathHelper.n(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed)) && !(event4 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                            if (event4.getLogWarning()) {
                                                i.warn("{} moved too quickly! {},{},{}", new Object[]{this.g.aq(), d32, d4, d5});
                                            }
                                            this.a(this.g.dP(), this.g.dR(), this.g.dV(), this.g.ec(), this.g.ee());
                                            return;
                                        }
                                    }
                                }
                                AxisAlignedBB boundingBox = this.g.dj();
                                d32 = d3 - this.x;
                                d4 = d1 - this.y;
                                d5 = d2 - this.z;
                                boolean bl = flag = d4 > 0.0;
                                if (this.g.aV() && !packet.b() && flag) {
                                    PlayerJumpEvent event5;
                                    CraftPlayer player = this.getCraftPlayer();
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packet.h) {
                                        to.setX(packet.a);
                                        to.setY(packet.b);
                                        to.setZ(packet.c);
                                    }
                                    if (packet.i) {
                                        to.setYaw(packet.d);
                                        to.setPitch(packet.e);
                                    }
                                    if ((event5 = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                        this.g.u();
                                    } else {
                                        from = event5.getFrom();
                                        this.internalTeleport(new PositionMoveRotation(CraftLocation.toVec3(from), Vec3D.c, from.getYaw(), from.getPitch()), Collections.emptySet());
                                        return;
                                    }
                                }
                                boolean flag1 = this.g.af;
                                this.g.a(EnumMoveType.b, new Vec3D(d32, d4, d5));
                                ((net.minecraft.world.entity.Entity)this.g).bc = packet.b();
                                boolean bl2 = didCollide = toX != this.g.dP() || toY != this.g.dR() || toZ != this.g.dV();
                                if (this.H != null) {
                                    return;
                                }
                                double verticalDelta = d4;
                                d32 = d3 - this.g.dP();
                                d4 = d1 - this.g.dR();
                                if (d4 > -0.5 || d4 < 0.5) {
                                    d4 = 0.0;
                                }
                                d5 = d2 - this.g.dV();
                                d7 = d32 * d32 + d4 * d4 + d5 * d5;
                                boolean movedWrongly = false;
                                if (!(this.g.S() || !(d7 > SpigotConfig.movedWronglyThreshold) || this.g.gr() || this.g.ha() || this.g.au() || this.g.hq() || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                    movedWrongly = true;
                                    if (event2.getLogWarning()) {
                                        i.warn("{} moved wrongly!", (Object)this.g.aq());
                                    }
                                }
                                boolean allowMovement = this.g.ar || this.g.gr() || !movedWrongly;
                                this.g.a(d3, d1, d2, f2, f1);
                                if (!this.g.ar && !this.g.gr() && allowMovement) {
                                    AxisAlignedBB newBox = this.g.dj();
                                    if (didCollide || !boundingBox.equals(newBox)) {
                                        boolean bl3 = allowMovement = !this.hasNewCollision(serverLevel, this.g, boundingBox, newBox);
                                    }
                                }
                                if (!allowMovement && (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                    allowMovement = true;
                                }
                                if (allowMovement) {
                                    this.g.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                    CraftPlayer player = this.getCraftPlayer();
                                    if (!this.hasMoved) {
                                        this.lastPosX = prevX;
                                        this.lastPosY = prevY;
                                        this.lastPosZ = prevZ;
                                        this.lastYaw = prevYaw;
                                        this.lastPitch = prevPitch;
                                        this.hasMoved = true;
                                    }
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packet.h) {
                                        to.setX(packet.a);
                                        to.setY(packet.b);
                                        to.setZ(packet.c);
                                    }
                                    if (packet.i) {
                                        to.setYaw(packet.d);
                                        to.setPitch(packet.e);
                                    }
                                    double delta = MathHelper.n(this.lastPosX - to.getX()) + MathHelper.n(this.lastPosY - to.getY()) + MathHelper.n(this.lastPosZ - to.getZ());
                                    float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                    if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.g.fE()) {
                                        this.lastPosX = to.getX();
                                        this.lastPosY = to.getY();
                                        this.lastPosZ = to.getZ();
                                        this.lastYaw = to.getYaw();
                                        this.lastPitch = to.getPitch();
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event6 = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event6);
                                        if (event6.isCancelled()) {
                                            this.internalTeleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                            this.g.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                    this.g.a(d3, d1, d2, f2, f1);
                                    boolean isAutoSpinAttack = this.g.fW();
                                    this.K = verticalDelta >= -0.03125 && !flag1 && !this.g.au() && !this.d.ag() && !this.g.gL().c && !this.g.d(MobEffects.y) && !isFallFlying && !isAutoSpinAttack && this.b(this.g);
                                    this.g.A().p().a(this.g);
                                    Vec3D vec3 = new Vec3D(this.g.dP() - x2, this.g.dR() - y2, this.g.dV() - z2);
                                    this.g.a(packet.b(), packet.e(), vec3);
                                    this.g.a(vec3.g, vec3.h, vec3.i, packet.b());
                                    this.a(vec3);
                                    if (flag) {
                                        this.g.l();
                                    }
                                    if (packet.b() || this.g.ez() || this.g.fl() || this.g.au() || isFallFlying || isAutoSpinAttack) {
                                        this.g.hp();
                                    }
                                    this.g.a(this.g.dP() - x2, this.g.dR() - y2, this.g.dV() - z2);
                                    this.x = this.g.dP();
                                    this.y = this.g.dR();
                                    this.z = this.g.dV();
                                } else {
                                    this.internalTeleport(x2, y2, z2, f2, f1);
                                    this.g.a(this.g.dP() - x2, this.g.dR() - y2, this.g.dV() - z2, packet.b());
                                    this.g.aX();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean a(boolean isElytraMovement) {
        if (this.h()) {
            return false;
        }
        if (this.g.S()) {
            return false;
        }
        GameRules gameRules = this.g.A().U();
        return gameRules.a(GameRules.H) != false && (!isElytraMovement || gameRules.a(GameRules.i) != false);
    }

    private boolean u() {
        if (this.H != null) {
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.J = this.q;
        return false;
    }

    private boolean hasNewCollision(WorldServer level, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        int i2;
        ArrayList<AxisAlignedBB> collisionsBB = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(level, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB box = (AxisAlignedBB)collisionsBB.get(i2);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i2 = 0; i2 < len; ++i2) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i2);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    private boolean a(IWorldReader level, net.minecraft.world.entity.Entity entity, AxisAlignedBB box, double x2, double y2, double z2) {
        AxisAlignedBB aabb = entity.dj().d(x2 - entity.dP(), y2 - entity.dR(), z2 - entity.dV());
        Iterable<VoxelShape> preMoveCollisions = level.a(entity, aabb.h(1.0E-5f), box.g());
        VoxelShape voxelShape = VoxelShapes.a(box.h(1.0E-5f));
        for (VoxelShape voxelShape1 : preMoveCollisions) {
            if (VoxelShapes.c(voxelShape1, voxelShape, OperatorBoolean.i)) continue;
            return true;
        }
        return false;
    }

    public void a(double x2, double y2, double z2, float yRot, float xRot) {
        this.teleport(x2, y2, z2, yRot, xRot, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double x2, double y2, double z2, float yRot, float xRot, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, yRot, xRot), Collections.emptySet(), cause);
    }

    public void a(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        this.teleport(posMoveRotation, relatives, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this.g), posMoveRotation, relatives)).a(), (net.minecraft.world.level.World)this.g.A(), absolutePosition.c(), absolutePosition.d())))) {
            this.internalTeleport(posMoveRotation, relatives);
            return true;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (Relative relativeArgument : relatives) {
            TeleportFlag.Relative flag = CraftEntity.deltaRelativeToAPI(relativeArgument);
            if (flag == null) continue;
            relativeFlags.add(flag);
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            relatives = Set.of();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            posMoveRotation = new PositionMoveRotation(CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(posMoveRotation, relatives);
        return !event.isCancelled();
    }

    public void internalTeleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    public void internalTeleport(double x2, double y2, double z2, float yRot, float xRot) {
        this.internalTeleport(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, yRot, xRot), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation posMoveRotation, Set<Relative> relatives) {
        AsyncCatcher.catchOp("teleport");
        if (this.g.eh()) {
            i.info("Attempt to teleport removed player {} restricted", (Object)this.g.da());
            if (this.d.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(posMoveRotation.c())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.a(), posMoveRotation.b(), 0.0f, posMoveRotation.d());
        }
        if (Float.isNaN(posMoveRotation.d())) {
            posMoveRotation = new PositionMoveRotation(posMoveRotation.a(), posMoveRotation.b(), posMoveRotation.c(), 0.0f);
        }
        this.justTeleported = true;
        this.J = this.q;
        if (++this.I == Integer.MAX_VALUE) {
            this.I = 0;
        }
        this.g.a(posMoveRotation, relatives);
        this.H = this.g.dI();
        this.lastPosX = this.H.g;
        this.lastPosY = this.H.h;
        this.lastPosZ = this.H.i;
        this.lastYaw = this.g.ec();
        this.lastPitch = this.g.ee();
        this.b(PacketPlayOutPosition.a(this.I, posMoveRotation, relatives));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (this.q()) {
            BlockPosition pos = packet.b();
            this.g.J();
            PacketPlayInBlockDig.EnumPlayerDigType action = packet.f();
            switch (action) {
                case h: {
                    if (this.g.au()) {
                        return;
                    }
                    net.minecraft.world.item.ItemStack itemInHand = this.g.b(EnumHand.a);
                    if (this.g.c(itemInHand, 5)) {
                        return;
                    }
                    PiercingWeapon piercingWeapon = itemInHand.a(DataComponents.N);
                    if (piercingWeapon != null) {
                        piercingWeapon.a(this.g, EnumItemSlot.a);
                    }
                    return;
                }
                case g: {
                    if (!this.g.au()) {
                        net.minecraft.world.item.ItemStack itemInHand1 = this.g.b(EnumHand.b);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemInHand1);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.g.b(EnumHand.a));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (ItemStack)mainHand.clone(), (ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.g.a(EnumHand.b, this.g.b(EnumHand.a));
                        } else {
                            this.g.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.g.a(EnumHand.a, itemInHand1);
                        } else {
                            this.g.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.g.gf();
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.g.K();
                        }
                    }
                    return;
                }
                case e: {
                    if (!this.g.au()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                i.warn(this.g.da() + " dropped their items too quickly!");
                                this.disconnect((IChatBaseComponent)IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                                return;
                            }
                        }
                        this.g.drop(false);
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.g.K();
                        }
                    }
                    return;
                }
                case d: {
                    if (!this.g.au()) {
                        this.g.drop(true);
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.g.K();
                        }
                    }
                    return;
                }
                case f: {
                    this.g.ge();
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.g.K();
                    }
                    return;
                }
                case a: 
                case b: 
                case c: {
                    if (this.g.A().getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4) == null || !this.g.a(pos, 1.0)) {
                        this.g.g.a(packet.g());
                        return;
                    }
                    this.g.h.capturedBlockEntity = false;
                    this.g.h.captureSentBlockEntities = true;
                    this.g.h.a(pos, action, packet.e(), this.g.A().aw(), packet.g());
                    this.a(packet.g());
                    this.g.h.captureSentBlockEntities = false;
                    if (this.g.h.capturedBlockEntity) {
                        this.b(new ClientboundBlockChangedAckPacket(this.r));
                        this.g.g.r = -1;
                        this.g.h.capturedBlockEntity = false;
                        TileEntity blockEntity = this.g.A().c_(pos);
                        if (blockEntity != null) {
                            this.g.g.b(blockEntity.ax_());
                        }
                    }
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.g.K();
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean a(EntityPlayer player, net.minecraft.world.item.ItemStack stack) {
        ItemBucket bucketItem;
        if (stack.f()) {
            return false;
        }
        Item item = stack.h();
        return (item instanceof ItemBlock || item instanceof ItemBucket && (bucketItem = (ItemBucket)item).a() != FluidTypes.a) && !player.hh().a(stack);
    }

    private boolean checkLimit(long timestamp) {
        if (!GlobalConfiguration.get().spamLimiter.incomingPacketThreshold.enabled()) {
            return true;
        }
        int threshold = GlobalConfiguration.get().spamLimiter.incomingPacketThreshold.intValue();
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)threshold && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)threshold) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.q()) {
            this.a(packet.f());
            WorldServer serverLevel = this.g.A();
            EnumHand hand = packet.b();
            net.minecraft.world.item.ItemStack itemInHand = this.g.b(hand);
            if (itemInHand.a(serverLevel.Q())) {
                MovingObjectPositionBlock hitResult = packet.e();
                Vec3D location = hitResult.g();
                if (!(Double.isFinite(location.a()) && Double.isFinite(location.b()) && Double.isFinite(location.c()))) {
                    return;
                }
                BlockPosition blockPos = hitResult.b();
                if (this.g.a(blockPos, 1.0)) {
                    Vec3D vec3 = location.d(Vec3D.b(blockPos));
                    double d2 = 1.0000001;
                    if (Math.abs(vec3.a()) < 1.0000001 && Math.abs(vec3.b()) < 1.0000001 && Math.abs(vec3.c()) < 1.0000001) {
                        EnumDirection direction = hitResult.c();
                        this.g.J();
                        int maxY = this.g.A().aw();
                        if (blockPos.v() <= maxY) {
                            if (this.H == null && (serverLevel.a((net.minecraft.world.entity.Entity)this.g, blockPos) || serverLevel.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && serverLevel.a_(blockPos).b() instanceof BlockSign)) {
                                EnumInteractionResult.d success;
                                this.g.gf();
                                EnumInteractionResult interactionResult = this.g.h.a(this.g, serverLevel, itemInHand, hand, hitResult);
                                if (interactionResult.a()) {
                                    CriterionTriggers.Q.a(this.g, hitResult.b(), itemInHand.v());
                                }
                                if (direction == EnumDirection.b && !interactionResult.a() && blockPos.v() >= maxY && PlayerConnection.a(this.g, itemInHand)) {
                                    IChatMutableComponent component = IChatBaseComponent.a("build.tooHigh", maxY).a(EnumChatFormat.m);
                                    this.g.b(component, true);
                                } else if (interactionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)interactionResult).e() == EnumInteractionResult.e.c && !this.g.h.interactResult) {
                                    this.g.a(hand, true);
                                }
                            } else if (this.d.a(serverLevel, blockPos, this.g)) {
                                if (MCUtil.clientPredictsInteraction((EntityHuman)this.g, serverLevel.a_(blockPos), itemInHand)) {
                                    this.g.cn.b();
                                } else {
                                    this.g.cn.forceHeldSlot(hand);
                                }
                            }
                        } else {
                            IChatMutableComponent component1 = IChatBaseComponent.a("build.tooHigh", maxY).a(EnumChatFormat.m);
                            this.g.b(component1, true);
                        }
                        this.b(new PacketPlayOutBlockChange(serverLevel, blockPos));
                        this.b(new PacketPlayOutBlockChange(serverLevel, blockPos.a(direction)));
                        if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                            this.g.K();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        if (this.q()) {
            this.a(packet.e());
            WorldServer serverLevel = this.g.A();
            EnumHand hand = packet.b();
            net.minecraft.world.item.ItemStack itemInHand = this.g.b(hand);
            this.g.J();
            if (!itemInHand.f() && itemInHand.a(serverLevel.Q())) {
                EnumInteractionResult.d success;
                boolean cancelled;
                float f2 = MathHelper.f(packet.f());
                float f1 = MathHelper.f(packet.g());
                if (f1 != this.g.ee() || f2 != this.g.ec()) {
                    this.g.b(f2, f1);
                }
                double x2 = this.g.dP();
                double eyeY = this.g.dT();
                double z2 = this.g.dV();
                Vec3D from = new Vec3D(x2, eyeY, z2);
                float f3 = MathHelper.b((double)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                float f4 = MathHelper.a((double)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                float f5 = -MathHelper.b((double)(-f1 * ((float)Math.PI / 180)));
                float f6 = MathHelper.a((double)(-f1 * ((float)Math.PI / 180)));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.g.hm();
                Vec3D to = from.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                MovingObjectPositionBlock hitResult = this.g.A().a(new RayTrace(from, to, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.g));
                if (hitResult == null || hitResult.d() != MovingObjectPosition.EnumMovingObjectType.b) {
                    event = CraftEventFactory.callPlayerInteractEvent(this.g, Action.RIGHT_CLICK_AIR, itemInHand, hand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    cancelled = this.g.h.firedInteract && this.g.h.interactPosition.equals(hitResult.b()) && this.g.h.interactHand == hand && net.minecraft.world.item.ItemStack.c(this.g.h.interactItemStack, itemInHand) ? this.g.h.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.g, Action.RIGHT_CLICK_BLOCK, hitResult.b(), hitResult.c(), itemInHand, true, hand, hitResult.g())).useItemInHand() == Event.Result.DENY;
                    this.g.h.firedInteract = false;
                }
                if (cancelled) {
                    this.g.resyncUsingItem(this.g);
                    if (MCUtil.clientPredictsInteraction((EntityHuman)this.g, Blocks.a.m(), itemInHand)) {
                        this.g.cn.b();
                    } else {
                        this.g.cn.forceHeldSlotAndArmor(hand);
                    }
                    return;
                }
                itemInHand = this.g.b(hand);
                if (itemInHand.f()) {
                    return;
                }
                EnumInteractionResult enumInteractionResult = this.g.h.a(this.g, serverLevel, itemInHand, hand);
                if (enumInteractionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)enumInteractionResult).e() == EnumInteractionResult.e.c) {
                    this.g.a(hand, true);
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.au()) {
            for (WorldServer serverLevel : this.d.P()) {
                net.minecraft.world.entity.Entity entity = packet.a(serverLevel);
                if (entity == null) continue;
                this.g.teleportTo(serverLevel, entity.dP(), entity.dR(), entity.dV(), Set.of(), entity.ec(), entity.ee(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        net.minecraft.world.entity.Entity entity = this.g.dA();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractBoat = (AbstractBoat)entity;
            abstractBoat.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(DisconnectionDetails details) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        i.info("{} lost connection: {}", (Object)this.g.aq(), (Object)details.a().getString());
        Component quitMessage = details.quitMessage().map(PaperAdventure::asAdventure).orElse(null);
        this.removePlayerFromWorld(quitMessage);
        super.a(details);
    }

    private void v() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.W.close();
        this.g.v();
        Component component = quitMessage = quitMessage == null ? this.d.aj().remove(this.g) : this.d.aj().remove(this.g, quitMessage);
        if (quitMessage != null && !quitMessage.equals((Object)Component.empty())) {
            this.d.aj().a(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.g.Y().b();
    }

    public void a(int sequence) {
        if (sequence < 0) {
            this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Expected packet sequence nr >= 0"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.r = Math.max(sequence, this.r);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (packet.b() >= 0 && packet.b() < PlayerInventory.i()) {
            if (packet.b() == this.g.gK().g()) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.g.gK().g(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.g.gK().g()));
                this.g.J();
                return;
            }
            if (this.g.gK().g() != packet.b() && this.g.ga() == EnumHand.a) {
                this.g.gf();
            }
            this.g.gK().d(packet.b());
            this.g.J();
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.g.K();
            }
        } else {
            i.warn("{} tried to set an invalid carried item", (Object)this.g.aq());
            this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.d.ai()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), false, () -> {
                PlayerChatMessage signedMessage;
                try {
                    signedMessage = this.a(packet, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a var6) {
                    this.a(var6);
                    return;
                }
                CompletionStage completableFuture = this.a(signedMessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                CompletableFuture<IChatBaseComponent> componentFuture = this.d.bm().decorate(this.g, null, signedMessage.d());
                this.W.append(CompletableFuture.allOf(new CompletableFuture[]{completableFuture, componentFuture}), arg_0 -> this.lambda$handleChat$10(signedMessage, componentFuture, (CompletableFuture)completableFuture, arg_0));
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket packet) {
        this.tryHandleChat(packet.b(), true, () -> {
            if (this.g.w()) {
                return;
            }
            this.b(packet.b());
            this.detectRateSpam("/" + packet.b());
        }, true);
    }

    private void b(String command) {
        String prefixedCommand = "/" + command;
        if (SpigotConfig.logCommands) {
            i.info("{} issued server command: {}", (Object)this.g.da(), (Object)prefixedCommand);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), prefixedCommand, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseResults = this.c(command);
        if (this.d.ay() && SignableCommand.a(parseResults)) {
            i.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.g.gI().name(), (Object)command);
            this.g.a(o);
        } else {
            this.d.aF().a(parseResults, command);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket packet) {
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), true, () -> {
                if (this.g.w()) {
                    return;
                }
                this.a(packet, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + packet.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.b();
        if (SpigotConfig.logCommands) {
            i.info("{} issued server command: {}", (Object)this.g.da(), command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseResults = this.c(packet.b());
        try {
            map = this.a(packet, SignableCommand.b(parseResults), lastSeenMessages);
        }
        catch (SignedMessageChain.a var6) {
            this.a(var6);
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!((String)command).equals(packet.b())) {
            parseResults = this.c((String)command);
            map = Collections.emptyMap();
        }
        CommandSigningContext.a commandSigningContext = new CommandSigningContext.a(map);
        parseResults = net.minecraft.commands.CommandDispatcher.a(parseResults, commandSourceStack -> commandSourceStack.a(commandSigningContext, this.W));
        this.d.aF().a(parseResults, (String)command);
    }

    private void a(SignedMessageChain.a exception) {
        i.warn("Failed to update secure chat state for {}: '{}'", (Object)this.g.gI().name(), (Object)exception.a().getString());
        this.g.a(exception.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket packet, SignableCommand<S> command, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        List<ArgumentSignatures.a> list = packet.g().a();
        List<SignableCommand.a<S>> list1 = command.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a a2 : list) {
            SignableCommand.a<S> argument = command.a(a2.a());
            if (argument == null) {
                this.S.setChainBroken();
                throw PlayerConnection.a(packet.b(), list, list1);
            }
            SignedMessageBody signedMessageBody = new SignedMessageBody(argument.c(), packet.e(), packet.f(), lastSeenMessages);
            map.put(argument.a(), this.S.unpack(a2.b(), signedMessageBody));
        }
        for (SignableCommand.a a3 : list1) {
            if (map.containsKey(a3.a())) continue;
            throw PlayerConnection.a(packet.b(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> arguments) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> argument : arguments) {
            SignedMessageBody signedMessageBody = SignedMessageBody.a(argument.c());
            map.put(argument.a(), this.S.unpack(null, signedMessageBody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String command, List<ArgumentSignatures.a> signedArguments, List<SignableCommand.a<S>> unsignedArguments) {
        String string = signedArguments.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String string1 = unsignedArguments.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        i.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{command, string, string1});
        return new SignedMessageChain.a(o);
    }

    private ParseResults<CommandListenerWrapper> c(String command) {
        CommandDispatcher<CommandListenerWrapper> dispatcher = this.d.aF().a();
        return dispatcher.parse(command, this.g.C());
    }

    private void tryHandleChat(String message, boolean bypassHiddenChat, Runnable handler, boolean sync) {
        if (PlayerConnection.d(message)) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (this.g.eh() || !bypassHiddenChat && this.g.G() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.g.J();
            if (sync) {
                this.d.execute(handler);
            } else {
                handler.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b update) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.T;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> var10000;
            try {
                LastSeenMessages lastSeenMessages = this.T.a(update);
                var10000 = Optional.of(lastSeenMessages);
            }
            catch (LastSeenMessagesValidator.a var5) {
                i.error("Failed to validate message acknowledgements from {}: {}", (Object)this.g.aq(), (Object)var5.getMessage());
                this.disconnectAsync(n, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
                return Optional.empty();
            }
            return var10000;
        }
    }

    public static boolean d(String message) {
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (UtilColor.a(message.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String msg, PlayerChatMessage original, boolean async) {
        if (msg.isEmpty() || this.g.G() == EnumChatVisibility.c) {
            return;
        }
        if (this.g.G() != EnumChatVisibility.b) {
            if (!async && !Bukkit.isPrimaryThread()) {
                AsyncCatcher.catchOp("Asynchronous player chat is not allowed here");
            }
            new ChatProcessor(this.d, this.g, original, async).process();
        }
    }

    @Deprecated
    public void handleCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        this.b(command);
    }

    private PlayerChatMessage a(PacketPlayInChat packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignedMessageBody signedMessageBody = new SignedMessageBody(packet.b(), packet.e(), packet.f(), lastSeenMessages);
        return this.S.unpack(packet.g(), signedMessageBody);
    }

    private void a(PlayerChatMessage message) {
        String rawMessage = message.c();
        if (rawMessage.isEmpty()) {
            i.warn("{} tried to send an empty message", (Object)this.g.da());
        } else if (this.getCraftPlayer().isConversing()) {
            String conversationInput = rawMessage;
            this.d.processQueue.add(() -> this.getCraftPlayer().acceptConversationInput(conversationInput));
        } else if (this.g.G() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(rawMessage, message, true);
        }
        this.detectRateSpam(rawMessage);
    }

    private void detectRateSpam(String message) {
        if (SpigotConfig.enableSpamExclusions) {
            for (String exclude : SpigotConfig.spamExclusions) {
                if (exclude == null || !message.startsWith(exclude)) continue;
                return;
            }
        }
        if (!(this.s.isIncrementAndUnderThreshold() || this.d.aj().f(this.g.gJ()) || this.d.a(this.g.gJ()))) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.T;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.T.a(packet.b());
            }
            catch (LastSeenMessagesValidator.a var5) {
                i.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.g.aq(), (Object)var5.getMessage());
                this.disconnectAsync(n, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        float f1 = this.g.ee();
        float f2 = this.g.ec();
        double d0 = this.g.dP();
        double d1 = this.g.dR() + (double)this.g.dk();
        double d2 = this.g.dV();
        Location origin = new Location((World)this.g.A().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.g.hm(), this.g.hn());
        RayTraceResult result = this.g.A().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.g.getBukkitEntity() && this.g.getBukkitEntity().canSee((Entity)entity) && !handle.au() && handle.bX() && !handle.A(this.g);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.g, Action.LEFT_CLICK_AIR, this.g.gK().h(), EnumHand.a);
        } else {
            EnumGamemode gameType = this.g.h.b();
            if (gameType == EnumGamemode.c && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.g, Action.LEFT_CLICK_BLOCK, ((CraftBlock)result.getHitBlock()).getPosition(), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.g.gK().h(), EnumHand.a);
            } else if (gameType != EnumGamemode.b && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > this.g.hn() * this.g.hn()) {
                CraftEventFactory.callPlayerInteractEvent(this.g, Action.LEFT_CLICK_AIR, this.g.gK().h(), EnumHand.a);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), CraftEquipmentSlot.getHand(packet.b()));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.g.a(packet.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.q()) {
            if (this.g.eh()) {
                return;
            }
            switch (packet.e()) {
                case b: 
                case c: {
                    PlayerToggleSprintEvent event = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.e() == PacketPlayInEntityAction.EnumPlayerAction.b);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) break;
                    return;
                }
            }
            this.g.J();
            switch (packet.e()) {
                case b: {
                    this.g.i(true);
                    break;
                }
                case c: {
                    this.g.i(false);
                    break;
                }
                case a: {
                    if (!this.g.gr()) break;
                    this.g.a(false, true);
                    this.H = this.g.dI();
                    break;
                }
                case d: {
                    net.minecraft.world.entity.Entity entity = this.g.dA();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable playerRideableJumping = (IJumpable)((Object)entity);
                    int data = packet.f();
                    if (!playerRideableJumping.a() || data <= 0) break;
                    playerRideableJumping.b(data);
                    break;
                }
                case e: {
                    net.minecraft.world.entity.Entity entity = this.g.dA();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable playerRideableJumping = (IJumpable)((Object)entity);
                    playerRideableJumping.b();
                    break;
                }
                case f: {
                    net.minecraft.world.entity.Entity entity = this.g.dz();
                    if (!(entity instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hasCustomInventoryScreen = (HasCustomInventoryScreen)((Object)entity);
                    hasCustomInventoryScreen.b(this.g);
                    break;
                }
                case g: {
                    if (this.g.gR()) break;
                    this.g.fK();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage chatMessage, ChatMessageType.a boundChatType) {
        if (!this.getCraftPlayer().canSeePlayer(chatMessage.k().c())) {
            this.a(chatMessage.d(), boundChatType);
            return;
        }
        MessageSignatureCache messageSignatureCache = this.V;
        synchronized (messageSignatureCache) {
            this.b(new ClientboundPlayerChatPacket(this.U++, chatMessage.k().c(), chatMessage.k().b(), chatMessage.l(), chatMessage.m().a(this.V), chatMessage.n(), chatMessage.o(), boundChatType));
            MessageSignature messageSignature = chatMessage.l();
            if (messageSignature != null) {
                int i2;
                this.V.a(chatMessage.m(), chatMessage.l());
                LastSeenMessagesValidator lastSeenMessagesValidator = this.T;
                synchronized (lastSeenMessagesValidator) {
                    this.T.a(messageSignature);
                    i2 = this.T.a();
                }
                if (i2 > 4096) {
                    this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
                }
            }
        }
    }

    public void a(IChatBaseComponent message, ChatMessageType.a boundChatType) {
        this.b(new ClientboundDisguisedChatPacket(message, boundChatType));
    }

    public SocketAddress n() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        if (this.e.k.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.e.k.remoteAddress();
    }

    public void o() {
        this.X = true;
        this.v();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket packet) {
        this.e.a(new ClientboundPongResponsePacket(packet.b()));
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        if (this.q()) {
            final WorldServer serverLevel = this.g.A();
            final net.minecraft.world.entity.Entity target = packet.a(serverLevel);
            if (target == this.g && !this.g.au()) {
                this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Cannot interact with self!"), PlayerKickEvent.Cause.SELF_INTERACTION);
                return;
            }
            this.g.J();
            this.g.h(packet.b());
            if (target != null) {
                if (!serverLevel.w().a(target.dK())) {
                    return;
                }
                AxisAlignedBB boundingBox = target.dj();
                if (packet.a(this.g, boundingBox, GlobalConfiguration.get().misc.clientInteractionLeniencyDistance.or(3.0))) {
                    packet.a(new PacketPlayInUseEntity.c(){

                        private void performInteraction(EnumHand hand, a entityInteraction, PlayerInteractEntityEvent event) {
                            net.minecraft.world.item.ItemStack itemInHand = PlayerConnection.this.g.b(hand);
                            if (itemInHand.a(serverLevel.Q())) {
                                boolean resendData;
                                net.minecraft.world.item.ItemStack itemStack = itemInHand.v();
                                Item itemType = itemInHand.h();
                                boolean triggerLeashUpdate = itemStack.a(Items.wZ) && target instanceof Leashable;
                                PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                                boolean bl = resendData = event.isCancelled() || !PlayerConnection.this.g.b(hand).a(itemType);
                                if (itemType == Items.sl && target instanceof Bucketable && target instanceof EntityLiving && resendData) {
                                    target.resendPossiblyDesyncedEntityData(PlayerConnection.this.g);
                                }
                                if (resendData) {
                                    if (MCUtil.clientPredictsInteraction((EntityHuman)PlayerConnection.this.g, target, itemInHand)) {
                                        PlayerConnection.this.g.cn.b();
                                    } else {
                                        PlayerConnection.this.g.cn.forceHeldSlot(hand);
                                    }
                                }
                                if (triggerLeashUpdate && resendData) {
                                    PlayerConnection.this.b(new PacketPlayOutAttachEntity(target, ((Leashable)((Object)target)).C()));
                                }
                                if (resendData) {
                                    target.refreshEntityData(PlayerConnection.this.g);
                                    if (target instanceof Allay || target instanceof EntityHorseAbstract) {
                                        PlayerConnection.this.b(new PacketPlayOutEntityEquipment(target.aA(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)target).a((EnumItemSlot)slot).v())).collect(Collectors.toList()), true));
                                        PlayerConnection.this.g.cn.b();
                                    } else {
                                        PlayerConnection.this.g.cn.forceHeldSlot(hand);
                                    }
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                EnumInteractionResult result = entityInteraction.run(PlayerConnection.this.g, target, hand);
                                if (result instanceof EnumInteractionResult.d) {
                                    EnumInteractionResult.d success = (EnumInteractionResult.d)result;
                                    net.minecraft.world.item.ItemStack itemStack1 = success.c() ? itemStack : net.minecraft.world.item.ItemStack.l;
                                    CriterionTriggers.U.a(PlayerConnection.this.g, itemStack1, target);
                                    if (success.e() == EnumInteractionResult.e.c) {
                                        PlayerConnection.this.g.a(hand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void a(EnumHand hand) {
                            this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void a(EnumHand hand, Vec3D interactionLocation) {
                            this.performInteraction(hand, (player, entity, interactionHand) -> entity.a(player, interactionLocation, interactionHand), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)target.getBukkitEntity(), CraftVector.toBukkit(interactionLocation), CraftEquipmentSlot.getHand(hand)));
                        }

                        @Override
                        public void a() {
                            EntityArrow abstractArrow;
                            if (!(target instanceof EntityItem || target instanceof EntityExperienceOrb || target == PlayerConnection.this.g && !PlayerConnection.this.g.au() || target instanceof EntityArrow && !(abstractArrow = (EntityArrow)target).cT())) {
                                net.minecraft.world.item.ItemStack itemInHand = PlayerConnection.this.g.b(EnumHand.a);
                                if (itemInHand.a(serverLevel.Q()) && !PlayerConnection.this.g.c(itemInHand, 5)) {
                                    PlayerConnection.this.g.e(target);
                                }
                            } else {
                                PlayerConnection.this.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                                i.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.g.aq());
                            }
                        }
                    });
                }
            } else {
                packet.a(new PacketPlayInUseEntity.c(){

                    @Override
                    public void a(EnumHand hand) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.g, packet, hand, null);
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.g, packet, hand, pos);
                    }

                    @Override
                    public void a() {
                        CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.g, packet, EnumHand.a, null);
                    }
                });
            }
            if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                this.g.K();
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.g.J();
        PacketPlayInClientCommand.EnumClientCommand action = packet.b();
        switch (action) {
            case a: {
                if (this.g.k) {
                    this.g.k = false;
                    this.g = this.d.aj().respawn(this.g, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.m();
                    this.y();
                    CriterionTriggers.w.a(this.g, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.g.eZ() > 0.0f) {
                    return;
                }
                this.g = this.d.aj().respawn(this.g, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                this.m();
                this.y();
                if (!this.d.v_()) break;
                this.g.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.g.A().U().set(GameRules.ab, false, this.g.A());
                break;
            }
            case b: {
                this.g.K().a(this.g);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packet, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.g, reason);
        this.g.s();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        if (this.g.cn.l == packet.b() && this.g.cn.b(this.g)) {
            boolean cancelled = this.g.au();
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
            } else {
                short slotNum = packet.f();
                if (!this.g.cn.a(slotNum)) {
                    i.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.g.aq(), (int)slotNum, this.g.cn.k.size()});
                } else {
                    boolean flag = packet.e() != this.g.cn.j();
                    this.g.cn.h();
                    if (slotNum < -1 && slotNum != -999) {
                        return;
                    }
                    InventoryView inventory = this.g.cn.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType((int)slotNum);
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    switch (packet.h()) {
                        case a: {
                            if (packet.g() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.g() != 0 && packet.g() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (slotNum == -999) {
                                if (this.g.cn.g().f()) break;
                                action = packet.g() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.g.cn.b(slotNum);
                            if (slot == null) break;
                            net.minecraft.world.item.ItemStack clickedItem = slot.g();
                            net.minecraft.world.item.ItemStack cursor = this.g.cn.g();
                            if (clickedItem.f()) {
                                if (cursor.f()) break;
                                if (cursor.h() instanceof BundleItem && cursor.c(DataComponents.X) && packet.g() != 0) {
                                    action = cursor.a(DataComponents.X).g() ? InventoryAction.NOTHING : InventoryAction.PLACE_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.g() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.g)) break;
                            if (cursor.f()) {
                                if (slot.g().h() instanceof BundleItem && slot.g().c(DataComponents.X) && packet.g() != 0) {
                                    action = slot.g().a(DataComponents.X).g() ? InventoryAction.NOTHING : InventoryAction.PICKUP_FROM_BUNDLE;
                                    break;
                                }
                                action = packet.g() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                int toPickup;
                                if (net.minecraft.world.item.ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packet.g() == 0 ? cursor.N() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.k() - clickedItem.N());
                                    if ((toPlace = Math.min(toPlace, slot.c.ap_() - clickedItem.N())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.N()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.N() > slot.a()) break;
                                if (cursor.h() instanceof BundleItem && cursor.c(DataComponents.X) && packet.g() == 0) {
                                    toPickup = cursor.a(DataComponents.X).getMaxAmountToAdd(slot.g());
                                    if (toPickup >= slot.g().N()) {
                                        action = InventoryAction.PICKUP_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PICKUP_SOME_INTO_BUNDLE;
                                    break;
                                }
                                if (slot.g().h() instanceof BundleItem && slot.g().c(DataComponents.X) && packet.g() == 0) {
                                    toPickup = slot.g().a(DataComponents.X).getMaxAmountToAdd(cursor);
                                    if (toPickup >= cursor.N()) {
                                        action = InventoryAction.PLACE_ALL_INTO_BUNDLE;
                                        break;
                                    }
                                    if (toPickup == 0) {
                                        action = InventoryAction.NOTHING;
                                        break;
                                    }
                                    action = InventoryAction.PLACE_SOME_INTO_BUNDLE;
                                    break;
                                }
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!net.minecraft.world.item.ItemStack.c(cursor, clickedItem) || clickedItem.N() < 0 || clickedItem.N() + cursor.N() > cursor.k()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packet.g() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.g() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.g() != 0 && packet.g() != 1) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.g.cn.b(slotNum);
                            if (slot != null && slot.a(this.g) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packet.g() < 0 || packet.g() >= 9) && packet.g() != 40) break;
                            if (slotNum < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.g() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.g.cn.b(slotNum);
                            if (clickedSlot.a(this.g)) {
                                net.minecraft.world.item.ItemStack hotbar = this.g.gK().a(packet.g());
                                if (!hotbar.f() && clickedSlot.a(hotbar) || hotbar.f() && clickedSlot.h()) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packet.g() == 2) {
                                click = ClickType.MIDDLE;
                                if (slotNum < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.g.cn.b(slotNum);
                                if (slot != null && slot.h() && this.g.gL().d && this.g.cn.g().f()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (slotNum >= 0) {
                                if (packet.g() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.g.cn.b(slotNum);
                                    if (slot != null && slot.h() && slot.a(this.g) && !slot.g().f() && slot.g().h() != Items.a) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.g() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.g.cn.b(slotNum);
                                if (slot != null && slot.h() && slot.a(this.g) && !slot.g().f() && slot.g().h() != Items.a) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            Container containerMenu = this.g.cn;
                            int currentStatus = this.g.cn.w;
                            int newStatus = Container.d(packet.g());
                            if (!(currentStatus != 1 || newStatus != 2 && currentStatus != newStatus || containerMenu.g().f() || newStatus == 0 || newStatus == 1 || newStatus != 2 || this.g.cn.x.isEmpty() || this.g.cn.x.size() != 1)) {
                                int index = containerMenu.x.iterator().next().d;
                                containerMenu.f();
                                this.a(new PacketPlayInWindowClick(packet.b(), packet.e(), (short)index, (byte)containerMenu.v, InventoryClickType.a, packet.i(), packet.j()));
                                return;
                            }
                            this.g.cn.a(slotNum, (int)packet.g(), packet.h(), this.g);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (slotNum < 0 || this.g.cn.g().f()) break;
                            net.minecraft.world.item.ItemStack cursor = this.g.cn.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.h())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.h()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.h() != InventoryClickType.f) {
                        CartographyInventory cartographyInventory;
                        SmithingInventory smithingInv;
                        ItemStack result;
                        CraftingInventory craftingInv;
                        Recipe recipe;
                        if (this.g.cn.w != 0) {
                            action = InventoryAction.NOTHING;
                        }
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, (int)slotNum, click, action, (int)packet.g()) : new InventoryClickEvent(inventory, type, (int)slotNum, click, action);
                        Inventory top = inventory.getTopInventory();
                        if (slotNum == 0 && top instanceof CraftingInventory && (recipe = (craftingInv = (CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, (int)slotNum, click, action, (int)packet.g()) : new CraftItemEvent(recipe, inventory, type, (int)slotNum, click, action);
                        }
                        if (slotNum == 3 && top instanceof SmithingInventory && (result = (smithingInv = (SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, (int)slotNum, click, action, (int)packet.g()) : new SmithItemEvent(inventory, type, (int)slotNum, click, action);
                        }
                        if (slotNum == 2 && top instanceof CartographyInventory && (result = (cartographyInventory = (CartographyInventory)top).getResult()) != null && !result.isEmpty()) {
                            event = click == ClickType.NUMBER_KEY ? new CartographyItemEvent(inventory, type, (int)slotNum, click, action, (int)packet.g()) : new CartographyItemEvent(inventory, type, (int)slotNum, click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.g.cn;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.g.cn != oldContainer) {
                            this.g.cn.i();
                            this.g.cn.e();
                            return;
                        }
                        if (event.getResult() != Event.Result.DENY) {
                            this.g.cn.a(slotNum, (int)packet.g(), packet.h(), this.g);
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.g.cn.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.i())) {
                        this.g.cn.a(entry.getIntKey(), (HashedStack)entry.getValue());
                    }
                    this.g.cn.a(packet.j());
                    this.g.cn.i();
                    if (flag) {
                        this.g.cn.e();
                    } else {
                        this.g.cn.d();
                    }
                    if (packet.g() == 40 && this.g.cn != this.g.cm) {
                        this.g.dE.sendOffHandSlotChange();
                    }
                    if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                        this.g.K();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        if (!Bukkit.isPrimaryThread() && !this.recipeSpamPackets.isIncrementAndUnderThreshold()) {
            this.disconnectAsync((IChatBaseComponent)IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.g.J();
        if (!this.g.au() && this.g.cn.l == packet.b()) {
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
            } else {
                CraftingManager.d recipeFromDisplay = this.d.aJ().a(packet.e());
                if (recipeFromDisplay != null) {
                    Container container;
                    RecipeHolder recipeHolder = recipeFromDisplay.b();
                    if (this.g.L().b(recipeHolder.a()) && (container = this.g.cn) instanceof ContainerRecipeBook) {
                        ContainerRecipeBook recipeBookMenu = (ContainerRecipeBook)container;
                        if (recipeHolder.b().aq_().c()) {
                            i.debug("Player {} tried to place impossible recipe {}", (Object)this.g, (Object)recipeHolder.a().a());
                            return;
                        }
                        NamespacedKey recipeName = CraftNamespacedKey.fromMinecraft(recipeHolder.a().a());
                        boolean makeAll = packet.f();
                        com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent paperEvent = new com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent((Player)this.g.getBukkitEntity(), recipeName, makeAll);
                        if (!paperEvent.callEvent()) {
                            return;
                        }
                        recipeName = paperEvent.getRecipe();
                        makeAll = paperEvent.isMakeAll();
                        if (PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                            Recipe recipe = this.cserver.getRecipe(recipeName);
                            if (recipe == null) {
                                return;
                            }
                            PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.g, recipe, makeAll);
                            recipeName = ((Keyed)event.getRecipe()).getKey();
                            makeAll = event.isShiftClick();
                        }
                        if (!(this.g.cn instanceof ContainerRecipeBook)) {
                            return;
                        }
                        recipeHolder = this.d.aJ().b(ResourceKey.a(Registries.bK, CraftNamespacedKey.toMinecraft(recipeName))).orElse(null);
                        if (recipeHolder == null) {
                            return;
                        }
                        ContainerRecipeBook.a postPlaceAction = recipeBookMenu.a(makeAll, this.g.ha(), recipeHolder, this.g.A(), this.g.gK());
                        if (postPlaceAction == ContainerRecipeBook.a.b) {
                            this.b(new PacketPlayOutAutoRecipe(this.g.cn.l, recipeFromDisplay.a().b()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        if (this.g.cn.l == packet.b() && !this.g.au()) {
            if (!this.g.cn.b(this.g)) {
                i.debug("Player {} interacted with invalid menu {}", (Object)this.g, (Object)this.g.cn);
            } else {
                boolean flag = this.g.cn.a((EntityHuman)this.g, packet.e());
                if (flag) {
                    this.g.cn.d();
                }
                if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                    this.g.K();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.gv()) {
            boolean flag2;
            boolean flag = packet.b() < 0;
            net.minecraft.world.item.ItemStack itemStack = packet.e();
            if (!itemStack.a(this.g.A().Q())) {
                return;
            }
            boolean flag1 = packet.b() >= 1 && packet.b() <= 45;
            boolean bl = flag2 = itemStack.f() || itemStack.N() <= itemStack.k();
            if (flag || flag1 && !net.minecraft.world.item.ItemStack.a(this.g.cm.b(packet.b()).g(), packet.e())) {
                CraftInventoryView inventory = this.g.cm.getBukkitView();
                ItemStack item = CraftItemStack.asBukkitCopy(packet.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.b() < 36) {
                    type = packet.b() >= 5 && packet.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packet.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemStack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.b() >= 0) {
                            this.g.g.b(new PacketPlayOutSetSlot(this.g.cm.l, this.g.cm.k(), packet.b(), this.g.cm.b(packet.b()).g()));
                            this.g.g.b(new ClientboundSetCursorItemPacket(net.minecraft.world.item.ItemStack.l.v()));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.g.cm.b(packet.b()).e(itemStack);
                this.g.cm.a((int)packet.b(), itemStack);
                this.g.cm.d();
                if (GlobalConfiguration.get().unsupportedSettings.updateEquipmentOnPlayerActions) {
                    this.g.K();
                }
            } else if (flag && flag2) {
                if (this.t.c()) {
                    this.t.a();
                    this.g.a(itemStack, true);
                } else {
                    i.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.g.aq());
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        String[] lines = packet.f();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i2].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i2].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i2].length()) continue;
            lines[i2] = lines[i2].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(texts -> this.a(packet, (List<FilteredText>)texts), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packet, List<FilteredText> filteredText) {
        if (this.g.fE()) {
            return;
        }
        this.g.J();
        WorldServer serverLevel = this.g.A();
        BlockPosition pos = packet.b();
        if (serverLevel.H(pos)) {
            if (!new UncheckedSignChangeEvent((Player)this.g.getBukkitEntity(), MCUtil.toPosition(pos), packet.e() ? Side.FRONT : Side.BACK, filteredText.stream().map(line -> Component.text((String)line.d())).toList()).callEvent()) {
                return;
            }
            TileEntity tileEntity = serverLevel.c_(pos);
            if (!(tileEntity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign signBlockEntity = (TileEntitySign)tileEntity;
            signBlockEntity.a((EntityHuman)this.g, packet.e(), filteredText);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.gL().c && this.g.gL().b != packet.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.g.getBukkitEntity(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.g.gL().b = packet.b();
            } else {
                this.g.z();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (packet.b().c() < 0) {
            i.warn("Disconnecting {} for invalid view distance: {}", (Object)this.g.da(), (Object)packet.b().c());
            this.disconnect((IChatBaseComponent)IChatBaseComponent.b("Invalid client settings"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        boolean isModelPartShown = this.g.a(PlayerModelPart.g);
        this.g.a(packet.b());
        this.e.k.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.b().b()));
        if (this.g.a(PlayerModelPart.g) != isModelPartShown) {
            this.d.aj().a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.h, this.g));
        }
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (!this.g.I().hasPermission(Permissions.b) && !this.h()) {
            i.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.g.gI().name(), (Object)packet.b().b());
        }
    }

    @Override
    public void a(ServerboundChangeGameModePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (!CommandGamemode.a.a(this.g.I())) {
            i.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.g.gI().name(), (Object)packet.b().e().getString());
        } else {
            CommandGamemode.setGameMode(this.g.C(), this.g, packet.b(), PlayerGameModeChangeEvent.Cause.GAMEMODE_SWITCHER);
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        if (this.g.I().hasPermission(Permissions.b) || this.h()) {
            this.d.c(packet.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        RemoteChatSession.a data = packet.b();
        ProfilePublicKey.a data1 = this.R != null ? this.R.d().b() : null;
        ProfilePublicKey.a data2 = data.b();
        if (!Objects.equals(data1, data2)) {
            if (data1 != null && data2.b().isBefore(data1.b())) {
                this.disconnect(ProfilePublicKey.a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signatureValidator = this.d.ar().a();
                    if (signatureValidator == null) {
                        i.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.g.gI().name());
                        return;
                    }
                    this.a(data.a(this.g.gI(), signatureValidator));
                }
                catch (ProfilePublicKey.b var6) {
                    this.disconnect(var6.a(), var6.kickCause);
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.X) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        ServerConfigurationPacketListenerImpl listener = new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.g.E()));
        this.e.a(ConfigurationProtocols.b, listener);
        new PlayerConnectionReconfigureEvent((PlayerConfigurationConnection)listener.paperConnection).callEvent();
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.h.a(packet.b());
    }

    @Override
    public void a(ServerboundDebugSubscriptionRequestPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.g.a(packet.b());
    }

    private void a(RemoteChatSession chatSession) {
        this.R = chatSession;
        this.hasLoggedExpiry = false;
        this.S = chatSession.a(this.g.cY());
        this.W.append(() -> this.d.h(() -> {
            this.g.a(chatSession);
            this.d.aj().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), (Collection<EntityPlayer>)List.of(this.g)), this.g);
        }));
    }

    @Override
    public void a(ServerboundCustomPayloadPacket packet) {
        super.a(packet);
    }

    @Override
    public void a(ServerboundClientTickEndPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.g.A());
        this.tickEndEvent.callEvent();
        if (!this.Q) {
            this.g.a(Vec3D.c);
        }
        this.Q = false;
    }

    private void a(Vec3D movement) {
        if (movement.h() > (double)1.0E-5f) {
            this.g.J();
        }
        this.g.a(movement);
        this.Q = true;
    }

    @Override
    public boolean a() {
        return this.g.gv();
    }

    @Override
    public EntityPlayer p() {
        return this.g;
    }

    public boolean q() {
        return !this.Y && this.Z <= 0;
    }

    public void r() {
        if (this.Z > 1) {
            --this.Z;
        } else if (this.Z == 1) {
            this.x();
        }
    }

    private void x() {
        if (!this.q()) {
            PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((Player)this.g.getBukkitEntity(), true);
            event.callEvent();
        }
        this.Z = 0;
    }

    public void s() {
        this.Y = true;
    }

    public void y() {
        this.Y = false;
        this.Z = 60;
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    public CraftPlayer getCraftPlayer() {
        return this.g == null ? null : this.g.getBukkitEntity();
    }

    @Override
    public void disconnectAsync(DisconnectionDetails disconnectionInfo) {
        if (this.cserver.isPrimaryThread()) {
            this.b(disconnectionInfo);
            return;
        }
        this.e.m();
        this.d.scheduleOnMain(() -> {
            this.b(disconnectionInfo);
            if (this.g.quitReason == null) {
                this.e.enableAutoRead();
            }
        });
    }

    public final boolean isDisconnected() {
        return !this.g.joining && !this.e.i() || this.processedDisconnect;
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        super.a(packet);
        this.e.resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.e().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packet.b(), packStatus));
    }

    public void disconnect(Component reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asVanilla(reason), DisconnectionReason.game(cause));
    }

    public void disconnect(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(reason, DisconnectionReason.game(cause));
    }

    public void disconnectAsync(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(PaperAdventure.asVanilla(reason), cause);
    }

    public void disconnectAsync(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(reason, DisconnectionReason.game(cause));
    }

    public PaperPlayerGameConnection paperConnection() {
        return this.playerGameConnection;
    }

    private /* synthetic */ void lambda$handleChat$10(PlayerChatMessage signedMessage, CompletableFuture componentFuture, CompletableFuture completableFuture, Void $) {
        PlayerChatMessage playerChatMessage = signedMessage.a((IChatBaseComponent)componentFuture.join()).a(((FilteredText)completableFuture.join()).e());
        this.a(playerChatMessage);
    }

    @FunctionalInterface
    static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

