/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientCredential;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.ChatDeserializer;
import org.jspecify.annotations.Nullable;

public class PlayerSafetyServiceTextFilter
extends ServerTextFilter {
    private final ConfidentialClientApplication b;
    private final ClientCredentialParameters c;
    private final Set<String> d;
    private final int e;

    private PlayerSafetyServiceTextFilter(URL chatEndpoint, ServerTextFilter.b chatEncoder, ServerTextFilter.a chatIgnoreStrategy, ExecutorService workerPool, ConfidentialClientApplication client, ClientCredentialParameters clientParameters, Set<String> fullyFilteredEvents, int connectionReadTimeoutMs) {
        super(chatEndpoint, chatEncoder, chatIgnoreStrategy, workerPool);
        this.b = client;
        this.c = clientParameters;
        this.d = fullyFilteredEvents;
        this.e = connectionReadTimeoutMs;
    }

    public static @Nullable ServerTextFilter a(String config) {
        ConfidentialClientApplication confidentialClientApplication;
        IClientCertificate iClientCertificate;
        URL url;
        JsonObject jsonObject = ChatDeserializer.a(config);
        URI uri = URI.create(ChatDeserializer.i(jsonObject, "apiServer"));
        String asString = ChatDeserializer.i(jsonObject, "apiPath");
        String asString1 = ChatDeserializer.i(jsonObject, "scope");
        String asString2 = ChatDeserializer.a(jsonObject, "serverId", "");
        String asString3 = ChatDeserializer.i(jsonObject, "applicationId");
        String asString4 = ChatDeserializer.i(jsonObject, "tenantId");
        String asString5 = ChatDeserializer.a(jsonObject, "roomId", "Java:Chat");
        String asString6 = ChatDeserializer.i(jsonObject, "certificatePath");
        String asString7 = ChatDeserializer.a(jsonObject, "certificatePassword", "");
        int asInt = ChatDeserializer.a(jsonObject, "hashesToDrop", -1);
        int asInt1 = ChatDeserializer.a(jsonObject, "maxConcurrentRequests", 7);
        JsonArray asJsonArray = ChatDeserializer.v(jsonObject, "fullyFilteredEvents");
        HashSet<String> set = new HashSet<String>();
        asJsonArray.forEach(jsonElement -> set.add(ChatDeserializer.a(jsonElement, "filteredEvent")));
        int asInt2 = ChatDeserializer.a(jsonObject, "connectionReadTimeoutMs", 2000);
        try {
            url = uri.resolve(asString).toURL();
        }
        catch (MalformedURLException var26) {
            throw new RuntimeException(var26);
        }
        ServerTextFilter.b messageEncoder = (profile, message) -> {
            JsonObject jsonObject1 = new JsonObject();
            jsonObject1.addProperty("userId", profile.id().toString());
            jsonObject1.addProperty("userDisplayName", profile.name());
            jsonObject1.addProperty("server", asString2);
            jsonObject1.addProperty("room", asString5);
            jsonObject1.addProperty("area", "JavaChatRealms");
            jsonObject1.addProperty("data", message);
            jsonObject1.addProperty("language", "*");
            return jsonObject1;
        };
        ServerTextFilter.a ignoreStrategy = ServerTextFilter.a.select(asInt);
        ExecutorService executorService = PlayerSafetyServiceTextFilter.a(asInt1);
        try (InputStream inputStream = Files.newInputStream(Path.of(asString6, new String[0]), new OpenOption[0]);){
            iClientCertificate = ClientCredentialFactory.createFromCertificate((InputStream)inputStream, (String)asString7);
        }
        catch (Exception var28) {
            ServerTextFilter.a.warn("Failed to open certificate file");
            return null;
        }
        try {
            confidentialClientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)asString3, (IClientCredential)iClientCertificate).sendX5c(true).executorService(executorService)).authority(String.format(Locale.ROOT, "https://login.microsoftonline.com/%s/", asString4))).build();
        }
        catch (Exception var25) {
            ServerTextFilter.a.warn("Failed to create confidential client application");
            return null;
        }
        ClientCredentialParameters clientCredentialParameters = ClientCredentialParameters.builder(Set.of(asString1)).build();
        return new PlayerSafetyServiceTextFilter(url, messageEncoder, ignoreStrategy, executorService, confidentialClientApplication, clientCredentialParameters, set, asInt2);
    }

    private IAuthenticationResult b() {
        return (IAuthenticationResult)this.b.acquireToken(this.c).join();
    }

    @Override
    protected void a(HttpURLConnection connection) {
        IAuthenticationResult iAuthenticationResult = this.b();
        connection.setRequestProperty("Authorization", "Bearer " + iAuthenticationResult.accessToken());
    }

    @Override
    protected FilteredText a(String text, ServerTextFilter.a ignoreStrategy, JsonObject response) {
        JsonObject asJsonObject = ChatDeserializer.a(response, "result", null);
        if (asJsonObject == null) {
            return FilteredText.b(text);
        }
        boolean asBoolean = ChatDeserializer.a(asJsonObject, "filtered", true);
        if (!asBoolean) {
            return FilteredText.a(text);
        }
        for (JsonElement jsonElement : ChatDeserializer.a(asJsonObject, "events", new JsonArray())) {
            JsonObject asJsonObject1 = jsonElement.getAsJsonObject();
            String asString = ChatDeserializer.a(asJsonObject1, "id", "");
            if (!this.d.contains(asString)) continue;
            return FilteredText.b(text);
        }
        JsonArray asJsonArray1 = ChatDeserializer.a(asJsonObject, "redactedTextIndex", new JsonArray());
        return new FilteredText(text, this.a(text, asJsonArray1, ignoreStrategy));
    }

    @Override
    protected int a() {
        return this.e;
    }
}

