/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.connection.PaperCommonConnection;
import io.papermc.paper.connection.PaperPlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PluginMessageBridgeImpl;
import io.papermc.paper.event.player.PaperPlayerCustomClickEvent;
import io.papermc.paper.util.KeepAlive;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomClickActionPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener {
    private static final Logger f = LogUtils.getLogger();
    public static final int b = 15000;
    private static final int g = 15000;
    private static final IChatBaseComponent h = IChatBaseComponent.c("disconnect.timeout");
    static final IChatBaseComponent c = IChatBaseComponent.c("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer d;
    public final NetworkManager e;
    private final boolean i;
    private long m;
    private boolean n = false;
    private volatile int o;
    private final KeepAlive keepAlive;
    private volatile boolean p = false;
    public final CraftServer cserver;
    public boolean processedDisconnect;
    public final Map<UUID, ResourcePackCallback> packCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    protected static final MinecraftKey MINECRAFT_BRAND = MinecraftKey.b("brand");
    public @Nullable String playerBrand;
    public final Set<String> pluginMessagerChannels;
    public static final MinecraftKey CUSTOM_REGISTER = MinecraftKey.b("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = MinecraftKey.b("unregister");

    public ServerCommonPacketListenerImpl(MinecraftServer server, NetworkManager connection, CommonListenerCookie cookie) {
        this.d = server;
        this.e = connection;
        this.o = cookie.b();
        this.i = cookie.d();
        this.playerBrand = cookie.brandName();
        this.cserver = server.server;
        this.pluginMessagerChannels = cookie.channels();
        this.keepAlive = cookie.keepAlive();
    }

    public abstract PlayerCommonConnection getApiConnection();

    public abstract Audience getAudience();

    private void l() {
        if (!this.n) {
            this.m = SystemUtils.c();
            this.n = true;
        }
    }

    @Override
    public void a(DisconnectionDetails details) {
        if (this.h()) {
            f.info("Stopping singleplayer server as player logged out");
            this.d.a(false);
        }
    }

    @Override
    public void a(Packet packet, Exception exception) throws ReportedException {
        ServerCommonPacketListener.super.a(packet, exception);
        this.d.a(exception, packet.a());
    }

    @Override
    public void a(ServerboundKeepAlivePacket packet) {
        long now = System.nanoTime();
        KeepAlive.PendingKeepAlive pending = (KeepAlive.PendingKeepAlive)this.keepAlive.pendingKeepAlives.peek();
        if (pending != null && pending.challengeId() == packet.b()) {
            this.keepAlive.pendingKeepAlives.remove((Object)pending);
            KeepAlive.KeepAliveResponse response = new KeepAlive.KeepAliveResponse(pending.txTimeNS(), now);
            this.keepAlive.pingCalculator1m.update(response);
            this.keepAlive.pingCalculator5s.update(response);
            this.o = this.keepAlive.pingCalculator5s.getAvgLatencyMS();
            return;
        }
        Iterator itr = this.keepAlive.pendingKeepAlives.iterator();
        while (itr.hasNext()) {
            KeepAlive.PendingKeepAlive ka = (KeepAlive.PendingKeepAlive)itr.next();
            if (ka.challengeId() != packet.b()) continue;
            itr.remove();
            if (this.processedDisconnect) break;
            f.info("Disconnecting {} for sending keepalive response ({}) out-of-order!", (Object)this.i().name(), (Object)packet.b());
            this.disconnectAsync(h, DisconnectionReason.TIMEOUT);
            return;
        }
        if (!this.processedDisconnect) {
            f.info("Disconnecting {} for sending keepalive response ({}) without matching challenge!", (Object)this.i().name(), (Object)packet.b());
            this.disconnectAsync(h, DisconnectionReason.TIMEOUT);
            return;
        }
    }

    @Override
    public void a(ServerboundPongPacket packet) {
    }

    @Override
    public void a(ServerboundCustomPayloadPacket packet) {
        CustomPacketPayload customPacketPayload = packet.b();
        if (!(customPacketPayload instanceof DiscardedPayload)) {
            return;
        }
        DiscardedPayload discardedPayload = (DiscardedPayload)customPacketPayload;
        PlayerConnectionUtils.a(packet, this, this.d.bv());
        MinecraftKey identifier = packet.b().a().a();
        byte[] data = discardedPayload.data();
        try {
            boolean registerChannel = CUSTOM_REGISTER.equals(identifier);
            if (registerChannel || CUSTOM_UNREGISTER.equals(identifier)) {
                int startIndex = 0;
                for (int i2 = 0; i2 < data.length; ++i2) {
                    byte b2 = data[i2];
                    if (b2 != 0) continue;
                    this.readChannelIdentifier(data, startIndex, i2, registerChannel);
                    startIndex = i2 + 1;
                }
                this.readChannelIdentifier(data, startIndex, data.length, registerChannel);
                return;
            }
            if (identifier.equals(MINECRAFT_BRAND)) {
                this.playerBrand = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])data)).d(256);
            }
            this.cserver.getMessenger().dispatchIncomingMessage(this.paperConnection(), identifier.toString(), data);
        }
        catch (Exception e2) {
            PlayerConnection.i.error("Couldn't handle custom payload on channel {}", (Object)identifier, (Object)e2);
            this.disconnect(IChatBaseComponent.b("Invalid custom payload payload!"), DisconnectionReason.INVALID_PAYLOAD);
        }
    }

    private void readChannelIdentifier(byte[] data, int from, int to, boolean register) {
        PaperPlayerConfigurationConnection bridge;
        ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
        Objects.requireNonNull(serverCommonPacketListenerImpl);
        ServerCommonPacketListenerImpl serverCommonPacketListenerImpl2 = serverCommonPacketListenerImpl;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlayerConnection.class, ServerConfigurationPacketListenerImpl.class}, (Object)serverCommonPacketListenerImpl2, n2)) {
            case 0: {
                PlayerConnection gamePacketListener = (PlayerConnection)serverCommonPacketListenerImpl2;
                PluginMessageBridgeImpl pluginMessageBridgeImpl = gamePacketListener.g.getBukkitEntity();
                break;
            }
            case 1: {
                ServerConfigurationPacketListenerImpl commonPacketListener = (ServerConfigurationPacketListenerImpl)serverCommonPacketListenerImpl2;
                PluginMessageBridgeImpl pluginMessageBridgeImpl = commonPacketListener.paperConnection;
                break;
            }
            default: {
                PluginMessageBridgeImpl pluginMessageBridgeImpl = bridge = null;
            }
        }
        if (bridge == null) {
            return;
        }
        int length = to - from;
        if (length == 0) {
            return;
        }
        String channel = new String(data, from, length, StandardCharsets.US_ASCII);
        if (register) {
            bridge.addChannel(channel);
        } else {
            bridge.removeChannel(channel);
        }
    }

    @Override
    public void a(ServerboundCustomClickActionPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.d.bv());
        this.d.a(packet.b(), packet.e());
        PaperPlayerCustomClickEvent event = new PaperPlayerCustomClickEvent(PaperAdventure.asAdventure(packet.b()), this.getApiConnection(), packet.e().orElse(null));
        event.callEvent();
        ClickCallbackProviderImpl.DIALOG_CLICK_MANAGER.tryRunCallback(this.getAudience(), packet.b(), packet.e());
        ClickCallbackProviderImpl.ADVENTURE_CLICK_MANAGER.tryRunCallback(this.getAudience(), packet.b(), packet.e());
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        ResourcePackCallback callback;
        PlayerConnectionUtils.a(packet, this, this.d.bv());
        if (packet.e() == ServerboundResourcePackPacket.a.b && this.d.ad()) {
            f.info("Disconnecting {} due to resource pack {} rejection", (Object)this.i().name(), (Object)packet.b());
            this.disconnect(IChatBaseComponent.c("multiplayer.requiredTexturePrompt.disconnect"), DisconnectionReason.RESOURCE_PACK_REJECTION);
        }
        if ((callback = packet.e().a() ? this.packCallbacks.remove(packet.b()) : this.packCallbacks.get(packet.b())) != null) {
            ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
            Objects.requireNonNull(serverCommonPacketListenerImpl);
            ServerCommonPacketListenerImpl serverCommonPacketListenerImpl2 = serverCommonPacketListenerImpl;
            int n2 = 0;
            CraftPlayer audience = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlayerConnection.class, ServerConfigurationPacketListenerImpl.class}, (Object)serverCommonPacketListenerImpl2, n2)) {
                case 0 -> {
                    PlayerConnection serverGamePacketListener = (PlayerConnection)serverCommonPacketListenerImpl2;
                    yield serverGamePacketListener.getCraftPlayer();
                }
                case 1 -> {
                    ServerConfigurationPacketListenerImpl configurationPacketListener = (ServerConfigurationPacketListenerImpl)serverCommonPacketListenerImpl2;
                    yield configurationPacketListener.paperConnection.getAudience();
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this));
            };
            callback.packEventReceived(packet.b(), ResourcePackStatus.valueOf((String)packet.e().name()), (Audience)audience);
        }
    }

    @Override
    public void a(ServerboundCookieResponsePacket packet) {
        if (this.paperConnection().handleCookieResponse(packet)) {
            return;
        }
        this.disconnect(c, DisconnectionReason.INVALID_COOKIE);
    }

    protected void e() {
        Profiler.a().a("keepAlive");
        long millis = SystemUtils.c();
        if (this.a(millis) && !this.processedDisconnect) {
            KeepAlive.PendingKeepAlive oldest;
            long currTime = System.nanoTime();
            if (currTime - this.keepAlive.lastKeepAliveTx >= TimeUnit.SECONDS.toNanos(1L)) {
                this.keepAlive.lastKeepAliveTx = currTime;
                KeepAlive.PendingKeepAlive pka = new KeepAlive.PendingKeepAlive(currTime, millis);
                this.keepAlive.pendingKeepAlives.add((Object)pka);
                this.b(new ClientboundKeepAlivePacket(pka.challengeId()));
            }
            if ((oldest = (KeepAlive.PendingKeepAlive)this.keepAlive.pendingKeepAlives.peek()) != null && currTime - oldest.txTimeNS() > TimeUnit.MILLISECONDS.toNanos(KEEPALIVE_LIMIT)) {
                f.info("{} was kicked due to keepalive timeout!", (Object)this.i().name());
                this.disconnect(h, DisconnectionReason.TIMEOUT);
            }
        }
        Profiler.a().c();
    }

    private boolean a(long time) {
        if (this.n) {
            if (time - this.m >= 15000L) {
                this.disconnect(h, DisconnectionReason.TIMEOUT);
            }
            return false;
        }
        return true;
    }

    public void f() {
        this.p = true;
    }

    public void g() {
        this.p = false;
        this.e.a();
    }

    public void b(Packet<?> packet) {
        this.a(packet, null);
    }

    public void a(Packet<?> packet, @Nullable ChannelFutureListener sendListener) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition defaultSpawnPositionPacket = (PacketPlayOutSpawnPosition)packet;
            ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
            if (serverCommonPacketListenerImpl instanceof PlayerConnection) {
                PlayerConnection serverGamePacketListener = (PlayerConnection)serverCommonPacketListenerImpl;
                serverGamePacketListener.g.compassTarget = CraftLocation.toBukkit((BaseBlockPosition)defaultSpawnPositionPacket.b().b(), (World)serverGamePacketListener.p().A());
            }
        }
        if (packet.d()) {
            this.l();
        }
        boolean flag = !this.p || !this.d.bK();
        try {
            this.e.a(packet, sendListener, flag);
        }
        catch (Throwable var7) {
            CrashReport crashReport = CrashReport.a(var7, "Sending packet");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Packet being sent");
            crashReportCategory.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashReport);
        }
    }

    @Deprecated
    @DoNotUse
    public void a(IChatBaseComponent reason) {
        this.disconnect(reason, DisconnectionReason.UNKNOWN);
    }

    public void disconnect(IChatBaseComponent reason, DisconnectionReason cause) {
        this.b(new DisconnectionDetails(reason, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(cause)));
    }

    public void b(final DisconnectionDetails disconnectionDetails) {
        IChatBaseComponent leaveMessage;
        IChatBaseComponent reason;
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.b(disconnectionDetails);
                    return null;
                }
            };
            this.d.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
            return;
        }
        ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
        if (serverCommonPacketListenerImpl instanceof PlayerConnection) {
            PlayerConnection serverGamePacketListener = (PlayerConnection)serverCommonPacketListenerImpl;
            TranslatableComponent rawLeaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? serverGamePacketListener.g.getBukkitEntity().displayName() : Component.text((String)serverGamePacketListener.g.da())});
            EntityPlayer player = serverGamePacketListener.g;
            PlayerKickEvent.Cause cause = disconnectionDetails.disconnectionReason().orElseThrow().game().orElse(PlayerKickEvent.Cause.UNKNOWN);
            PlayerKickEvent event = new PlayerKickEvent((Player)player.getBukkitEntity(), PaperAdventure.asAdventure(disconnectionDetails.a()), (Component)rawLeaveMessage, cause);
            if (this.cserver.getServer().z()) {
                this.cserver.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return;
            }
            reason = PaperAdventure.asVanilla(event.reason());
            leaveMessage = PaperAdventure.asVanilla(event.leaveMessage());
            serverGamePacketListener.g.quitReason = PlayerQuitEvent.QuitReason.KICKED;
            switch (cause) {
                case FLYING_PLAYER: {
                    f.warn("{} was kicked for floating too long!", (Object)player.aq());
                    break;
                }
                case FLYING_VEHICLE: {
                    f.warn("{} was kicked for floating a vehicle too long!", (Object)player.aq());
                }
            }
        } else {
            reason = disconnectionDetails.a();
            leaveMessage = null;
        }
        this.disconnect0(new DisconnectionDetails(reason, disconnectionDetails.b(), disconnectionDetails.c(), Optional.ofNullable(leaveMessage), disconnectionDetails.disconnectionReason()));
    }

    private void disconnect0(DisconnectionDetails disconnectionDetails) {
        this.e.a(new ClientboundDisconnectPacket(disconnectionDetails.a()), PacketSendListener.a(() -> this.e.a(disconnectionDetails)));
        this.a(disconnectionDetails);
        this.e.m();
        this.d.scheduleOnMain(this.e::n);
    }

    public final void disconnectAsync(IChatBaseComponent component, DisconnectionReason reason) {
        this.disconnectAsync(new DisconnectionDetails(component, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(reason)));
    }

    @Deprecated
    @DoNotUse
    public final void disconnectAsync(IChatBaseComponent component) {
        this.disconnectAsync(component, DisconnectionReason.UNKNOWN);
    }

    public abstract void disconnectAsync(DisconnectionDetails var1);

    public boolean isTransferred() {
        return this.i;
    }

    public abstract PaperCommonConnection<?> paperConnection();

    protected boolean h() {
        return this.d.a(new NameAndId(this.i()));
    }

    protected abstract GameProfile i();

    @VisibleForDebug
    public GameProfile j() {
        return this.i();
    }

    public int k() {
        return this.o;
    }

    protected CommonListenerCookie a(ClientInformation clientInformation) {
        return new CommonListenerCookie(this.i(), this.o, clientInformation, this.i, this.playerBrand, this.pluginMessagerChannels, this.keepAlive);
    }
}

